/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.system.PositionRegistBeanInterface;
import jp.mosp.platform.bean.system.PositionSearchBeanInterface;
import jp.mosp.platform.comparator.base.EmploymentContractCodeComparator;
import jp.mosp.platform.comparator.base.PositionCodeComparator;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.PositionMasterVo;

public class PositionMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2300";
    public static final String CMD_SEARCH = "PF2302";
    public static final String CMD_SORT = "PF2304";
    public static final String CMD_PAGE = "PF2305";
    public static final String CMD_REGIST = "PF2307";
    public static final String CMD_DELETE = "PF2309";
    public static final String CMD_INSERT_MODE = "PF2311";
    public static final String CMD_EDIT_MODE = "PF2312";
    public static final String CMD_ADD_MODE = "PF2313";
    public static final String CMD_BATCH_UPDATE = "PF2314";
    protected static final String DEFAULT_LEVEL = "0";

    protected BaseVo getSpecificVo() {
        return new PositionMasterVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.insertMode();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmploymentContractCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        PositionSearchBeanInterface search = this.reference().positionSearch();
        this.setSearchParams(search, vo);
        List list = search.getSearchList(search);
        vo.setList(list);
        vo.setComparatorName(PositionCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        vo.setTxtEditPositionCode("");
        vo.setTxtEditPositionName("");
        vo.setTxtEditPositionAbbr("");
        vo.setTxtEditPositionGrade("");
        vo.setTxtEditPositionLevel(DEFAULT_LEVEL);
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String positionCode, Date activateDate) throws MospException {
        PositionDtoInterface dto = this.reference().position().getPositionInfo(positionCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.reference().position().getPositionHistory(positionCode));
    }

    protected void setSearchParams(PositionSearchBeanInterface search, PositionMasterVo vo) throws MospException {
        search.setActivateDate(this.getSearchActivateDate());
        search.setPositionCode(vo.getTxtSearchPositionCode());
        search.setPositionName(vo.getTxtSearchPositionName());
        search.setPositionAbbr(vo.getTxtSearchPositionAbbr());
        search.setPositionGrade(vo.getTxtSearchPositionGrade());
        search.setPositionLevel(vo.getTxtSearchPositionLevel());
        search.setInactivateFlag(vo.getPltSearchInactivate());
    }

    protected void regist() throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PositionRegistBeanInterface regist = this.platform().positionRegist();
        PositionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getPositionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        PositionRegistBeanInterface regist = this.platform().positionRegist();
        PositionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getPositionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        PositionRegistBeanInterface regist = this.platform().positionRegist();
        PositionDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getPositionCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().positionRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteHistoryMessage(idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        this.platform().positionRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        String[] aryActivateDate = new String[list.size()];
        String[] aryPositionCode = new String[list.size()];
        String[] aryPositionName = new String[list.size()];
        String[] aryPositionAbbr = new String[list.size()];
        String[] aryPositionGrade = new String[list.size()];
        String[] aryPositionLevel = new String[list.size()];
        String[] aryInactivateFlag = new String[list.size()];
        long[] aryCkbRecordId = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PositionDtoInterface dto = (PositionDtoInterface)list.get(i);
            aryActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryPositionCode[i] = dto.getPositionCode();
            aryPositionName[i] = dto.getPositionName();
            aryPositionAbbr[i] = dto.getPositionAbbr();
            aryPositionGrade[i] = String.valueOf(dto.getPositionGrade());
            aryPositionLevel[i] = String.valueOf(dto.getPositionLevel());
            aryInactivateFlag[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            aryCkbRecordId[i] = dto.getPfmPositionId();
        }
        vo.setAryLblActivateDate(aryActivateDate);
        vo.setAryLblPositionCode(aryPositionCode);
        vo.setAryLblPositionName(aryPositionName);
        vo.setAryLblPositionAbbr(aryPositionAbbr);
        vo.setAryLblGrade(aryPositionGrade);
        vo.setAryLblLevel(aryPositionLevel);
        vo.setAryLblInactivate(aryInactivateFlag);
        vo.setAryCkbRecordId(aryCkbRecordId);
    }

    protected void setDtoFields(PositionDtoInterface dto) throws MospException {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        dto.setPfmPositionId(vo.getRecordId());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setPositionCode(vo.getTxtEditPositionCode());
        dto.setPositionName(vo.getTxtEditPositionName());
        dto.setPositionAbbr(vo.getTxtEditPositionAbbr());
        dto.setPositionGrade(this.getInt(vo.getTxtEditPositionGrade()));
        dto.setPositionLevel(this.getInt(vo.getTxtEditPositionLevel()));
    }

    protected void setVoFields(PositionDtoInterface dto) {
        PositionMasterVo vo = (PositionMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmPositionId());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditPositionCode(dto.getPositionCode());
        vo.setTxtEditPositionName(dto.getPositionName());
        vo.setTxtEditPositionAbbr(dto.getPositionAbbr());
        vo.setTxtEditPositionGrade(String.valueOf(dto.getPositionGrade()));
        vo.setTxtEditPositionLevel(String.valueOf(dto.getPositionLevel()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }
}

