/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.dto.mail.impl.MailTemplateDto;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.AvalonLogSystem;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class MailTemplateUtility {
    private Template template;
    private VelocityContext context = new VelocityContext();
    private VelocityEngine engine = new VelocityEngine();
    private Properties vp = new Properties();
    private String text = "";
    private boolean loadercache = true;

    public void init(MospParams mospParams, String templatePath, String templateFileName) {
        this.vp = this.getProperties(mospParams.getApplicationProperty("Docbase") + templatePath);
        this.engine.init(this.vp);
        this.template = this.engine.getTemplate(templateFileName, "Windows-31J");
    }

    public VelocityContext getContext() {
        return this.context;
    }

    public void setMailItem(MailTemplateDto dto) {
        this.context.put("dto", (Object)dto);
    }

    public void setMailItem(String key, String value) {
        this.context.put(key, (Object)value);
    }

    public String getText() throws MospException {
        this.merge();
        return this.text;
    }

    private void merge() throws MospException {
        StringWriter sw = new StringWriter();
        this.template.merge((Context)this.context, (Writer)sw);
        this.text = sw.toString();
        sw.flush();
        try {
            sw.close();
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
    }

    public void freshConText() {
        this.context = new VelocityContext();
    }

    private Properties getProperties(String templatePath) {
        Properties props = new Properties();
        props.setProperty("resource.loader", "file");
        props.setProperty("file.resource.loader.description", "Velocity File Resource Loader");
        props.setProperty("file.resource.loader.class", FileResourceLoader.class.getCanonicalName());
        props.setProperty("file.resource.loader.path", templatePath);
        props.setProperty("file.resource.loader.cache", Boolean.toString(this.loadercache));
        props.setProperty("file.resource.loader.modificationCheckInterval", "0");
        props.setProperty("input.encoding", "Windows-31J");
        props.setProperty("output.encoding", "Windows-31J");
        props.setProperty("runtime.log.logsystem.class", AvalonLogSystem.class.getCanonicalName());
        return props;
    }
}

