/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformMessageUtility {
    public static final String MSG_I_PROCESS_SUCCEED = "PFI0001";
    public static final String MSG_W_CHECK_NUMERIC = "PFW0113";
    public static final String MSG_W_CHECK_FORM = "PFW0115";
    public static final String MSG_W_CHECK_DATE = "PFW0116";
    public static final String MSG_W_CHECK_DECIMAL = "PFW0130";
    public static final String MSG_W_DATE_INVALID = "PFW0132";
    public static final String MSG_W_EMPLOYEE_IS = "PFW0202";
    public static final String MSG_W_WORKFLOW_PROCESS_FAILED = "PFW0229";
    public static final String MSG_W_OTHER_DATA_EXIST = "PFW0236";
    public static final String MSG_W_UNREGISTERED = "PFW0237";

    private PlatformMessageUtility() {
    }

    public static void addInsertNewSucceed(MospParams mospParams) {
        mospParams.addMessage("PFI0001", new String[]{PlatformNamingUtility.newInsert((MospParams)mospParams)});
    }

    public static void addErrorRequireCheck(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0103", new String[0]);
    }

    public static void addErrorCheckNumeric(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0113", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static void addErrorCheckForm(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0115", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static void addErrorCheckDate(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0116", new String[0]);
    }

    public static void addErrorCheckDecimal(MospParams mospParams, String fieldName, int integerDigit, int decimalDigit, Integer row) {
        mospParams.addErrorMessage("PFW0130", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), String.valueOf(integerDigit), String.valueOf(decimalDigit)});
    }

    public static void addErrorEmployeeNotExist(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0201", new String[]{PlatformMessageUtility.getNameEmployee((MospParams)mospParams)});
    }

    public static void addErrorSelectedUserIdNotExist(MospParams mospParams, String userId, Integer row) {
        String rep = PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)PlatformMessageUtility.getNameUserId((MospParams)mospParams), (Integer)row);
        mospParams.addErrorMessage("PFW0214", new String[]{rep, userId});
    }

    public static void addErrorWorkflowProcessFailed(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0229", new String[0]);
    }

    public static void addErrorEmployeeRetired(MospParams mospParams, Integer row) {
        mospParams.addErrorMessage("PFW0202", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)"", (Integer)row), PlatformMessageUtility.getNameRetirement((MospParams)mospParams)});
    }

    public static void addErrorEmployeeSuspended(MospParams mospParams, Integer row) {
        mospParams.addErrorMessage("PFW0202", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)"", (Integer)row), PlatformMessageUtility.getNameSuspension((MospParams)mospParams)});
    }

    public static void addErrorOtherAddressExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0236", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.addressInfo((MospParams)mospParams)});
    }

    public static void addErrorOtherPhoneExist(MospParams mospParams, Date activateDate, Integer row) {
        mospParams.addErrorMessage("PFW0236", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)DateUtility.getStringDate((Date)activateDate), (Integer)row), PlatformNamingUtility.phoneInfo((MospParams)mospParams)});
    }

    public static void addErrorUnregisteredMailAddress(MospParams mospParams, Date activateDate, String employeeCode) {
        mospParams.addErrorMessage("PFW0237", new String[]{DateUtility.getStringDate((Date)activateDate), employeeCode, PlatformMessageUtility.getNameMailAddress((MospParams)mospParams)});
    }

    public static void addErrorAvailableChars(MospParams mospParams, String fieldName, List<String> availables, Integer row) {
        mospParams.addErrorMessage("PFW0105", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row), PlatformMessageUtility.getAvailableCharString((MospParams)mospParams, availables)});
    }

    protected static String getRowedFieldName(MospParams mospParams, String fieldName, Integer row) {
        return MessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row);
    }

    public static String getDraftSucceed(MospParams mospParams) {
        return mospParams.getMessage("PFI0001", new String[]{PlatformMessageUtility.getNameDraft((MospParams)mospParams)});
    }

    public static void addMessageSearchFailed(MospParams mospParams) {
        mospParams.addMessage("PFI0002", new String[]{PlatformNamingUtility.search((MospParams)mospParams)});
    }

    public static void addErrorDuplicate(MospParams mospParams) {
        mospParams.addErrorMessage("PFW0204", new String[0]);
    }

    public static void addErrorDateInvalid(MospParams mospParams, String fieldName, Integer row) {
        mospParams.addErrorMessage("PFW0132", new String[]{PlatformMessageUtility.getRowedFieldName((MospParams)mospParams, (String)fieldName, (Integer)row)});
    }

    public static String getNameEmployeeCode(MospParams mospParams) {
        return PlatformNamingUtility.employeeCode((MospParams)mospParams);
    }

    public static String getNameActivateDate(MospParams mospParams) {
        return mospParams.getName("ActivateDate");
    }

    public static String getNameEmployee(MospParams mospParams) {
        return mospParams.getName("Employee");
    }

    public static String getNameUserId(MospParams mospParams) {
        return mospParams.getName("User", new String[]{"Id"});
    }

    public static String getNameDraft(MospParams mospParams) {
        return mospParams.getName("WorkPaper");
    }

    public static String getNameRetirement(MospParams mospParams) {
        return mospParams.getName("RetirementOn");
    }

    public static String getNameSuspension(MospParams mospParams) {
        return mospParams.getName("RetirementLeave");
    }

    public static String getNameMailAddress(MospParams mospParams) {
        return mospParams.getName("MailAddress");
    }

    public static String getAvailableCharString(MospParams mospParams, List<String> availables) {
        String[] array = new String[availables.size()];
        int i = 0;
        for (String available : availables) {
            array[i++] = available.equals("") ? PlatformNamingUtility.blank((MospParams)mospParams) : available;
        }
        return MospUtility.toSeparatedString((String[])array, (String)PlatformNamingUtility.touten((MospParams)mospParams));
    }
}

