/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MainMenuProperty;
import jp.mosp.framework.property.MenuProperty;
import jp.mosp.framework.property.RoleMenuProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.platform.base.ActivateDtoInterface;
import jp.mosp.platform.base.PlatformVo;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.base.ApplicationMasterDtoInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformUtility {
    public static final String NAM_UPPER_TRIANGULAR = "UpperTriangular";
    public static final String NAM_LOWER_TRIANGULAR = "LowerTriangular";

    private PlatformUtility() {
    }

    public static String getSortMark(String sortKey, MospParams mospParams) {
        PlatformVo vo = (PlatformVo)mospParams.getVo();
        if (!sortKey.equals(vo.getComparatorName())) {
            return "";
        }
        if (vo.isAscending()) {
            return mospParams.getName("UpperTriangular");
        }
        return mospParams.getName("LowerTriangular");
    }

    public static Set<String> getApproverRoleSet(MospParams mospParams) {
        HashSet<String> approverRoleSet = new HashSet<String>();
        Map map = mospParams.getProperties().getRoleProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (!((RoleProperty)entry.getValue()).isApprover()) continue;
            approverRoleSet.add((String)entry.getKey());
        }
        return approverRoleSet;
    }

    public static Set<String> getPersonalIdSet(List<? extends PersonalIdDtoInterface> list) {
        HashSet<String> set = new HashSet<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list) {
            set.add(personalIdDtoInterface.getPersonalId());
        }
        return set;
    }

    public static boolean isTheMenuValid(MospParams mospParams, String mainMenuKey, String menuKey) {
        MainMenuProperty mainMenu = (MainMenuProperty)mospParams.getProperties().getMainMenuProperties().get(mainMenuKey);
        if (mainMenu == null) {
            return false;
        }
        MenuProperty menu = (MenuProperty)mainMenu.getMenuMap().get(menuKey);
        if (menu == null) {
            return false;
        }
        return menu.isMenuValid();
    }

    public static boolean isTheMenuAvailable(MospParams mospParams, String mainMenuKey, String menuKey) {
        if (!PlatformUtility.isTheMenuValid((MospParams)mospParams, (String)mainMenuKey, (String)menuKey)) {
            return false;
        }
        RoleProperty role = mospParams.getUserRole();
        if (role == null) {
            return false;
        }
        RoleMenuProperty roleMenu = (RoleMenuProperty)role.getRoleMenuMap().get(menuKey);
        return roleMenu != null;
    }

    public static Date getLatestActivateDate(Set<? extends ActivateDtoInterface> set, Date targetDate) {
        ArrayList<? extends ActivateDtoInterface> list = new ArrayList<ActivateDtoInterface>(set);
        Collections.sort(list, new ActivateDateComparator());
        return PlatformUtility.getLatestActivateDate(list, (Date)targetDate);
    }

    public static Date getLatestActivateDate(List<? extends ActivateDtoInterface> list, Date targetDate) {
        ActivateDtoInterface latestDto = PlatformUtility.getLatestDto(list, (Date)targetDate);
        if (latestDto == null) {
            return null;
        }
        return latestDto.getActivateDate();
    }

    public static ActivateDtoInterface getLatestDto(List<? extends ActivateDtoInterface> list, Date targetDate) {
        if (targetDate == null || list == null) {
            return null;
        }
        ActivateDtoInterface latestDto = null;
        for (ActivateDtoInterface activateDtoInterface : list) {
            if (targetDate.before(activateDtoInterface.getActivateDate())) continue;
            latestDto = activateDtoInterface;
        }
        return latestDto;
    }

    public static ActivateDtoInterface getDto(List<? extends ActivateDtoInterface> list, Date activateDate) {
        if (activateDate == null || list == null) {
            return null;
        }
        for (ActivateDtoInterface activateDtoInterface : list) {
            if (activateDate.compareTo(activateDtoInterface.getActivateDate()) != 0) continue;
            return activateDtoInterface;
        }
        return null;
    }

    public static long next(String format, long min, long max, Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        Collections.reverse(list);
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (String str : list) {
            if (str.length() != format.length()) continue;
            long seq = 0L;
            try {
                seq = decimalFormat.parse(str).longValue();
            }
            catch (Throwable t) {
                continue;
            }
            if (max < seq) continue;
            if (max == seq) {
                return max;
            }
            if (seq < min) {
                return min;
            }
            return seq + 1L;
        }
        return min;
    }

    public static ApplicationMasterDtoInterface getApplicationMaster(HumanDtoInterface humanDto, Set<? extends ApplicationMasterDtoInterface> personSet, Set<? extends ApplicationMasterDtoInterface> masterSet) {
        ApplicationMasterDtoInterface dto = null;
        if (humanDto == null) {
            return dto;
        }
        String personalId = humanDto.getPersonalId();
        String positionCode = humanDto.getPositionCode();
        String sectionCode = humanDto.getSectionCode();
        String employmentContractCode = humanDto.getEmploymentContractCode();
        String workPlaceCode = humanDto.getWorkPlaceCode();
        String blank = "";
        dto = PlatformUtility.getApplicationPerson(personSet, (String)personalId);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        return dto;
    }

    protected static ApplicationMasterDtoInterface getApplicationPerson(Set<? extends ApplicationMasterDtoInterface> personSet, String personalId) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : personSet) {
            String personalIds = applicationMasterDtoInterface.getPersonalIds();
            if (!personalIds.contains(personalId)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    protected static ApplicationMasterDtoInterface getApplicationMaster(Set<? extends ApplicationMasterDtoInterface> masterSet, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : masterSet) {
            if (!applicationMasterDtoInterface.getWorkPlaceCode().equals(workPlaceCode) || !applicationMasterDtoInterface.getEmploymentContractCode().equals(employmentContractCode) || !applicationMasterDtoInterface.getSectionCode().equals(sectionCode) || !applicationMasterDtoInterface.getPositionCode().equals(positionCode)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    public static boolean isFlagOff(int flag) {
        return flag == 0;
    }

    public static boolean isFlagOn(int flag) {
        return flag == 1;
    }

    public static boolean isForwardMatch(String condition, String value) {
        return value.startsWith(condition);
    }

    public static boolean isBackwardMatch(String condition, String value) {
        return value.endsWith(condition);
    }

    public static boolean isBroadMatch(String condition, String value) {
        return value.indexOf(condition) >= 0;
    }

    public static boolean isExactMatch(String condition, String value) {
        return value.equals(condition);
    }
}

