/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceSearchBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.dto.workflow.RouteApplicationReferenceDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.RouteApplicationReferenceVo;

public class RouteApplicationReferenceAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3500";
    public static final String CMD_SEARCH = "PF3502";
    public static final String CMD_SET_ACTIVATION_DATE = "PF3506";
    public static final String CMD_SORT = "PF3508";
    public static final String CMD_PAGE = "PF3509";

    protected BaseVo getSpecificVo() {
        return new RouteApplicationReferenceVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void show() throws MospException {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        this.initApplicationReferenceVoFields();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
        this.setPulldown();
    }

    protected void search() throws MospException {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        RouteApplicationReferenceSearchBeanInterface search = this.reference().routeApplicationReferenceSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setEmployeeName(vo.getTxtSearchEmployeeName());
        search.setWorkPlaceCode(vo.getPltSearchWorkPlace());
        search.setEmploymentCode(vo.getPltSearchEmployment());
        search.setSectionCode(vo.getPltSearchSection());
        search.setPositionCode(vo.getPltSearchPosition());
        search.setWorkflowType(this.getInt(vo.getPltSearchFlowType()));
        search.setRouteApplicationCode(vo.getTxtSearchRouteApplicationCode());
        search.setRouteApplicationName(vo.getTxtSearchRouteApplicationName());
        search.setRouteCode(vo.getTxtSearchRouteCode());
        search.setRouteName(vo.getTxtSearchRouteName());
        search.setApproverCode(vo.getTxtSearchApproverCode());
        search.setApproverName(vo.getTxtSearchApproverName());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void setActivationDate() throws MospException {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    private void setPulldown() throws MospException {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSearchWorkPlaceMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchEmploymentMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltSearchPositionMaster(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getSearchActivateDate();
        vo.setAryPltSearchWorkPlaceMaster(this.reference().workPlace().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchEmploymentMaster(this.reference().employmentContract().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchSectionMaster(this.reference().section().getCodedSelectArray(date, true, null));
        vo.setAryPltSearchPositionMaster(this.reference().position().getCodedSelectArray(date, true, null));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        String[] aryLblEmployeeCode = new String[list.size()];
        String[] aryLblEmployeeName = new String[list.size()];
        String[] aryLblRouteApplicationCode = new String[list.size()];
        String[] aryLblRouteApplicationName = new String[list.size()];
        String[] aryLblRouteCode = new String[list.size()];
        String[] aryLblRouteName = new String[list.size()];
        String[] aryLblFirstApprovalName = new String[list.size()];
        String[] aryLblRouteStage = new String[list.size()];
        String[] aryLblEndApprovalName = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RouteApplicationReferenceDtoInterface dto = (RouteApplicationReferenceDtoInterface)list.get(i);
            aryLblEmployeeCode[i] = dto.getEmployeeCode();
            aryLblEmployeeName[i] = dto.getEmployeeName();
            aryLblRouteApplicationCode[i] = dto.getRouteApplicationCode();
            aryLblRouteApplicationName[i] = dto.getRouteApplicationName();
            aryLblRouteCode[i] = dto.getRouteCode();
            aryLblRouteName[i] = dto.getRouteName();
            aryLblRouteStage[i] = String.valueOf(dto.getRouteStage());
            aryLblFirstApprovalName[i] = dto.getFirstApprovalName();
            aryLblEndApprovalName[i] = dto.getEndApprovalName();
        }
        vo.setAryLblEmployeeCode(aryLblEmployeeCode);
        vo.setAryLblEmployeeName(aryLblEmployeeName);
        vo.setAryLblRouteApplicationCode(aryLblRouteApplicationCode);
        vo.setAryLblRouteApplicationName(aryLblRouteApplicationName);
        vo.setAryLblRouteCode(aryLblRouteCode);
        vo.setAryLblRouteName(aryLblRouteName);
        vo.setAryLblRouteStage(aryLblRouteStage);
        vo.setAryLblFirstApprovalName(aryLblFirstApprovalName);
        vo.setAryLblEndApprovalName(aryLblEndApprovalName);
    }

    public void setDefaultValues() {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchEmployeeName("");
        vo.setPltSearchWorkPlace("");
        vo.setPltSearchEmployment("");
        vo.setPltSearchSection("");
        vo.setPltSearchPosition("");
        vo.setPltSearchFlowType("");
        vo.setTxtSearchRouteApplicationCode("");
        vo.setTxtSearchRouteApplicationName("");
        vo.setTxtSearchRouteCode("");
        vo.setTxtSearchRouteName("");
        vo.setTxtSearchApproverCode("");
        vo.setTxtSearchApproverName("");
    }

    protected void initApplicationReferenceVoFields() {
        RouteApplicationReferenceVo vo = (RouteApplicationReferenceVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        this.setSearchActivateDate(date);
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setTxtUpdateActivateYear(this.getStringYear(date));
        vo.setTxtUpdateActivateMonth(this.getStringMonth(date));
        vo.setTxtUpdateActivateDay(this.getStringDay(date));
        vo.setPltUpdateInactivate(String.valueOf(0));
    }
}

