/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmApprovalUnitDto;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.UnitCardVo;

public class UnitCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3120";
    public static final String CMD_SELECT_SHOW = "PF3121";
    public static final String CMD_REGIST = "PF3125";
    public static final String CMD_DELETE = "PF3127";
    public static final String CMD_SET_ACTIVATION_DATE = "PF3170";
    public static final String CMD_INSERT_MODE = "PF3171";
    public static final String CMD_ADD_MODE = "PF3173";

    protected BaseVo getSpecificVo() {
        return new UnitCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo();
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo();
            this.selectShow();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void selectShow() throws MospException {
        this.editMode();
    }

    protected void regist() throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalUnitRegistBeanInterface regist = platform.approvalUnitRegist();
        PfmApprovalUnitDto dto = new PfmApprovalUnitDto();
        this.setDtoFields((ApprovalUnitDtoInterface)dto);
        regist.insert((ApprovalUnitDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertNewMessage();
        this.setEditUpdateMode(dto.getUnitCode(), dto.getActivateDate());
    }

    protected void add() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalUnitRegistBeanInterface regist = platform.approvalUnitRegist();
        ApprovalUnitDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setEditUpdateMode(dto.getUnitCode(), dto.getActivateDate());
    }

    protected void update() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalUnitRegistBeanInterface regist = platform.approvalUnitRegist();
        ApprovalUnitDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setEditUpdateMode(dto.getUnitCode(), dto.getActivateDate());
    }

    protected void delete() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        ApprovalUnitRegistBeanInterface regist = platform.approvalUnitRegist();
        ApprovalUnitDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteHistoryFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        if (vo.getModeActivateDate().equals("fixed") && (vo.getAryPltSectionMaster().length == 1 || vo.getAryPltPositionMaster().length == 1)) {
            String masterName = "";
            if (vo.getAryPltSectionMaster().length == 1) {
                masterName = this.mospParams.getName("Section");
            } else if (vo.getAryPltPositionMaster().length == 1) {
                masterName = this.mospParams.getName("Position");
            }
            if (!vo.getModeCardEdit().equals("add") || !vo.getRadUnitType().equals("person")) {
                this.addSetMasterPulldownFailedMessage(masterName);
            }
            if (vo.getModeCardEdit().equals("insert")) {
                vo.setRadUnitType("person");
            }
        }
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void addMode() throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        this.setEditAddMode();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    public void setDefaultValues() {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        vo.setTxtUnitCode("");
        vo.setTxtUnitName("");
        vo.setPltRouteStage(String.valueOf(0));
        vo.setPltSectionMaster("");
        vo.setPltPositionMaster("");
        vo.setTxtEmployeeCode("");
        vo.setLblSectionPosition("");
        vo.setLblEmployeeCode("");
        vo.setRadUnitType("section");
    }

    protected void setEditUpdateMode(String unitCode, Date activateDate) throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        ApprovalUnitReferenceBeanInterface reference = this.reference().approvalUnit();
        ApprovalUnitDtoInterface dto = reference.findForKey(unitCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(reference.getApprovalUnitHistory(unitCode));
    }

    protected void setDtoFields(ApprovalUnitDtoInterface dto) throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        dto.setActivateDate(this.getEditActivateDate());
        dto.setUnitCode(vo.getTxtUnitCode());
        dto.setUnitName(vo.getTxtUnitName());
        dto.setRouteStage(this.getInt(vo.getPltRouteStage()));
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setUnitType(vo.getRadUnitType());
        if (vo.getRadUnitType().equals("section")) {
            dto.setApproverSectionCode(vo.getPltSectionMaster());
            dto.setApproverPositionCode(vo.getPltPositionMaster());
            dto.setApproverPositionGrade(vo.getPltPositionGradeRange());
            dto.setApproverPersonalId("");
        } else {
            dto.setApproverSectionCode("");
            dto.setApproverPositionCode("");
            dto.setApproverPositionGrade("");
            dto.setApproverPersonalId(this.checkWithdrawal(this.reference().human().getPersonalIds(vo.getTxtEmployeeCode(), this.getEditActivateDate())));
        }
    }

    protected void setVoFields(ApprovalUnitDtoInterface dto) throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtUnitCode(dto.getUnitCode());
        vo.setTxtUnitName(dto.getUnitName());
        vo.setPltRouteStage(String.valueOf(dto.getRouteStage()));
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setRadUnitType(dto.getUnitType());
        vo.setPltSectionMaster(dto.getApproverSectionCode());
        vo.setPltPositionMaster(dto.getApproverPositionCode());
        vo.setPltPositionGradeRange(dto.getApproverPositionGrade());
        HumanReferenceBeanInterface human = this.reference().human();
        vo.setTxtEmployeeCode(human.getEmployeeCodes(dto.getApproverPersonalId(), dto.getActivateDate()));
        vo.setLblEmployeeCode(human.getHumanNames(dto.getApproverPersonalId(), dto.getActivateDate()));
        if (vo.getRadUnitType().equals("person")) {
            return;
        }
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        humanSearch.setTargetDate(dto.getActivateDate());
        humanSearch.setSectionCode(dto.getApproverSectionCode());
        humanSearch.setPositionCode(dto.getApproverPositionCode());
        humanSearch.setPositionGradeRange(dto.getApproverPositionGrade());
        humanSearch.setNeedConcurrent(true);
        humanSearch.setStateType("presence");
        List list = humanSearch.search();
        ArrayList<String> personalIdList = new ArrayList<String>();
        for (HumanDtoInterface humanDto : list) {
            personalIdList.add(humanDto.getPersonalId());
        }
        vo.setLblEmployeeCode(human.getHumanNames(personalIdList, dto.getActivateDate()));
    }

    private void setPulldown() throws MospException {
        UnitCardVo vo = (UnitCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSectionMaster(this.getInputActivateDatePulldown());
            vo.setAryPltPositionMaster(this.getInputActivateDatePulldown());
            vo.setLblEmployeeCode("");
        } else {
            Date date = this.getEditActivateDate();
            String[][] arySection = this.reference().section().getCodedSelectArray(date, true, null);
            vo.setAryPltSectionMaster(arySection);
            String[][] aryPosition = this.reference().position().getCodedSelectArray(date, true, null);
            vo.setAryPltPositionMaster(aryPosition);
        }
    }

    protected void addSetMasterPulldownFailedMessage(String masterName) {
        this.mospParams.addErrorMessage("PFW0220", new String[]{masterName});
    }

    protected String checkWithdrawal(String id) throws MospException {
        String[] arrayCode;
        Date targetDate = this.getEditActivateDate();
        for (String element : arrayCode = id.split(",")) {
            if ("".equals(element) || !this.reference().retirement().isRetired(element, targetDate)) continue;
            this.addNotRetirementEmployeesErrorMessage(targetDate, this.reference().human().getEmployeeCode(element, targetDate));
            return "";
        }
        return id;
    }
}

