/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitSearchBeanInterface;
import jp.mosp.platform.comparator.workflow.ApprovalUnitMasterUnitCodeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.workflow.vo.UnitListVo;

public class UnitListAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3110";
    public static final String CMD_SEARCH = "PF3112";
    public static final String CMD_RE_SEARCH = "PF3113";
    public static final String CMD_SORT = "PF3118";
    public static final String CMD_PAGE = "PF3119";
    public static final String CMD_BATCH_UPDATE = "PF3185";

    public UnitListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new UnitListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        UnitListVo vo = (UnitListVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.setDefaultValues();
        vo.setTxtSearchUnitCode("");
        vo.setTxtSearchUnitName("");
        vo.setTxtSearchSectionName("");
        vo.setTxtSearchPositoinName("");
        vo.setTxtSearchEmployeeCode("");
        vo.setTxtSearchApprover("");
        vo.setPltSearchUnitType("section");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ApprovalUnitMasterUnitCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
    }

    protected void search() throws MospException {
        UnitListVo vo = (UnitListVo)this.mospParams.getVo();
        ApprovalUnitSearchBeanInterface search = this.reference().approvalUnitSearch();
        HumanReferenceBeanInterface getHumanInfo = this.reference().human();
        search.setActivateDate(this.getSearchActivateDate());
        search.setUnitCode(vo.getTxtSearchUnitCode());
        search.setUnitName(vo.getTxtSearchUnitName());
        search.setUnitType(vo.getPltSearchUnitType());
        search.setSectionName(vo.getTxtSearchSectionName());
        search.setPositionName(vo.getTxtSearchPositoinName());
        search.setEmployeeCode(vo.getTxtSearchEmployeeCode());
        search.setApprover(vo.getTxtSearchApprover());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        if (!(!vo.getPltSearchUnitType().equals("person") || vo.getTxtSearchEmployeeCode().isEmpty() && vo.getTxtSearchApprover().isEmpty())) {
            Date date = this.getSearchActivateDate();
            List humanList = getHumanInfo.getHumanList(date);
            ArrayList<ApprovalUnitDtoInterface> listTmp = new ArrayList<ApprovalUnitDtoInterface>();
            ArrayList<String> listPersonId = new ArrayList<String>();
            for (int i = 0; i < humanList.size(); ++i) {
                HumanDtoInterface humanDto = (HumanDtoInterface)humanList.get(i);
                String humanName = humanDto.getLastName() + humanDto.getFirstName();
                String humanNameWithBlank = humanDto.getLastName() + " " + humanDto.getFirstName();
                if (!vo.getTxtSearchEmployeeCode().isEmpty() && !vo.getTxtSearchApprover().isEmpty()) {
                    if (!humanDto.getEmployeeCode().contains(vo.getTxtSearchEmployeeCode()) || !humanName.contains(vo.getTxtSearchApprover()) && !humanNameWithBlank.contains(vo.getTxtSearchApprover())) continue;
                    listPersonId.add(humanDto.getPersonalId());
                    continue;
                }
                if (vo.getTxtSearchApprover().isEmpty()) {
                    if (!humanDto.getEmployeeCode().contains(vo.getTxtSearchEmployeeCode())) continue;
                    listPersonId.add(humanDto.getPersonalId());
                    continue;
                }
                if (!humanName.contains(vo.getTxtSearchApprover()) && !humanNameWithBlank.contains(vo.getTxtSearchApprover())) continue;
                listPersonId.add(humanDto.getPersonalId());
            }
            for (ApprovalUnitDtoInterface unitDto : list) {
                for (String personalId : listPersonId) {
                    if (!unitDto.getApproverPersonalId().contains(personalId) || listTmp.contains(unitDto)) continue;
                    listTmp.add(unitDto);
                }
            }
            list.clear();
            if (listTmp.size() != 0) {
                list.addAll(listTmp);
            }
        }
        vo.setList(list);
        vo.setComparatorName(ApprovalUnitMasterUnitCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        UnitListVo vo = (UnitListVo)this.mospParams.getVo();
        PlatformBeanHandlerInterface platform = this.platform();
        platform.approvalUnitRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            this.addBatchUpdateFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateMessage();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        UnitListVo vo = (UnitListVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblUnitCode = new String[list.size()];
        String[] aryLblUnitName = new String[list.size()];
        String[] aryLblUnitType = new String[list.size()];
        String[] aryLblApproval = new String[list.size()];
        String[] aryLblUnitInactivate = new String[list.size()];
        HumanReferenceBeanInterface getHumanInfo = this.reference().human();
        PositionReferenceBeanInterface getPositionInfo = this.reference().position();
        SectionReferenceBeanInterface getSectionInfo = this.reference().section();
        for (int i = 0; i < list.size(); ++i) {
            ApprovalUnitDtoInterface dto = (ApprovalUnitDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getPfmApprovalUnitId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblUnitCode[i] = dto.getUnitCode();
            aryLblUnitName[i] = dto.getUnitName();
            aryLblUnitType[i] = this.getUnitTypeName(dto.getUnitType());
            aryLblUnitInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            Date date = dto.getActivateDate();
            if (dto.getUnitType().equals("section")) {
                String positionAbbr = getPositionInfo.getPositionAbbr(dto.getApproverPositionCode(), date);
                String sectionAbbr = getSectionInfo.getSectionAbbr(dto.getApproverSectionCode(), date);
                aryLblApproval[i] = positionAbbr + " " + sectionAbbr;
                continue;
            }
            String[] aryPersonalCode = dto.getApproverPersonalId().split(",");
            ArrayList<String> aryEmployeeCode = new ArrayList<String>();
            for (String element : aryPersonalCode) {
                String employeeCode = getHumanInfo.getEmployeeCode(element, date);
                if (employeeCode.equals("")) continue;
                aryEmployeeCode.add(employeeCode);
            }
            Collections.sort(aryEmployeeCode);
            HumanDtoInterface humanDto = getHumanInfo.getHumanInfoForEmployeeCode((String)aryEmployeeCode.get(0), date);
            aryLblApproval[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
        }
        vo.setAryCkbUnitListId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblUnitCode(aryLblUnitCode);
        vo.setAryLblUnitName(aryLblUnitName);
        vo.setAryLblUnitType(aryLblUnitType);
        vo.setAryLblApproval(aryLblApproval);
        vo.setAryLblInactivate(aryLblUnitInactivate);
    }

    public void setDefaultValues() {
        UnitListVo vo = (UnitListVo)this.mospParams.getVo();
        vo.setAryLblActivateDate(new String[0]);
        vo.setAryLblUnitCode(new String[0]);
        vo.setAryLblUnitName(new String[0]);
        vo.setAryLblUnitType(new String[0]);
        vo.setAryLblApproval(new String[0]);
        vo.setAryLblInactivate(new String[0]);
        vo.setAryCkbUnitListId(new String[0]);
        vo.setCkbSelect(new String[0]);
    }

    protected String getUnitTypeName(String unitType) {
        for (String[] code : this.mospParams.getProperties().getCodeArray("UnitType", false)) {
            if (!code[0].equals(String.valueOf(unitType))) continue;
            return code[1];
        }
        return "";
    }
}

