/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.action;

import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.setup.bean.impl.DbSetUpManagement;
import jp.mosp.setup.constant.SetUpStatus;
import jp.mosp.setup.dto.DbSetUpParameterInterface;
import jp.mosp.setup.vo.DbConfirmVo;
import jp.mosp.setup.vo.DbCreateVo;

public class DbCreateAction
extends PlatformAction {
    public static final String CMD_SHOW = "SU2000";
    public static final String CMD_CHECK = "SU2001";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_CHECK)) {
            this.prepareVo();
            this.create();
        }
    }

    protected DbCreateVo getSpecificVo() {
        return new DbCreateVo();
    }

    protected void show() throws MospException {
        DbCreateVo vo = (DbCreateVo)this.mospParams.getVo();
        vo.setTxtDbName(this.mospParams.getApplicationProperty("DefaultDbName"));
        vo.setTxtRoleName(this.mospParams.getApplicationProperty("DefaultDbUser"));
        vo.setTxtRolePw(this.mospParams.getApplicationProperty("DefaultDbPassword"));
    }

    protected void create() throws MospException {
        BaseVo baseVo = this.mospParams.getStoredVo(DbConfirmVo.class.getName());
        if (baseVo == null) {
            this.mospParams.addErrorMessage("SUE006", new String[0]);
            this.mospParams.setNextCommand("SU1000");
            this.mospParams.getStoredInfo().initStoredInfo();
            return;
        }
        DbConfirmVo confirmVo = (DbConfirmVo)baseVo;
        DbSetUpParameterInterface parameter = DbSetUpManagement.initParameter((MospParams)this.mospParams);
        parameter.setServerName(confirmVo.getTxtServer());
        parameter.setPort(this.getInt(confirmVo.getTxtPort()));
        parameter.setSuperPassword(confirmVo.getTxtPostgresPass());
        SetUpStatus status = DbSetUpManagement.getInstance((MospParams)this.mospParams, (DbSetUpParameterInterface)parameter).confirm();
        if (SetUpStatus.ERROR.equals((Object)status)) {
            return;
        }
        DbCreateVo createVo = (DbCreateVo)this.mospParams.getVo();
        parameter.setDbName(createVo.getTxtDbName());
        parameter.setUserName(createVo.getTxtRoleName());
        parameter.setUserPassword(createVo.getTxtRolePw());
        DbSetUpManagement.getInstance((MospParams)this.mospParams, (DbSetUpParameterInterface)parameter).createDataBase();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.mospParams.setNextCommand("SU3000");
    }
}

