/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.action;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.MospUser;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.setup.bean.impl.DbSetUpManagement;
import jp.mosp.setup.dto.DbSetUpParameterInterface;
import jp.mosp.setup.vo.DbCreateVo;
import jp.mosp.setup.vo.FirstUserVo;

public class FirstUserAction
extends PlatformAction {
    public static final String CMD_SHOW = "SU3000";
    public static final String CMD_REGIST = "SU3001";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.insert();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected FirstUserVo getSpecificVo() {
        return new FirstUserVo();
    }

    protected void show() throws MospException {
        if (!this.hasDbCreateVo()) {
            this.mospParams.setNextCommand("PF0010");
            return;
        }
        FirstUserVo vo = (FirstUserVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtActivateYear(this.getStringYear(date));
        vo.setTxtActivateMonth(this.getStringMonth(date));
        vo.setTxtActivateDay(this.getStringDay(date));
        vo.setModeActivateDate("chaning");
    }

    protected void insert() throws MospException {
        if (!this.hasDbCreateVo()) {
            this.mospParams.setNextCommand("PF0010");
            return;
        }
        FirstUserVo vo = (FirstUserVo)this.mospParams.getVo();
        MospUser mospUser = new MospUser();
        mospUser.setUserId(vo.getTxtUserId());
        this.mospParams.setUser(mospUser);
        DbSetUpParameterInterface parameter = DbSetUpManagement.initParameter((MospParams)this.mospParams);
        parameter.setUserId(vo.getTxtUserId());
        parameter.setEmployeeCode(vo.getTxtEmployeeCode());
        parameter.setLastName(vo.getTxtLastName());
        parameter.setFirstName(vo.getTxtFirstName());
        parameter.setLastKana(vo.getTxtLastKana());
        parameter.setFirstKana(vo.getTxtFirstKana());
        parameter.setEntranceDate(this.getDate(vo.getTxtEntranceYear(), vo.getTxtEntranceMonth(), vo.getTxtEntranceDay()));
        Date activateDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        parameter.setActivateDate(activateDate);
        DbSetUpManagement.getInstance((MospParams)this.mospParams, (DbSetUpParameterInterface)parameter).initialize(new boolean[]{true});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.mospParams.setUser(null);
        this.addInsertNewMessage();
        vo.setTxtEmployeeCode(vo.getTxtEmployeeCode());
        vo.setModeActivateDate(this.getStringDate(activateDate));
        this.mospParams.setNextCommand("SU4000");
    }

    protected boolean hasDbCreateVo() {
        return this.mospParams.getStoredVo(DbCreateVo.class.getName()) != null;
    }
}

