/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.action;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.setup.bean.impl.DbSetUpManagement;
import jp.mosp.setup.constant.Command;
import jp.mosp.setup.constant.SetUpStatus;
import jp.mosp.setup.dto.DbSetUpParameterInterface;
import jp.mosp.setup.vo.XmlCreateVo;

public class XmlCreateAction
extends PlatformAction {
    public static final String CMD_SHOW = "SU5000";
    public static final String CMD_CHECK = "SU5001";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_CHECK)) {
            this.prepareVo();
            this.create();
        }
    }

    protected XmlCreateVo getSpecificVo() {
        return new XmlCreateVo();
    }

    protected void show() throws MospException {
        SetUpStatus status = DbSetUpManagement.getInstance((MospParams)this.mospParams, null).confirm();
        if (SetUpStatus.ALREADY.equals((Object)status)) {
            this.mospParams.setNextCommand("PF0010");
            return;
        }
        this.mospParams.getErrorMessageList().clear();
        XmlCreateVo vo = (XmlCreateVo)this.mospParams.getVo();
        vo.setTxtServer(this.mospParams.getApplicationProperty("DefaultServerName"));
        vo.setTxtPort(this.mospParams.getApplicationProperty("DefaultPort"));
        vo.setTxtDbName(this.mospParams.getApplicationProperty("DefaultDbName"));
        vo.setTxtRoleName(this.mospParams.getApplicationProperty("DefaultDbUser"));
        vo.setTxtRolePw(this.mospParams.getApplicationProperty("DefaultDbPassword"));
    }

    protected void create() throws MospException {
        SetUpStatus status = DbSetUpManagement.getInstance((MospParams)this.mospParams, null).confirm();
        this.mospParams.getErrorMessageList().clear();
        if (SetUpStatus.ALREADY.equals((Object)status)) {
            this.mospParams.setNextCommand("PF0010");
            return;
        }
        DbSetUpParameterInterface parameter = DbSetUpManagement.initParameter((MospParams)this.mospParams);
        XmlCreateVo vo = (XmlCreateVo)this.mospParams.getStoredVo(XmlCreateVo.class.getName());
        parameter.setServerName(vo.getTxtServer());
        parameter.setPort(this.getInt(vo.getTxtPort()));
        parameter.setDbName(vo.getTxtDbName());
        parameter.setUserName(vo.getTxtRoleName());
        parameter.setUserPassword(vo.getTxtRolePw());
        parameter.setCommand(Command.AS_USER);
        DbSetUpManagement management = DbSetUpManagement.getInstance((MospParams)this.mospParams, (DbSetUpParameterInterface)parameter);
        if (SetUpStatus.ERROR.equals((Object)management.confirm())) {
            return;
        }
        management.createXml();
        if (!this.mospParams.hasErrorMessage()) {
            this.mospParams.setNextCommand("PF0010");
        }
    }
}

