/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public abstract class TimeBean
extends PlatformBean {
    public static final int TIMES_WORK_DEFAULT = 1;
    public static final int MILLI_SEC_PER_HOUR = 3600000;
    public static final String REG_ATTENDANCE_TIME = "([0-3][0-9]|[4][0-7])[0-5][0-9]";

    public TimeBean() {
    }

    protected TimeBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    protected Set<String> getTimeFunctionSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        set.add("4");
        set.add("5");
        set.add("6");
        return set;
    }

    protected Date getTime(Date time, Date standardDate) throws MospException {
        long deference = time.getTime() - this.getDefaultStandardDate().getTime();
        return new Date(standardDate.getTime() + deference);
    }

    protected Date getDefaultStandardDate() throws MospException {
        return DateUtility.getTime((int)0, (int)0);
    }

    protected int getDefferenceMinutes(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        long defference = endTime.getTime() - startTime.getTime();
        return (int)(defference / 60000L);
    }

    protected String getStringTime(Date date, Date standardDate) {
        if (date == null) {
            return this.getHyphenNaming();
        }
        return DateUtility.getStringTime((Date)date, (Date)standardDate);
    }

    protected Date getAttendanceTime(Date date, String time) {
        if (!time.matches(REG_ATTENDANCE_TIME)) {
            this.mospParams.addErrorMessage("TMW0233", new String[]{this.getStringDate(date)});
            return null;
        }
        Integer hour = this.getInteger(time.substring(0, 2));
        Integer minute = this.getInteger(time.substring(2, 4));
        long attendanceTime = date.getTime();
        attendanceTime += hour.longValue() * 3600000L;
        return new Date(attendanceTime += (long)(minute * 3600000 / 60));
    }

    protected String getHyphenNaming() {
        return this.mospParams.getName("Hyphen");
    }

    protected void addScheduleNotExistErrorMessage(Date targetDate) {
        String[] rep = new String[]{this.getStringDate(targetDate), this.mospParams.getName("Calendar", new String[]{"Information"})};
        this.mospParams.addErrorMessage("TMW0246", rep);
    }

    protected void addWorkTypeNotExistErrorMessage(Date targetDate) {
        String[] rep = new String[]{this.getStringDate(targetDate), this.mospParams.getName("Work", new String[]{"Form", "Information"})};
        this.mospParams.addErrorMessage("TMW0246", rep);
    }

    protected void addNotWorkDateErrorMessage(Date targetDate) {
        this.mospParams.addErrorMessage("TMW0249", new String[]{this.getStringDate(targetDate), this.mospParams.getName("jp.mosp.time.input.vo.WorkOnHolidayRequestVo")});
    }

    protected void addSettingApplicationDefectLimitStandardErrorMessage(Date date) {
        String errorMes = this.mospParams.getName("Limit", new String[]{"Norm"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{errorMes});
    }

    protected void addOvertimeTargetWorkDateHolidayErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("OvertimeWork", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addOvertimeTargetDateOvertimeErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("OvertimeWork"), this.mospParams.getName("OvertimeWork", new String[]{"Year", "Month", "Day", "Or", "OvertimeWork", "Type"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addOvertimeTargetDateRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("OvertimeWork", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0277", aryRep);
    }

    protected void addOvertimeTargetWorkDateWorkOnHolidayRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("Holiday", new String[]{"GoingWork"}), this.mospParams.getName("OvertimeWork", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0246", aryRep);
    }

    protected void addOvertimeTargetWorkDateAttendanceRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("OvertimeWork", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addOvertimePeriodErrorMessage() {
        String[] aryRep = new String[]{this.mospParams.getName("OvertimeWork", new String[]{"Application"}), this.mospParams.getName("No1", new String[]{"Months"}), this.mospParams.getName("OvertimeWork", new String[]{"Year"})};
        this.mospParams.addErrorMessage("TMW0241", aryRep);
    }

    protected void addOvertimeRequestTimeErrorMessage() {
        this.mospParams.addErrorMessage("PFW0105", new String[]{this.mospParams.getName("OvertimeWork", new String[]{"Application", "Time"}), this.mospParams.getName("Time")});
    }

    protected void addOvertimeRequestReasonErrorMessage() {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("OvertimeWork", new String[]{"Reason"})});
    }

    protected void addHolidayNotExistErrorMessage() {
        String rep = this.mospParams.getName("Vacation", new String[]{"Classification"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }

    protected void addHolidayNotGiveErrorMessage(String holidayName) {
        this.mospParams.addErrorMessage("TMW0259", new String[]{holidayName});
    }

    protected void addHolidayNumDaysExcessErrorMessage(String holidayName, String unit) {
        this.mospParams.addErrorMessage("TMW0254", new String[]{holidayName, unit});
    }

    protected void addHolidayTargetWorkDateHolidayErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addHolidayTargetDateRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0277", aryRep);
    }

    protected void addHolidayTargetWorkDateAttendanceRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addHolidayRequestDateErrorMessage() {
        this.mospParams.addErrorMessage("TMW0251", new String[0]);
    }

    protected void addHolidayOverlapRange1ErrorMessage() {
        String errorMes1 = this.mospParams.getName("Vacation", new String[]{"Content"});
        String errorMes2 = this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day"});
        this.mospParams.addErrorMessage("TMW0243", new String[]{errorMes1, errorMes2});
    }

    protected void addHolidayOverlapRange2ErrorMessage() {
        String errorMes1 = this.mospParams.getName("Vacation", new String[]{"Content"});
        String errorMes2 = this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day", "Or", "Vacation", "Range"});
        this.mospParams.addErrorMessage("TMW0243", new String[]{errorMes1, errorMes2});
    }

    protected void addHolidayRequestReasonErrorMessage() {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Vacation", new String[]{"Reason"}), null});
    }

    protected void addHolidayLimitDateErrorMessage() {
        String rep = this.mospParams.getName("Vacation", new String[]{"Year", "Month", "Day"});
        this.mospParams.addErrorMessage("TMW0244", new String[]{rep});
    }

    protected void addWorkOnHolidayTargetWorkDateHolidayErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("Holiday"), this.mospParams.getName("GoingWork", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addWorkOnHolidayTargetDateRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("GoingWork", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0277", aryRep);
    }

    protected void addWorkOnHolidayTargetDateWorkOnHolidayRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("Holiday", new String[]{"GoingWork"}), this.mospParams.getName("GoingWork", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addWorkOnHolidayRequestReasonErrorMessage() {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Application", new String[]{"Reason"})});
    }

    protected void addSubHolidayTargetDateSubHolidayRequestErrorMessage() {
        String errorMes1 = this.mospParams.getName("Vacation", new String[]{"Content"});
        String errorMes2 = this.mospParams.getName("CompensatoryHoliday", new String[]{"Day", "Or", "Vacation", "Range"});
        this.mospParams.addErrorMessage("TMW0243", new String[]{errorMes1, errorMes2});
    }

    protected void addSubHolidayTargetDateRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0277", aryRep);
    }

    protected void addSubHolidayTargetWorkDateAttendanceRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addSubHolidayTargetNoWorkDateErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addSubHolidayTargetWorkDateHolidayErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("CompensatoryHoliday", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addDifferenceTargetWorkDateHolidayErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Day"})};
        this.mospParams.addErrorMessage("TMW0242", aryRep);
    }

    protected void addDifferenceTargetWorkDateAttendanceRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addDifferenceTargetDateRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{this.getStringDate(date), this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Day"})};
        this.mospParams.addErrorMessage("TMW0277", aryRep);
    }

    protected void addDifferencePeriodErrorMessage() {
        String[] aryRep = new String[]{this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Application"}), this.mospParams.getName("No1", new String[]{"Months"}), this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Day"})};
        this.mospParams.addErrorMessage("TMW0241", aryRep);
    }

    protected void addDifferenceTargetDateDifferenceRequestErrorMessage(Date date) {
        String[] aryRep = new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}), this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Day"})};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void addDifferenceRequestReasonErrorMessage() {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Reason")});
    }

    protected void addOthersRequestErrorMessage(Date date, String requestTitle) {
        String[] aryRep = new String[]{this.getStringDate(date), requestTitle};
        this.mospParams.addErrorMessage("TMW0309", aryRep);
    }

    protected void addAttendancePeriodErrorMessage(String limit) {
        String[] aryRep = new String[]{this.mospParams.getName("WorkManage", new String[]{"Application"}), limit, this.mospParams.getName("Work", new String[]{"Day"})};
        this.mospParams.addErrorMessage("TMW0241", aryRep);
    }

    protected void addMonthlyTreatmentErrorMessage(int targetYear, int targetMonth, String name) {
        String mes1 = targetYear + this.mospParams.getName("Year") + targetMonth + this.mospParams.getName("Month");
        this.mospParams.addErrorMessage("TMW0272", new String[]{mes1, name});
    }

    protected void addNotUserAttendanceManagementTargetErrorMessage(Date targetDate, String code) {
        this.mospParams.addErrorMessage("TMW0273", new String[]{DateUtility.getStringDate((Date)targetDate), code});
    }

    protected void initial(String personalId, Date targetDate, String functionCode) throws MospException {
        ApplicationReferenceBeanInterface applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        TimeSettingReferenceBeanInterface timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        ScheduleReferenceBeanInterface scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        PaidHolidayReferenceBeanInterface paidHolidayReference = (PaidHolidayReferenceBeanInterface)this.createBean(PaidHolidayReferenceBeanInterface.class);
        ApplicationDtoInterface applicationDto = applicationReference.findForPerson(personalId, targetDate);
        applicationReference.chkExistApplication(applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), targetDate);
        timeSettingReference.chkExistTimeSetting(timeSettingDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (timeSettingDto.getTimeManagementFlag() != 0) {
            HumanDtoInterface dto = this.getHumanInfo(personalId, targetDate);
            if (timeSettingDto.getTimeManagementFlag() == 2 && (functionCode.equals("3") || functionCode.equals("4") || functionCode.equals("7"))) {
                return;
            }
            this.addNotUserAttendanceManagementTargetErrorMessage(targetDate, dto.getEmployeeCode());
            return;
        }
        ScheduleDtoInterface scheduleDto = scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
        scheduleReference.chkExistSchedule(scheduleDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PaidHolidayDtoInterface paidHolidayDto = paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), targetDate);
        paidHolidayReference.chkExistPaidHoliday(paidHolidayDto, targetDate);
    }

    protected int getRoundMinute(int time, int type, int unit) {
        return TimeUtility.getRoundMinute((int)time, (int)type, (int)unit);
    }

    protected boolean checkDuplicationTimeZone(Date requestStartTime, Date requestEndTime, Date startTime, Date endTime) {
        if (startTime.equals(requestStartTime) || endTime.equals(requestEndTime)) {
            return true;
        }
        if (startTime.before(requestStartTime) && endTime.after(requestStartTime)) {
            return true;
        }
        return startTime.after(requestStartTime) && startTime.before(requestEndTime);
    }
}

