/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.AppliReasonDataExportBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.comparator.report.AppliReasonDataComparator;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class AppliReasonDataExportBean
extends TimeApplicationBean
implements AppliReasonDataExportBeanInterface {
    public static final String FILENAME_EXTENSION_CSV = ".csv";
    protected ExportDaoInterface exportDao;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface sectionReference;
    protected ExportFieldDaoInterface exportFieldDao;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected AttendanceReferenceBeanInterface attendanceRefer;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected HolidayDaoInterface holidayDao;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected SubstituteDaoInterface substituteDao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected WorkTypeChangeRequestDaoInterface workTypeChangeRequestDao;
    WorkTypeReferenceBeanInterface workTypeRefer;
    protected DifferenceRequestDaoInterface differenceRequestDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    private int ckbNeedLowerSection = 0;
    protected List<HumanDtoInterface> humanList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<WorkOnHolidayRequestDtoInterface> workOnHolidayList;
    protected List<DifferenceRequestDtoInterface> differenceRequestList;
    protected List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList;

    public AppliReasonDataExportBean() {
    }

    public AppliReasonDataExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.attendanceRefer = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.workTypeChangeRequestDao = (WorkTypeChangeRequestDaoInterface)this.createDao(WorkTypeChangeRequestDaoInterface.class);
        this.differenceRequestDao = (DifferenceRequestDaoInterface)this.createDao(DifferenceRequestDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public void export(String exportCode, int startYear, int startMonth, int endYear, int endMonth, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, int ckbNeedLowerSection, String positionCode) throws MospException {
        Date lastDate;
        this.ckbNeedLowerSection = ckbNeedLowerSection;
        ExportDtoInterface dto = this.exportDao.findForKey(exportCode);
        if (dto == null) {
            this.addNoExportDataMessage();
            return;
        }
        CutoffDtoInterface cutoffDto = this.cutoffUtil.getCutoff(cutoffCode, startYear, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)startYear, (int)startMonth);
        List list = this.getCsvDataList(dto, firstDate, lastDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)endYear, (int)endMonth), cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (list.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)list));
        this.mospParams.setFileName(this.getFilename(dto, firstDate, lastDate));
    }

    protected List<String[]> getCsvDataList(ExportDtoInterface dto, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List fieldList = this.exportFieldDao.findForList(dto.getExportCode());
        this.getHumanList(list, fieldList, startDate, endDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        for (HumanDtoInterface humanDto : this.humanList) {
            this.getAppliedRequestList(humanDto.getPersonalId(), startDate, endDate);
            this.addOverTimeRequestData(humanDto, list, fieldList, endDate);
            this.addHolidayRequestData(humanDto, list, fieldList, startDate, endDate);
            this.addWorkOnHolidayRequestData(humanDto, list, fieldList, endDate);
            this.addDifferebceRequestData(humanDto, list, fieldList, endDate);
            this.addWorkTypeChangeRequestData(humanDto, list, fieldList, endDate);
        }
        Collections.sort(list, new AppliReasonDataComparator());
        if (dto.getHeader() != 0) {
            this.addHeader(list, this.getHeader(dto, fieldList));
        }
        return list;
    }

    protected void getAppliedRequestList(String personalId, Date startDate, Date endDate) throws MospException {
        this.overtimeRequestList = new ArrayList();
        this.holidayRequestList = new ArrayList();
        this.workOnHolidayList = new ArrayList();
        this.differenceRequestList = new ArrayList();
        this.workTypeChangeRequestList = new ArrayList();
        List overtimeList = this.overtimeRequestDao.findForList(personalId, startDate, endDate);
        for (OvertimeRequestDtoInterface dto : overtimeList) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            this.overtimeRequestList.add(dto);
        }
        List holidayList = this.holidayRequestDao.findForTerm(personalId, startDate, endDate);
        for (HolidayRequestDtoInterface dto : holidayList) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            this.holidayRequestList.add(dto);
        }
        List workList = this.workOnHolidayRequestDao.findForList(personalId, startDate, endDate);
        for (WorkOnHolidayRequestDtoInterface dto : workList) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            this.workOnHolidayList.add(dto);
        }
        List differenceList = this.differenceRequestDao.findForList(personalId, startDate, endDate);
        for (DifferenceRequestDtoInterface dto : differenceList) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            this.differenceRequestList.add(dto);
        }
        List worktypeList = this.workTypeChangeRequestDao.findForTerm(personalId, startDate, endDate);
        for (WorkTypeChangeRequestDtoInterface dto : worktypeList) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) continue;
            this.workTypeChangeRequestList.add(dto);
        }
    }

    protected void addOverTimeRequestData(HumanDtoInterface humanDto, List<String[]> list, List<ExportFieldDtoInterface> fieldList, Date endDate) throws MospException {
        for (OvertimeRequestDtoInterface overtimeDto : this.overtimeRequestList) {
            String[] fieldValue = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                String fieldName = fieldList.get(i).getFieldName();
                fieldValue[i] = this.getHumanData(humanDto, fieldName, endDate);
                if ("work_date".equals(fieldName)) {
                    fieldValue[i] = DateUtility.getStringDateAndDay((Date)overtimeDto.getRequestDate());
                    continue;
                }
                if ("appli_type".equals(fieldName)) {
                    fieldValue[i] = this.mospParams.getName("OvertimeWork");
                    continue;
                }
                if ("appli_detailed_1".equals(fieldName)) {
                    fieldValue[i] = this.getCodeName(overtimeDto.getOvertimeType(), "OverTimeType");
                    continue;
                }
                if ("appli_detailed_2".equals(fieldName)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(overtimeDto.getRequestTime() / 60 + this.mospParams.getName("Time"));
                    sb.append(overtimeDto.getRequestTime() % 60 + this.mospParams.getName("Minutes"));
                    fieldValue[i] = sb.toString();
                    continue;
                }
                if ("appli_detailed_3".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if ("appli_detailed_4".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if (!"appli_reason".equals(fieldName)) continue;
                fieldValue[i] = overtimeDto.getRequestReason();
            }
            list.add(fieldValue);
        }
    }

    protected void addHolidayRequestData(HumanDtoInterface humanDto, List<String[]> list, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        for (HolidayRequestDtoInterface holidayDto : this.holidayRequestList) {
            List dateList = TimeUtility.getDateList((Date)holidayDto.getRequestStartDate(), (Date)holidayDto.getRequestEndDate());
            for (Date requestDate : dateList) {
                String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(humanDto.getPersonalId(), requestDate, true);
                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || requestDate.compareTo(startDate) < 0 || requestDate.compareTo(endDate) > 0) continue;
                String[] fieldValue = new String[fieldList.size()];
                for (int i = 0; i < fieldList.size(); ++i) {
                    String fieldName = fieldList.get(i).getFieldName();
                    fieldValue[i] = this.getHumanData(humanDto, fieldName, endDate);
                    if ("employee_code".equals(fieldName)) {
                        fieldValue[i] = humanDto.getEmployeeCode();
                        continue;
                    }
                    if ("full_name".equals(fieldName)) {
                        fieldValue[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                        continue;
                    }
                    if ("work_date".equals(fieldName)) {
                        fieldValue[i] = DateUtility.getStringDateAndDay((Date)requestDate);
                        continue;
                    }
                    if ("appli_type".equals(fieldName)) {
                        fieldValue[i] = this.mospParams.getName("Vacation");
                        continue;
                    }
                    if ("appli_detailed_1".equals(fieldName)) {
                        fieldValue[i] = this.getCodeName(holidayDto.getHolidayType1(), "HolidayType");
                        continue;
                    }
                    if ("appli_detailed_2".equals(fieldName)) {
                        int holidayType1 = holidayDto.getHolidayType1();
                        String holidayType2 = "";
                        if (holidayType1 == 1) {
                            holidayType2 = this.getCodeName(holidayDto.getHolidayType2(), "HolidayType2WithPay");
                        } else {
                            HolidayDtoInterface holiday = this.holidayDao.findForInfo(holidayDto.getHolidayType2(), requestDate, holidayType1);
                            if (holiday != null) {
                                holidayType2 = holiday.getHolidayAbbr();
                            }
                        }
                        fieldValue[i] = holidayType2;
                        continue;
                    }
                    if ("appli_detailed_3".equals(fieldName)) {
                        fieldValue[i] = this.getCodeName(holidayDto.getHolidayRange(), "HolidayType3Range1");
                        continue;
                    }
                    if ("appli_detailed_4".equals(fieldName)) {
                        String detail4 = "";
                        if (holidayDto.getHolidayRange() == 4) {
                            detail4 = this.getTimeWaveFormat(holidayDto.getStartTime(), holidayDto.getEndTime(), holidayDto.getRequestStartDate());
                        }
                        fieldValue[i] = detail4;
                        continue;
                    }
                    if (!"appli_reason".equals(fieldName)) continue;
                    fieldValue[i] = holidayDto.getRequestReason();
                }
                list.add(fieldValue);
            }
        }
    }

    protected void addWorkOnHolidayRequestData(HumanDtoInterface humanDto, List<String[]> list, List<ExportFieldDtoInterface> fieldList, Date endDate) throws MospException {
        for (WorkOnHolidayRequestDtoInterface workDto : this.workOnHolidayList) {
            String[] fieldValue = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                List substituteList;
                String fieldName = fieldList.get(i).getFieldName();
                fieldValue[i] = this.getHumanData(humanDto, fieldName, endDate);
                if ("employee_code".equals(fieldName)) {
                    fieldValue[i] = humanDto.getEmployeeCode();
                    continue;
                }
                if ("full_name".equals(fieldName)) {
                    fieldValue[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                    continue;
                }
                if ("work_date".equals(fieldName)) {
                    fieldValue[i] = DateUtility.getStringDateAndDay((Date)workDto.getRequestDate());
                    continue;
                }
                if ("appli_type".equals(fieldName)) {
                    fieldValue[i] = this.mospParams.getName("SubstituteWorkAbbr", new String[]{"MiddlePoint", "WorkingHoliday"});
                    continue;
                }
                if ("appli_detailed_1".equals(fieldName)) {
                    String substitute = "";
                    substitute = workDto.getSubstitute() == 3 ? this.mospParams.getName("AnteMeridiem") : (workDto.getSubstitute() == 4 ? this.mospParams.getName("PostMeridiem") : this.getCodeName(workDto.getSubstitute(), "WorkOnHolidaySubstitute"));
                    fieldValue[i] = substitute;
                    continue;
                }
                if ("appli_detailed_2".equals(fieldName)) {
                    String detail2 = "";
                    if (workDto.getSubstitute() == 2) {
                        detail2 = this.getTimeWaveFormat(workDto.getStartTime(), workDto.getEndTime(), workDto.getRequestDate());
                    } else {
                        substituteList = this.substituteDao.findForWorkflow(workDto.getWorkflow());
                        Iterator i$ = substituteList.iterator();
                        if (i$.hasNext()) {
                            SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)i$.next();
                            detail2 = DateUtility.getStringDateAndDay((Date)substituteDto.getSubstituteDate());
                        }
                    }
                    fieldValue[i] = detail2;
                    continue;
                }
                if ("appli_detailed_3".equals(fieldName)) {
                    String detail3 = "";
                    substituteList = this.substituteDao.findForWorkflow(workDto.getWorkflow());
                    for (SubstituteDtoInterface substituteDto : substituteList) {
                        if (substituteDto.getSubstituteRange() == 1) {
                            detail3 = this.mospParams.getName("AllDays");
                            continue;
                        }
                        detail3 = this.getCodeName(substituteDto.getSubstituteRange(), "SubstituteHolidayRange");
                        break;
                    }
                    fieldValue[i] = detail3;
                    continue;
                }
                if ("appli_detailed_4".equals(fieldName)) {
                    String workTypeCode = "";
                    if (!workDto.getWorkTypeCode().isEmpty()) {
                        workTypeCode = workDto.getWorkTypeCode();
                    }
                    fieldValue[i] = workTypeCode;
                    continue;
                }
                if (!"appli_reason".equals(fieldName)) continue;
                fieldValue[i] = workDto.getRequestReason();
            }
            list.add(fieldValue);
        }
    }

    protected void addDifferebceRequestData(HumanDtoInterface humanDto, List<String[]> list, List<ExportFieldDtoInterface> fieldList, Date endDate) throws MospException {
        for (DifferenceRequestDtoInterface differenceDto : this.differenceRequestList) {
            String[] fieldValue = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                String fieldName = fieldList.get(i).getFieldName();
                fieldValue[i] = this.getHumanData(humanDto, fieldName, endDate);
                if ("employee_code".equals(fieldName)) {
                    fieldValue[i] = humanDto.getEmployeeCode();
                    continue;
                }
                if ("full_name".equals(fieldName)) {
                    fieldValue[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                    continue;
                }
                if ("work_date".equals(fieldName)) {
                    fieldValue[i] = DateUtility.getStringDateAndDay((Date)differenceDto.getRequestDate());
                    continue;
                }
                if ("appli_type".equals(fieldName)) {
                    fieldValue[i] = this.mospParams.getName("TimeDifference");
                    continue;
                }
                if ("appli_detailed_1".equals(fieldName)) {
                    String detail1 = "";
                    if ("a".equals(differenceDto.getDifferenceType())) {
                        detail1 = this.mospParams.getName("CharaA");
                    } else if ("b".equals(differenceDto.getDifferenceType())) {
                        detail1 = this.mospParams.getName("CharaB");
                    } else if ("c".equals(differenceDto.getDifferenceType())) {
                        detail1 = this.mospParams.getName("CharaC");
                    } else if ("d".equals(differenceDto.getDifferenceType())) {
                        detail1 = this.mospParams.getName("CharaD");
                    } else if ("s".equals(differenceDto.getDifferenceType())) {
                        detail1 = this.mospParams.getName("CharaS");
                    }
                    fieldValue[i] = detail1;
                    continue;
                }
                if ("appli_detailed_2".equals(fieldName)) {
                    String time;
                    fieldValue[i] = time = this.getTimeWaveFormat(differenceDto.getRequestStart(), differenceDto.getRequestEnd(), differenceDto.getRequestDate());
                    continue;
                }
                if ("appli_detailed_3".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if ("appli_detailed_4".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if (!"appli_reason".equals(fieldName)) continue;
                fieldValue[i] = differenceDto.getRequestReason();
            }
            list.add(fieldValue);
        }
    }

    protected void addWorkTypeChangeRequestData(HumanDtoInterface humanDto, List<String[]> list, List<ExportFieldDtoInterface> fieldList, Date endDate) throws MospException {
        for (WorkTypeChangeRequestDtoInterface workTypeChangeDto : this.workTypeChangeRequestList) {
            String[] fieldValue = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                String fieldName = fieldList.get(i).getFieldName();
                fieldValue[i] = this.getHumanData(humanDto, fieldName, endDate);
                if ("employee_code".equals(fieldName)) {
                    fieldValue[i] = humanDto.getEmployeeCode();
                    continue;
                }
                if ("full_name".equals(fieldName)) {
                    fieldValue[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                    continue;
                }
                if ("work_date".equals(fieldName)) {
                    fieldValue[i] = DateUtility.getStringDateAndDay((Date)workTypeChangeDto.getRequestDate());
                    continue;
                }
                if ("appli_type".equals(fieldName)) {
                    fieldValue[i] = this.mospParams.getName("WorkTypeAbbr", new String[]{"Change"});
                    continue;
                }
                if ("appli_detailed_1".equals(fieldName)) {
                    fieldValue[i] = this.workTypeRefer.getWorkTypeAbbrAndTime(workTypeChangeDto.getWorkTypeCode(), workTypeChangeDto.getRequestDate());
                    continue;
                }
                if ("appli_detailed_2".equals(fieldName)) {
                    fieldValue[i] = workTypeChangeDto.getWorkTypeCode();
                    continue;
                }
                if ("appli_detailed_3".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if ("appli_detailed_4".equals(fieldName)) {
                    fieldValue[i] = "";
                    continue;
                }
                if (!"appli_reason".equals(fieldName)) continue;
                fieldValue[i] = workTypeChangeDto.getRequestReason();
            }
            list.add(fieldValue);
        }
    }

    protected void getHumanList(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setStartDate(startDate);
        this.humanSearch.setEndDate(endDate);
        this.humanSearch.setTargetDate(endDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        if (this.ckbNeedLowerSection == 1) {
            this.humanSearch.setNeedLowerSection(true);
        } else {
            this.humanSearch.setNeedLowerSection(false);
        }
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        List presenceHumanList = this.humanSearch.search();
        this.humanSearch.setStateType("suspend");
        List suspendHumanList = this.humanSearch.search();
        ArrayList allHumanList = new ArrayList();
        allHumanList.addAll(presenceHumanList);
        allHumanList.addAll(suspendHumanList);
        this.humanList = new ArrayList();
        if (cutoffCode.isEmpty()) {
            this.humanList = allHumanList;
        } else {
            for (HumanDtoInterface humanDto : allHumanList) {
                if (!this.hasCutoffSettings(humanDto.getPersonalId(), endDate) || !this.cutoffDto.getCutoffCode().equals(cutoffCode)) continue;
                this.humanList.add(humanDto);
            }
        }
    }

    protected String getHumanData(HumanDtoInterface dto, String fieldName, Date targetDate) throws MospException {
        if ("employee_code".equals(fieldName)) {
            return dto.getEmployeeCode();
        }
        if ("full_name".equals(fieldName)) {
            return MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
        }
        if ("section_name".equals(fieldName)) {
            return this.sectionReference.getSectionName(dto.getSectionCode(), targetDate);
        }
        if ("section_display".equals(fieldName)) {
            return this.sectionReference.getSectionDisplay(dto.getSectionCode(), targetDate);
        }
        return "";
    }

    protected void addHeader(List<String[]> csvDataList, String[] header) {
        csvDataList.add(0, header);
    }

    protected String[] getHeader(ExportDtoInterface dto, List<ExportFieldDtoInterface> list) {
        String[][] array = this.mospParams.getProperties().getCodeArray(dto.getExportTable(), false);
        String[] header = new String[list.size()];
        for (int i = 0; i < header.length; ++i) {
            header[i] = MospUtility.getCodeName((String)list.get(i).getFieldName(), (String[][])array);
        }
        return header;
    }

    protected String getFilename(ExportDtoInterface dto, Date firstDate, Date lastDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getExportCode());
        sb.append(this.mospParams.getName("Hyphen"));
        sb.append(DateUtility.getStringYear((Date)firstDate));
        sb.append(DateUtility.getStringMonth((Date)firstDate));
        sb.append(DateUtility.getStringDay((Date)firstDate));
        sb.append(this.mospParams.getName("Hyphen"));
        sb.append(DateUtility.getStringYear((Date)lastDate));
        sb.append(DateUtility.getStringMonth((Date)lastDate));
        sb.append(DateUtility.getStringDay((Date)lastDate));
        sb.append(this.getFilenameExtension(dto));
        return sb.toString();
    }

    protected String getFilenameExtension(ExportDtoInterface dto) {
        if ("1".equals(dto.getType())) {
            return FILENAME_EXTENSION_CSV;
        }
        return "";
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }

    protected String getTimeDotFormat(int time) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.convIntegerTimeToIntegerHour(time));
        sb.append(this.mospParams.getName("Dot"));
        sb.append(this.convIntegerTimeToStringMinutes(time));
        return sb.toString();
    }

    protected int convIntegerTimeToIntegerHour(int time) {
        return time / 60;
    }

    protected String convIntegerTimeToStringMinutes(int time) {
        int minute = this.convIntegerTimeToIntegerMinute(time);
        StringBuffer sb = new StringBuffer();
        if (minute < 10) {
            sb.append(0);
        }
        sb.append(minute);
        return sb.toString();
    }

    protected int convIntegerTimeToIntegerMinute(int time) {
        return Math.abs(time) % 60;
    }

    protected String getTimeWaveFormat(Date date1, Date date2, Date standardDate) {
        if (date1 == null || date2 == null || standardDate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtility.getStringTime((Date)date1, (Date)standardDate));
        sb.append(this.mospParams.getName("Wave"));
        sb.append(DateUtility.getStringTime((Date)date2, (Date)standardDate));
        return sb.toString();
    }
}

