/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.time.bean.ApplicationRegistBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmApplicationDto;

public class ApplicationRegistBean
extends PlatformBean
implements ApplicationRegistBeanInterface {
    ApplicationDaoInterface dao;
    HumanReferenceBeanInterface human;

    public ApplicationRegistBean() {
    }

    public ApplicationRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ApplicationDaoInterface)this.createDao(ApplicationDaoInterface.class);
    }

    public ApplicationDtoInterface getInitDto() {
        return new TmmApplicationDto();
    }

    public void insert(ApplicationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(ApplicationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(ApplicationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmApplicationId());
        dto.setTmmApplicationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(ApplicationDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmApplicationId());
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) {
    }

    public void delete(long[] idArray) {
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            ApplicationDtoInterface dto = (ApplicationDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getApplicationCode());
        }
        return list;
    }

    protected void checkInsert(ApplicationDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getApplicationCode()));
        this.checkSettingDuplicate(dto, false);
    }

    protected void checkAdd(ApplicationDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getApplicationCode(), dto.getActivateDate()));
        this.checkSettingDuplicate(dto, false);
    }

    protected void checkUpdate(ApplicationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmApplicationId());
        this.checkSettingDuplicate(dto, false);
    }

    protected void checkDelete(ApplicationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmApplicationId());
        this.checkSettingDuplicate(dto, true);
    }

    protected void validate(ApplicationDtoInterface dto) {
        this.revisionPersonalIds(dto);
    }

    protected void revisionPersonalIds(ApplicationDtoInterface dto) {
        if (dto.getApplicationType() == Integer.parseInt("0")) {
            return;
        }
        dto.setPersonalIds(this.overlapValue(dto.getPersonalIds(), ","));
    }

    protected void checkSettingDuplicate(ApplicationDtoInterface dto, boolean isCheckDelete) throws MospException {
        Date endDate = null;
        ApplicationDtoInterface latterDto = this.dao.findLatterInfo(dto.getApplicationCode(), dto.getActivateDate());
        if (latterDto != null) {
            endDate = latterDto.getActivateDate();
        }
        ApplicationDtoInterface targetDto = dto;
        if (isCheckDelete) {
            targetDto = this.dao.findFormerInfo(dto.getApplicationCode(), dto.getActivateDate());
        }
        if (targetDto == null || !this.isDtoActivate((BaseDtoInterface)targetDto)) {
            return;
        }
        if (targetDto.getApplicationType() == Integer.parseInt("0")) {
            this.checkMasterDuplicate(targetDto, endDate);
        } else {
            for (String personalId : this.asList(targetDto.getPersonalIds(), ",")) {
                this.checkPersonDuplicate(targetDto.getApplicationCode(), targetDto.getActivateDate(), personalId, endDate);
            }
        }
    }

    protected void checkMasterDuplicate(ApplicationDtoInterface dto, Date endDate) throws MospException {
        ApplicationDtoInterface currentDto = this.dao.findForMaster(dto.getActivateDate(), dto.getWorkPlaceCode(), dto.getEmploymentContractCode(), dto.getSectionCode(), dto.getPositionCode());
        if (currentDto != null && !dto.getApplicationCode().equals(currentDto.getApplicationCode())) {
            this.addMasterDuplicateMessage(currentDto.getApplicationCode());
            return;
        }
        List list = this.dao.findMasterDuplicated(dto.getActivateDate(), endDate, dto.getWorkPlaceCode(), dto.getEmploymentContractCode(), dto.getSectionCode(), dto.getPositionCode());
        for (ApplicationDtoInterface targetDto : list) {
            if (dto.getApplicationCode().equals(targetDto.getApplicationCode())) continue;
            this.addMasterDuplicateMessage(targetDto.getApplicationCode());
            return;
        }
    }

    protected void checkPersonDuplicate(String applicationCode, Date activateDate, String personalId, Date endDate) throws MospException {
        ApplicationDtoInterface currentDto = this.dao.findForPersonalId(activateDate, personalId);
        if (currentDto != null && !applicationCode.equals(currentDto.getApplicationCode())) {
            this.addPersonDuplicateMessage(currentDto.getApplicationCode(), currentDto.getActivateDate(), personalId);
            return;
        }
        List list = this.dao.findPersonDuplicated(activateDate, endDate, personalId);
        for (ApplicationDtoInterface latterDto : list) {
            if (applicationCode.equals(latterDto.getApplicationCode())) continue;
            this.addPersonDuplicateMessage(latterDto.getApplicationCode(), latterDto.getActivateDate(), personalId);
            return;
        }
    }

    protected void addPersonDuplicateMessage(String applicationCode, Date activateDate, String personalId) throws MospException {
        if (this.human == null) {
            this.human = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        }
        String employeeCode = this.human.getEmployeeCode(personalId, activateDate);
        this.mospParams.addErrorMessage("PFW0224", new String[]{employeeCode, applicationCode});
    }

    protected void addMasterDuplicateMessage(String applicationCode) {
        this.mospParams.addErrorMessage("PFW0225", new String[]{applicationCode});
    }
}

