/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceBean;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.LimitStandardReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.impl.OvertimeRequestReferenceBean;
import jp.mosp.time.bean.impl.PaidHolidayReferenceBean;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.HolidayUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceListReferenceBean
extends AttendanceBean
implements AttendanceListReferenceBeanInterface {
    public static final int HOURS_DIGITS = 2;
    public static final String SEPARATOR_HOURS = ".";
    public static final String LIMIT_STANDARD_TERM_MONTH1 = "month1";
    protected static final int LEN_HALF_WORK_TYPE = 1;
    protected PaidHolidayReferenceBean paidHoliday;
    protected LimitStandardReferenceBeanInterface limitStandard;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected AttendanceCorrectionReferenceBeanInterface correction;
    protected HolidayRequestReferenceBeanInterface holidayRequest;
    protected OvertimeRequestReferenceBeanInterface overtime;
    protected SubHolidayReferenceBeanInterface subHolidayRefer;
    protected SubHolidayRequestReferenceBeanInterface subHoliday;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChange;
    protected DifferenceRequestReferenceBeanInterface difference;
    protected SectionReferenceBeanInterface section;
    protected WorkPlaceReferenceBeanInterface workPlace;
    protected HolidayReferenceBeanInterface holiday;
    protected RetirementReferenceBeanInterface retirement;
    protected SuspensionReferenceBeanInterface suspension;
    protected ApplicationDtoInterface applicationDto;
    protected TimeSettingDtoInterface timeSettingDto;
    protected CutoffDtoInterface cutoffDto;
    protected ScheduleDtoInterface scheduleDto;
    protected List<ScheduleDateDtoInterface> scheduleDateList;
    protected Map<Date, ApplicationDtoInterface> applicationMap;
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployee;
    protected TimeMasterBeanInterface timeMasterBean;
    protected String personalId;
    protected int targetYear;
    protected int targetMonth;
    protected Date firstDate;
    protected Date lastDate;
    protected boolean isTightened;
    protected int halfWorkTypeLength;
    protected List<AttendanceDtoInterface> attendanceDtoList;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<SubstituteDtoInterface> substituteList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected List<WorkOnHolidayRequestDtoInterface> workOnHolidayRequestList;
    protected List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList;
    protected List<DifferenceRequestDtoInterface> differenceRequestList;
    protected List<AttendanceListDto> attendanceList;
    private RequestUtilBeanInterface requestUtil;
    private Map<Long, WorkflowDtoInterface> workflowMap;
    private Map<String, WorkTypeEntity> workTypeEntityMap;

    public void initBean() throws MospException {
        super.initBean();
        this.paidHoliday = (PaidHolidayReferenceBean)this.createBean(PaidHolidayReferenceBean.class);
        this.limitStandard = (LimitStandardReferenceBeanInterface)this.createBean(LimitStandardReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.correction = (AttendanceCorrectionReferenceBeanInterface)this.createBean(AttendanceCorrectionReferenceBeanInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.overtime = (OvertimeRequestReferenceBean)this.createBean(OvertimeRequestReferenceBean.class);
        this.workOnHoliday = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.subHolidayRefer = (SubHolidayReferenceBeanInterface)this.createBean(SubHolidayReferenceBeanInterface.class);
        this.subHoliday = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.workTypeChange = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.difference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
        this.section = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
        this.workPlace = (WorkPlaceReferenceBeanInterface)this.createBean(WorkPlaceReferenceBeanInterface.class);
        this.holiday = (HolidayReferenceBeanInterface)this.createBean(HolidayReferenceBeanInterface.class);
        this.retirement = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.suspension = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.totalTimeEmployee = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        this.timeMasterBean = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
        this.halfWorkTypeLength = 1;
    }

    public List<AttendanceListDto> getScheduleList(String personalId, Date targetDate) throws MospException {
        this.initFields(personalId);
        this.initDateFields(targetDate);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTargetYearMonth(targetDate);
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addScheduleList(true, true);
        this.addApplicationList(false, false, true);
        this.setApprovalTime();
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setHeaderFields();
        this.setScheduleExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getScheduleList(String personalId, int year, int month) throws MospException {
        this.initFields(personalId);
        this.initDateFields(year, month);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addScheduleList(true, true);
        this.addApplicationList(false, false, true);
        this.setApprovalTime();
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setHeaderFields();
        this.setScheduleExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getActualList(String personalId, Date targetDate) throws MospException {
        this.initFields(personalId);
        this.initDateFields(targetDate);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTargetYearMonth(targetDate);
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTightened();
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(false);
        this.addApplicationList(false, true, false);
        this.addScheduleList(false, false);
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setHeaderFields();
        this.setActualExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getActualList(String personalId, int year, int month) throws MospException {
        this.initFields(personalId);
        this.initDateFields(year, month);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTightened();
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(false);
        this.addApplicationList(false, true, false);
        this.addScheduleList(false, false);
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setHeaderFields();
        this.setActualExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getAttendanceList(String personalId, Date targetDate) throws MospException {
        this.initFields(personalId);
        this.initDateFields(targetDate);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTargetYearMonth(targetDate);
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTightened();
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(true);
        this.addApplicationList(true, false, false);
        this.addDraftList();
        this.addScheduleList(true, false);
        this.setLimitStandard();
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setDtoHyphenFields(this.useScheduledTime());
        this.setNeedCheckbox();
        this.setAttendanceExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getAttendanceList(String personalId, int year, int month) throws MospException {
        this.initFields(personalId);
        this.initDateFields(year, month);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTightened();
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(true);
        this.addApplicationList(true, false, false);
        this.addDraftList();
        this.addScheduleList(true, false);
        this.setLimitStandard();
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setDtoHyphenFields(this.useScheduledTime());
        this.setNeedCheckbox();
        this.setAttendanceExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getWeeklyAttendanceList(String personalId, Date targetDate) throws MospException {
        this.initFields(personalId);
        this.initDateFields(targetDate);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setWeekTerm(targetDate);
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(true);
        this.addApplicationList(true, false, false);
        this.addDraftList();
        this.addScheduleList(true, false);
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setDtoHyphenFields(this.useScheduledTime());
        this.setWeeklyAttendanceExtraInfo();
        return this.attendanceList;
    }

    public List<AttendanceListDto> getApprovalAttendanceList(String personalId, int year, int month) throws MospException {
        this.initFields(personalId);
        this.initDateFields(year, month);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setCutoffTerm();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.setTightened();
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(true);
        this.addApplicationList(true, true, false);
        this.addScheduleList(false, false);
        this.setLimitStandard();
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setDtoHyphenFields(false);
        this.setNeedApprovalCheckbox();
        this.setApprovalAttendanceExtraInfo();
        return this.attendanceList;
    }

    public AttendanceListDto getAttendanceListDto(String personalId, Date targetDate) throws MospException {
        this.initFields(personalId);
        this.initDateFields(targetDate);
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.firstDate = CapsuleUtility.getDateClone((Date)targetDate);
        this.lastDate = CapsuleUtility.getDateClone((Date)targetDate);
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.addActualList(true);
        this.addApplicationList(true, false, false);
        this.addDraftList();
        this.addScheduleList(true, false);
        this.totalAttendanceList();
        this.setDtoStringFields();
        this.setAttendanceListDtoExtraInfo();
        if (this.attendanceList.size() == 1) {
            return (AttendanceListDto)this.attendanceList.get(0);
        }
        return null;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public Date getLastDate() {
        return this.getDateClone(this.lastDate);
    }

    public Date getFirstDate() {
        return this.getDateClone(this.firstDate);
    }

    public int getTargetYear() {
        return this.targetYear;
    }

    public int getTargetMonth() {
        return this.targetMonth;
    }

    public String getScheduleName() {
        return this.scheduleDto == null ? "" : this.scheduleDto.getScheduleName();
    }

    public List<Date> getNotAttendanceAppliList(String personalId, Date startDate, Date endDate) throws MospException {
        List attendanceList = this.getListForAttendanceCheck(personalId, startDate, endDate);
        ArrayList<Date> errorList = new ArrayList<Date>();
        for (AttendanceListDto dto : attendanceList) {
            if (!dto.isNeedCheckbox()) continue;
            errorList.add(dto.getWorkDate());
        }
        return errorList;
    }

    protected List<AttendanceListDto> getListForAttendanceCheck(String personalId, Date firstDate, Date lastDate) throws MospException {
        this.initFields(personalId);
        this.firstDate = firstDate;
        this.lastDate = lastDate;
        this.setApplicationSettings();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.initAttendanceList();
        if (this.mospParams.hasErrorMessage()) {
            return this.attendanceList;
        }
        this.addActualList(true);
        this.addApplicationList(true, false, false);
        this.addDraftList();
        this.addScheduleList(true, false);
        return this.attendanceList;
    }

    protected void initFields(String personalId) {
        this.applicationMap = null;
        this.applicationDto = null;
        this.timeSettingDto = null;
        this.cutoffDto = null;
        this.scheduleDto = null;
        this.scheduleDateList = null;
        this.firstDate = null;
        this.lastDate = null;
        this.attendanceList = new ArrayList();
        this.personalId = personalId;
    }

    protected void initDateFields(Date targetDate) {
        this.targetYear = DateUtility.getYear((Date)targetDate);
        this.targetMonth = DateUtility.getMonth((Date)targetDate);
        this.lastDate = targetDate;
    }

    protected void initDateFields(int year, int month) throws MospException {
        this.targetYear = year;
        this.targetMonth = month;
        this.lastDate = MonthUtility.getYearMonthTargetDate((int)year, (int)month, (MospParams)this.mospParams);
    }

    protected void setHeaderFields() throws MospException {
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(0);
        HumanDtoInterface humanDto = this.getHumanInfo(this.personalId, this.lastDate);
        dto.setTargetDate(MonthUtility.getYearMonthDate((int)this.targetYear, (int)this.targetMonth));
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setEmployeeName(MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName()));
        dto.setSectionName(this.section.getSectionName(humanDto.getSectionCode(), this.lastDate));
        if (this.section.useDisplayName()) {
            dto.setSectionName(this.section.getSectionDisplay(humanDto.getSectionCode(), this.lastDate));
        }
        dto.setWorkPlaceName(this.workPlace.getWorkPlaceName(humanDto.getWorkPlaceCode(), this.lastDate));
        dto.setSealBoxAvailable(true);
        AttendanceListDto lastDto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        lastDto.setSubHolidayRequestValid(TimeUtility.isSubHolidayRequestValid((MospParams)this.mospParams));
    }

    protected void setApplicationSettings() throws MospException {
        this.attendanceList = new ArrayList();
        this.applicationDto = this.applicationReference.findForPerson(this.personalId, this.lastDate);
        this.applicationReference.chkExistApplication(this.applicationDto, this.lastDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.timeSettingDto = this.timeSettingReference.getTimeSettingInfo(this.applicationDto.getWorkSettingCode(), this.lastDate);
        this.timeSettingReference.chkExistTimeSetting(this.timeSettingDto, this.lastDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.cutoffDto = this.cutoffUtil.getCutoff(this.timeSettingDto.getCutoffCode(), this.lastDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.scheduleDto = this.scheduleReference.getScheduleInfo(this.applicationDto.getScheduleCode(), this.lastDate);
        this.scheduleReference.chkExistSchedule(this.scheduleDto, this.lastDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void setTargetYearMonth(Date targetDate) throws MospException {
        int cutoffDate = this.cutoffDto.getCutoffDate();
        Date yearMonth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)targetDate);
        this.targetYear = DateUtility.getYear((Date)yearMonth);
        this.targetMonth = DateUtility.getMonth((Date)yearMonth);
    }

    protected void setCutoffTerm() throws MospException {
        int cutoffDate = this.cutoffDto.getCutoffDate();
        this.firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)this.targetYear, (int)this.targetMonth);
        this.lastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)this.targetYear, (int)this.targetMonth);
        if (!this.isEntered(this.personalId, this.lastDate) || this.applicationReference.findForPerson(this.personalId, this.lastDate) == null) {
            this.setApplicationSettings();
        }
    }

    protected void setTightened() throws MospException {
        Integer state = this.totalTimeEmployee.getCutoffState(this.personalId, this.targetYear, this.targetMonth);
        this.isTightened = state != null && state != 0;
    }

    protected void initAttendanceList() throws MospException {
        this.attendanceList = new ArrayList();
        Date workDate = this.getDateClone(this.firstDate);
        while (!workDate.after(this.lastDate)) {
            AttendanceListDto dto = new AttendanceListDto();
            dto.setWorkDate(workDate);
            dto.setPersonalId(this.personalId);
            this.attendanceList.add(dto);
            workDate = this.addDay(workDate, 1);
        }
        this.workflowMap = new HashMap();
        this.workTypeEntityMap = new HashMap();
        this.applicationMap = this.timeMasterBean.getApplicationMap(this.personalId, this.firstDate, this.lastDate);
        this.scheduleDateList = this.scheduleDateReference.findForList(this.scheduleDto.getScheduleCode(), this.firstDate, this.lastDate);
        this.attendanceDtoList = this.attendanceReference.getAttendanceList(this.personalId, this.firstDate, this.lastDate);
        this.holidayRequestList = this.holidayRequest.getHolidayRequestList(this.personalId, this.firstDate, this.lastDate);
        this.overtimeRequestList = this.overtime.getOvertimeRequestList(this.personalId, this.firstDate, this.lastDate);
        this.subHolidayRequestList = this.subHoliday.getSubHolidayRequestList(this.personalId, this.firstDate, this.lastDate);
        this.substituteList = this.substituteReference.getSubstituteList(this.personalId, this.firstDate, this.lastDate);
        this.workOnHolidayRequestList = this.workOnHoliday.getWorkOnHolidayRequestList(this.personalId, this.firstDate, this.lastDate);
        this.workTypeChangeRequestList = this.workTypeChange.getWorkTypeChangeRequestList(this.personalId, this.firstDate, this.lastDate);
        this.differenceRequestList = this.difference.getDifferenceRequestList(this.personalId, this.firstDate, this.lastDate);
    }

    protected void addApplicationList(boolean containNotApproved, boolean isActualList, boolean isSchedule) throws MospException {
        this.addWorkTypeChangeRequestList(containNotApproved, isActualList, isSchedule);
        this.addHolidayRequestList(containNotApproved);
        this.addWorkOnHolidayRequestList(containNotApproved, isActualList);
        this.addSubstituteList(containNotApproved);
        this.addSubHolidayRequestList(containNotApproved);
        this.addOvertimeRequestList(containNotApproved);
        this.addDifferenceRequestList(containNotApproved, isActualList);
        this.confirmTimelyPaidHoliday();
        this.checkPluralRequest(containNotApproved);
    }

    protected void addHolidayRequestList(boolean containNotApproved) throws MospException {
        float paidHolidays = 0.0f;
        float paidHolidayTime = 0.0f;
        float specialHolidays = 0.0f;
        float otherHolidays = 0.0f;
        float absenceDays = 0.0f;
        this.holidayRequestList = this.holidayRequest.getHolidayRequestList(this.personalId, this.firstDate, this.lastDate);
        for (HolidayRequestDtoInterface holidayRequestDto : this.holidayRequestList) {
            WorkflowDtoInterface workflowDto = this.getWorkflow(holidayRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                Date targetDate = holidayRequestDto.getRequestStartDate();
                Date endDate = holidayRequestDto.getRequestEndDate();
                while (!endDate.before(targetDate)) {
                    ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(this.personalId, targetDate);
                    this.applicationReference.chkExistApplication(applicationDto, targetDate);
                    if (this.mospParams.hasErrorMessage()) {
                        return;
                    }
                    ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
                    this.scheduleReference.chkExistSchedule(scheduleDto, targetDate);
                    if (this.mospParams.hasErrorMessage()) {
                        return;
                    }
                    ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
                    this.scheduleDateReference.chkExistScheduleDate(scheduleDateDto, targetDate);
                    if (this.mospParams.hasErrorMessage()) {
                        return;
                    }
                    String workTypeCode = scheduleDateDto.getWorkTypeCode();
                    this.requestUtil.setRequests(this.personalId, targetDate);
                    WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
                    if (workOnHolidayRequestDto == null) {
                        for (SubstituteDtoInterface substituteDto : this.requestUtil.getSubstituteList(true)) {
                            if (!this.isAll(substituteDto)) continue;
                            workTypeCode = substituteDto.getSubstituteType();
                            break;
                        }
                    } else {
                        workTypeCode = this.getWorkOnHolidayWorkType(workOnHolidayRequestDto);
                    }
                    if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
                        targetDate = this.addDay(targetDate, 1);
                        continue;
                    }
                    AttendanceListDto dto = this.getAttendanceListDto(targetDate);
                    targetDate = this.addDay(targetDate, 1);
                    if (dto == null) continue;
                    String remark = this.getHolidayNaming() + this.getDraftAbbrNaming();
                    Map timeHoliday = this.holidayRequest.getTimeHolidayStatusTimesMap(this.personalId, dto.getWorkDate(), null);
                    if ((Integer)timeHoliday.get(this.getDraftAbbrNaming()) > 0) {
                        remark = remark + " " + this.mospParams.getName("Hour") + timeHoliday.get(this.getDraftAbbrNaming());
                    }
                    this.addRemark(dto, remark);
                }
                continue;
            }
            float times = this.getHolidayTimes(holidayRequestDto);
            Date targetDate = holidayRequestDto.getRequestStartDate();
            Date endDate = holidayRequestDto.getRequestEndDate();
            while (!endDate.before(targetDate)) {
                ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(this.personalId, targetDate);
                this.applicationReference.chkExistApplication(applicationDto, targetDate);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
                this.scheduleReference.chkExistSchedule(scheduleDto, targetDate);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
                this.scheduleDateReference.chkExistScheduleDate(scheduleDateDto, targetDate);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                String workTypeCode = scheduleDateDto.getWorkTypeCode();
                this.requestUtil.setRequests(this.personalId, targetDate);
                WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
                if (workOnHolidayRequestDto == null) {
                    for (SubstituteDtoInterface substituteDto : this.requestUtil.getSubstituteList(true)) {
                        if (!this.isAll(substituteDto)) continue;
                        workTypeCode = substituteDto.getSubstituteType();
                        break;
                    }
                } else {
                    workTypeCode = this.getWorkOnHolidayWorkType(workOnHolidayRequestDto);
                }
                if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
                    targetDate = this.addDay(targetDate, 1);
                    continue;
                }
                AttendanceListDto dto = this.getAttendanceListDto(targetDate);
                targetDate = this.addDay(targetDate, 1);
                if (dto == null) continue;
                this.setDtoFields(dto, holidayRequestDto, workflowDto);
                switch (holidayRequestDto.getHolidayType1()) {
                    case 1: {
                        if (holidayRequestDto.getHolidayRange() == 4) {
                            paidHolidayTime += times;
                            break;
                        }
                        paidHolidays += times;
                        break;
                    }
                    case 2: {
                        specialHolidays += times;
                        break;
                    }
                    case 3: {
                        otherHolidays += times;
                        break;
                    }
                    case 4: {
                        absenceDays += times;
                        break;
                    }
                }
            }
        }
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        dto.setPaidHolidays(Float.valueOf(paidHolidays));
        dto.setPaidHolidayTime(Float.valueOf(paidHolidayTime));
        dto.setSpecialHolidays(Float.valueOf(specialHolidays));
        dto.setOtherHolidays(Float.valueOf(otherHolidays));
        dto.setAbsenceDays(Float.valueOf(absenceDays));
    }

    protected boolean isRequestNeeded(WorkflowDtoInterface workflowDto, boolean containNotApproved) throws MospException {
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return false;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return false;
        }
        return containNotApproved || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto);
    }

    protected boolean isRevert(WorkflowDtoInterface dto) {
        return "3".equals(dto.getWorkflowStatus());
    }

    protected float getHolidayTimes(HolidayRequestDtoInterface holidayRequestDto) {
        switch (holidayRequestDto.getHolidayRange()) {
            case 1: {
                return 1.0f;
            }
            case 2: 
            case 3: {
                return 0.5f;
            }
            case 4: {
                return holidayRequestDto.getUseHour();
            }
        }
        return 0.0f;
    }

    protected float getHolidayTimes(int holidayRange) {
        switch (holidayRange) {
            case 1: {
                return 1.0f;
            }
            case 2: 
            case 3: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    protected void setDtoFields(AttendanceListDto dto, HolidayRequestDtoInterface holidayRequestDto, WorkflowDtoInterface workflowDto) throws MospException {
        String remark = this.getHolidayNaming() + this.getWorkflowStatusAbbr(workflowDto);
        Map timeHoliday = this.holidayRequest.getTimeHolidayStatusTimesMap(this.personalId, holidayRequestDto.getRequestStartDate(), null);
        if ((Integer)timeHoliday.get(this.getWorkflowStatusAbbr(workflowDto)) > 0) {
            remark = remark + " " + this.mospParams.getName("Hour") + timeHoliday.get(this.getWorkflowStatusAbbr(workflowDto));
        }
        this.addRemark(dto, remark);
        if (holidayRequestDto.getHolidayRange() != 1) {
            return;
        }
        dto.setWorkTypeCode("");
        dto.setNeedCheckbox(false);
        dto.setApplicationInfo(this.workflow.getWorkflowStatus(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        dto.setNeedStatusLink(false);
        dto.setAttendanceRecordId(holidayRequestDto.getTmdHolidayRequestId());
        dto.setWorkTypeAbbr(this.getWorkTypeAbbr(holidayRequestDto));
        this.setCut(dto);
        this.setShortUnpaid(dto);
    }

    protected String getWorkflowStatusAbbr(WorkflowDtoInterface workflowDto) {
        if (workflowDto == null) {
            return "";
        }
        if ("5".equals(workflowDto.getWorkflowStatus())) {
            return "";
        }
        if (this.workflow.isDraft(workflowDto)) {
            return this.getDraftAbbrNaming();
        }
        if ("9".equals(workflowDto.getWorkflowStatus())) {
            return this.getCompleteApprovalAbbrNaming();
        }
        if (this.isRevert(workflowDto) && workflowDto.getWorkflowStage() == 0) {
            return this.getRevertAbbrNaming();
        }
        return this.getApprovalAbbrNaming();
    }

    protected String getWorkOnHolidayAbbr(WorkOnHolidayRequestDtoInterface dto) {
        int substitute = dto.getSubstitute();
        if (substitute == 1 || substitute == 5 || substitute == 3 || substitute == 4) {
            return this.getSubstituteWorkAbbrNaming();
        }
        if (substitute == 2) {
            return this.getWorkOnHolidayAbbrNaming();
        }
        return "";
    }

    protected void addWorkOnHolidayRequestList(boolean containNotApproved, boolean isActualList) throws MospException {
        for (WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto : this.workOnHolidayRequestList) {
            AttendanceDtoInterface attendanceDto;
            AttendanceListDto dto = this.getAttendanceListDto(workOnHolidayRequestDto.getRequestDate());
            String requestAbbr = this.getWorkOnHolidayAbbr(workOnHolidayRequestDto);
            WorkflowDtoInterface workflowDto = this.getWorkflow(workOnHolidayRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                this.addRemark(dto, requestAbbr + this.getDraftAbbrNaming());
                continue;
            }
            this.addRemark(dto, requestAbbr + this.getWorkflowStatusAbbr(workflowDto));
            if (dto.getWorkTypeCode() != null) continue;
            this.setNeedCheckbox(dto, workOnHolidayRequestDto);
            if (isActualList) {
                dto.setWorkTypeCode("");
                continue;
            }
            dto.setWorkTypeCode(this.getWorkOnHolidayWorkType(workOnHolidayRequestDto));
            if (workOnHolidayRequestDto.getSubstitute() == 2) {
                dto.setStartTime(this.getWorkTypeStartTime(dto));
                dto.setEndTime(this.getWorkTypeEndTime(dto));
                dto.setApplicationInfo(this.getScheduleNaming());
            } else {
                this.setDtoFields(dto, dto.getWorkTypeCode(), true, false, workOnHolidayRequestDto.getSubstitute() == 4, workOnHolidayRequestDto.getSubstitute() == 3);
                this.setNeedCheckbox(dto, workOnHolidayRequestDto);
            }
            if ((attendanceDto = this.getAttendanceDtoListDto(dto.getWorkDate())) == null) continue;
            WorkflowDtoInterface attendanceWorkflow = this.getWorkflow(attendanceDto.getWorkflow());
            this.setDtoFields(dto, attendanceDto, attendanceWorkflow);
            this.setNeedCheckbox(dto, workOnHolidayRequestDto);
        }
    }

    protected void addSubstituteList(boolean containNotApproved) throws MospException {
        float substituteHolidays = 0.0f;
        for (SubstituteDtoInterface substituteDto : this.substituteList) {
            WorkflowDtoInterface sameDayWorkflowDto;
            WorkOnHolidayRequestDtoInterface sameDayWorkOnHolidayRequestDto;
            WorkflowDtoInterface workflowDto;
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHoliday.findForWorkflow(substituteDto.getWorkflow());
            if (workOnHolidayRequestDto == null || !this.isRequestNeeded(workflowDto = this.getWorkflow(workOnHolidayRequestDto.getWorkflow()), containNotApproved) || (sameDayWorkOnHolidayRequestDto = this.workOnHoliday.findForKeyOnWorkflow(this.personalId, substituteDto.getSubstituteDate())) != null && this.isRequestNeeded(sameDayWorkflowDto = this.getWorkflow(workOnHolidayRequestDto.getWorkflow()), containNotApproved)) continue;
            AttendanceListDto dto = this.getAttendanceListDto(substituteDto.getSubstituteDate());
            this.addRemark(dto, this.getSubstituteAbbrNaming() + this.getWorkflowStatusAbbr(workflowDto));
            substituteHolidays += this.getHolidayTimes(substituteDto.getSubstituteRange());
            if (substituteDto.getSubstituteRange() != 1) continue;
            dto.setWorkTypeCode("");
            if (substituteDto.getSubstituteType().equals("legal_holiday")) {
                dto.setWorkTypeAbbr(this.getLegalSubstituteAbbrNaming());
            } else {
                dto.setWorkTypeAbbr(this.getPrescribedSubstituteAbbrNaming());
            }
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
            this.setCut(dto);
            this.setShortUnpaid(dto);
        }
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        dto.setSubstituteHolidays(Float.valueOf(substituteHolidays));
    }

    protected void addSubHolidayRequestList(boolean containNotApproved) throws MospException {
        float subHolidays = 0.0f;
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : this.subHolidayRequestList) {
            AttendanceListDto dto = this.getAttendanceListDto(subHolidayRequestDto.getRequestDate());
            WorkflowDtoInterface workflowDto = this.getWorkflow(subHolidayRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                this.addRemark(dto, this.getSubHolidayAbbrNaming() + this.getDraftAbbrNaming());
                continue;
            }
            this.addRemark(dto, this.getSubHolidayAbbrNaming() + this.getWorkflowStatusAbbr(workflowDto));
            subHolidays += this.getHolidayTimes(subHolidayRequestDto.getHolidayRange());
            if (subHolidayRequestDto.getHolidayRange() != 1) continue;
            dto.setWorkTypeCode("");
            dto.setWorkTypeAbbr(this.getWorkTypeAbbr(subHolidayRequestDto));
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
            this.setCut(dto);
            this.setShortUnpaid(dto);
        }
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        dto.setSubHolidays(Float.valueOf(subHolidays));
    }

    protected void addOvertimeRequestList(boolean containNotApproved) throws MospException {
        for (OvertimeRequestDtoInterface overtimeRequestDto : this.overtimeRequestList) {
            AttendanceListDto dto = this.getAttendanceListDto(overtimeRequestDto.getRequestDate());
            WorkflowDtoInterface workflowDto = this.getWorkflow(overtimeRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                this.addRemark(dto, this.getOvertimeAbbrNaming() + this.getDraftAbbrNaming());
                continue;
            }
            this.addRemark(dto, this.getOvertimeAbbrNaming() + this.getWorkflowStatusAbbr(workflowDto));
        }
    }

    protected void addWorkTypeChangeRequestList(boolean containNotApproved, boolean isActualList, boolean isSchedule) throws MospException {
        for (WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto : this.workTypeChangeRequestList) {
            AttendanceDtoInterface attendanceDto;
            AttendanceListDto dto = this.getAttendanceListDto(workTypeChangeRequestDto.getRequestDate());
            WorkflowDtoInterface workflowDto = this.getWorkflow(workTypeChangeRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                this.addRemark(dto, this.getWorkTypeChangeAbbrNaming() + this.getDraftAbbrNaming());
                continue;
            }
            this.addRemark(dto, this.getWorkTypeChangeAbbrNaming() + this.getWorkflowStatusAbbr(workflowDto));
            boolean isComplete = this.workflow.isCompleted(workflowDto);
            if (isComplete && dto.getWorkTypeCode() == null) {
                dto.setWorkTypeCode(workTypeChangeRequestDto.getWorkTypeCode());
            }
            if (isActualList) continue;
            if (isComplete) {
                dto.setWorkTypeCode(workTypeChangeRequestDto.getWorkTypeCode());
                dto.setStartTime(this.getWorkTypeStartTime(dto));
                dto.setEndTime(this.getWorkTypeEndTime(dto));
            }
            if ((attendanceDto = this.getAttendanceDtoListDto(dto.getWorkDate())) == null) {
                dto.setNeedCheckbox(true);
                dto.setApplicationInfo(this.getScheduleNaming());
                continue;
            }
            if (isSchedule) continue;
            WorkflowDtoInterface attendanceWorkflow = this.getWorkflow(attendanceDto.getWorkflow());
            this.setDtoFields(dto, attendanceDto, attendanceWorkflow);
        }
    }

    protected void addDifferenceRequestList(boolean containNotApproved, boolean isActualList) throws MospException {
        List list = this.difference.getDifferenceRequestList(this.personalId, this.firstDate, this.lastDate);
        for (DifferenceRequestDtoInterface differenceRequestDto : list) {
            AttendanceListDto dto = this.getAttendanceListDto(differenceRequestDto.getRequestDate());
            WorkflowDtoInterface workflowDto = this.getWorkflow(differenceRequestDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) {
                if (!containNotApproved || !this.workflow.isDraft(workflowDto)) continue;
                this.addRemark(dto, this.getTimeDefferenceAbbrNaming() + this.getDraftAbbrNaming());
                continue;
            }
            this.addRemark(dto, this.getTimeDefferenceAbbrNaming() + this.getWorkflowStatusAbbr(workflowDto));
            boolean isComplete = this.workflow.isCompleted(workflowDto);
            boolean isApprovable = this.workflow.isApprovable(workflowDto);
            boolean isFirstReverted = this.workflow.isFirstReverted(workflowDto);
            if (isComplete) {
                dto.setWorkTypeCode(differenceRequestDto.getDifferenceType());
            }
            if (isActualList) continue;
            if (isComplete) {
                dto.setWorkTypeCode(differenceRequestDto.getDifferenceType());
                dto.setStartTime(differenceRequestDto.getRequestStart());
                dto.setEndTime(differenceRequestDto.getRequestEnd());
            } else if (isApprovable || isFirstReverted) {
                dto.setWorkTypeCode(differenceRequestDto.getDifferenceType());
            }
            AttendanceDtoInterface attendanceDto = this.getAttendanceDtoListDto(dto.getWorkDate());
            if (attendanceDto == null) {
                dto.setNeedCheckbox(true);
                dto.setApplicationInfo(this.getScheduleNaming());
                continue;
            }
            WorkflowDtoInterface attendanceWorkflow = this.getWorkflow(attendanceDto.getWorkflow());
            this.setDtoFields(dto, attendanceDto, attendanceWorkflow);
            if (!isComplete && !isApprovable && !isFirstReverted) continue;
            dto.setWorkTypeCode(differenceRequestDto.getDifferenceType());
        }
    }

    protected void confirmTimelyPaidHoliday() throws MospException {
        String paidHolidayCode = this.applicationDto.getPaidHolidayCode();
        PaidHolidayDtoInterface paidHolidayDto = this.paidHoliday.getPaidHolidayInfo(paidHolidayCode, this.lastDate);
        if (paidHolidayDto != null && paidHolidayDto.getTimelyPaidHolidayFlag() == 0) {
            return;
        }
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        dto.setPaidHolidayTime(null);
    }

    protected void checkPluralRequest(boolean containNotApproved) throws MospException {
        block0: for (AttendanceListDto dto : this.attendanceList) {
            WorkflowDtoInterface workflowDto;
            float holidayTimes = 0.0f;
            WorkflowDtoInterface anteWorkflowDto = null;
            WorkflowDtoInterface postWorkflowDto = null;
            RequestEntity entity = this.getRequestEntity(this.personalId, dto.getWorkDate());
            for (HolidayRequestDtoInterface holidayRequestDto : this.holidayRequestList) {
                if (!DateUtility.isTermContain((Date)dto.getWorkDate(), (Date)holidayRequestDto.getRequestStartDate(), (Date)holidayRequestDto.getRequestEndDate()) || !this.isRequestNeeded(workflowDto = this.getWorkflow(holidayRequestDto.getWorkflow()), containNotApproved)) continue;
                if (holidayRequestDto.getHolidayRange() == 1) continue block0;
                holidayTimes += this.getHolidayTimes(holidayRequestDto.getHolidayRange());
                String workTypeAbbrInitial = this.substrForHalfWorkType(this.getWorkTypeAbbr(holidayRequestDto));
                if (dto.getWorkTypeAnteAbbr() == null && holidayRequestDto.getHolidayRange() == 2) {
                    dto.setWorkTypeAnteAbbr(workTypeAbbrInitial);
                    anteWorkflowDto = workflowDto;
                }
                if (dto.getWorkTypePostAbbr() != null || holidayRequestDto.getHolidayRange() != 3) continue;
                dto.setWorkTypePostAbbr(workTypeAbbrInitial);
                postWorkflowDto = workflowDto;
            }
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : this.subHolidayRequestList) {
                if (subHolidayRequestDto.getRequestDate().compareTo(dto.getWorkDate()) != 0 || !this.isRequestNeeded(workflowDto = this.getWorkflow(subHolidayRequestDto.getWorkflow()), containNotApproved)) continue;
                if (subHolidayRequestDto.getHolidayRange() == 1) {
                    dto.setNeedCheckbox(false);
                    continue block0;
                }
                holidayTimes += this.getHolidayTimes(subHolidayRequestDto.getHolidayRange());
                if (dto.getWorkTypeAnteAbbr() == null && subHolidayRequestDto.getHolidayRange() == 2) {
                    dto.setWorkTypeAnteAbbr(this.getSubHolidayAbbrNaming());
                    anteWorkflowDto = workflowDto;
                }
                if (dto.getWorkTypePostAbbr() != null || subHolidayRequestDto.getHolidayRange() != 3) continue;
                dto.setWorkTypePostAbbr(this.getSubHolidayAbbrNaming());
                postWorkflowDto = workflowDto;
            }
            for (WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto : this.workOnHolidayRequestList) {
                if (!workOnHolidayRequestDto.getRequestDate().equals(dto.getWorkDate()) || !this.isRequestNeeded(workflowDto = this.workflow.getLatestWorkflowInfo(workOnHolidayRequestDto.getWorkflow()), containNotApproved)) continue;
                if (holidayTimes == 1.0f) break;
                int substitute = workOnHolidayRequestDto.getSubstitute();
                if (substitute == 1 || substitute == 2 || substitute == 5) continue block0;
                if (entity.isHalfPostpone(!containNotApproved) && !entity.isAmPmHalfSubstitute(!containNotApproved)) continue;
                holidayTimes += 0.5f;
                if (dto.getWorkTypeAnteAbbr() == null && substitute == 3) {
                    dto.setWorkTypeAnteAbbr(this.getHalfSubstituteWorkAbbrNaming());
                    anteWorkflowDto = workflowDto;
                }
                if (dto.getWorkTypePostAbbr() != null || substitute != 4) continue;
                dto.setWorkTypePostAbbr(this.getHalfSubstituteWorkAbbrNaming());
                postWorkflowDto = workflowDto;
            }
            for (SubstituteDtoInterface substituteDto : this.substituteList) {
                WorkflowDtoInterface workOnHolidayWorkflow;
                WorkOnHolidayRequestDtoInterface workOnHolidayDto;
                if (!substituteDto.getSubstituteDate().equals(dto.getWorkDate()) || !this.isRequestNeeded(workflowDto = this.getWorkflow(substituteDto.getWorkflow()), containNotApproved)) continue;
                if (holidayTimes == 1.0f) break;
                if (substituteDto.getSubstituteRange() == 1) continue block0;
                if (entity.isHalfPostpone(!containNotApproved) || (workOnHolidayDto = this.workOnHoliday.findForKeyOnWorkflow(this.personalId, substituteDto.getSubstituteDate())) != null && !WorkflowUtility.isDraft((WorkflowDtoInterface)(workOnHolidayWorkflow = this.workflow.getLatestWorkflowInfo(workOnHolidayDto.getWorkflow())))) continue;
                holidayTimes += this.getHolidayTimes(substituteDto.getSubstituteRange());
                if (dto.getWorkTypeAnteAbbr() == null && substituteDto.getSubstituteRange() == 2) {
                    dto.setWorkTypeAnteAbbr(this.getSubstituteHolidayAbbrNaming());
                    anteWorkflowDto = workflowDto;
                }
                if (dto.getWorkTypePostAbbr() != null || substituteDto.getSubstituteRange() != 3) continue;
                dto.setWorkTypePostAbbr(this.getSubstituteHolidayAbbrNaming());
                postWorkflowDto = workflowDto;
            }
            if (!(holidayTimes >= 1.0f)) continue;
            dto.setWorkTypeCode("");
            dto.setWorkTypeAbbr(dto.getWorkTypeAnteAbbr() + this.getSlashNaming() + dto.getWorkTypePostAbbr());
            if (this.getSubstituteHolidayAbbrNaming().equals(dto.getWorkTypeAnteAbbr())) {
                if (this.getSubstituteHolidayAbbrNaming().equals(dto.getWorkTypePostAbbr())) {
                    dto.setWorkTypeAbbr(this.getSubstituteHolidayAbbrNaming());
                } else {
                    dto.setWorkTypeAbbr(this.getAnteMeridiemSubstituteHolidayAbbrNaming() + this.getSlashNaming() + dto.getWorkTypePostAbbr());
                }
            } else if (this.getSubstituteHolidayAbbrNaming().equals(dto.getWorkTypePostAbbr())) {
                dto.setWorkTypeAbbr(dto.getWorkTypeAnteAbbr() + this.getSlashNaming() + this.getPostMeridiemSubstituteHolidayAbbrNaming());
            }
            this.setCut(dto);
            this.setShortUnpaid(dto);
            dto.setNeedCheckbox(false);
            this.setApplicationInfo(dto, anteWorkflowDto, postWorkflowDto);
        }
    }

    protected void setCut(AttendanceListDto dto) throws MospException {
        dto.setCat(null);
    }

    protected void setShortUnpaid(AttendanceListDto dto) throws MospException {
        dto.setShortUnpaid(null);
    }

    protected void addActualList(boolean containNotApproved) throws MospException {
        for (AttendanceDtoInterface attendanceDto : this.attendanceDtoList) {
            AttendanceListDto dto = this.getAttendanceListDto(attendanceDto.getWorkDate());
            WorkflowDtoInterface workflowDto = this.getWorkflow(attendanceDto.getWorkflow());
            if (!this.isRequestNeeded(workflowDto, containNotApproved)) continue;
            this.setDtoFields(dto, attendanceDto, workflowDto);
        }
    }

    protected void addDraftList() throws MospException {
        for (AttendanceDtoInterface attendanceDto : this.attendanceDtoList) {
            WorkflowDtoInterface workflowDto;
            AttendanceListDto dto = this.getAttendanceListDto(attendanceDto.getWorkDate());
            if (dto.getWorkTypeCode() != null || !this.workflow.isDraft(workflowDto = this.getWorkflow(attendanceDto.getWorkflow()))) continue;
            this.setDtoFields(dto, attendanceDto, workflowDto);
        }
    }

    protected void addScheduleList(boolean needWorkDay, boolean needWorkTime) throws MospException {
        Date retireDate = this.retirement.getRetireDate(this.personalId);
        for (AttendanceListDto dto : this.attendanceList) {
            ScheduleDateDtoInterface scheduleDateDto = this.getScheduleDateDto(dto.getWorkDate());
            if (scheduleDateDto == null || scheduleDateDto.getWorkTypeCode().isEmpty()) continue;
            dto.setHolidayFlag(TimeUtility.isHoliday((String)scheduleDateDto.getWorkTypeCode()));
            if (dto.getWorkTypeCode() != null || this.applicationMap.get(dto.getWorkDate()) == null || retireDate != null && retireDate.before(dto.getWorkDate())) continue;
            SuspensionDtoInterface suspensionDto = this.suspension.getSuspentionInfo(this.personalId, dto.getWorkDate());
            if (suspensionDto != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getAdministrativeLeaveNaming());
                if (suspensionDto.getSuspensionReason() != null && !suspensionDto.getSuspensionReason().isEmpty()) {
                    sb.append(this.mospParams.getName("SingleColon"));
                    sb.append(suspensionDto.getSuspensionReason());
                }
                this.addRemark(dto, sb.toString());
                continue;
            }
            this.setDtoFields(dto, scheduleDateDto.getWorkTypeCode(), needWorkDay, needWorkTime);
        }
    }

    protected String getWorkTypeAbbr(HolidayRequestDtoInterface dto) throws MospException {
        switch (dto.getHolidayType1()) {
            case 1: {
                if (dto.getHolidayType2().equals(String.valueOf(1))) {
                    return this.getPaidHolidayAbbrNaming();
                }
                return this.getStockHolidayAbbrNaming();
            }
            case 2: 
            case 3: 
            case 4: {
                return this.holiday.getHolidayAbbr(dto.getHolidayType2(), dto.getRequestEndDate(), dto.getHolidayType1());
            }
        }
        return null;
    }

    protected String getWorkTypeAbbr(SubHolidayRequestDtoInterface dto) {
        switch (dto.getWorkDateSubHolidayType()) {
            case 1: 
            case 3: {
                return this.getPrescribedSubHolidayAbbrNaming();
            }
            case 2: {
                return this.getLegalSubHolidayAbbrNaming();
            }
        }
        return null;
    }

    protected boolean isApprovable(WorkflowDtoInterface dto) {
        String status = dto.getWorkflowStatus();
        if (status.equals("1") || status.equals("2")) {
            return true;
        }
        return (status.equals("4") || status.equals("2")) && dto.getWorkflowStage() > 0;
    }

    protected boolean isNeedCheckBox(WorkflowDtoInterface dto) {
        if (this.workflow.isDraft(dto)) {
            return true;
        }
        return this.isRevert(dto) && dto.getWorkflowStage() == 0;
    }

    protected boolean getNeedStatusLink(WorkflowDtoInterface dto) {
        return !this.workflow.isDraft(dto);
    }

    protected ScheduleDateDtoInterface getScheduleDateDto(Date targetDate) throws MospException {
        if (this.applicationMap.get(targetDate) == null) {
            return null;
        }
        String scheduleCode = ((ApplicationDtoInterface)this.applicationMap.get(targetDate)).getScheduleCode();
        if (scheduleCode.isEmpty()) {
            return null;
        }
        if (scheduleCode.equals(this.scheduleDto.getScheduleCode())) {
            for (ScheduleDateDtoInterface dto : this.scheduleDateList) {
                if (!targetDate.equals(dto.getScheduleDate())) continue;
                return dto;
            }
        }
        return this.scheduleDateReference.findForKey(scheduleCode, targetDate);
    }

    protected AttendanceDtoInterface getAttendanceDtoListDto(Date targetDate) {
        if (this.attendanceDtoList == null) {
            return null;
        }
        for (AttendanceDtoInterface dto : this.attendanceDtoList) {
            if (!targetDate.equals(dto.getWorkDate())) continue;
            return dto;
        }
        return null;
    }

    protected AttendanceListDto getAttendanceListDto(Date targetDate) {
        for (AttendanceListDto dto : this.attendanceList) {
            if (!targetDate.equals(dto.getWorkDate())) continue;
            return dto;
        }
        return null;
    }

    protected void setLimitStandard() throws MospException {
        LimitStandardDtoInterface limitStandardDto = this.limitStandard.findForKey(this.timeSettingDto.getWorkSettingCode(), this.timeSettingDto.getActivateDate(), LIMIT_STANDARD_TERM_MONTH1);
        if (limitStandardDto == null) {
            return;
        }
        int attention = limitStandardDto.getAttentionTime();
        int warning = limitStandardDto.getWarningTime();
        int overtimeTotal = 0;
        for (AttendanceListDto dto : this.attendanceList) {
            if (dto.getOvertimeOut() == null || (float)dto.getOvertimeOut().intValue() == 0.0f) continue;
            if ((overtimeTotal += dto.getOvertimeOut().intValue()) > attention) {
                dto.setOvertimeStyle("style=\"color: darkorange\"");
            }
            if (overtimeTotal <= warning) continue;
            dto.setOvertimeStyle("style=\"color: red\"");
        }
    }

    protected void totalAttendanceList() throws MospException {
        int workTimeTotal = 0;
        int restTimeTotal = 0;
        int privateTimeTotal = 0;
        int publicTimeTotal = 0;
        int minutelyHolidayATimeTotal = 0;
        int minutelyHolidayBTimeTotal = 0;
        int lateTimeTotal = 0;
        int leaveEarlyTimeTotal = 0;
        int lateLeaveEarlyTimeTotal = 0;
        int overtimeTotal = 0;
        int overtimeInTotal = 0;
        int overtimeOutTotal = 0;
        int holidayWorkTimeTotal = 0;
        int shortUnpaidTotal = 0;
        int lateNightTimeTotal = 0;
        int catTotal = 0;
        int workDays = 0;
        int lateDays = 0;
        int leaveEarlyDays = 0;
        int overtimeDays = 0;
        int holidayWorkDays = 0;
        int lateNightDays = 0;
        int prescribedHolidays = 0;
        int legalHolidays = 0;
        int holidays = 0;
        for (AttendanceListDto dto : this.attendanceList) {
            workTimeTotal += dto.getWorkTime() == null ? 0 : dto.getWorkTime();
            restTimeTotal += dto.getRestTime() == null ? 0 : dto.getRestTime();
            privateTimeTotal += dto.getPrivateTime() == null ? 0 : dto.getPrivateTime();
            publicTimeTotal += dto.getPublicTime() == null ? 0 : dto.getPublicTime();
            minutelyHolidayATimeTotal += dto.getMinutelyHolidayATime() == null ? 0 : dto.getMinutelyHolidayATime();
            minutelyHolidayBTimeTotal += dto.getMinutelyHolidayBTime() == null ? 0 : dto.getMinutelyHolidayBTime();
            lateTimeTotal += dto.getLateTime() == null ? 0 : dto.getLateTime();
            leaveEarlyTimeTotal += dto.getLeaveEarlyTime() == null ? 0 : dto.getLeaveEarlyTime();
            lateLeaveEarlyTimeTotal += dto.getLateLeaveEarlyTime() == null ? 0 : dto.getLateLeaveEarlyTime();
            overtimeTotal += dto.getOvertime() == null ? 0 : dto.getOvertime();
            overtimeInTotal += dto.getOvertimeIn() == null ? 0 : dto.getOvertimeIn();
            overtimeOutTotal += dto.getOvertimeOut() == null ? 0 : dto.getOvertimeOut();
            holidayWorkTimeTotal += dto.getHolidayWorkTime() == null ? 0 : dto.getHolidayWorkTime();
            shortUnpaidTotal += dto.getShortUnpaid() == null ? 0 : dto.getShortUnpaid();
            lateNightTimeTotal += dto.getLateNightTime() == null ? 0 : dto.getLateNightTime();
            catTotal += dto.getCat() == null ? 0 : dto.getCat();
            workDays += dto.getGoingWork();
            lateDays += this.countHours(dto.getLateTime());
            leaveEarlyDays += this.countHours(dto.getLeaveEarlyTime());
            overtimeDays += this.countHours(dto.getOvertime());
            lateNightDays += this.countHours(dto.getLateNightTime());
            if (dto.getWorkTypeCode() == null || dto.getWorkTypeCode().isEmpty()) continue;
            holidayWorkDays += TimeUtility.isWorkOnLegalHoliday((String)dto.getWorkTypeCode()) || TimeUtility.isWorkOnPrescribedHoliday((String)dto.getWorkTypeCode()) ? 1 : 0;
            holidays = (prescribedHolidays += TimeUtility.isPrescribedHoliday((String)dto.getWorkTypeCode()) ? 1 : 0) + (legalHolidays += TimeUtility.isLegalHoliday((String)dto.getWorkTypeCode()) ? 1 : 0);
        }
        AttendanceListDto dto = (AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1);
        dto.setWorkTimeTotal(Integer.valueOf(workTimeTotal));
        dto.setRestTimeTotal(Integer.valueOf(restTimeTotal));
        dto.setPrivateTimeTotal(Integer.valueOf(privateTimeTotal));
        dto.setPublicTimeTotal(Integer.valueOf(publicTimeTotal));
        dto.setMinutelyHolidayATimeTotal(Integer.valueOf(minutelyHolidayATimeTotal));
        dto.setMinutelyHolidayBTimeTotal(Integer.valueOf(minutelyHolidayBTimeTotal));
        dto.setLateTimeTotal(Integer.valueOf(lateTimeTotal));
        dto.setLeaveEarlyTimeTotal(Integer.valueOf(leaveEarlyTimeTotal));
        dto.setLateLeaveEarlyTimeTotal(Integer.valueOf(lateLeaveEarlyTimeTotal));
        dto.setOvertimeTotal(Integer.valueOf(overtimeTotal));
        dto.setOvertimeInTotal(Integer.valueOf(overtimeInTotal));
        dto.setOvertimeOutTotal(Integer.valueOf(overtimeOutTotal));
        dto.setHolidayWorkTimeTotal(Integer.valueOf(holidayWorkTimeTotal));
        dto.setShortUnpaidTotal(Integer.valueOf(shortUnpaidTotal));
        dto.setLateNightTimeTotal(Integer.valueOf(lateNightTimeTotal));
        dto.setCatTotal(Integer.valueOf(catTotal));
        dto.setWorkDays(Integer.valueOf(workDays));
        dto.setLateDays(Integer.valueOf(lateDays));
        dto.setLeaveEarlyDays(Integer.valueOf(leaveEarlyDays));
        dto.setOvertimeDays(Integer.valueOf(overtimeDays));
        dto.setHolidayWorkDays(Integer.valueOf(holidayWorkDays));
        dto.setLateNightDays(Integer.valueOf(lateNightDays));
        dto.setPrescribedHolidays(Integer.valueOf(prescribedHolidays));
        dto.setLegalHolidays(Integer.valueOf(legalHolidays));
        dto.setHolidays(Integer.valueOf(holidays));
        Float[] subHolidayDays = this.subHolidayRefer.getBirthSubHolidayTimes(this.personalId, ((AttendanceListDto)this.attendanceList.get(0)).getWorkDate(), ((AttendanceListDto)this.attendanceList.get(this.attendanceList.size() - 1)).getWorkDate());
        dto.setBirthPrescribedSubHoliday(subHolidayDays[0]);
        dto.setBirthLegalSubHoliday(subHolidayDays[1]);
        dto.setBirthMidnightSubHolidaydays(subHolidayDays[2]);
    }

    protected void setDtoFields(AttendanceListDto dto, AttendanceDtoInterface attendanceDto, WorkflowDtoInterface workflowDto) throws MospException {
        dto.setGoingWork(1);
        dto.setWorkTypeCode(attendanceDto.getWorkTypeCode());
        dto.setStartTime(attendanceDto.getActualStartTime());
        dto.setEndTime(attendanceDto.getActualEndTime());
        dto.setWorkTime(Integer.valueOf(attendanceDto.getWorkTime()));
        dto.setRestTime(Integer.valueOf(attendanceDto.getRestTime()));
        dto.setPrivateTime(Integer.valueOf(attendanceDto.getPrivateTime()));
        dto.setPublicTime(Integer.valueOf(attendanceDto.getPublicTime()));
        dto.setMinutelyHolidayATime(Integer.valueOf(attendanceDto.getMinutelyHolidayATime()));
        dto.setMinutelyHolidayA(attendanceDto.getMinutelyHolidayA());
        dto.setMinutelyHolidayBTime(Integer.valueOf(attendanceDto.getMinutelyHolidayBTime()));
        dto.setMinutelyHolidayB(attendanceDto.getMinutelyHolidayB());
        dto.setLateTime(Integer.valueOf(attendanceDto.getLateTime()));
        dto.setLeaveEarlyTime(Integer.valueOf(attendanceDto.getLeaveEarlyTime()));
        dto.setLateLeaveEarlyTime(Integer.valueOf(attendanceDto.getLateTime() + attendanceDto.getLeaveEarlyTime()));
        dto.setOvertime(Integer.valueOf(attendanceDto.getOvertime()));
        dto.setOvertimeIn(Integer.valueOf(attendanceDto.getOvertimeIn()));
        dto.setOvertimeOut(Integer.valueOf(attendanceDto.getOvertimeOut()));
        dto.setHolidayWorkTime(Integer.valueOf(attendanceDto.getLegalWorkTime()));
        dto.setLateNightTime(Integer.valueOf(attendanceDto.getLateNightTime()));
        dto.setShortUnpaid(Integer.valueOf(attendanceDto.getShortUnpaid()));
        dto.setTimeComment(MospUtility.concat((String[])new String[]{attendanceDto.getTimeComment(), attendanceDto.getRemarks()}));
        this.addAttendanceRemark(dto, attendanceDto);
        dto.setApplicationInfo(this.workflow.getWorkflowStatus(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        dto.setNeedCheckbox(this.isNeedCheckBox(workflowDto));
        dto.setNeedStatusLink(this.getNeedStatusLink(workflowDto));
        dto.setAttendanceRecordId(attendanceDto.getTmdAttendanceId());
        dto.setWorkflowRecordId(workflowDto.getPftWorkflowId());
        dto.setWorkflow(workflowDto.getWorkflow());
        dto.setWorkflowStatus(workflowDto.getWorkflowStatus());
        dto.setWorkflowStage(workflowDto.getWorkflowStage());
        dto.setCorrectionInfo(this.getCorrectionInfo(attendanceDto));
    }

    protected String getCorrectionInfo(AttendanceDtoInterface attendanceDto) throws MospException {
        AttendanceCorrectionDtoInterface attendanceCorrectionDto = this.correction.getLatestAttendanceCorrectionInfo(this.personalId, attendanceDto.getWorkDate(), 1);
        if (attendanceCorrectionDto == null) {
            return "";
        }
        if (attendanceCorrectionDto.getPersonalId().equals(attendanceCorrectionDto.getCorrectionPersonalId())) {
            return this.getSelfCorrectAbbrNaming();
        }
        return this.getOtherCorrectAbbrNaming();
    }

    protected void addAttendanceRemark(AttendanceListDto dto, AttendanceDtoInterface attendanceDto) {
        if (!attendanceDto.getLateReason().isEmpty()) {
            this.addRemark(dto, TimeNamingUtility.getLateAbbrNaming((MospParams)this.mospParams) + " " + MospUtility.getCodeName((MospParams)this.mospParams, (String)attendanceDto.getLateReason(), (String)"ReasonOfLate"));
        }
        if (!attendanceDto.getLeaveEarlyReason().isEmpty()) {
            this.addRemark(dto, TimeNamingUtility.getEarlyAbbrNaming((MospParams)this.mospParams) + " " + MospUtility.getCodeName((MospParams)this.mospParams, (String)attendanceDto.getLeaveEarlyReason(), (String)"ReasonOfLeaveEarly"));
        }
        if (attendanceDto.getDirectStart() == Integer.parseInt("1")) {
            this.addRemark(dto, this.getDirectStartNaming());
        }
        if (attendanceDto.getDirectEnd() == Integer.parseInt("1")) {
            this.addRemark(dto, this.getDirectEndNaming());
        }
    }

    protected void setDtoFields(AttendanceListDto dto, String workTypeCode, boolean needWorkDay, boolean needWorkTime) throws MospException {
        if (workTypeCode.equals("prescribed_holiday") || workTypeCode.equals("legal_holiday")) {
            dto.setWorkTypeCode(workTypeCode);
            dto.setApplicationInfo(this.getApplovedNaming());
            dto.setNeedCheckbox(false);
            return;
        }
        if (!needWorkDay) {
            return;
        }
        dto.setWorkTypeCode(workTypeCode);
        dto.setApplicationInfo(this.getScheduleNaming());
        dto.setNeedCheckbox(true);
        if (dto.getStartTime() == null) {
            dto.setStartTime(this.getWorkTypeStartTime(dto));
        }
        if (dto.getEndTime() == null) {
            dto.setEndTime(this.getWorkTypeEndTime(dto));
        }
        if (!needWorkTime) {
            return;
        }
        dto.setWorkTime(Integer.valueOf(this.getWorkTypeEntity(dto).getWorkTime()));
        dto.setRestTime(Integer.valueOf(this.getWorkTypeEntity(dto).getRestTime()));
    }

    protected void setDtoFields(AttendanceListDto dto, String workTypeCode, boolean needWorkDay, boolean needWorkTime, boolean holidayRangeAm, boolean holidayRangePm) throws MospException {
        if (!holidayRangeAm && !holidayRangePm) {
            this.setDtoFields(dto, workTypeCode, needWorkDay, needWorkTime);
            return;
        }
        if (workTypeCode.equals("prescribed_holiday") || workTypeCode.equals("legal_holiday")) {
            dto.setWorkTypeCode(workTypeCode);
            dto.setApplicationInfo(this.getApplovedNaming());
            dto.setNeedCheckbox(false);
            return;
        }
        if (!needWorkDay) {
            return;
        }
        dto.setWorkTypeCode(workTypeCode);
        dto.setApplicationInfo(this.getScheduleNaming());
        dto.setNeedCheckbox(true);
        Date startTime = this.getWorkTypeStartTime(dto);
        Date endTime = this.getWorkTypeEndTime(dto);
        if (dto.getStartTime() == null) {
            dto.setStartTime(startTime);
        }
        if (dto.getEndTime() == null) {
            dto.setEndTime(endTime);
        }
        if (!needWorkTime) {
            return;
        }
        dto.setWorkTime(Integer.valueOf(this.getWorkTypeEntity(dto).getWorkTime()));
        dto.setRestTime(Integer.valueOf(this.getWorkTypeEntity(dto).getRestTime()));
        if (holidayRangeAm || holidayRangePm) {
            dto.setWorkTime(Integer.valueOf(this.getDefferenceMinutes(startTime, endTime)));
            dto.setRestTime(null);
        }
    }

    protected void setDtoStringFields() throws MospException {
        for (AttendanceListDto dto : this.attendanceList) {
            this.setDtoStringFields(dto);
        }
    }

    protected void setDtoHyphenFields(boolean useScheduledTime) throws MospException {
        if (useScheduledTime) {
            return;
        }
        for (AttendanceListDto dto : this.attendanceList) {
            if (dto.getCorrectionInfo() != null) continue;
            dto.setStartTimeString(this.getHyphenNaming());
            dto.setEndTimeString(this.getHyphenNaming());
        }
    }

    protected void setNeedCheckbox() throws MospException {
        if (!this.isTightened) {
            return;
        }
        for (AttendanceListDto dto : this.attendanceList) {
            dto.setNeedCheckbox(false);
        }
    }

    protected void setNeedCheckbox(AttendanceListDto dto, WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto) throws MospException {
        dto.setNeedCheckbox(false);
        if (this.workflow.isCompleted(workOnHolidayRequestDto.getWorkflow())) {
            dto.setNeedCheckbox(true);
        }
    }

    protected void setNeedApprovalCheckbox() throws MospException {
        if (this.isTightened) {
            for (AttendanceListDto dto : this.attendanceList) {
                dto.setNeedCheckbox(false);
            }
            return;
        }
        Map approvableMap = this.getApprovableMap();
        for (AttendanceListDto dto : this.attendanceList) {
            dto.setNeedCheckbox(false);
            if (dto.getWorkflow() == 0L || !approvableMap.containsKey(dto.getWorkflow())) continue;
            dto.setNeedCheckbox(true);
        }
    }

    protected Map<Long, WorkflowDtoInterface> getApprovableMap() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        ApprovalInfoReferenceBeanInterface approvalReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        return (Map)approvalReference.getApprovableMap(personalId).get("1");
    }

    protected void setDtoStringFields(AttendanceListDto dto) throws MospException {
        Date standardDate = dto.getWorkDate();
        Date targetDate = dto.getWorkDate();
        dto.setWorkDateString(this.getStringMonthDay(targetDate));
        dto.setWorkDayOfWeek(this.getStringDayOfWeek(targetDate));
        dto.setWorkDayOfWeekStyle(HolidayUtility.getWorkDayOfWeekStyle((Date)targetDate, (MospParams)this.mospParams));
        this.addRemark(dto, this.getScheduleDateRemark(dto.getWorkDate()));
        this.setWorkTypeAbbr(dto);
        dto.setStartTimeString(this.getStringTime(dto.getStartTime(), standardDate));
        dto.setStartTimeStyle(this.getAttendanceTimeStyle(dto.getApplicationInfo()));
        dto.setEndTimeString(this.getStringTime(dto.getEndTime(), standardDate));
        dto.setEndTimeStyle(this.getAttendanceTimeStyle(dto.getApplicationInfo()));
        dto.setStartRecordTimeString(this.getStringTime(dto.getStartRecordTime(), standardDate));
        dto.setEndRecordTimeString(this.getStringTime(dto.getEndRecordTime(), standardDate));
        dto.setWorkTimeString(this.getStringHours(dto.getWorkTime(), true));
        dto.setRestTimeString(this.getStringHours(dto.getRestTime(), true));
        dto.setPrivateTimeString(this.getStringHours(dto.getPrivateTime(), true));
        dto.setPublicTimeString(this.getStringHours(dto.getPublicTime(), true));
        dto.setLateTimeString(this.getStringHours(dto.getLateTime(), true));
        dto.setLeaveEarlyTimeString(this.getStringHours(dto.getLeaveEarlyTime(), true));
        dto.setLateLeaveEarlyTimeString(this.getStringHours(dto.getLateLeaveEarlyTime(), true));
        dto.setOvertimeString(this.getStringHours(dto.getOvertime(), true));
        dto.setOvertimeInString(this.getStringHours(dto.getOvertimeIn(), true));
        dto.setOvertimeOutString(this.getStringHours(dto.getOvertimeOut(), true));
        dto.setHolidayWorkTimeString(this.getStringHours(dto.getHolidayWorkTime(), true));
        dto.setLateNightTimeString(this.getStringHours(dto.getLateNightTime(), true));
        dto.setShortUnpaidString(this.getStringHours(dto.getShortUnpaid(), true));
        dto.setWorkTimeTotalString(this.getStringHours(dto.getWorkTimeTotal(), false));
        dto.setRestTimeTotalString(this.getStringHours(dto.getRestTimeTotal(), false));
        dto.setPrivateTimeTotalString(this.getStringHours(dto.getPrivateTimeTotal(), false));
        dto.setPublicTimeTotalString(this.getStringHours(dto.getPublicTimeTotal(), false));
        dto.setLateTimeTotalString(this.getStringHours(dto.getLateTimeTotal(), false));
        dto.setLeaveEarlyTimeTotalString(this.getStringHours(dto.getLeaveEarlyTimeTotal(), false));
        dto.setLateLeaveEarlyTimeTotalString(this.getStringHours(dto.getLateLeaveEarlyTimeTotal(), false));
        dto.setOvertimeTotalString(this.getStringHours(dto.getOvertimeTotal(), false));
        dto.setOvertimeInTotalString(this.getStringHours(dto.getOvertimeInTotal(), false));
        dto.setOvertimeOutTotalString(this.getStringHours(dto.getOvertimeOutTotal(), false));
        dto.setHolidayWorkTimeTotalString(this.getStringHours(dto.getHolidayWorkTimeTotal(), false));
        dto.setLateNightTimeTotalString(this.getStringHours(dto.getLateNightTimeTotal(), false));
        dto.setShortUnpaidTotalString(this.getStringHours(dto.getShortUnpaidTotal(), false));
        dto.setCatTotalString(this.getStringHours(dto.getCatTotal(), false));
        dto.setWorkDaysString(this.getStringTimes(dto.getWorkDays()));
        dto.setLateDaysString(this.getStringTimes(dto.getLateDays()));
        dto.setLeaveEarlyDaysString(this.getStringTimes(dto.getLeaveEarlyDays()));
        dto.setOvertimeDaysString(this.getStringTimes(dto.getOvertimeDays()));
        dto.setHolidayWorkDaysString(this.getStringTimes(dto.getHolidayWorkDays()));
        dto.setBirthPrescribedSubHolidayString(this.getStringFloat(dto.getBirthPrescribedSubHoliday()));
        dto.setBirthLegalSubHolidayString(this.getStringFloat(dto.getBirthLegalSubHoliday()));
        dto.setBirthMidnightSubHolidayString(this.getStringFloat(dto.getBirthMidnightSubHoliday()));
        if (this.getStringFloat(dto.getBirthMidnightSubHoliday()).equals(this.getHyphenNaming())) {
            dto.setBirthMidnightSubHolidayString(null);
        }
        dto.setLateNightDaysString(this.getStringTimes(dto.getLateNightDays()));
        dto.setPrescribedHolidaysString(this.getStringTimes(dto.getPrescribedHolidays()));
        dto.setLegalHolidaysString(this.getStringTimes(dto.getLegalHolidays()));
        dto.setHolidayString(this.getStringTimes(dto.getHolidays()));
        dto.setSubstituteHolidaysString(this.getStringTimes(dto.getSubstituteHolidays()));
        dto.setPaidHolidaysString(this.getStringTimes(dto.getPaidHolidays()));
        dto.setPaidHolidayTimeString(this.getStringTimes(dto.getPaidHolidayTime()));
        dto.setSpecialHolidaysString(this.getStringTimes(dto.getSpecialHolidays()));
        dto.setOtherHolidaysString(this.getStringTimes(dto.getOtherHolidays()));
        dto.setSubHolidaysString(this.getStringTimes(dto.getSubHolidays()));
        dto.setAbsenceDaysString(this.getStringTimes(dto.getAbsenceDays()));
        dto.setMinutelyHolidayATimeString(this.getStringHours(dto.getMinutelyHolidayATimeTotal(), false));
        dto.setMinutelyHolidayBTimeString(this.getStringHours(dto.getMinutelyHolidayBTimeTotal(), false));
        dto.setEmployeeCodeTitle(PlatformNamingUtility.employeeCode((MospParams)this.mospParams));
        dto.setOvertimeTitle(this.mospParams.getName("LeftOut"));
        if (this.mospParams.getApplicationPropertyBool("UseMinutelyHoliday")) {
            dto.setMinutelyHolidayATitle(this.mospParams.getName("MinutelyHolidayAAbbr"));
            dto.setMinutelyHolidayBTitle(this.mospParams.getName("MinutelyHolidayBAbbr"));
        }
        dto.setHourlyPaidHolidayValid(true);
        dto.setSpecialHolidaysTitle(this.mospParams.getName("TotalSpecialLeave"));
        if (dto.getMinutelyHolidayA() == 1 || dto.getMinutelyHolidayB() == 1) {
            dto.setStartTimeString(this.getHyphenNaming());
            dto.setEndTimeString(this.getHyphenNaming());
            dto.setWorkTimeString(this.getHyphenNaming());
            dto.setRestTimeString(this.getHyphenNaming());
            dto.setPrivateTimeString(this.getHyphenNaming());
            dto.setPublicTimeString(this.getHyphenNaming());
            dto.setLateTimeString(this.getHyphenNaming());
            dto.setLeaveEarlyTimeString(this.getHyphenNaming());
            dto.setLateLeaveEarlyTimeString(this.getHyphenNaming());
            dto.setOvertimeString(this.getHyphenNaming());
            dto.setOvertimeInString(this.getHyphenNaming());
            dto.setOvertimeOutString(this.getHyphenNaming());
            dto.setHolidayWorkTimeString(this.getHyphenNaming());
            dto.setLateNightTimeString(this.getHyphenNaming());
        }
    }

    protected String getAttendanceTimeStyle(String state) {
        if (this.mospParams.getName("Schedule").equals(state)) {
            return "style=\"color: gray\"";
        }
        return "";
    }

    protected void setWorkTypeAbbr(AttendanceListDto dto) throws MospException {
        if (dto.getWorkTypeCode() == null || dto.getWorkTypeCode().isEmpty()) {
            return;
        }
        String workTypeAbbr = this.difference.getDifferenceAbbr(dto.getWorkTypeCode());
        String workTypeAbbrInitial = workTypeAbbr.substring(workTypeAbbr.length() - 1);
        if (dto.getWorkTypeCode().equals(workTypeAbbr) && !(workTypeAbbr = this.getWorkTypeEntity(dto.getWorkTypeCode()).getWorkTypeAbbr()).isEmpty()) {
            workTypeAbbrInitial = this.substrForHalfWorkType(workTypeAbbr);
        }
        if (dto.getWorkTypeAnteAbbr() != null && !dto.getWorkTypeAnteAbbr().isEmpty()) {
            if (this.getHalfSubstituteWorkAbbrNaming().equals(dto.getWorkTypeAnteAbbr())) {
                dto.setWorkTypeAbbr(this.getHalfSubstituteWorkAbbrNaming());
                return;
            }
            if (this.getSubstituteHolidayAbbrNaming().equals(dto.getWorkTypeAnteAbbr())) {
                dto.setWorkTypeAbbr(this.getHalfSubstituteHolidayAbbrNaming());
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.substrForHalfWorkType(dto.getWorkTypeAnteAbbr()));
            sb.append(this.getSlashNaming());
            sb.append(workTypeAbbrInitial);
            dto.setWorkTypeAbbr(sb.toString());
            return;
        }
        if (dto.getWorkTypePostAbbr() != null && !dto.getWorkTypePostAbbr().isEmpty()) {
            if (this.getHalfSubstituteWorkAbbrNaming().equals(dto.getWorkTypePostAbbr())) {
                dto.setWorkTypeAbbr(this.getHalfSubstituteWorkAbbrNaming());
                return;
            }
            if (this.getSubstituteHolidayAbbrNaming().equals(dto.getWorkTypePostAbbr())) {
                dto.setWorkTypeAbbr(this.getHalfSubstituteHolidayAbbrNaming());
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(workTypeAbbrInitial);
            sb.append(this.getSlashNaming());
            sb.append(this.substrForHalfWorkType(dto.getWorkTypePostAbbr()));
            dto.setWorkTypeAbbr(sb.toString());
            return;
        }
        dto.setWorkTypeAbbr(workTypeAbbr);
    }

    protected String getScheduleDateRemark(Date targetDate) throws MospException {
        ScheduleDateDtoInterface dto = this.getScheduleDateDto(targetDate);
        if (dto == null) {
            return "";
        }
        return dto.getRemark();
    }

    protected Date getWorkTypeStartTime(AttendanceListDto dto) throws MospException {
        WorkTypeEntity workTypeEntity = this.getWorkTypeEntity(dto.getWorkTypeCode());
        RequestEntity requestEntity = this.getRequestEntity(this.personalId, dto.getWorkDate());
        return workTypeEntity.getStartTime(requestEntity);
    }

    protected Date getWorkTypeEndTime(AttendanceListDto dto) throws MospException {
        WorkTypeEntity workTypeEntity = this.getWorkTypeEntity(dto.getWorkTypeCode());
        RequestEntity requestEntity = this.getRequestEntity(this.personalId, dto.getWorkDate());
        return workTypeEntity.getEndTime(requestEntity);
    }

    protected WorkTypeEntity getWorkTypeEntity(String workTypeCode) throws MospException {
        WorkTypeEntity workTypeEntity = (WorkTypeEntity)this.workTypeEntityMap.get(workTypeCode);
        if (workTypeEntity != null) {
            return workTypeEntity;
        }
        workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, this.lastDate);
        this.workTypeEntityMap.put(workTypeCode, workTypeEntity);
        return workTypeEntity;
    }

    protected WorkTypeEntity getWorkTypeEntity(AttendanceListDto dto) throws MospException {
        return this.getWorkTypeEntity(dto.getWorkTypeCode());
    }

    protected RequestEntity getRequestEntity(String personalId, Date targetDate) throws MospException {
        RequestEntity requestEntity = new RequestEntity(personalId, targetDate);
        AttendanceDtoInterface targetAttendanceDto = null;
        ArrayList<HolidayRequestDtoInterface> targetHolidayRequestList = new ArrayList<HolidayRequestDtoInterface>();
        ArrayList<HolidayRequestDtoInterface> targetSubHolidayRequestList = new ArrayList<HolidayRequestDtoInterface>();
        ArrayList<HolidayRequestDtoInterface> targetSubstituteList = new ArrayList<HolidayRequestDtoInterface>();
        ArrayList<HolidayRequestDtoInterface> targetOvertimeRequestList = new ArrayList<HolidayRequestDtoInterface>();
        HolidayRequestDtoInterface targetWorkOnHolidayRequestDto = null;
        HolidayRequestDtoInterface targetDifferenceRequestDto = null;
        HolidayRequestDtoInterface targetWorkTypeChangeRequestDto = null;
        targetAttendanceDto = this.getAttendanceDtoListDto(targetDate);
        for (HolidayRequestDtoInterface dto : this.holidayRequestList) {
            if (!DateUtility.isTermContain((Date)targetDate, (Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate())) continue;
            targetHolidayRequestList.add(dto);
        }
        for (HolidayRequestDtoInterface dto : this.subHolidayRequestList) {
            if (targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            targetSubHolidayRequestList.add(dto);
        }
        for (HolidayRequestDtoInterface dto : this.substituteList) {
            if (targetDate.compareTo(dto.getSubstituteDate()) != 0) continue;
            targetSubstituteList.add(dto);
        }
        for (HolidayRequestDtoInterface dto : targetOvertimeRequestList) {
            if (targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            targetOvertimeRequestList.add(dto);
        }
        for (HolidayRequestDtoInterface dto : this.workOnHolidayRequestList) {
            if (targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            targetWorkOnHolidayRequestDto = dto;
            break;
        }
        for (HolidayRequestDtoInterface dto : this.differenceRequestList) {
            if (targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            targetDifferenceRequestDto = dto;
            break;
        }
        for (HolidayRequestDtoInterface dto : this.workTypeChangeRequestList) {
            if (targetDate.compareTo(dto.getRequestDate()) != 0) continue;
            targetWorkTypeChangeRequestDto = dto;
            break;
        }
        requestEntity.setAttendanceDto(targetAttendanceDto);
        requestEntity.setHolidayRequestList(targetHolidayRequestList);
        requestEntity.setSubHolidayRequestList(targetSubHolidayRequestList);
        requestEntity.setSubstituteList(targetSubstituteList);
        requestEntity.setOverTimeRequestList(targetOvertimeRequestList);
        requestEntity.setWorkOnHolidayRequestDto((WorkOnHolidayRequestDtoInterface)targetWorkOnHolidayRequestDto);
        requestEntity.setDifferenceRequestDto((DifferenceRequestDtoInterface)targetDifferenceRequestDto);
        requestEntity.setWorkTypeChangeRequestDto((WorkTypeChangeRequestDtoInterface)targetWorkTypeChangeRequestDto);
        if (targetAttendanceDto != null) {
            this.getWorkflow(targetAttendanceDto.getWorkflow());
        }
        for (HolidayRequestDtoInterface dto : targetHolidayRequestList) {
            this.getWorkflow(dto.getWorkflow());
        }
        for (HolidayRequestDtoInterface dto : targetSubHolidayRequestList) {
            this.getWorkflow(dto.getWorkflow());
        }
        for (HolidayRequestDtoInterface dto : targetSubstituteList) {
            this.getWorkflow(dto.getWorkflow());
        }
        for (HolidayRequestDtoInterface dto : targetOvertimeRequestList) {
            this.getWorkflow(dto.getWorkflow());
        }
        if (targetDifferenceRequestDto != null) {
            this.getWorkflow(targetDifferenceRequestDto.getWorkflow());
        }
        if (targetWorkTypeChangeRequestDto != null) {
            this.getWorkflow(targetWorkTypeChangeRequestDto.getWorkflow());
        }
        requestEntity.setWorkflowMap(this.workflowMap);
        return requestEntity;
    }

    protected void addRemark(AttendanceListDto dto, String remark) {
        if (remark == null || remark.isEmpty()) {
            return;
        }
        if (dto.getRemark() != null && dto.getRemark().indexOf(remark) >= 0) {
            return;
        }
        dto.setRemark(MospUtility.concat((String[])new String[]{dto.getRemark(), remark}));
    }

    protected int countHours(Integer minutes) {
        if (minutes == null || minutes == 0) {
            return 0;
        }
        return 1;
    }

    protected String getStringHours(Integer minutes, boolean needHyphen) {
        if (minutes == null) {
            return this.getHyphenNaming();
        }
        if (needHyphen && minutes == 0) {
            return this.getHyphenNaming();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(minutes / 60);
        sb.append(SEPARATOR_HOURS);
        int remainder = minutes % 60;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMinimumIntegerDigits(2);
        sb.append(nf.format(remainder));
        return sb.toString();
    }

    protected String getStringFloat(Float value) {
        if (value == null) {
            return this.getHyphenNaming();
        }
        return String.valueOf(value);
    }

    protected String getStringTimes(Integer times) {
        if (times == null) {
            return this.getHyphenNaming();
        }
        return times.toString();
    }

    protected String getStringTimes(Float times) {
        if (times == null) {
            return this.getHyphenNaming();
        }
        DecimalFormat df = new DecimalFormat("#.#");
        return df.format(times);
    }

    protected boolean useScheduledTime() {
        return this.timeSettingDto.getUseScheduledTime() == 0;
    }

    protected void setWeekTerm(Date targetDate) throws MospException {
        int startWeek = this.timeSettingDto.getStartWeek();
        while (!DateUtility.isDayOfWeek((Date)targetDate, (int)startWeek)) {
            targetDate = this.addDay(targetDate, -1);
        }
        this.firstDate = this.getDateClone(targetDate);
        targetDate = this.addDay(targetDate, 1);
        while (!DateUtility.isDayOfWeek((Date)targetDate, (int)startWeek)) {
            targetDate = this.addDay(targetDate, 1);
        }
        this.lastDate = this.addDay(targetDate, -1);
    }

    protected WorkflowDtoInterface getWorkflow(long workflowNo) throws MospException {
        WorkflowDtoInterface dto = (WorkflowDtoInterface)this.workflowMap.get(workflowNo);
        if (dto != null) {
            return dto;
        }
        dto = this.workflow.getLatestWorkflowInfo(workflowNo);
        if (dto != null) {
            this.workflowMap.put(workflowNo, dto);
        }
        return dto;
    }

    protected String substrForHalfWorkType(String workTypeAbbr) {
        if (workTypeAbbr == null || workTypeAbbr.isEmpty()) {
            return "";
        }
        int length = workTypeAbbr.length();
        if (length <= this.halfWorkTypeLength) {
            return workTypeAbbr;
        }
        return workTypeAbbr.substring(0, this.halfWorkTypeLength);
    }

    protected String getStringMonthDay(Date date) {
        return DateUtility.getStringDate((Date)date, (String)"MM/dd");
    }

    protected String getStringDayOfWeek(Date date) {
        return DateUtility.getStringDayOfWeek((Date)date);
    }

    protected String getPrescribedSubHolidayAbbrNaming() {
        return this.mospParams.getName("PrescribedAbbreviation", new String[]{"CompensatoryHoliday"});
    }

    protected String getLegalSubHolidayAbbrNaming() {
        return this.mospParams.getName("LegalAbbreviation", new String[]{"CompensatoryHoliday"});
    }

    protected String getPrescribedSubstituteAbbrNaming() {
        return this.mospParams.getName("PrescribedAbbreviation", new String[]{"ClosedVibration"});
    }

    protected String getLegalSubstituteAbbrNaming() {
        return this.mospParams.getName("LegalAbbreviation", new String[]{"ClosedVibration"});
    }

    protected String getScheduleNaming() {
        return this.mospParams.getName("Schedule");
    }

    protected String getApplovedNaming() {
        return this.mospParams.getName("Approval", new String[]{"Finish"});
    }

    protected String getDirectStartNaming() {
        return this.mospParams.getName("DirectStart");
    }

    protected String getDirectEndNaming() {
        return this.mospParams.getName("DirectEnd");
    }

    protected String getPaidHolidayAbbrNaming() {
        return this.mospParams.getName("PaidHolidayAbbr");
    }

    protected String getStockHolidayAbbrNaming() {
        return this.mospParams.getName("StockHolidayAbbr");
    }

    protected String getHolidayNaming() {
        return this.mospParams.getName("Vacation");
    }

    protected String getWorkOnHolidayAbbrNaming() {
        return this.mospParams.getName("WorkingHoliday");
    }

    protected String getSubstituteWorkAbbrNaming() {
        return this.mospParams.getName("SubstituteAbbr", new String[]{"GoingWorkAbbr"});
    }

    protected String getSubstituteAbbrNaming() {
        return this.mospParams.getName("SubstituteAbbr");
    }

    protected String getSubstituteHolidayAbbrNaming() {
        return this.mospParams.getName("ClosedVibration");
    }

    protected String getHalfSubstituteHolidayAbbrNaming() {
        return this.mospParams.getName("HalfSubstituteHolidayAbbr");
    }

    protected String getAnteMeridiemSubstituteHolidayAbbrNaming() {
        return this.mospParams.getName("AnteMeridiemSubstituteHolidayAbbr");
    }

    protected String getPostMeridiemSubstituteHolidayAbbrNaming() {
        return this.mospParams.getName("PostMeridiemSubstituteHolidayAbbr");
    }

    protected String getHalfSubstituteWorkAbbrNaming() {
        return this.mospParams.getName("HalfSubstituteWorkAbbr");
    }

    protected String getSubHolidayAbbrNaming() {
        return this.mospParams.getName("Generation");
    }

    protected String getOvertimeAbbrNaming() {
        return this.mospParams.getName("OvertimeAbbr");
    }

    protected String getWorkTypeChangeAbbrNaming() {
        return this.mospParams.getName("WorkTypeChangeAbbr");
    }

    protected String getTimeDefferenceAbbrNaming() {
        return this.mospParams.getName("TimeDefferenceAbbr");
    }

    protected String getAdministrativeLeaveNaming() {
        return this.mospParams.getName("RetirementLeave");
    }

    protected String getCompleteApprovalAbbrNaming() {
        return this.mospParams.getName("Finish");
    }

    protected String getRevertAbbrNaming() {
        return this.mospParams.getName("Back");
    }

    protected String getApprovalAbbrNaming() {
        return this.mospParams.getName("Register");
    }

    protected String getDraftAbbrNaming() {
        return this.mospParams.getName("Under");
    }

    protected String getSelfCorrectAbbrNaming() {
        return this.mospParams.getName("CorrectionHistory");
    }

    protected String getOtherCorrectAbbrNaming() {
        return this.mospParams.getName("Other");
    }

    protected String getSlashNaming() {
        return this.mospParams.getName("Slash");
    }

    protected void setApprovalTime() throws MospException {
        block0: for (AttendanceListDto dto : this.attendanceList) {
            Date endTime;
            Date startTime;
            boolean amHoliday = false;
            boolean pmHoliday = false;
            WorkTypeChangeRequestDtoInterface workTypeChangeDto = null;
            WorkOnHolidayRequestDtoInterface workOnHolidayDto = null;
            for (HolidayRequestDtoInterface holidayRequestDto : this.holidayRequestList) {
                if (!DateUtility.isTermContain((Date)dto.getWorkDate(), (Date)holidayRequestDto.getRequestStartDate(), (Date)holidayRequestDto.getRequestEndDate()) || !this.workflow.isCompleted(holidayRequestDto.getWorkflow())) continue;
                if (holidayRequestDto.getHolidayRange() == 1) {
                    dto.setRestTime(null);
                    dto.setWorkTime(null);
                    continue block0;
                }
                if (holidayRequestDto.getHolidayRange() == 2) {
                    amHoliday = true;
                } else if (holidayRequestDto.getHolidayRange() == 3) {
                    pmHoliday = true;
                }
                if (!amHoliday || !pmHoliday) continue;
                dto.setRestTime(null);
                dto.setWorkTime(null);
                continue block0;
            }
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : this.subHolidayRequestList) {
                if (!subHolidayRequestDto.getRequestDate().equals(dto.getWorkDate()) || !this.workflow.isCompleted(subHolidayRequestDto.getWorkflow())) continue;
                if (subHolidayRequestDto.getHolidayRange() == 1) {
                    dto.setRestTime(null);
                    dto.setWorkTime(null);
                    continue block0;
                }
                if (subHolidayRequestDto.getHolidayRange() == 2) {
                    amHoliday = true;
                } else if (subHolidayRequestDto.getHolidayRange() == 3) {
                    pmHoliday = true;
                }
                if (!amHoliday || !pmHoliday) continue;
                dto.setRestTime(null);
                dto.setWorkTime(null);
                continue block0;
            }
            for (SubstituteDtoInterface substituteDto : this.substituteList) {
                if (!substituteDto.getSubstituteDate().equals(dto.getWorkDate()) || !this.workflow.isCompleted(substituteDto.getWorkflow())) continue;
                if (substituteDto.getSubstituteRange() == 1) {
                    dto.setRestTime(null);
                    dto.setWorkTime(null);
                    continue block0;
                }
                if (substituteDto.getSubstituteRange() == 2) {
                    amHoliday = true;
                } else if (substituteDto.getSubstituteRange() == 3) {
                    pmHoliday = true;
                }
                if (!amHoliday || !pmHoliday) continue;
                dto.setRestTime(null);
                dto.setWorkTime(null);
                continue block0;
            }
            for (WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto : this.workOnHolidayRequestList) {
                if (!workOnHolidayRequestDto.getRequestDate().equals(dto.getWorkDate()) || !this.workflow.isCompleted(workOnHolidayRequestDto.getWorkflow())) continue;
                if (workOnHolidayRequestDto.getSubstitute() == 3) {
                    pmHoliday = true;
                } else if (workOnHolidayRequestDto.getSubstitute() == 4) {
                    amHoliday = true;
                }
                if (amHoliday && pmHoliday) {
                    dto.setRestTime(null);
                    dto.setWorkTime(null);
                    continue block0;
                }
                workOnHolidayDto = workOnHolidayRequestDto;
            }
            for (WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto : this.workTypeChangeRequestList) {
                if (!workTypeChangeRequestDto.getRequestDate().equals(dto.getWorkDate()) || !this.workflow.isCompleted(workTypeChangeRequestDto.getWorkflow())) continue;
                workTypeChangeDto = workTypeChangeRequestDto;
            }
            if (workTypeChangeDto != null) {
                dto.setStartTime(null);
                dto.setEndTime(null);
                this.setDtoFields(dto, workTypeChangeDto.getWorkTypeCode(), true, true, amHoliday, pmHoliday);
                continue;
            }
            if (workOnHolidayDto != null) {
                this.setDtoFields(dto, this.getWorkOnHolidayWorkType(workOnHolidayDto), true, true, amHoliday, pmHoliday);
                if (workOnHolidayDto.getSubstitute() != 2) continue;
                startTime = this.getWorkTypeStartTime(dto);
                endTime = this.getWorkTypeEndTime(dto);
                dto.setWorkTime(Integer.valueOf(this.getDefferenceMinutes(startTime, endTime)));
                continue;
            }
            if (!amHoliday && !pmHoliday) continue;
            startTime = this.getWorkTypeStartTime(dto);
            endTime = this.getWorkTypeEndTime(dto);
            if (startTime == null || endTime == null) continue;
            dto.setStartTime(startTime);
            dto.setEndTime(endTime);
            dto.setRestTime(null);
            dto.setWorkTime(Integer.valueOf(this.getDefferenceMinutes(startTime, endTime)));
        }
    }

    protected void setApplicationInfo(AttendanceListDto dto, WorkflowDtoInterface anteDto, WorkflowDtoInterface postDto) {
        int postStatus;
        if (anteDto == null || postDto == null) {
            return;
        }
        int anteStatus = Integer.parseInt(anteDto.getWorkflowStatus());
        if (anteStatus > (postStatus = Integer.parseInt(postDto.getWorkflowStatus()))) {
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(postDto.getWorkflowStatus(), postDto.getWorkflowStage()));
            return;
        }
        if (anteStatus < postStatus) {
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(anteDto.getWorkflowStatus(), anteDto.getWorkflowStage()));
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)anteDto) || WorkflowUtility.isApply((WorkflowDtoInterface)anteDto) || WorkflowUtility.isCancel((WorkflowDtoInterface)anteDto) || WorkflowUtility.isCompleted((WorkflowDtoInterface)anteDto)) {
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(anteDto.getWorkflowStatus(), anteDto.getWorkflowStage()));
        } else if ("2".equals(anteDto.getWorkflowStatus()) || "3".equals(anteDto.getWorkflowStatus())) {
            if (anteDto.getWorkflowStage() <= postDto.getWorkflowStage()) {
                dto.setApplicationInfo(this.workflow.getWorkflowStatus(anteDto.getWorkflowStatus(), anteDto.getWorkflowStage()));
                return;
            }
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(postDto.getWorkflowStatus(), postDto.getWorkflowStage()));
        } else if ("6".equals(anteDto.getWorkflowStatus()) || "7".equals(anteDto.getWorkflowStatus())) {
            dto.setApplicationInfo(this.workflow.getWorkflowStatus(anteDto.getWorkflowStatus(), anteDto.getWorkflowStage()));
            return;
        }
    }

    protected boolean isAll(SubstituteDtoInterface dto) {
        return this.isAll(dto.getHolidayRange());
    }

    protected boolean isAll(int range) {
        return range == 1;
    }

    protected void setScheduleExtraInfo() throws MospException {
    }

    protected void setActualExtraInfo() throws MospException {
    }

    protected void setAttendanceExtraInfo() throws MospException {
    }

    protected void setWeeklyAttendanceExtraInfo() throws MospException {
    }

    protected void setApprovalAttendanceExtraInfo() throws MospException {
    }

    protected void setAttendanceListDtoExtraInfo() throws MospException {
    }

    public void setHalfWorkTypeLength(int halfWorkTypeLength) {
        this.halfWorkTypeLength = halfWorkTypeLength;
    }
}

