/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.AttendanceReapplicationExportBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceReapplicationExportBean
extends TimeApplicationBean
implements AttendanceReapplicationExportBeanInterface {
    public static final String FILENAME_EXTENSION_CSV = ".csv";
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected AttendanceDaoInterface attendanceDao;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected HumanReferenceBeanInterface humanReference;
    protected HumanSearchBeanInterface humanSearch;
    private int ckbNeedLowerSection = 0;

    public AttendanceReapplicationExportBean() {
    }

    public AttendanceReapplicationExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
    }

    public void export(String exportCode, int startYear, int startMonth, int endYear, int endMonth, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, int ckbNeedLowerSection, String positionCode) throws MospException {
        Date lastDate;
        this.ckbNeedLowerSection = ckbNeedLowerSection;
        ExportDtoInterface dto = this.exportDao.findForKey(exportCode);
        if (dto == null) {
            this.addNoExportDataMessage();
            return;
        }
        CutoffDtoInterface cutoffDto = this.cutoffUtil.getCutoff(cutoffCode, startYear, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date firstDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)startYear, (int)startMonth);
        List list = this.getCsvDataList(dto, firstDate, lastDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)endYear, (int)endMonth), cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (list.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)list));
        this.mospParams.setFileName(this.getFilename(dto, firstDate, lastDate));
    }

    protected List<String[]> getCsvDataList(ExportDtoInterface dto, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        List fieldList = this.exportFieldDao.findForList(dto.getExportCode());
        List list = this.getCsvDataList(fieldList, firstDate, lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (dto.getHeader() != 0) {
            this.addHeader(list, this.getHeader(dto, fieldList));
        }
        return list;
    }

    protected List<String[]> getCsvDataList(List<ExportFieldDtoInterface> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        Integer employeeCodeIndex = null;
        Integer fullNameIndex = null;
        Integer workDateIndex = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            int index = dto.getFieldOrder() - 1;
            if ("employee_code".equals(dto.getFieldName())) {
                employeeCodeIndex = index;
                continue;
            }
            if ("full_name".equals(dto.getFieldName())) {
                fullNameIndex = index;
                continue;
            }
            if (!"work_date".equals(dto.getFieldName())) continue;
            workDateIndex = index;
        }
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        for (AttendanceDtoInterface dto : this.findAttendanceList(this.findHumanList(lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode), firstDate, lastDate)) {
            HumanDtoInterface humanDto = this.humanReference.getHumanInfo(dto.getPersonalId(), dto.getWorkDate());
            String[] csvData = new String[fieldList.size()];
            if (employeeCodeIndex != null && humanDto != null) {
                csvData[employeeCodeIndex.intValue()] = humanDto.getEmployeeCode();
            }
            if (fullNameIndex != null && humanDto != null) {
                csvData[fullNameIndex.intValue()] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
            }
            if (workDateIndex != null) {
                csvData[workDateIndex.intValue()] = this.getStringDate(dto.getWorkDate());
            }
            csvDataList.add(csvData);
        }
        return csvDataList;
    }

    protected List<HumanDtoInterface> findHumanList(Date targetDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("");
        if (this.ckbNeedLowerSection == 1) {
            this.humanSearch.setNeedLowerSection(true);
        } else {
            this.humanSearch.setNeedLowerSection(false);
        }
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        List humanList = this.humanSearch.search();
        if (cutoffCode.isEmpty()) {
            return humanList;
        }
        ArrayList<HumanDtoInterface> list = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface dto : humanList) {
            if (!this.hasCutoffSettings(dto.getPersonalId(), targetDate) || !this.cutoffDto.getCutoffCode().equals(cutoffCode)) continue;
            list.add(dto);
        }
        return list;
    }

    protected List<AttendanceDtoInterface> findAttendanceList(List<HumanDtoInterface> list, Date firstDate, Date lastDate) throws MospException {
        ArrayList<AttendanceDtoInterface> attendanceList = new ArrayList<AttendanceDtoInterface>();
        for (HumanDtoInterface dto : list) {
            List attendanceDtoList = this.findAttendanceList(dto.getPersonalId(), firstDate, lastDate);
            if (attendanceDtoList.isEmpty()) continue;
            attendanceList.addAll(attendanceDtoList);
        }
        return attendanceList;
    }

    protected List<AttendanceDtoInterface> findAttendanceList(String personalId, Date firstDate, Date lastDate) throws MospException {
        ArrayList<AttendanceDtoInterface> list = new ArrayList<AttendanceDtoInterface>();
        for (AttendanceDtoInterface dto : this.attendanceDao.findForReapplicationExport(personalId, firstDate, lastDate)) {
            if (!this.isReapplicationTarget(dto)) continue;
            list.add(dto);
        }
        return list;
    }

    protected String getTomorrowWorkTypeCode(AttendanceDtoInterface dto) throws MospException {
        return this.getWorkTypeCode(dto.getPersonalId(), this.addDay(dto.getWorkDate(), 1));
    }

    protected String getWorkTypeCode(String personalId, Date targetDate) throws MospException {
        return this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, true);
    }

    protected void addHeader(List<String[]> csvDataList, String[] header) {
        csvDataList.add(0, header);
    }

    protected String[] getHeader(ExportDtoInterface dto, List<ExportFieldDtoInterface> list) {
        String[][] array = this.mospParams.getProperties().getCodeArray(dto.getExportTable(), false);
        String[] header = new String[list.size()];
        for (int i = 0; i < header.length; ++i) {
            header[i] = MospUtility.getCodeName((String)list.get(i).getFieldName(), (String[][])array);
        }
        return header;
    }

    protected String getFilename(ExportDtoInterface dto, Date firstDate, Date lastDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getExportCode());
        sb.append(this.mospParams.getName("Hyphen"));
        sb.append(DateUtility.getStringYear((Date)firstDate));
        sb.append(DateUtility.getStringMonth((Date)firstDate));
        sb.append(DateUtility.getStringDay((Date)firstDate));
        sb.append(this.mospParams.getName("Hyphen"));
        sb.append(DateUtility.getStringYear((Date)lastDate));
        sb.append(DateUtility.getStringMonth((Date)lastDate));
        sb.append(DateUtility.getStringDay((Date)lastDate));
        sb.append(this.getFilenameExtension(dto));
        return sb.toString();
    }

    protected String getFilenameExtension(ExportDtoInterface dto) {
        if ("1".equals(dto.getType())) {
            return FILENAME_EXTENSION_CSV;
        }
        return "";
    }

    protected void setFileName(String fileName) {
        this.mospParams.setFileName(fileName);
    }

    protected void addNoExportDataMessage() {
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Export", new String[]{"Information"})});
    }

    protected boolean isReapplicationTarget(AttendanceDtoInterface dto) throws MospException {
        return this.isReapplicationTarget(dto, this.getTomorrowWorkTypeCode(dto));
    }

    protected boolean isReapplicationTarget(AttendanceDtoInterface dto, String tomorrowWorkTypeCode) {
        return dto.getLegalWorkTime() > 0 && !"work_on_legal".equals(dto.getWorkTypeCode()) && !"legal_holiday".equals(tomorrowWorkTypeCode) && !"work_on_legal".equals(tomorrowWorkTypeCode) || this.addDay(dto.getWorkDate(), 1).before(dto.getEndTime()) && dto.getLegalWorkTime() == 0 && ("legal_holiday".equals(tomorrowWorkTypeCode) || "work_on_legal".equals(tomorrowWorkTypeCode));
    }
}

