/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.AttendanceCorrectionRegistBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceDto;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceRegistBean
extends TimeApplicationBean
implements AttendanceRegistBeanInterface {
    protected AttendanceDaoInterface dao;
    private AttendanceReferenceBeanInterface attendanceReference;
    private HolidayRequestReferenceBeanInterface holidayRequestReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected WorkTypeItemDaoInterface workTypeItemDao;
    protected WorkflowReferenceBeanInterface workflowReference;
    private OvertimeRequestDaoInterface overtimeDao;
    private DifferenceRequestReferenceBeanInterface differenceReference;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    private SubstituteDaoInterface substituteDao;
    private SubHolidayRequestDaoInterface subHolidayDao;
    private RetirementReferenceBeanInterface retirementReference;
    private WorkflowCommentReferenceBeanInterface workflowCommentReference;
    private AttendanceCorrectionRegistBeanInterface attendanceCorrectionRegist;
    private RestRegistBeanInterface restRegist;
    private GoOutRegistBeanInterface goOutRegist;
    private SubHolidayRegistBeanInterface subHolidayRegist;
    private WorkflowRegistBeanInterface workflowRegist;
    private WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    private CutoffUtilBeanInterface cutoffUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected static final String APP_KEY_APPLICABLE_LIMIT_ATTENDANCE = "ApplicableLimitAttendance";

    public AttendanceRegistBean() {
    }

    public AttendanceRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
        this.holidayRequestReference = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.overtimeDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.differenceReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.subHolidayDao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.workflowCommentReference = (WorkflowCommentReferenceBeanInterface)this.createBean(WorkflowCommentReferenceBeanInterface.class);
        this.attendanceCorrectionRegist = (AttendanceCorrectionRegistBeanInterface)this.createBean(AttendanceCorrectionRegistBeanInterface.class);
        this.restRegist = (RestRegistBeanInterface)this.createBean(RestRegistBeanInterface.class);
        this.goOutRegist = (GoOutRegistBeanInterface)this.createBean(GoOutRegistBeanInterface.class);
        this.subHolidayRegist = (SubHolidayRegistBeanInterface)this.createBean(SubHolidayRegistBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
    }

    public AttendanceDtoInterface getInitDto() {
        return new TmdAttendanceDto();
    }

    public void regist(AttendanceDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork()) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void insert(AttendanceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(AttendanceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
        dto.setTmdAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(AttendanceDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork()));
    }

    protected void checkAdd(AttendanceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
    }

    public void checkValidate(AttendanceDtoInterface dto) throws MospException {
        this.checkTimeValidity(dto);
        this.attendanceReference.chkBasicInfo(dto.getPersonalId(), dto.getWorkDate());
    }

    public void validate(AttendanceDtoInterface dto) {
    }

    public void checkDraft(AttendanceDtoInterface dto) throws MospException {
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        this.checkTemporaryClosingFinal(dto);
        if (dto.getStartTime() != null || dto.getEndTime() != null) {
            this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDraftStartTimeForWork(dto);
            this.checkDraftEndTimeForWork(dto);
        }
        this.checkWorkOnHolidayRequest(dto);
        this.checkHolidayRequest(dto);
        if (this.mospParams.getApplicationPropertyBool("UseMinutelyHoliday")) {
            this.checkMinutelyHoliday(dto);
        }
    }

    public void checkAppli(AttendanceDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkPeriod(dto);
        if (dto.getMinutelyHolidayA() != 1 && dto.getMinutelyHolidayB() != 1) {
            this.checkLateTime(dto);
            this.checkLeaveEarlyTime(dto);
        }
        this.checkOvertime(dto);
        this.checkRequest(dto);
        this.checkPaidLeaveTime(dto);
        this.checkPaidLeaveTimeForShortTime(dto);
        this.checkAttendance(dto);
    }

    public void checkCancelAppli(AttendanceDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        this.checkSubHoliday(dto, this.mospParams.getName("Release"));
    }

    public void checkDelete(AttendanceDtoInterface dto) throws MospException {
        this.checkSubHoliday(dto, this.mospParams.getName("Delete"));
    }

    public void checkApproval(AttendanceDtoInterface dto) throws MospException {
        this.checkAppli(dto);
        this.checkTomorrowAttendance(dto);
    }

    public void checkCancelApproval(AttendanceDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(AttendanceDtoInterface dto) throws MospException {
        this.checkSubHoliday(dto, this.mospParams.getName("Release"));
    }

    public void checkPeriod(AttendanceDtoInterface dto) {
        int checkPeriodDays = this.mospParams.getApplicationProperty(APP_KEY_APPLICABLE_LIMIT_ATTENDANCE, 0);
        if (checkPeriodDays == 0) {
            return;
        }
        if (checkPeriodDays > 100) {
            int targetMonth = checkPeriodDays - 100;
            if (dto.getWorkDate().after(DateUtility.addMonth((Date)this.getSystemDate(), (int)targetMonth)) || dto.getWorkDate().equals(DateUtility.addMonth((Date)this.getSystemDate(), (int)targetMonth))) {
                this.addAttendancePeriodErrorMessage(targetMonth + this.mospParams.getName("Months"));
            }
            return;
        }
        if (dto.getWorkDate().after(DateUtility.addDay((Date)this.getSystemDate(), (int)checkPeriodDays)) || dto.getWorkDate().equals(DateUtility.addDay((Date)this.getSystemDate(), (int)checkPeriodDays))) {
            this.addAttendancePeriodErrorMessage(checkPeriodDays + this.mospParams.getName("Day"));
        }
    }

    public void checkLateTime(AttendanceDtoInterface dto) throws MospException {
        this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (this.checkLateLimit(dto, this.timeSettingDto)) {
            List list = this.holidayRequestReference.getHolidayRequestList(dto.getPersonalId(), dto.getWorkDate());
            for (HolidayRequestDtoInterface holidayRequestDto : list) {
                WorkflowDtoInterface workflowDto;
                if (holidayRequestDto.getHolidayRange() != 2 || WorkflowUtility.isDraft((WorkflowDtoInterface)(workflowDto = this.workflowReference.getLatestWorkflowInfo(holidayRequestDto.getWorkflow()))) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
                return;
            }
            this.getArdinessTardinessLimitOver(dto.getWorkDate());
        }
    }

    public void checkLeaveEarlyTime(AttendanceDtoInterface dto) throws MospException {
        this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (this.checkLeaveEarlyLimit(dto, this.timeSettingDto)) {
            List list = this.holidayRequestReference.getHolidayRequestList(dto.getPersonalId(), dto.getWorkDate());
            for (HolidayRequestDtoInterface holidayRequestDto : list) {
                WorkflowDtoInterface workflowDto;
                if (holidayRequestDto.getHolidayRange() != 3 || WorkflowUtility.isDraft((WorkflowDtoInterface)(workflowDto = this.workflowReference.getLatestWorkflowInfo(holidayRequestDto.getWorkflow()))) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
                return;
            }
            this.getLeaveEarlyLimitOver(dto.getWorkDate());
        }
    }

    public void checkHolidayTime(String personalId, Date workDate, List<RestDtoInterface> restList, List<GoOutDtoInterface> goOutPublicList, List<GoOutDtoInterface> goOutPrivateList, List<GoOutDtoInterface> goOutMinutely1HolidayList, List<GoOutDtoInterface> goOutMinutely2HolidayList) throws MospException {
        String workDateString = DateUtility.getStringDateAndDay((Date)workDate);
        this.requestUtil.setRequests(personalId, workDate);
        List holidayList = this.requestUtil.getHolidayList(true);
        for (HolidayRequestDtoInterface holidayDto : holidayList) {
            if (holidayDto.getHolidayRange() != 4) continue;
            Date startTime = holidayDto.getStartTime();
            Date endTime = holidayDto.getEndTime();
            for (RestDtoInterface restDto : restList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, restDto.getRestStart(), restDto.getRestEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("Rest" + restDto.getRest())};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutPublicList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Official"));
                sb.append(this.mospParams.getName("GoingOut"));
                sb.append(goOutDto.getTimesGoOut());
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), sb.toString()};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutPrivateList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("PrivateGoingOut" + goOutDto.getTimesGoOut())};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutMinutely1HolidayList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("MinutelyHolidayAAbbr")};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutMinutely2HolidayList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("MinutelyHolidayBAbbr")};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
        }
    }

    public void checkAttendanceCardDraft(AttendanceDtoInterface dto) throws MospException {
    }

    public void checkAttendanceCardAppli(AttendanceDtoInterface dto) throws MospException {
    }

    public void checkDraftStartTimeForWork(AttendanceDtoInterface dto) throws MospException {
        if (dto.getStartTime() == null) {
            return;
        }
        String workDate = this.getStringDate(dto.getWorkDate());
        if (!dto.getStartTime().before(this.addDay(dto.getWorkDate(), 1))) {
            this.mospParams.addErrorMessage("TMW0235", new String[]{workDate, DateUtility.getStringTime((Date)DateUtility.addHour((Date)DateUtility.getDefaultTime(), (int)24), (Date)DateUtility.getDefaultTime()), this.getNameStartTimeForWork()});
        }
        if (!dto.getStartTime().before(this.getTime(this.timeSettingDto.getStartDayTime(), dto.getWorkDate()))) {
            return;
        }
        AttendanceDtoInterface yesterdayDto = this.attendanceReference.findForKey(dto.getPersonalId(), this.addDay(dto.getWorkDate(), -1), 1);
        if (yesterdayDto == null || yesterdayDto.getEndTime() == null) {
            return;
        }
        if (dto.getStartTime().after(yesterdayDto.getEndTime())) {
            return;
        }
        String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Kara"});
        this.mospParams.addErrorMessage("TMW0239", new String[]{workDate, rep, DateUtility.getStringTime((Date)this.timeSettingDto.getStartDayTime()), DateUtility.getStringTime((Date)DateUtility.addHour((Date)this.timeSettingDto.getStartDayTime(), (int)24), (Date)DateUtility.getDefaultTime())});
    }

    public void checkDraftEndTimeForWork(AttendanceDtoInterface dto) throws MospException {
        if (dto.getEndTime() == null) {
            return;
        }
        String workDate = this.getStringDate(dto.getWorkDate());
        Date tomorrowDate = this.addDay(dto.getWorkDate(), 1);
        Date afterTwentyFourHoursTime = this.getTime(this.timeSettingDto.getStartDayTime(), tomorrowDate);
        String afterTwentyFourHours = DateUtility.getStringTime((Date)afterTwentyFourHoursTime, (Date)dto.getWorkDate());
        if (dto.getEndTime().after(afterTwentyFourHoursTime)) {
            this.mospParams.addErrorMessage("TMW0235", new String[]{workDate, afterTwentyFourHours, this.getNameEndTimeForWork()});
        }
        if (afterTwentyFourHoursTime.equals(dto.getEndTime())) {
            return;
        }
        AttendanceDtoInterface tomorrowDto = this.attendanceReference.findForKey(dto.getPersonalId(), tomorrowDate, 1);
        if (tomorrowDto == null || tomorrowDto.getStartTime() == null) {
            return;
        }
        if (dto.getEndTime().before(tomorrowDto.getStartTime())) {
            return;
        }
        String rep = this.mospParams.getName("NextDay", new String[]{"To"});
        this.mospParams.addErrorMessage("TMW0239", new String[]{workDate, rep, DateUtility.getStringTime((Date)this.timeSettingDto.getStartDayTime()), afterTwentyFourHours});
    }

    public boolean checkLateLimit(AttendanceDtoInterface dto, TimeSettingDtoInterface timeSettingDto) {
        int lateEarlyHalf = DateUtility.getHour((Date)timeSettingDto.getLateEarlyHalf()) * 60 + DateUtility.getMinute((Date)timeSettingDto.getLateEarlyHalf());
        return lateEarlyHalf < dto.getLateTime();
    }

    public boolean checkLeaveEarlyLimit(AttendanceDtoInterface dto, TimeSettingDtoInterface timeSettingDto) {
        int lateEarlyHalf = DateUtility.getHour((Date)timeSettingDto.getLateEarlyHalf()) * 60 + DateUtility.getMinute((Date)timeSettingDto.getLateEarlyHalf());
        return lateEarlyHalf < dto.getLeaveEarlyTime();
    }

    public void checkOvertime(AttendanceDtoInterface dto) throws MospException {
        boolean overTimeAfter;
        this.setCutoffSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int noApproval = this.cutoffDto.getNoApproval();
        if (noApproval != 2) {
            return;
        }
        boolean overTimeBefore = dto.getOvertimeBefore() > 0;
        boolean bl = overTimeAfter = dto.getOvertimeAfter() > 0;
        if (!overTimeBefore && !overTimeAfter) {
            return;
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) {
            return;
        }
        List overtimeRequestList = this.requestUtil.getOverTimeList(true);
        for (OvertimeRequestDtoInterface overtimeRequestDto : overtimeRequestList) {
            int type = overtimeRequestDto.getOvertimeType();
            if (overTimeBefore && type == 1) {
                overTimeBefore = false;
                continue;
            }
            if (!overTimeAfter || type != 2) continue;
            overTimeAfter = false;
        }
        if (!overTimeBefore && !overTimeAfter) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0304", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("OvertimeWork"), this.mospParams.getName("OvertimeWork")});
    }

    public void checkRequest(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        String personalId = dto.getPersonalId();
        Date requestDate = dto.getWorkDate();
        String requestName = "";
        this.requestUtil.setRequests(personalId, requestDate);
        ArrayList completedOvertimeList = new ArrayList();
        completedOvertimeList.addAll(this.requestUtil.getOverTimeList(true));
        List overtimeList = this.overtimeDao.findForList(personalId, requestDate);
        for (OvertimeRequestDtoInterface requestDto : overtimeList) {
            WorkflowDtoInterface workflowDto2 = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto2)) continue;
            requestName = this.mospParams.getName("OvertimeWork", new String[]{"Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
        }
        DifferenceRequestDtoInterface differenceDto = this.differenceReference.findForKeyOnWorkflow(personalId, requestDate);
        if (!(differenceDto == null || (workflowDto = this.workflowReference.getLatestWorkflowInfo(differenceDto.getWorkflow())) == null || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto))) {
            requestName = this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
        }
        List holidayList = this.holidayRequestReference.getHolidayRequestList(personalId, requestDate);
        for (HolidayRequestDtoInterface requestDto : holidayList) {
            WorkflowDtoInterface workflowDto3;
            int holidayRange = requestDto.getHolidayRange();
            if (holidayRange != 2 && holidayRange != 3 && holidayRange != 4 || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)(workflowDto3 = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow()))) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto3)) continue;
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto3)) {
                requestName = this.mospParams.getName("Vacation", new String[]{"Application"});
                this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
                return;
            }
            if (holidayRange != 4 || this.isConfirmValidate(dto, completedOvertimeList, differenceDto, requestDto.getStartTime(), requestDto.getEndTime())) continue;
            String[] rep = new String[]{this.mospParams.getName("HolidayTime")};
            this.mospParams.addErrorMessage("TMW0237", rep);
            break;
        }
        List substituteList = this.substituteDao.findForList(personalId, requestDate);
        for (SubstituteDtoInterface substituteDto : substituteList) {
            WorkflowDtoInterface workflowDto4;
            int range = substituteDto.getSubstituteRange();
            if (range != 2 && range != 3 || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)(workflowDto4 = this.workflowReference.getLatestWorkflowInfo(substituteDto.getWorkflow()))) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto4) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto4)) continue;
            requestName = this.mospParams.getName("Holiday", new String[]{"GoingWork", "Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
        }
        List subHolidayList = this.subHolidayDao.findForList(personalId, requestDate);
        for (SubHolidayRequestDtoInterface requestDto : subHolidayList) {
            WorkflowDtoInterface workflowDto5;
            int holidayRange = requestDto.getHolidayRange();
            if (holidayRange != 2 && holidayRange != 3 || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)(workflowDto5 = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow()))) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto5) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto5)) continue;
            requestName = this.mospParams.getName("CompensatoryHoliday", new String[]{"Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.requestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeDto != null && !this.workflowIntegrate.isCompleted(workTypeChangeDto.getWorkflow())) {
            requestName = this.mospParams.getName("Work", new String[]{"Form", "Change", "Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(requestDate), requestName});
        }
    }

    protected boolean isConfirmValidate(AttendanceDtoInterface dto, List<OvertimeRequestDtoInterface> overtimeList, DifferenceRequestDtoInterface differenceDto, Date requestStartTime, Date requestEndTime) throws MospException {
        if (TimeUtility.isWorkOnLegalHoliday((String)dto.getWorkTypeCode()) || TimeUtility.isWorkOnPrescribedHoliday((String)dto.getWorkTypeCode())) {
            return true;
        }
        Date startTime = dto.getStartTime();
        Date endTime = dto.getEndTime();
        if (differenceDto != null && this.workflowIntegrate.isCompleted(differenceDto.getWorkflow())) {
            startTime = differenceDto.getRequestStart();
            endTime = differenceDto.getRequestEnd();
        } else {
            WorkTypeItemDtoInterface startDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkStart");
            WorkTypeItemDtoInterface endDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkEnd");
            if (startDto != null && endDto != null) {
                int startHour = DateUtility.getHour((Date)startDto.getWorkTypeItemValue(), (Date)DateUtility.getDefaultTime());
                int startMinute = DateUtility.getMinute((Date)startDto.getWorkTypeItemValue());
                int endHour = DateUtility.getHour((Date)endDto.getWorkTypeItemValue(), (Date)DateUtility.getDefaultTime());
                int endMinute = DateUtility.getMinute((Date)endDto.getWorkTypeItemValue());
                startTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)dto.getWorkDate(), (int)startHour), (int)startMinute);
                endTime = DateUtility.addMinute((Date)DateUtility.addHour((Date)dto.getWorkDate(), (int)endHour), (int)endMinute);
            }
        }
        return !requestStartTime.before(startTime) && !requestEndTime.after(endTime);
    }

    protected void checkWorkOnHolidayRequest(AttendanceDtoInterface dto) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (workOnHolidayRequestDto == null || this.workflowIntegrate.isCompleted(workOnHolidayRequestDto.getWorkflow())) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0278", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("jp.mosp.time.input.vo.WorkOnHolidayRequestVo")});
    }

    protected boolean isWorkDayForWorkOnHoliday() throws MospException {
        if (this.requestUtil.getWorkOnHolidayDto(true) != null) {
            return true;
        }
        return this.requestUtil.checkHolidayRangeSubstitute(this.requestUtil.getSubstituteList(false)) != 1;
    }

    protected void checkHolidayRequest(AttendanceDtoInterface dto) throws MospException {
        if (!this.isWorkDayForWorkOnHoliday()) {
            this.mospParams.addErrorMessage("TMW0279", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("ObservedHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})});
            return;
        }
        boolean holidayAm = false;
        boolean holidayPm = false;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null || workOnHolidayRequestDto.getSubstitute() == 1) {
            int holidayRange = this.requestUtil.checkHolidayRangeHoliday(this.requestUtil.getHolidayList(false));
            if (holidayRange == 1) {
                TimeMessageUtility.addErrorNotApplicableForHoliday((MospParams)this.mospParams, (Date)dto.getWorkDate(), null);
                return;
            }
            if (holidayRange == 2) {
                holidayAm = true;
            } else if (holidayRange == 3) {
                holidayPm = true;
            } else if (holidayRange == 5) {
                holidayAm = true;
                holidayPm = true;
            }
        }
        boolean subHolidayAm = false;
        boolean subHolidayPm = false;
        int subHolidayRange = this.requestUtil.checkHolidayRangeSubHoliday(this.requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 1) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("CompensatoryHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0279", rep);
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayPm = true;
        } else if (subHolidayRange == 5) {
            subHolidayAm = true;
            subHolidayPm = true;
        }
        boolean substituteAm = false;
        boolean substitutePm = false;
        int substituteRange = this.getSubstituteRange(dto);
        if (substituteRange == 1) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("ObservedHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0279", rep);
            return;
        }
        if (substituteRange == 2) {
            substituteAm = true;
        } else if (substituteRange == 3) {
            substitutePm = true;
        } else if (substituteRange == 5) {
            substituteAm = true;
            substitutePm = true;
        }
        if ((holidayAm || subHolidayAm || substituteAm) && (holidayPm || subHolidayPm || substitutePm)) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0338", rep);
        }
    }

    protected void checkMinutelyHoliday(AttendanceDtoInterface dto) throws MospException {
        boolean allMinutelyHolidayB;
        String workTypeCode = dto.getWorkTypeCode();
        if (workTypeCode.equals("work_on_prescribed")) {
            if (dto.getMinutelyHolidayATime() != 0 || dto.getMinutelyHolidayBTime() != 0) {
                String[] rep = new String[]{this.mospParams.getName("Prescribed", new String[]{"Holiday", "GoingWork", "Day"}), this.mospParams.getName("MinutelyHoliday")};
                this.mospParams.addErrorMessage("TMW0327", rep);
                return;
            }
        } else if (workTypeCode.equals("work_on_legal") && (dto.getMinutelyHolidayATime() != 0 || dto.getMinutelyHolidayBTime() != 0)) {
            String[] rep = new String[]{this.mospParams.getName("Legal", new String[]{"Holiday", "GoingWork", "Day"}), this.mospParams.getName("MinutelyHoliday")};
            this.mospParams.addErrorMessage("TMW0327", rep);
            return;
        }
        TimeSettingDtoInterface timeSettingDto = this.cutoffUtil.getTimeSetting(dto.getPersonalId(), dto.getWorkDate());
        int time = DateUtility.getHour((Date)timeSettingDto.getGeneralWorkTime()) * 60;
        int minutelyHolidayTime = dto.getMinutelyHolidayATime() + dto.getMinutelyHolidayBTime();
        boolean allMinutelyHolidayA = dto.getMinutelyHolidayA() == this.getInteger("1").intValue();
        boolean bl = allMinutelyHolidayB = dto.getMinutelyHolidayB() == this.getInteger("1").intValue();
        if ((time += DateUtility.getMinute((Date)timeSettingDto.getGeneralWorkTime())) >= minutelyHolidayTime) {
            return;
        }
        if (allMinutelyHolidayA && allMinutelyHolidayB) {
            TimeMessageUtility.addErrorMinutelyAOutOfWorkTime((MospParams)this.mospParams);
            TimeMessageUtility.addErrorMinutelyBOutOfWorkTime((MospParams)this.mospParams);
            return;
        }
        if (allMinutelyHolidayA) {
            TimeMessageUtility.addErrorMinutelyAOutOfWorkTime((MospParams)this.mospParams);
            return;
        }
        if (allMinutelyHolidayB) {
            TimeMessageUtility.addErrorMinutelyBOutOfWorkTime((MospParams)this.mospParams);
            return;
        }
        this.mospParams.addErrorMessage("TMW0310", new String[]{this.mospParams.getName("MinutelyHoliday"), this.mospParams.getName("Prescribed", new String[]{"Labor", "Time"})});
    }

    public void checkTimeExist(AttendanceDtoInterface dto) {
        if (dto.getStartTime() == null && dto.getEndTime() == null) {
            this.mospParams.addErrorMessage("TMW0268", new String[0]);
        }
    }

    public void checkTimeValidity(AttendanceDtoInterface dto) {
        if (dto.getStartTime() == null || dto.getEndTime() == null) {
            return;
        }
        this.checkWorkTime(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (dto.getEndTime().before(dto.getStartTime())) {
            this.addInvalidOrderMessage(this.mospParams.getName("StartWork"), this.mospParams.getName("EndWork"));
        }
    }

    protected void checkWorkTime(AttendanceDtoInterface dto) {
        boolean allBHoliday;
        if (dto.getWorkTime() < 0) {
            this.mospParams.addErrorMessage("TMW0325", new String[0]);
        }
        boolean allAHoliday = dto.getMinutelyHolidayA() == this.getInteger("1").intValue();
        boolean bl = allBHoliday = dto.getMinutelyHolidayB() == this.getInteger("1").intValue();
        if (!(dto.getWorkTime() != 0 || allAHoliday || allBHoliday || dto.getMinutelyHolidayATime() <= 0 && dto.getMinutelyHolidayBTime() <= 0)) {
            TimeMessageUtility.addErrorMinutelyAllHoliday((MospParams)this.mospParams);
        }
        if (dto.getWorkTime() > 0 && (allAHoliday || allBHoliday)) {
            this.mospParams.addErrorMessage("TMW0324", new String[0]);
        }
    }

    public void checkAttendance(AttendanceDtoInterface dto) throws MospException {
        AttendanceDtoInterface attendanceDto = this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if ("3".equals(workflowDto.getWorkflowStatus()) && workflowDto.getWorkflowStage() == 0) {
            return;
        }
        if (dto.getWorkflow() == workflowDto.getWorkflow()) {
            return;
        }
        TimeMessageUtility.addErrorAlreadyApplyWork((MospParams)this.mospParams, (Date)dto.getWorkDate(), null);
    }

    public void checkRequired(AttendanceDtoInterface dto) {
        this.checkRegistStartTimeForWork(dto);
        this.checkRegistEndTimeForWork(dto);
        this.checkLateReason(dto);
        this.checkLeaveEarlyReason(dto);
    }

    protected void checkRegistStartTimeForWork(AttendanceDtoInterface dto) {
        if (dto == null || dto.getStartTime() == null) {
            this.mospParams.addErrorMessage("TMW0233", new String[]{this.getNameStartTimeForWork()});
        }
    }

    protected void checkRegistEndTimeForWork(AttendanceDtoInterface dto) {
        if (dto == null || dto.getEndTime() == null) {
            this.mospParams.addErrorMessage("TMW0233", new String[]{this.getNameEndTimeForWork()});
        }
    }

    protected void checkLateReason(AttendanceDtoInterface dto) {
        if (dto.getActualLateTime() == 0) {
            return;
        }
        if (dto.getLateReason().isEmpty()) {
            this.mospParams.addErrorMessage("TMW0319", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Tardiness", new String[]{"Reason"})});
        }
    }

    protected void checkLeaveEarlyReason(AttendanceDtoInterface dto) {
        if (dto.getActualLeaveEarlyTime() == 0) {
            return;
        }
        if (dto.getLeaveEarlyReason().isEmpty()) {
            this.mospParams.addErrorMessage("TMW0319", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("LeaveEarly", new String[]{"Reason"})});
        }
    }

    protected void checkPaidLeaveTime(AttendanceDtoInterface dto) throws MospException {
        AttendanceDtoInterface tomorrowDto;
        RequestUtilBeanInterface yesterdayRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        yesterdayRequestUtil.setRequests(dto.getPersonalId(), DateUtility.addDay((Date)dto.getWorkDate(), (int)-1));
        RequestUtilBeanInterface tomorrowRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        tomorrowRequestUtil.setRequests(dto.getPersonalId(), DateUtility.addDay((Date)dto.getWorkDate(), (int)1));
        AttendanceDtoInterface yesterdayDto = yesterdayRequestUtil.getApplicatedAttendance();
        if (yesterdayDto == null) {
            yesterdayDto = yesterdayRequestUtil.getFirstRevertedAttendance();
        }
        if (yesterdayDto == null) {
            yesterdayDto = yesterdayRequestUtil.getDraftAttendance();
        }
        Date yesterdayEndTime = null;
        if (yesterdayDto != null) {
            yesterdayEndTime = yesterdayDto.getEndTime();
        }
        if ((tomorrowDto = tomorrowRequestUtil.getApplicatedAttendance()) == null) {
            tomorrowDto = tomorrowRequestUtil.getFirstRevertedAttendance();
        }
        if (tomorrowDto == null) {
            tomorrowDto = tomorrowRequestUtil.getDraftAttendance();
        }
        Date tomorrowStartTime = null;
        if (tomorrowDto != null) {
            tomorrowStartTime = tomorrowDto.getStartTime();
        }
        if (yesterdayEndTime != null || tomorrowStartTime != null) {
            for (HolidayRequestDtoInterface holidayDto : this.requestUtil.getHolidayList(true)) {
                if (holidayDto.getHolidayRange() != 4) continue;
                if (yesterdayEndTime != null && holidayDto.getStartTime().before(yesterdayEndTime)) {
                    String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Of", "Work", "Time"});
                    this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("HolidayTime"), rep});
                    return;
                }
                if (tomorrowStartTime == null || !holidayDto.getEndTime().after(tomorrowStartTime)) continue;
                String rep = this.mospParams.getName("NextDay", new String[]{"Of", "Work", "Time"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("HolidayTime"), rep});
                return;
            }
        }
        if (dto.getStartTime() != null) {
            for (HolidayRequestDtoInterface holidayDto : yesterdayRequestUtil.getHolidayList(false)) {
                if (holidayDto.getHolidayRange() != 4 || !holidayDto.getEndTime().after(dto.getStartTime())) continue;
                String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Of", "HolidayTime"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Work", new String[]{"Time"}), rep});
                return;
            }
        }
        if (dto.getEndTime() != null) {
            for (HolidayRequestDtoInterface holidayDto : tomorrowRequestUtil.getHolidayList(false)) {
                if (holidayDto.getHolidayRange() != 4 || !holidayDto.getStartTime().before(dto.getEndTime())) continue;
                String rep = this.mospParams.getName("NextDay", new String[]{"Of", "HolidayTime"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Work", new String[]{"Time"}), rep});
                return;
            }
        }
    }

    protected void checkPaidLeaveTimeForShortTime(AttendanceDtoInterface dto) throws MospException {
        DifferenceRequestDtoInterface differenceRequestDto = this.requestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            return;
        }
        WorkTypeEntity workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), dto.getWorkDate());
        if (workTypeEntity == null) {
            return;
        }
        boolean isShort1TimeSet = workTypeEntity.isShort1TimeSet();
        Date short1StartTime = null;
        Date short1EndTime = null;
        if (isShort1TimeSet) {
            short1StartTime = this.getTime(workTypeEntity.getShort1StartTime(), dto.getWorkDate());
            short1EndTime = this.getTime(workTypeEntity.getShort1EndTime(), dto.getWorkDate());
        }
        boolean isShort2TimeSet = workTypeEntity.isShort2TimeSet();
        Date short2StartTime = null;
        Date short2EndTime = null;
        if (isShort2TimeSet) {
            short2StartTime = this.getTime(workTypeEntity.getShort2StartTime(), dto.getWorkDate());
            short2EndTime = this.getTime(workTypeEntity.getShort2EndTime(), dto.getWorkDate());
        }
        if (!isShort1TimeSet && !isShort2TimeSet) {
            return;
        }
        for (HolidayRequestDtoInterface holidayDto : this.requestUtil.getHolidayList(true)) {
            if (holidayDto.getHolidayRange() != 4) continue;
            if (isShort1TimeSet && this.checkDuplicationTimeZone(holidayDto.getStartTime(), holidayDto.getEndTime(), short1StartTime, short1EndTime)) {
                this.mospParams.addErrorMessage("TMW0312", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("ShortTime", new String[]{"Time", "No1"}), this.mospParams.getName("HolidayTime")});
                return;
            }
            if (!isShort2TimeSet || !this.checkDuplicationTimeZone(holidayDto.getStartTime(), holidayDto.getEndTime(), short2StartTime, short2EndTime)) continue;
            this.mospParams.addErrorMessage("TMW0312", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("ShortTime", new String[]{"Time", "No2"}), this.mospParams.getName("HolidayTime")});
            return;
        }
    }

    public void checkPrivateGoOut(AttendanceDtoInterface dto, List<RestDtoInterface> restList, List<GoOutDtoInterface> privateList) throws MospException {
        int end;
        int end2;
        int start;
        int count;
        int time;
        int workEnd;
        int workStart;
        WorkflowDtoInterface workflowDto;
        if (dto.getStartTime() == null || dto.getEndTime() == null) {
            return;
        }
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int regWorkStart = 0;
        int regWorkEnd = 0;
        boolean isWorkOnDayOff = false;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(false);
        if (workOnHolidayRequestDto != null && (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workOnHolidayRequestDto.getWorkflow())) != null && (this.workflowIntegrate.isApprovable(workflowDto) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) && workOnHolidayRequestDto.getSubstitute() == 2) {
            isWorkOnDayOff = true;
            regWorkStart = this.getDefferenceMinutes(dto.getWorkDate(), dto.getStartTime());
            regWorkEnd = this.getDefferenceMinutes(dto.getWorkDate(), dto.getEndTime());
        }
        boolean isDifferenceWork = false;
        DifferenceRequestDtoInterface differenceDto = this.requestUtil.getDifferenceDto(true);
        if (differenceDto != null) {
            isDifferenceWork = true;
            regWorkStart = this.getDefferenceMinutes(dto.getWorkDate(), differenceDto.getRequestStart());
            regWorkEnd = this.getDefferenceMinutes(dto.getWorkDate(), differenceDto.getRequestEnd());
        }
        if (!isWorkOnDayOff && !isDifferenceWork) {
            WorkTypeItemDtoInterface workStartDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkStart");
            WorkTypeItemDtoInterface workEndDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkEnd");
            if (workStartDto == null || workEndDto == null) {
                this.addWorkTypeNotExistErrorMessage(dto.getWorkDate());
                return;
            }
            regWorkStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), workStartDto.getWorkTypeItemValue());
            regWorkEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), workEndDto.getWorkTypeItemValue());
        }
        if ((workStart = this.getDefferenceMinutes(dto.getWorkDate(), dto.getStartTime())) < regWorkStart) {
            workStart = regWorkStart;
        }
        if ((workEnd = this.getDefferenceMinutes(dto.getWorkDate(), dto.getEndTime())) > regWorkEnd) {
            workEnd = regWorkEnd;
        }
        TreeMap<Integer, Integer> restMap = new TreeMap<Integer, Integer>();
        for (RestDtoInterface restDto : restList) {
            int start2 = this.getDefferenceMinutes(dto.getWorkDate(), restDto.getRestStart());
            int end3 = this.getDefferenceMinutes(dto.getWorkDate(), restDto.getRestEnd());
            if (start2 >= regWorkEnd || end3 <= regWorkStart) continue;
            if (start2 < workStart) {
                start2 = workStart;
            }
            if (end3 > workEnd) {
                end3 = workEnd;
            }
            if (restMap.containsKey(start2) && (Integer)restMap.get(start2) >= end3) continue;
            restMap.put(start2, end3);
        }
        TreeMap<Integer, GoOutDtoInterface> privateMap = new TreeMap<Integer, GoOutDtoInterface>();
        for (GoOutDtoInterface privateDto : privateList) {
            GoOutDtoInterface goOutDto;
            int start3 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutStart());
            int end4 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
            if (start3 >= regWorkEnd || end4 <= regWorkStart) continue;
            if (start3 < workStart) {
                start3 = workStart;
            }
            if (end4 > workEnd) {
                end4 = workEnd;
            }
            if ((goOutDto = (GoOutDtoInterface)privateMap.get(start3)) == null) {
                privateMap.put(start3, privateDto);
                continue;
            }
            int goOutEnd = this.getDefferenceMinutes(dto.getWorkDate(), goOutDto.getGoOutEnd());
            if (goOutEnd > workEnd) {
                goOutEnd = workEnd;
            }
            if (goOutEnd >= end4) continue;
            privateMap.put(start3, privateDto);
        }
        int limitTime = this.getDefferenceMinutes(this.getDefaultStandardDate(), this.timeSettingDto.getLateEarlyHalf());
        int holidayRange = this.requestUtil.checkHolidayRangeHoliday(this.requestUtil.getHolidayList(false));
        int subHolidayRange = this.requestUtil.checkHolidayRangeSubHoliday(this.requestUtil.getSubHolidayList(false));
        if (holidayRange != 2 && subHolidayRange != 2 && dto.getLateTime() <= limitTime) {
            time = workStart;
            int privateTime = dto.getLateTime();
            while (privateTime <= limitTime) {
                count = 0;
                for (Map.Entry entry : privateMap.entrySet()) {
                    GoOutDtoInterface privateDto = (GoOutDtoInterface)entry.getValue();
                    start = (Integer)entry.getKey();
                    end2 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
                    if (end2 > workEnd) {
                        end2 = workEnd;
                    }
                    if (start != time || end2 <= time) continue;
                    privateTime += privateDto.getGoOutTime();
                    time = end2;
                    ++count;
                }
                for (Map.Entry entry : restMap.entrySet()) {
                    int start4 = (Integer)entry.getKey();
                    end = (Integer)entry.getValue();
                    if (start4 != time || end <= time) continue;
                    time = end;
                    ++count;
                }
                if (count != 0) continue;
                break;
            }
            if (privateTime > limitTime) {
                this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("PrivateGoingOut"), this.mospParams.getName("Tardiness"), this.mospParams.getName("AmRest")});
                return;
            }
        }
        if (holidayRange != 3 && subHolidayRange != 3 && dto.getLeaveEarlyTime() <= limitTime) {
            time = workEnd;
            int privateTime = dto.getLeaveEarlyTime();
            while (privateTime <= limitTime) {
                count = 0;
                for (Map.Entry entry : privateMap.entrySet()) {
                    GoOutDtoInterface privateDto = (GoOutDtoInterface)entry.getValue();
                    start = (Integer)entry.getKey();
                    end2 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
                    if (end2 > workEnd) {
                        end2 = workEnd;
                    }
                    if (end2 != time || start >= time) continue;
                    privateTime += privateDto.getGoOutTime();
                    time = start;
                    ++count;
                }
                for (Map.Entry entry : restMap.entrySet()) {
                    int start5 = (Integer)entry.getKey();
                    end = (Integer)entry.getValue();
                    if (end != time || start5 >= time) continue;
                    time = start5;
                    ++count;
                }
                if (count != 0) continue;
                break;
            }
            if (privateTime > limitTime) {
                this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("PrivateGoingOut"), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("PmRest")});
            }
        }
    }

    public void checkTemporaryClosingFinal(AttendanceDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getWorkDate(), this.getNameWorkDate());
    }

    public void checkApprover(AttendanceDtoInterface dto, WorkflowDtoInterface workDto) throws MospException {
        String[] arrayApproverId;
        String approverId = workDto.getApproverId();
        if ("SELF_APPRO".equals(approverId)) {
            return;
        }
        for (String element : arrayApproverId = approverId.split(",")) {
            if (element.isEmpty()) {
                if (0 < arrayApproverId.length) continue;
                this.mospParams.addErrorMessage("PFW0227", new String[]{this.mospParams.getName("Approver"), this.getNameWorkDate()});
                continue;
            }
            if (!this.isEntered(element, dto.getWorkDate())) {
                this.mospParams.addErrorMessage("PFW0227", new String[]{this.mospParams.getName("Approver"), this.getNameWorkDate()});
            }
            if (!this.retirementReference.isRetired(element, dto.getWorkDate())) continue;
            this.mospParams.addErrorMessage("PFW0227", new String[]{this.mospParams.getName("Approver"), this.getNameWorkDate()});
        }
    }

    protected void checkTomorrowAttendance(AttendanceDtoInterface dto) throws MospException {
        RequestUtilBeanInterface tomorrowRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        tomorrowRequestUtil.setRequests(dto.getPersonalId(), this.addDay(dto.getWorkDate(), 1));
        AttendanceDtoInterface tomorrowDto = tomorrowRequestUtil.getApplicatedAttendance();
        if (tomorrowDto == null || tomorrowDto.getStartTime() == null) {
            return;
        }
        if (tomorrowDto.getStartTime().before(dto.getEndTime())) {
            this.mospParams.addErrorMessage("TMW0286", new String[]{this.getStringDate(dto.getWorkDate())});
        }
    }

    protected void checkSubHoliday(AttendanceDtoInterface dto, String operationName) throws MospException {
        List legalList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 2);
        if (this.isAppliSubHoliday(legalList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
        List prescribedList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 1);
        if (this.isAppliSubHoliday(prescribedList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
        List nightList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 3);
        if (this.isAppliSubHoliday(nightList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
    }

    int getSubstituteRange(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        List substituteDtoList = this.requestUtil.getSubstituteList(false);
        int substituteRange = this.requestUtil.checkHolidayRangeSubstitute(substituteDtoList);
        int workOnHolidayRange = 0;
        WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (workOnHolidayDto != null && WorkflowUtility.isApplied((WorkflowDtoInterface)(workflowDto = this.workflowReference.getLatestWorkflowInfo(workOnHolidayDto.getWorkflow()))) && !WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) {
            if (workOnHolidayDto.getSubstitute() == 3) {
                workOnHolidayRange = 2;
            } else if (workOnHolidayDto.getSubstitute() == 4) {
                workOnHolidayRange = 3;
            }
        }
        return substituteRange -= workOnHolidayRange;
    }

    protected boolean isAppliSubHoliday(List<SubHolidayRequestDtoInterface> list) throws MospException {
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : list) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    protected void addSubHolidayRequestedErrorMessage(String operationName) {
        this.mospParams.addErrorMessage("TMW0316", new String[]{this.mospParams.getName("CompensatoryHoliday"), operationName});
    }

    public void delete(String personalId, Date workDate) throws MospException {
        AttendanceDtoInterface dto = this.dao.findForKey(personalId, workDate, 1);
        if (dto == null) {
            return;
        }
        this.workflowRegist.delete(this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow()));
        this.workflowCommentRegist.deleteList(this.workflowCommentReference.getWorkflowCommentList(dto.getWorkflow()));
        this.restRegist.delete(personalId, workDate, 1);
        this.goOutRegist.delete(personalId, workDate, 1);
        this.attendanceCorrectionRegist.delete(personalId, workDate, 1);
        this.delete(dto);
        this.subHolidayRegist.delete(personalId, workDate);
    }

    public void delete(AttendanceDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
    }

    protected String getNameWorkDate() {
        return this.mospParams.getName("Work", new String[]{"Day"});
    }

    protected String getNameStartTimeForWork() {
        return this.mospParams.getName("StartWork", new String[]{"Moment"});
    }

    protected String getNameEndTimeForWork() {
        return this.mospParams.getName("EndWork", new String[]{"Moment"});
    }

    protected void getArdinessTardinessLimitOver(Date workDate) {
        this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(workDate), this.mospParams.getName("Tardiness"), this.mospParams.getName("Tardiness"), this.mospParams.getName("AmRest")});
    }

    protected void getLeaveEarlyLimitOver(Date workDate) {
        this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(workDate), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("PmRest")});
    }
}

