/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceTransactionDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceTransactionDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtAttendanceDto;

public class AttendanceTransactionRegistBean
extends TimeBean
implements AttendanceTransactionRegistBeanInterface {
    protected AttendanceTransactionDaoInterface dao;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected PaidHolidayReferenceBeanInterface paidHolidayReference;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected HolidayReferenceBeanInterface holidayReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;

    public AttendanceTransactionRegistBean() {
    }

    public AttendanceTransactionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (AttendanceTransactionDaoInterface)this.createDao(AttendanceTransactionDaoInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.paidHolidayReference = (PaidHolidayReferenceBeanInterface)this.createBean(PaidHolidayReferenceBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.holidayReference = (HolidayReferenceBeanInterface)this.createBean(HolidayReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public void regist(String personalId, Date workDate) throws MospException {
        this.regist(personalId, workDate, true);
    }

    public void regist(AttendanceDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getWorkDate(), dto.getWorkflow());
    }

    public void regist(HolidayRequestDtoInterface dto) throws MospException {
        Date date = dto.getRequestStartDate();
        while (!date.after(dto.getRequestEndDate())) {
            this.regist(dto.getPersonalId(), date, dto.getWorkflow());
            date = this.addDay(date, 1);
        }
    }

    public void regist(SubHolidayRequestDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getRequestDate(), dto.getWorkflow());
    }

    public void regist(SubstituteDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getSubstituteDate(), dto.getWorkflow());
    }

    protected void regist(String personalId, Date workDate, long workflow) throws MospException {
        if (this.workflowIntegrate.isCompleted(workflow)) {
            this.regist(personalId, workDate);
        }
    }

    protected void regist(String personalId, Date workDate, boolean isUpdate) throws MospException {
        AttendanceTransactionDtoInterface dto = this.dao.findForKey(personalId, workDate);
        if (dto == null) {
            dto = new TmtAttendanceDto();
            this.setDtoFields(dto, personalId, workDate);
            this.insert(dto);
            return;
        }
        if (isUpdate) {
            this.setDtoFields(dto);
            this.update(dto);
        }
    }

    public void regist(String personalId, Date firstDate, Date lastDate, boolean isUpdate) throws MospException {
        Date date = firstDate;
        while (!date.after(lastDate)) {
            this.regist(personalId, date, isUpdate);
            date = this.addDay(date, 1);
        }
    }

    protected void setDtoFields(AttendanceTransactionDtoInterface dto, String personalId, Date workDate) throws MospException {
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        this.setDtoFields(dto);
    }

    protected void setDtoFields(AttendanceTransactionDtoInterface dto) throws MospException {
        dto.setAttendanceType("");
        dto.setNumerator(0);
        dto.setDenominator(0);
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getWorkDate())) {
            dto.setAttendanceType("suspension");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return;
        }
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getWorkDate())) {
            dto.setAttendanceType("retirement");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return;
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        AttendanceDtoInterface attendanceDto = requestUtil.getApplicatedAttendance();
        if (attendanceDto != null && this.workflowIntegrate.isCompleted(attendanceDto.getWorkflow())) {
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
            if (workOnHolidayRequestDto == null) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return;
            }
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return;
            }
            if (substitute == 2) {
                PaidHolidayDtoInterface paidHolidayDto;
                ApplicationDtoInterface applicationDto;
                String attendanceType = "";
                if ("legal_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                    attendanceType = "work_on_legal";
                } else if ("prescribed_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                    attendanceType = "work_on_prescribed";
                }
                if (!attendanceType.isEmpty() && (applicationDto = this.applicationReference.findForPerson(dto.getPersonalId(), dto.getWorkDate())) != null && (paidHolidayDto = this.paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), dto.getWorkDate())) != null) {
                    int workOnHolidayCalc = paidHolidayDto.getWorkOnHolidayCalc();
                    if (workOnHolidayCalc == 1) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(1);
                        dto.setDenominator(1);
                        return;
                    }
                    if (workOnHolidayCalc == 2) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(0);
                        dto.setDenominator(1);
                        return;
                    }
                    if (workOnHolidayCalc == 3) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(0);
                        dto.setDenominator(0);
                        return;
                    }
                }
            } else if (substitute == 3 || substitute == 4) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return;
            }
            dto.setAttendanceType("attendance");
            dto.setNumerator(1);
            dto.setDenominator(1);
            return;
        }
        int substituteRange = requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true));
        if (substituteRange == 1 || substituteRange == 5) {
            dto.setAttendanceType("substitute");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return;
        }
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true));
        if (subHolidayRange == 1 || subHolidayRange == 2 || subHolidayRange == 3 || subHolidayRange == 5) {
            dto.setAttendanceType("sub_holiday");
            dto.setNumerator(1);
            dto.setDenominator(1);
            return;
        }
        String workTypeCode = this.getScheduledWorkTypeCode(dto);
        Integer amHoliday = null;
        Integer pmHoliday = null;
        List holidayList = requestUtil.getHolidayList(true);
        for (HolidayRequestDtoInterface holidayRequestDto : holidayList) {
            boolean isPm;
            boolean isAll = holidayRequestDto.getHolidayRange() == 1;
            boolean isAm = holidayRequestDto.getHolidayRange() == 2;
            boolean bl = isPm = holidayRequestDto.getHolidayRange() == 3;
            if (holidayRequestDto.getHolidayType1() == 1) {
                if (Integer.toString(1).equals(holidayRequestDto.getHolidayType2())) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(1);
                    dto.setDenominator(1);
                    return;
                }
                if (!Integer.toString(2).equals(holidayRequestDto.getHolidayType2())) continue;
                int stockHolidayAttendance = this.mospParams.getApplicationProperty("StockHolidayAttendance", 1);
                if (stockHolidayAttendance == 1) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(1);
                    dto.setDenominator(1);
                    return;
                }
                if (isAll) {
                    dto.setAttendanceType("holiday");
                    if (stockHolidayAttendance == 2) {
                        dto.setNumerator(0);
                        dto.setDenominator(1);
                        return;
                    }
                    if (stockHolidayAttendance != 3) continue;
                    dto.setNumerator(0);
                    dto.setDenominator(0);
                    return;
                }
                if (holidayRequestDto.getHolidayRange() == 2) {
                    amHoliday = stockHolidayAttendance;
                    continue;
                }
                if (holidayRequestDto.getHolidayRange() != 3) continue;
                pmHoliday = stockHolidayAttendance;
                continue;
            }
            if (holidayRequestDto.getHolidayType1() != 2 && holidayRequestDto.getHolidayType1() != 3 && holidayRequestDto.getHolidayType1() != 4) continue;
            if (workTypeCode.isEmpty() || "legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
                dto.setAttendanceType(workTypeCode);
                dto.setNumerator(0);
                dto.setDenominator(0);
                return;
            }
            HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(holidayRequestDto.getHolidayType2(), holidayRequestDto.getRequestStartDate(), holidayRequestDto.getHolidayType1());
            if (holidayDto == null) continue;
            if (holidayDto.getPaidHolidayCalc() == 1) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return;
            }
            if (holidayDto.getPaidHolidayCalc() == 2) {
                if (isAll) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(0);
                    dto.setDenominator(1);
                    return;
                }
                if (isAm) {
                    amHoliday = 2;
                }
                if (!isPm) continue;
                pmHoliday = 2;
                continue;
            }
            if (holidayDto.getPaidHolidayCalc() != 3) continue;
            if (isAll) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(0);
                return;
            }
            if (isAm && amHoliday == null) {
                amHoliday = 3;
            }
            if (!isPm || pmHoliday != null) continue;
            pmHoliday = 3;
        }
        if (requestUtil.isHolidayAllDay(true)) {
            if (amHoliday != null && amHoliday == 2 || pmHoliday != null && pmHoliday == 2) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(1);
                return;
            }
            if (amHoliday != null && amHoliday == 3 || pmHoliday != null && pmHoliday == 3) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(0);
                return;
            }
        }
        if (workTypeCode.isEmpty() || "legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            dto.setAttendanceType(workTypeCode);
            dto.setNumerator(0);
            dto.setDenominator(0);
            return;
        }
        dto.setAttendanceType("attendance");
        dto.setNumerator(0);
        dto.setDenominator(1);
    }

    public void regist(String personalId, Map<Date, String> attendanceMap) throws MospException {
        for (Map.Entry<Date, String> entry : attendanceMap.entrySet()) {
            Date workDate = entry.getKey();
            String attendanceType = entry.getValue();
            TmtAttendanceDto dto = new TmtAttendanceDto();
            dto.setPersonalId(personalId);
            dto.setWorkDate(workDate);
            dto.setAttendanceType(attendanceType);
            dto.setNumerator(0);
            dto.setDenominator(0);
            AttendanceTransactionDtoInterface formerDto = this.dao.findForKey(personalId, workDate);
            if (formerDto != null) {
                this.logicalDelete((BaseDaoInterface)this.dao, formerDto.getTmtAttendanceId());
            }
            this.insert((AttendanceTransactionDtoInterface)dto);
        }
    }

    protected void insert(AttendanceTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmtAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(AttendanceTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtAttendanceId());
        dto.setTmtAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void validate(AttendanceTransactionDtoInterface dto) {
    }

    protected void checkInsert(AttendanceTransactionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate()));
    }

    protected void checkUpdate(AttendanceTransactionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtAttendanceId());
    }

    protected String getScheduledWorkTypeCode(AttendanceTransactionDtoInterface dto) throws MospException {
        return this.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getWorkDate());
    }

    protected String getScheduledWorkTypeCode(String personalId, Date date) throws MospException {
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, date);
        if (applicationDto == null) {
            return "";
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), date);
        if (scheduleDto == null) {
            return "";
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), date);
        if (scheduleDateDto == null || scheduleDateDto.getWorkTypeCode() == null) {
            return "";
        }
        if (scheduleDateDto.getWorkTypeCode().isEmpty() || "legal_holiday".equals(scheduleDateDto.getWorkTypeCode()) || "prescribed_holiday".equals(scheduleDateDto.getWorkTypeCode())) {
            return scheduleDateDto.getWorkTypeCode();
        }
        WorkTypeDtoInterface workTypeDto = this.workTypeReference.findForInfo(scheduleDateDto.getWorkTypeCode(), date);
        if (workTypeDto == null || workTypeDto.getWorkTypeCode() == null) {
            return "";
        }
        return workTypeDto.getWorkTypeCode();
    }
}

