/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.CutoffRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmCutoffDto;

public class CutoffRegistBean
extends PlatformBean
implements CutoffRegistBeanInterface {
    CutoffDaoInterface dao;
    TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeetransactionReference;

    public CutoffRegistBean() {
    }

    public CutoffRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (CutoffDaoInterface)this.createDao(CutoffDaoInterface.class);
        this.totalTimeEmployeetransactionReference = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
    }

    public CutoffDtoInterface getInitDto() {
        return new TmmCutoffDto();
    }

    public void insert(CutoffDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmCutoffId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(CutoffDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmCutoffId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(CutoffDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmCutoffId());
        dto.setTmmCutoffId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            CutoffDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmCutoffId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmCutoffId());
            dto.setTmmCutoffId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((CutoffDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(CutoffDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getCutoffCode()));
    }

    protected void checkAdd(CutoffDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getCutoffCode(), dto.getActivateDate()));
        List list = this.dao.findForHistory(dto.getCutoffCode());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List timeSettingList = this.getTimeSettingListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getCutoffCode(), timeSettingList);
    }

    protected void checkUpdate(CutoffDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmCutoffId());
        List list = this.dao.findForHistory(dto.getCutoffCode());
        this.checkChangeCutoffUpdate(dto, list);
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmCutoffId(), true))) {
            return;
        }
        List timeSettingList = this.getTimeSettingListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getCutoffCode(), timeSettingList);
    }

    protected void checkDelete(CutoffDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmCutoffId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getCutoffCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List timeSettingList = this.getTimeSettingListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getCutoffCode(), timeSettingList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            CutoffDtoInterface dto = (CutoffDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getCutoffCode());
        }
        return list;
    }

    protected void checkChangeCutoffUpdate(CutoffDtoInterface dto, List<CutoffDtoInterface> list) throws MospException {
        List totalList;
        CutoffDtoInterface nextCutoffDto;
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getTmmCutoffId() != dto.getTmmCutoffId()) continue;
            index = i;
            break;
        }
        Date endDate = null;
        CutoffDtoInterface targetCutoffDto = list.get(index);
        if (targetCutoffDto.getCutoffDate() == dto.getCutoffDate() && targetCutoffDto.getInactivateFlag() == dto.getInactivateFlag()) {
            return;
        }
        if (list.size() - 1 != index && (nextCutoffDto = list.get(index + 1)) != null) {
            endDate = nextCutoffDto.getActivateDate();
        }
        if ((totalList = this.totalTimeEmployeetransactionReference.isCutoffTermState(dto.getCutoffCode(), targetCutoffDto.getActivateDate(), endDate)).isEmpty()) {
            return;
        }
        for (TotalTimeEmployeeDtoInterface totalDto : totalList) {
            String year = String.valueOf(totalDto.getCalculationYear());
            String month = String.valueOf(totalDto.getCalculationMonth());
            if (totalDto.getCutoffState() == 1) {
                this.mospParams.addErrorMessage("TMW0223", new String[]{year, month});
                break;
            }
            if (totalDto.getCutoffState() != 2) continue;
            this.mospParams.addErrorMessage("TMW0223", new String[]{year, month});
            break;
        }
    }

    protected void validate(CutoffDtoInterface dto) {
    }

    protected void checkCodeIsUsed(String code, List<TimeSettingDtoInterface> list) {
        String codeAdded = "";
        for (TimeSettingDtoInterface dto : list) {
            if (!code.equals(dto.getCutoffCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getWorkSettingCode())) continue;
            this.addCutoffCodeIsUsedMessage(code, dto);
            codeAdded = dto.getWorkSettingCode();
        }
    }

    protected List<TimeSettingDtoInterface> getTimeSettingListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        TimeSettingDaoInterface timeSettingDao = (TimeSettingDaoInterface)this.createDao(TimeSettingDaoInterface.class);
        List timeSettingList = timeSettingDao.findForActivateDate(dto.getActivateDate());
        timeSettingList.addAll(timeSettingDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return timeSettingList;
    }

    protected void addCutoffCodeIsUsedMessage(String code, TimeSettingDtoInterface dto) {
        this.mospParams.addErrorMessage("TMW0224", new String[]{code, dto.getWorkSettingCode()});
    }
}

