/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.dao.settings.GoOutDaoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdGoOutDto;

public class GoOutRegistBean
extends PlatformBean
implements GoOutRegistBeanInterface {
    protected AttendanceCalcBeanInterface attendanceCalc;
    GoOutDaoInterface dao;

    public GoOutRegistBean() {
    }

    public GoOutRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.attendanceCalc = (AttendanceCalcBeanInterface)this.createBean(AttendanceCalcBeanInterface.class);
        this.dao = (GoOutDaoInterface)this.createDao(GoOutDaoInterface.class);
    }

    public GoOutDtoInterface getInitDto() {
        return new TmdGoOutDto();
    }

    public void regist(GoOutDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getGoOutType(), dto.getTimesGoOut()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void insert(GoOutDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdGoOutId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(GoOutDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
        dto.setTmdGoOutId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(GoOutDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getGoOutType(), dto.getTimesGoOut(), dto.getGoOutStart(), dto.getGoOutEnd()));
    }

    protected void checkUpdate(GoOutDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    protected void validate(GoOutDtoInterface dto) {
    }

    public void delete(String personalId, Date workDate, int timesWork) throws MospException {
        List list = this.dao.findForList(personalId, workDate, timesWork);
        for (GoOutDtoInterface dto : list) {
            this.checkDelete((GoOutDtoInterface)this.dao.findForKey(dto.getTmdGoOutId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
        }
    }

    protected void checkDelete(GoOutDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    public void delete(String personalId, Date workDate, int timesWork, int goOutType, int timesGoOut) throws MospException {
        GoOutDtoInterface dto = this.dao.findForKey(personalId, workDate, timesWork, goOutType, timesGoOut);
        this.checkDelete((GoOutDtoInterface)this.dao.findForKey(dto.getTmdGoOutId(), true));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdGoOutId());
    }

    public int getCalcPrivateGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        Date roundGoOutStart = this.attendanceCalc.getRoundMinute(goOutStart, timeSettingDto.getRoundDailyPrivateStart(), timeSettingDto.getRoundDailyPrivateStartUnit());
        Date roundGoOutEnd = this.attendanceCalc.getRoundMinute(goOutEnd, timeSettingDto.getRoundDailyPrivateEnd(), timeSettingDto.getRoundDailyPrivateEndUnit());
        return this.attendanceCalc.getDefferenceMinutes(roundGoOutStart, roundGoOutEnd);
    }

    public int getCalcPublicGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        Date roundGoOutStart = this.attendanceCalc.getRoundMinute(goOutStart, timeSettingDto.getRoundDailyPublicStart(), timeSettingDto.getRoundDailyPublicStartUnit());
        Date roundGoOutEnd = this.attendanceCalc.getRoundMinute(goOutEnd, timeSettingDto.getRoundDailyPublicEnd(), timeSettingDto.getRoundDailyPublicEndUnit());
        return this.attendanceCalc.getDefferenceMinutes(roundGoOutStart, roundGoOutEnd);
    }

    public int getCalcMinutelyHolidayAGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        return this.attendanceCalc.getDefferenceMinutes(goOutStart, goOutEnd);
    }

    public int getCalcMinutelyHolidayBGoOutTime(Date goOutStart, Date goOutEnd, TimeSettingDtoInterface timeSettingDto) {
        if (goOutStart == null || goOutEnd == null || timeSettingDto == null) {
            return 0;
        }
        return this.attendanceCalc.getDefferenceMinutes(goOutStart, goOutEnd);
    }
}

