/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayDataRegistBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayDataDto;

public class HolidayDataRegistBean
extends PlatformBean
implements HolidayDataRegistBeanInterface {
    HolidayDataDaoInterface dao;
    HolidayRequestReferenceBeanInterface holidayRequest;
    HolidayReferenceBeanInterface holiday;
    HumanReferenceBeanInterface humanReference;

    public HolidayDataRegistBean() {
    }

    public HolidayDataRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.holiday = (HolidayReferenceBeanInterface)this.createBean(HolidayReferenceBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
    }

    public HolidayDataDtoInterface getInitDto() {
        return new TmdHolidayDataDto();
    }

    public void insert(HolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkRegister(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        this.checkRegister(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayId());
        dto.setTmdHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(HolidayDataDtoInterface dto) throws MospException {
        HolidayDataDtoInterface holidayDataDto = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode(), dto.getHolidayType());
        if (holidayDataDto != null) {
            HumanDtoInterface humanDto = this.humanReference.getHumanInfo(dto.getPersonalId(), dto.getActivateDate());
            HolidayDtoInterface holidayDto = this.holiday.getHolidayInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            this.mospParams.addErrorMessage("TMW0339", new String[]{holidayDto.getHolidayName(), humanDto.getEmployeeCode()});
        }
    }

    protected void checkUpdate(HolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmdHolidayId(), true))) {
            return;
        }
        Map map = this.holidayRequest.getRequestDayHour(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayType(), dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayLimitDate());
        if (dto.getGivingDay() - dto.getCancelDay() < (Double)map.get("requestDay")) {
            String[] aryMeassage = new String[]{this.mospParams.getName("Giving", new String[]{"Days"})};
            this.mospParams.addMessage("TMW0271", aryMeassage);
        }
    }

    protected void validate(HolidayDataDtoInterface dto) {
    }

    protected void checkRegister(HolidayDataDtoInterface dto) throws MospException {
        HolidayDtoInterface holidayDto = this.holiday.getHolidayInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
        if (null != holidayDto) {
            this.checkHolidayLimit(dto, holidayDto.getNoLimit());
        }
    }

    protected void checkGivingDay(HolidayDataDtoInterface dto, int noLinit) {
        if (0 == noLinit && 0 == Double.compare(dto.getGivingDay(), 0.0)) {
            String mes1 = this.mospParams.getName("Giving", new String[]{"Days"});
            String mes2 = mes1 + this.mospParams.getName("Is", new String[]{"No0", "Dot", "No5", "Over"});
            this.mospParams.addErrorMessage("TMW0270", new String[]{mes1, mes2});
        }
    }

    protected void checkHolidayLimit(HolidayDataDtoInterface dto, int noLinit) {
        if (0 == noLinit && 0 == dto.getHolidayLimitDay() && 0 == dto.getHolidayLimitMonth()) {
            String mes1 = this.mospParams.getName("Acquisition", new String[]{"TimeLimit"});
            String mes2 = mes1 + this.mospParams.getName("Is", new String[]{"No1", "Day", "Over"});
            this.mospParams.addErrorMessage("TMW0270", new String[]{mes1, mes2});
        }
    }
}

