/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.HolidayExportBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class HolidayExportBean
extends PlatformBean
implements HolidayExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected HolidayDaoInterface holidayDao;
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected SubstituteDaoInterface substituteDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected TimeSettingReferenceBeanInterface timeSettingReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface sectionReference;
    protected List<HumanDtoInterface> humanList;
    private int ckbNeedLowerSection = 0;

    public HolidayExportBean() {
    }

    public HolidayExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
    }

    public void export(String exportCode, int startYear, int startMonth, int endYear, int endMonth, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, int ckbNeedLowerSection, String positionCode) throws MospException {
        Date endDate;
        this.ckbNeedLowerSection = ckbNeedLowerSection;
        ExportDtoInterface dto = this.exportDao.findForKey(exportCode);
        if (dto == null) {
            this.addNoExportDataMessage();
            return;
        }
        CutoffDtoInterface cutoffDto = this.cutoffUtil.getCutoff(cutoffCode, startYear, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date startDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)startYear, (int)startMonth);
        List list = this.getCsvDataList(dto, startDate, endDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)endYear, (int)endMonth), cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (list.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)list));
        this.setFileName(dto, startDate, endDate);
    }

    protected List<String[]> getCsvDataList(ExportDtoInterface dto, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List fieldList = this.exportFieldDao.findForList(dto.getExportCode());
        this.addHumanData(list, fieldList, startDate, endDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addPaidHolidayData(list, fieldList, startDate, endDate);
        this.addStockHolidayData(list, fieldList, startDate, endDate);
        this.addSubHolidayData(list, fieldList, startDate, endDate);
        this.addSubstituteHolidayData(list, fieldList, startDate, endDate);
        this.addHolidayData(list, fieldList, startDate, endDate);
        if (dto.getHeader() != 0) {
            this.addHeader(list, fieldList, endDate);
        }
        return list;
    }

    protected void addHeader(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate) throws MospException {
        String[] header = new String[fieldList.size()];
        for (int i = 0; i < header.length; ++i) {
            header[i] = this.getHeader(fieldList.get(i).getFieldName(), targetDate);
        }
        csvDataList.add(0, header);
    }

    protected void addHumanData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setStartDate(startDate);
        this.humanSearch.setEndDate(endDate);
        this.humanSearch.setTargetDate(endDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("presence");
        if (this.ckbNeedLowerSection == 1) {
            this.humanSearch.setNeedLowerSection(true);
        } else {
            this.humanSearch.setNeedLowerSection(false);
        }
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        List presenceHumanList = this.humanSearch.search();
        this.humanSearch.setStateType("suspend");
        List suspendHumanList = this.humanSearch.search();
        ArrayList allHumanList = new ArrayList();
        allHumanList.addAll(presenceHumanList);
        allHumanList.addAll(suspendHumanList);
        this.humanList = new ArrayList();
        if (cutoffCode.isEmpty()) {
            this.humanList = allHumanList;
        } else {
            for (HumanDtoInterface humanDto : allHumanList) {
                TimeSettingDtoInterface timeSettingDto;
                ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(humanDto.getPersonalId(), endDate);
                if (applicationDto == null || (timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), endDate)) == null || !cutoffCode.equals(timeSettingDto.getCutoffCode())) continue;
                this.humanList.add(humanDto);
            }
        }
        for (HumanDtoInterface humanDto : this.humanList) {
            String[] csvData = new String[fieldList.size()];
            for (int i = 0; i < csvData.length; ++i) {
                csvData[i] = this.getHumanData(humanDto, fieldList.get(i).getFieldName(), endDate);
            }
            csvDataList.add(csvData);
        }
    }

    protected void addPaidHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        Integer paidHolidayAllIndex = null;
        Integer paidHolidayHalfIndex = null;
        Integer paidHolidayTimeIndex = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            int index = dto.getFieldOrder() - 1;
            if ("paid_holiday_all".equals(dto.getFieldName())) {
                paidHolidayAllIndex = index;
                continue;
            }
            if ("paid_holiday_half".equals(dto.getFieldName())) {
                paidHolidayHalfIndex = index;
                continue;
            }
            if (!"paid_holiday_time".equals(dto.getFieldName())) continue;
            paidHolidayTimeIndex = index;
        }
        if (paidHolidayAllIndex == null && paidHolidayHalfIndex == null && paidHolidayTimeIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            int paidHolidayAll = 0;
            int paidHolidayHalf = 0;
            int paidHolidayTime = 0;
            List list = this.holidayRequestDao.findForTerm(((HumanDtoInterface)this.humanList.get(i)).getPersonalId(), startDate, endDate, 1, Integer.toString(1));
            for (HolidayRequestDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                int range = dto.getHolidayRange();
                if (paidHolidayAllIndex != null && range == 1) {
                    ++paidHolidayAll;
                    continue;
                }
                if (paidHolidayHalfIndex != null && (range == 2 || range == 3)) {
                    ++paidHolidayHalf;
                    continue;
                }
                if (paidHolidayTimeIndex == null || range != 4) continue;
                ++paidHolidayTime;
            }
            String[] csvData = csvDataList.get(i);
            if (paidHolidayAllIndex != null) {
                csvData[paidHolidayAllIndex.intValue()] = Integer.toString(paidHolidayAll);
            }
            if (paidHolidayHalfIndex != null) {
                csvData[paidHolidayHalfIndex.intValue()] = Integer.toString(paidHolidayHalf);
            }
            if (paidHolidayTimeIndex == null) continue;
            csvData[paidHolidayTimeIndex.intValue()] = Integer.toString(paidHolidayTime);
        }
    }

    protected void addStockHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        Integer stockHolidayAllIndex = null;
        Integer stockHolidayHalfIndex = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            int index = dto.getFieldOrder() - 1;
            if ("stock_holiday_all".equals(dto.getFieldName())) {
                stockHolidayAllIndex = index;
                continue;
            }
            if (!"stock_holiday_half".equals(dto.getFieldName())) continue;
            stockHolidayHalfIndex = index;
        }
        if (stockHolidayAllIndex == null && stockHolidayHalfIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            int stockHolidayAll = 0;
            int stockHolidayHalf = 0;
            List list = this.holidayRequestDao.findForTerm(((HumanDtoInterface)this.humanList.get(i)).getPersonalId(), startDate, endDate, 1, Integer.toString(2));
            for (HolidayRequestDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                int range = dto.getHolidayRange();
                if (stockHolidayAllIndex != null && range == 1) {
                    ++stockHolidayAll;
                    continue;
                }
                if (stockHolidayHalfIndex == null || range != 2 && range != 3) continue;
                ++stockHolidayHalf;
            }
            String[] csvData = csvDataList.get(i);
            if (stockHolidayAllIndex != null) {
                csvData[stockHolidayAllIndex.intValue()] = Integer.toString(stockHolidayAll);
            }
            if (stockHolidayHalfIndex == null) continue;
            csvData[stockHolidayHalfIndex.intValue()] = Integer.toString(stockHolidayHalf);
        }
    }

    protected void addSubHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        Integer subHolidayAllIndex = null;
        Integer subHolidayHalfIndex = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            int index = dto.getFieldOrder() - 1;
            if ("sub_holiday_all".equals(dto.getFieldName())) {
                subHolidayAllIndex = index;
                continue;
            }
            if (!"sub_holiday_half".equals(dto.getFieldName())) continue;
            subHolidayHalfIndex = index;
        }
        if (subHolidayAllIndex == null && subHolidayHalfIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            int subHolidayAll = 0;
            int subHolidayHalf = 0;
            List list = this.subHolidayRequestDao.findForTerm(((HumanDtoInterface)this.humanList.get(i)).getPersonalId(), startDate, endDate);
            for (SubHolidayRequestDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                int range = dto.getHolidayRange();
                if (subHolidayAllIndex != null && range == 1) {
                    ++subHolidayAll;
                    continue;
                }
                if (subHolidayHalfIndex == null || range != 2 && range != 3) continue;
                ++subHolidayHalf;
            }
            String[] csvData = csvDataList.get(i);
            if (subHolidayAllIndex != null) {
                csvData[subHolidayAllIndex.intValue()] = Integer.toString(subHolidayAll);
            }
            if (subHolidayHalfIndex == null) continue;
            csvData[subHolidayHalfIndex.intValue()] = Integer.toString(subHolidayHalf);
        }
    }

    protected void addSubstituteHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        Integer substituteHolidayAllIndex = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            if (!"substitute_holiday_all".equals(dto.getFieldName())) continue;
            substituteHolidayAllIndex = dto.getFieldOrder() - 1;
            break;
        }
        if (substituteHolidayAllIndex == null) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            int substituteHolidayAll = 0;
            List list = this.substituteDao.findForTerm(((HumanDtoInterface)this.humanList.get(i)).getPersonalId(), startDate, endDate);
            for (SubstituteDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getSubstituteDate());
                if (workOnHolidayRequestDto == null) {
                    ++substituteHolidayAll;
                    continue;
                }
                if (this.workflowIntegrate.isCompleted(workOnHolidayRequestDto.getWorkflow())) continue;
                ++substituteHolidayAll;
            }
            String[] csvData = csvDataList.get(i);
            csvData[substituteHolidayAllIndex.intValue()] = Integer.toString(substituteHolidayAll);
        }
    }

    protected void addHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        String comma = this.mospParams.getName("Comma");
        StringBuffer special = new StringBuffer();
        special.append(2);
        special.append(comma);
        StringBuffer other = new StringBuffer();
        other.append(3);
        other.append(comma);
        StringBuffer absence = new StringBuffer();
        absence.append(4);
        absence.append(comma);
        HashMap<String, Integer> holidayIndexMap = new HashMap<String, Integer>();
        for (ExportFieldDtoInterface dto : fieldList) {
            if (!dto.getFieldName().startsWith(special.toString()) && !dto.getFieldName().startsWith(other.toString()) && !dto.getFieldName().startsWith(absence.toString())) continue;
            holidayIndexMap.put(dto.getFieldName(), dto.getFieldOrder() - 1);
        }
        if (holidayIndexMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.humanList.size(); ++i) {
            for (Map.Entry entry : holidayIndexMap.entrySet()) {
                int count = 0;
                String[] array = ((String)entry.getKey()).split(comma);
                List list = this.holidayRequestDao.findForTerm(((HumanDtoInterface)this.humanList.get(i)).getPersonalId(), startDate, endDate, Integer.parseInt(array[0]), array[1]);
                for (HolidayRequestDtoInterface dto : list) {
                    if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                    int range = dto.getHolidayRange();
                    if ((!"all".equals(array[2]) || range != 1) && (!"half".equals(array[2]) || range != 2 && range != 3)) continue;
                    Date targetDate = dto.getRequestStartDate();
                    if (dto.getRequestStartDate().before(startDate)) {
                        targetDate = startDate;
                    }
                    Date targetEndDate = dto.getRequestEndDate();
                    if (dto.getRequestEndDate().after(endDate)) {
                        targetEndDate = endDate;
                    }
                    while (!targetDate.after(targetEndDate)) {
                        if (this.canHolidayRequest(dto.getPersonalId(), targetDate)) {
                            ++count;
                        }
                        targetDate = this.addDay(targetDate, 1);
                    }
                }
                String[] csvData = csvDataList.get(i);
                csvData[((Integer)entry.getValue()).intValue()] = Integer.toString(count);
            }
        }
    }

    protected String getHumanData(HumanDtoInterface dto, String fieldName, Date targetDate) throws MospException {
        if ("employee_code".equals(fieldName)) {
            return dto.getEmployeeCode();
        }
        if ("full_name".equals(fieldName)) {
            return MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
        }
        if ("section_name".equals(fieldName)) {
            return this.sectionReference.getSectionName(dto.getSectionCode(), targetDate);
        }
        if ("section_display".equals(fieldName)) {
            return this.sectionReference.getSectionDisplay(dto.getSectionCode(), targetDate);
        }
        return "";
    }

    protected String getHeader(String fieldName, Date targetDate) throws MospException {
        String frontParentheses = this.mospParams.getName("FrontParentheses");
        String backParentheses = this.mospParams.getName("BackParentheses");
        String frontWithCornerParentheses = this.mospParams.getName("FrontWithCornerParentheses");
        String backWithCornerParentheses = this.mospParams.getName("BackWithCornerParentheses");
        String header = this.getCodeName(fieldName, "export_holiday_request_data");
        if (!fieldName.equals(header)) {
            return header;
        }
        String[] array = fieldName.split(this.mospParams.getName("Comma"));
        HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(array[1], targetDate, Integer.parseInt(array[0]));
        if (holidayDto == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(frontWithCornerParentheses);
            sb.append(array[1]);
            sb.append(backWithCornerParentheses);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(holidayDto.getHolidayName());
        if ("all".equals(array[2]) || "half".equals(array[2])) {
            sb.append(frontParentheses);
            if ("all".equals(array[2])) {
                sb.append(this.mospParams.getName("AllTime"));
            } else if ("half".equals(array[2])) {
                sb.append(this.mospParams.getName("HalfTime"));
            }
            sb.append(backParentheses);
        }
        sb.append(frontWithCornerParentheses);
        sb.append(holidayDto.getHolidayCode());
        sb.append(backWithCornerParentheses);
        return sb.toString();
    }

    protected void setFileName(ExportDtoInterface dto, Date startDate, Date endDate) {
        String hyphen = this.mospParams.getName("Hyphen");
        String exportCode = "";
        String fileExtension = "";
        if (dto != null) {
            if (dto.getExportCode() != null) {
                exportCode = dto.getExportCode();
            }
            if ("1".equals(dto.getType())) {
                fileExtension = ".csv";
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(exportCode);
        sb.append(hyphen);
        sb.append(DateUtility.getStringYear((Date)startDate));
        sb.append(DateUtility.getStringMonth((Date)startDate));
        sb.append(DateUtility.getStringDay((Date)startDate));
        sb.append(hyphen);
        sb.append(DateUtility.getStringYear((Date)endDate));
        sb.append(DateUtility.getStringMonth((Date)endDate));
        sb.append(DateUtility.getStringDay((Date)endDate));
        sb.append(fileExtension);
        this.mospParams.setFileName(sb.toString());
    }

    protected boolean canHolidayRequest(String personalId, Date targetDate) throws MospException {
        SubstituteDtoInterface substituteDto;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(personalId, targetDate);
        if (workOnHolidayRequestDto != null && this.workflowIntegrate.isCompleted(workOnHolidayRequestDto.getWorkflow())) {
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1) {
                return true;
            }
            if (substitute == 2) {
                return false;
            }
        }
        if ((substituteDto = this.substituteDao.findForDate(personalId, targetDate)) != null && targetDate.compareTo(substituteDto.getSubstituteDate()) == 0) {
            return false;
        }
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, targetDate);
        this.applicationReference.chkExistApplication(applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
        this.scheduleReference.chkExistSchedule(scheduleDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
        this.scheduleDateReference.chkExistScheduleDate(scheduleDateDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        if ("legal_holiday".equals(scheduleDateDto.getWorkTypeCode()) || "prescribed_holiday".equals(scheduleDateDto.getWorkTypeCode())) {
            return false;
        }
        return this.workTypeReference.findForInfo(scheduleDateDto.getWorkTypeCode(), targetDate) != null;
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

