/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;

public class HolidayInfoReferenceBean
extends TimeBean
implements HolidayInfoReferenceBeanInterface {
    private HolidayDataDaoInterface dao;
    private HolidayDaoInterface holidayDao;
    private HolidayRequestDaoInterface holidayRequestDao;
    private HolidayRequestReferenceBeanInterface holidayRequest;
    private WorkflowIntegrateBeanInterface workflowIntegrate;

    public HolidayInfoReferenceBean() {
    }

    public HolidayInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public List<HolidayDataDtoInterface> getHolidayPossibleRequestListForRequest(String personalId, Date targetDate, int holidayType) throws MospException {
        ArrayList<HolidayDataDtoInterface> list = new ArrayList<HolidayDataDtoInterface>();
        List holidayDataList = this.dao.findForInfoList(personalId, targetDate, String.valueOf(0), holidayType);
        for (HolidayDataDtoInterface dto : holidayDataList) {
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                list.add(dto);
                continue;
            }
            double requestDay = 0.0;
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, dto.getActivateDate(), holidayType, dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                requestDay += holidayRequestDto.getUseDay();
            }
            if (!(dto.getGivingDay() - dto.getCancelDay() - requestDay > 0.0)) continue;
            dto.setCancelDay(dto.getCancelDay() + requestDay);
            list.add(dto);
        }
        return list;
    }

    public List<HolidayDataDtoInterface> getHolidayPossibleRequestList(String personalId, Date targetDate, int holidayType) throws MospException {
        ArrayList<HolidayDataDtoInterface> list = new ArrayList<HolidayDataDtoInterface>();
        List holidayDataList = this.dao.findForInfoList(personalId, targetDate, String.valueOf(0), holidayType);
        for (HolidayDataDtoInterface dto : holidayDataList) {
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                list.add(dto);
                continue;
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, dto.getActivateDate(), holidayType, dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayLimitDate());
            double requestDay = (Double)map.get("requestDay");
            if (!(dto.getGivingDay() - dto.getCancelDay() - requestDay > 0.0)) continue;
            dto.setCancelDay(dto.getCancelDay() + requestDay);
            list.add(dto);
        }
        return list;
    }

    public HolidayDataDtoInterface getHolidayPossibleRequestForRequest(String personalId, Date targetDate, String holidayCode, int holidayType) throws MospException {
        HolidayDataDtoInterface holidayDataDto = null;
        List list = this.dao.findForEarliestList(personalId, targetDate, holidayCode, holidayType);
        for (HolidayDataDtoInterface dto : list) {
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) continue;
            if (holidayDto.getNoLimit() == 1) {
                return dto;
            }
            double requestDay = 0.0;
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, dto.getActivateDate(), holidayType, holidayCode, dto.getActivateDate(), dto.getHolidayLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                requestDay += holidayRequestDto.getUseDay();
            }
            dto.setCancelDay(dto.getCancelDay() + requestDay);
            if (dto.getGivingDay() - dto.getCancelDay() > 0.0) {
                return dto;
            }
            holidayDataDto = dto;
        }
        return holidayDataDto;
    }

    public HolidayDataDtoInterface getHolidayPossibleRequest(String personalId, Date targetDate, String holidayCode, int holidayType) throws MospException {
        List list = this.dao.findForEarliestList(personalId, targetDate, holidayCode, holidayType);
        for (HolidayDataDtoInterface dto : list) {
            HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
            if (holidayDto == null || holidayDto.getInactivateFlag() == 1) {
                return null;
            }
            if (holidayDto.getNoLimit() == 1) {
                return dto;
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, dto.getActivateDate(), holidayType, holidayCode, dto.getActivateDate(), dto.getHolidayLimitDate());
            double requestDay = (Double)map.get("requestDay");
            if (!(dto.getGivingDay() - dto.getCancelDay() - requestDay > 0.0)) continue;
            dto.setCancelDay(dto.getCancelDay() + requestDay);
            return dto;
        }
        return null;
    }

    public boolean hasPersonalApplication(String personalId, Date startDate, Date endDate, int holidayType) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate, holidayType);
        return !list.isEmpty();
    }
}

