/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayManagementSearchBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayManagementListDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayManagementListDto;

public class HolidayManagementSearchBean
extends PlatformBean
implements HolidayManagementSearchBeanInterface {
    private HumanSearchBeanInterface humanSearch;
    private HolidayDataDaoInterface holidayDataDao;
    private HolidayRequestReferenceBeanInterface holidayRequest;
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;

    public HolidayManagementSearchBean() {
    }

    public HolidayManagementSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.holidayDataDao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
    }

    public List<HolidayManagementListDtoInterface> getSearchList(int holidayType) throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        List list = this.humanSearch.search();
        ArrayList<HolidayManagementListDtoInterface> holidayManagementList = new ArrayList<HolidayManagementListDtoInterface>();
        for (HumanDtoInterface dto : list) {
            String personalId = dto.getPersonalId();
            List holidayDataList = this.holidayDataDao.findForInfoList(personalId, this.activateDate, String.valueOf(0), holidayType);
            for (HolidayDataDtoInterface holidayDataDto : holidayDataList) {
                HolidayManagementListDto holidayManagementListDto = new HolidayManagementListDto();
                holidayManagementListDto.setEmployeeCode(dto.getEmployeeCode());
                holidayManagementListDto.setActivateDate(holidayDataDto.getActivateDate());
                holidayManagementListDto.setLastName(dto.getLastName());
                holidayManagementListDto.setFirstName(dto.getFirstName());
                holidayManagementListDto.setSectionCode(dto.getSectionCode());
                holidayManagementListDto.setHolidayCode(holidayDataDto.getHolidayCode());
                Map map = this.holidayRequest.getRequestDayHour(personalId, holidayDataDto.getActivateDate(), holidayType, holidayDataDto.getHolidayCode(), holidayDataDto.getActivateDate(), this.activateDate);
                holidayManagementListDto.setHolidayRemainder(holidayDataDto.getGivingDay() - holidayDataDto.getCancelDay() - (Double)map.get("requestDay"));
                holidayManagementListDto.setHolidayLimit(holidayDataDto.getHolidayLimitDate());
                holidayManagementList.add((HolidayManagementListDtoInterface)holidayManagementListDto);
            }
        }
        return holidayManagementList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }
}

