/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.LimitStandardRegistBeanInterface;
import jp.mosp.time.dao.settings.LimitStandardDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmLimitStandardDto;

public class LimitStandardRegistBean
extends PlatformBean
implements LimitStandardRegistBeanInterface {
    private LimitStandardDaoInterface dao;
    private TimeSettingDaoInterface timeSettingdao;
    public static final String ONE_WEEK = "week1";
    public static final String TWO_WEEK = "week2";
    public static final String FOUR_WEEK = "week4";
    public static final String ONE_MONTH = "month1";
    public static final String TWO_MONTH = "month2";
    public static final String THREE_MONTH = "month3";
    public static final String ONE_YEAR = "year1";

    public LimitStandardRegistBean() {
    }

    public LimitStandardRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (LimitStandardDaoInterface)this.createDao(LimitStandardDaoInterface.class);
        this.timeSettingdao = (TimeSettingDaoInterface)this.createDao(TimeSettingDaoInterface.class);
    }

    public LimitStandardDtoInterface getInitDto() {
        return new TmmLimitStandardDto();
    }

    public void insert(LimitStandardDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmLimitStandardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(LimitStandardDtoInterface dto) throws MospException {
        LimitStandardDtoInterface preDto = this.dao.findForInfo(dto.getWorkSettingCode(), dto.getActivateDate(), dto.getTerm());
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (preDto != null) {
            dto.setTmmLimitStandardId(this.getRecordID(dto));
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
        }
        dto.setTmmLimitStandardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        String[] termArray = new String[]{ONE_WEEK, TWO_WEEK, FOUR_WEEK, ONE_MONTH, TWO_MONTH, THREE_MONTH, ONE_YEAR};
        for (String code : this.getCodeList(idArray)) {
            for (String element : termArray) {
                LimitStandardDtoInterface dto = this.dao.findForKey(code, activateDate, element);
                if (dto == null) {
                    dto = this.dao.findForInfo(code, activateDate, element);
                    if (dto == null) continue;
                    dto.setActivateDate(activateDate);
                    dto.setInactivateFlag(inactivateFlag);
                    this.checkAdd(dto);
                    if (this.mospParams.hasErrorMessage()) continue;
                    dto.setTmmLimitStandardId(this.dao.nextRecordId());
                    this.dao.insert((BaseDtoInterface)dto);
                    continue;
                }
                dto.setInactivateFlag(inactivateFlag);
                this.checkUpdate(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
                dto.setTmmLimitStandardId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
            }
        }
    }

    public void delete(LimitStandardDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getWorkSettingCode(), dto.getActivateDate(), dto.getTerm()) == null) {
            return;
        }
        dto.setTmmLimitStandardId(this.getRecordID(dto));
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
    }

    protected void checkInsert(LimitStandardDtoInterface dto) throws MospException {
    }

    protected void checkAdd(LimitStandardDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkSettingCode(), dto.getActivateDate(), dto.getTerm()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void checkUpdate(LimitStandardDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmLimitStandardId(), true))) {
            return;
        }
    }

    protected void checkDelete(LimitStandardDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void validate(LimitStandardDtoInterface dto) {
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            TimeSettingDtoInterface dto = (TimeSettingDtoInterface)this.timeSettingdao.findForKey(id, false);
            list.add(dto.getWorkSettingCode());
        }
        return list;
    }

    protected boolean checkInput(LimitStandardDtoInterface dto) {
        return dto.getLimitTime() != 0 || dto.getAttentionTime() != 0 || dto.getWarningTime() != 0;
    }

    protected long getRecordID(LimitStandardDtoInterface dto) throws MospException {
        LimitStandardDtoInterface subDto = this.dao.findForKey(dto.getWorkSettingCode(), dto.getActivateDate(), dto.getTerm());
        return subDto.getTmmLimitStandardId();
    }
}

