/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.OvertimeInfoReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.LimitStandardDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class OvertimeInfoReferenceBean
extends TimeApplicationBean
implements OvertimeInfoReferenceBeanInterface {
    public static final int WEEK_CALCULATE_DAY = -7;
    protected LimitStandardDaoInterface limitStandardDao;
    protected AttendanceDaoInterface attendanceDao;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected WorkflowDaoInterface workflowDao;

    public OvertimeInfoReferenceBean() {
    }

    public OvertimeInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.limitStandardDao = (LimitStandardDaoInterface)this.createDao(LimitStandardDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
    }

    public int getPossibleTime1Week(String personalId) throws MospException {
        Date targrtDate = DateUtility.getSystemDate();
        this.setCutoffSettings(personalId, targrtDate);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        LimitStandardDtoInterface limitStandardDto = this.limitStandardDao.findForKey(this.timeSettingDto.getWorkSettingCode(), this.timeSettingDto.getActivateDate(), "week1");
        if (limitStandardDto == null) {
            this.addSettingApplicationDefectLimitStandardErrorMessage(this.timeSettingDto.getActivateDate());
            return 0;
        }
        Date startDate = this.getDateClone(targrtDate);
        int difference = DateUtility.getDayOfWeek((Date)startDate) - this.timeSettingDto.getStartWeek();
        if (difference >= 0) {
            while (difference != 0) {
                startDate = DateUtility.addDay((Date)startDate, (int)-1);
                --difference;
            }
        } else {
            while (difference != 0) {
                startDate = DateUtility.addDay((Date)startDate, (int)1);
                ++difference;
            }
            startDate = DateUtility.addDay((Date)startDate, (int)-7);
        }
        Date endDate = DateUtility.addDay((Date)startDate, (int)6);
        List attendanceList = this.attendanceDao.findForList(personalId, startDate, endDate);
        boolean requestFlag = true;
        int overTimeOut = 0;
        int requestTime = 0;
        Date targetDate = startDate;
        while (!targetDate.after(endDate)) {
            for (AttendanceDtoInterface attendanceDto : attendanceList) {
                WorkflowDtoInterface workflowDto;
                if (!targetDate.equals(attendanceDto.getWorkDate()) || (workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow())) == null || "0".equals(workflowDto.getWorkflowStatus())) continue;
                overTimeOut += attendanceDto.getOvertimeOut();
                requestFlag = false;
                break;
            }
            if (requestFlag) {
                List list = this.overtimeRequestDao.findForList(personalId, targetDate);
                for (OvertimeRequestDtoInterface requestDto : list) {
                    WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(requestDto.getWorkflow());
                    if (workflowDto == null || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
                    requestTime += requestDto.getRequestTime();
                }
            }
            requestFlag = true;
            targetDate = DateUtility.addDay((Date)targetDate, (int)1);
        }
        return limitStandardDto.getLimitTime() - overTimeOut - requestTime;
    }

    public int getPossibleTime1Month(String personalId) throws MospException {
        Date systemDate = DateUtility.getSystemDate();
        this.setCutoffSettings(personalId, systemDate);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        LimitStandardDtoInterface limitStandardDto = this.limitStandardDao.findForKey(this.timeSettingDto.getWorkSettingCode(), this.timeSettingDto.getActivateDate(), "month1");
        if (limitStandardDto == null) {
            this.addSettingApplicationDefectLimitStandardErrorMessage(this.timeSettingDto.getActivateDate());
            return 0;
        }
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)this.cutoffDto.getCutoffDate(), (Date)systemDate);
        int year = DateUtility.getYear((Date)cutoffMonth);
        int month = DateUtility.getMonth((Date)cutoffMonth);
        Date firstDate = TimeUtility.getCutoffFirstDate((int)this.cutoffDto.getCutoffDate(), (int)year, (int)month);
        Date lastDate = TimeUtility.getCutoffLastDate((int)this.cutoffDto.getCutoffDate(), (int)year, (int)month);
        List attendanceList = this.attendanceDao.findForList(personalId, firstDate, lastDate);
        boolean requestFlag = true;
        int overTimeOut = 0;
        int requestTime = 0;
        Date targetDate = firstDate;
        while (!targetDate.after(lastDate)) {
            for (AttendanceDtoInterface attendanceDto : attendanceList) {
                WorkflowDtoInterface workflowDto;
                if (!targetDate.equals(attendanceDto.getWorkDate()) || (workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow())) == null || "0".equals(workflowDto.getWorkflowStatus())) continue;
                overTimeOut += attendanceDto.getOvertimeOut();
                requestFlag = false;
                break;
            }
            if (requestFlag) {
                List list = this.overtimeRequestDao.findForList(personalId, targetDate);
                for (OvertimeRequestDtoInterface requestDto : list) {
                    WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(requestDto.getWorkflow());
                    if (workflowDto == null || "0".equals(workflowDto.getWorkflowStatus()) || "5".equals(workflowDto.getWorkflowStatus())) continue;
                    requestTime += requestDto.getRequestTime();
                }
            }
            requestFlag = true;
            targetDate = DateUtility.addDay((Date)targetDate, (int)1);
        }
        return limitStandardDto.getLimitTime() - overTimeOut - requestTime;
    }
}

