/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.bean.workflow.impl.WorkflowReferenceBean;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdOvertimeRequestDto;

public class OvertimeRequestRegistBean
extends TimeBean
implements OvertimeRequestRegistBeanInterface {
    private OvertimeRequestDaoInterface dao;
    private OvertimeRequestReferenceBeanInterface overtimeReference;
    private WorkflowRegistBeanInterface workflowRegist;
    private WorkflowIntegrateBeanInterface workflowIntegrate;
    private WorkflowReferenceBeanInterface workflowReference;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    private CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;

    public OvertimeRequestRegistBean() {
    }

    public OvertimeRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.overtimeReference = (OvertimeRequestReferenceBeanInterface)this.createBean(OvertimeRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBean)this.createBean(WorkflowReferenceBean.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
    }

    public OvertimeRequestDtoInterface getInitDto() {
        return new TmdOvertimeRequestDto();
    }

    public void insert(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdOvertimeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        }
    }

    public void regist(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdOvertimeRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void add(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
        dto.setTmdOvertimeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
    }

    protected void checkInsert(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate(), dto.getOvertimeType()));
    }

    protected void checkAdd(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
    }

    public void validate(OvertimeRequestDtoInterface dto) throws MospException {
        this.overtimeReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
    }

    public void checkSetRequestDate(OvertimeRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkSetRequestDate(dto, localRequestUtil);
    }

    protected void checkSetRequestDate(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkType(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(dto, localRequestUtil);
    }

    public void checkDraft(OvertimeRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkSetRequestDate(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkOvertimeOverlap(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, localRequestUtil);
    }

    public void checkAppli(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        this.checkPeriod(dto);
        this.checkRequired(dto);
    }

    public void checkCancelAppli(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkManage"));
        }
    }

    public void checkWithdrawn(OvertimeRequestDtoInterface dto) {
    }

    public void checkApproval(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkAppli(dto);
    }

    public void checkCancelApproval(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(OvertimeRequestDtoInterface dto) {
    }

    public void checkRequired(OvertimeRequestDtoInterface dto) {
        if (dto.getRequestTime() == 0) {
            this.addOvertimeRequestTimeErrorMessage();
        }
        if (dto.getRequestReason().isEmpty()) {
            this.addOvertimeRequestReasonErrorMessage();
        }
    }

    protected void checkRequest(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        if (localRequestUtil.isHolidayAllDay(false)) {
            this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getRequestDate()), this.getNameApplicationDay()});
        }
    }

    public void checkOvertimeOverlap(OvertimeRequestDtoInterface dto) throws MospException {
        List list = this.dao.findForList(dto.getPersonalId(), dto.getRequestDate());
        for (OvertimeRequestDtoInterface requestDto : list) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null || "5".equals(workflowDto.getWorkflowStatus()) || dto.getWorkflow() == workflowDto.getWorkflow() || dto.getOvertimeType() != requestDto.getOvertimeType()) continue;
            this.addOvertimeTargetDateOvertimeErrorMessage(dto.getRequestDate());
            break;
        }
    }

    public void checkPeriod(OvertimeRequestDtoInterface dto) {
        if (dto.getRequestDate().after(DateUtility.addMonth((Date)this.getSystemDate(), (int)1))) {
            this.addOvertimePeriodErrorMessage();
        }
    }

    protected void checkAttendance(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = localRequestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            return;
        }
        if (dto.getOvertimeType() == 2 && attendanceDto.getOvertimeAfter() > 0) {
            return;
        }
        this.addOvertimeTargetWorkDateAttendanceRequestErrorMessage(dto.getRequestDate());
    }

    protected void checkWorkType(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate(), localRequestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addOvertimeTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addOvertimeTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkingHoliday"));
        }
    }

    protected void checkEntered(OvertimeRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            this.addNotEntranceErrorMessage();
        }
    }

    protected void checkRetired(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspended(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeSuspendedMessage();
        }
    }

    public void checkTemporaryClosingFinal(OvertimeRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameApplicationDay());
    }

    protected String getNameApplicationDay() {
        return this.mospParams.getName("OvertimeWork") + this.mospParams.getName("Year") + this.mospParams.getName("Month") + this.mospParams.getName("Day");
    }
}

