/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayFirstYearReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayPointDateReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayProportionallyReferenceBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayFirstYearDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayGrantDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayPointDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayProportionallyDtoInterface;

public class PaidHolidayDataGrantBean
extends TimeApplicationBean
implements PaidHolidayDataGrantBeanInterface {
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataRefer;
    protected PaidHolidayDataRegistBeanInterface paidHolidayDataRegist;
    protected PaidHolidayGrantReferenceBeanInterface paidHolidayGrantRefer;
    protected PaidHolidayGrantRegistBeanInterface paidHolidayGrantRegist;
    protected PaidHolidayProportionallyReferenceBeanInterface paidHolidayProportionallyRefer;
    protected PaidHolidayFirstYearReferenceBeanInterface paidHolidayFirstYearRefer;
    protected PaidHolidayPointDateReferenceBeanInterface paidHolidayPointDateRefer;
    protected EntranceReferenceBeanInterface entranceRefer;
    protected HumanHistoryReferenceBeanInterface humanHistoryRefer;
    protected static final String PRESCRIBED_WEEKLY_WORKING_HOURS = "prescribedWeeklyWorkingHours";
    protected static final String PRESCRIBED_WEEKLY_WORKING_DAYS = "prescribedWeeklyWorkingDays";
    protected static final String PRESCRIBED_ANNUAL_WORKING_DAYS = "prescribedAnnualWorkingDays";

    public PaidHolidayDataGrantBean() {
    }

    public PaidHolidayDataGrantBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.paidHolidayDataRefer = (PaidHolidayDataReferenceBeanInterface)this.createBean(PaidHolidayDataReferenceBeanInterface.class);
        this.paidHolidayDataRegist = (PaidHolidayDataRegistBeanInterface)this.createBean(PaidHolidayDataRegistBeanInterface.class);
        this.paidHolidayGrantRefer = (PaidHolidayGrantReferenceBeanInterface)this.createBean(PaidHolidayGrantReferenceBeanInterface.class);
        this.paidHolidayGrantRegist = (PaidHolidayGrantRegistBeanInterface)this.createBean(PaidHolidayGrantRegistBeanInterface.class);
        this.paidHolidayProportionallyRefer = (PaidHolidayProportionallyReferenceBeanInterface)this.createBean(PaidHolidayProportionallyReferenceBeanInterface.class);
        this.paidHolidayFirstYearRefer = (PaidHolidayFirstYearReferenceBeanInterface)this.createBean(PaidHolidayFirstYearReferenceBeanInterface.class);
        this.paidHolidayPointDateRefer = (PaidHolidayPointDateReferenceBeanInterface)this.createBean(PaidHolidayPointDateReferenceBeanInterface.class);
        this.humanHistoryRefer = (HumanHistoryReferenceBeanInterface)this.createBean(HumanHistoryReferenceBeanInterface.class);
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
    }

    public void grant(String personalId, Date targetDate) throws MospException {
        this.grant(this.create(personalId, targetDate));
    }

    protected void grant(PaidHolidayDataDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.paidHolidayDataRefer.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHolidayDataDto != null) {
            this.paidHolidayDataRegist.delete(paidHolidayDataDto);
        }
        this.paidHolidayDataRegist.insert(dto);
        this.paidHolidayGrantRegist(dto);
    }

    protected void paidHolidayGrantRegist(PaidHolidayDataDtoInterface dto) throws MospException {
        this.paidHolidayGrantRegist(dto.getPersonalId(), dto.getAcquisitionDate());
    }

    protected void paidHolidayGrantRegist(String personalId, Date grantDate) throws MospException {
        PaidHolidayGrantDtoInterface dto = this.paidHolidayGrantRefer.findForKey(personalId, grantDate);
        if (dto == null) {
            dto = this.paidHolidayGrantRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setGrantDate(grantDate);
        }
        dto.setGrantStatus(3);
        this.paidHolidayGrantRegist.regist(dto);
    }

    protected PaidHolidayDataDtoInterface create(String personalId, Date targetDate) throws MospException {
        return this.create(personalId, targetDate, true);
    }

    public PaidHolidayDataDtoInterface create(String personalId, Date targetDate, boolean accomplish) throws MospException {
        return this.create(personalId, this.getGrantTimes(personalId, targetDate), accomplish);
    }

    protected PaidHolidayDataDtoInterface create(String personalId, int grantTimes, boolean accomplish) throws MospException {
        if (this.paidHolidayDto == null) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0 || paidHolidayType == 4) {
            Date grantDate = this.getGrantDate(personalId, grantTimes);
            if (grantDate == null) {
                return null;
            }
            PaidHolidayDataDtoInterface dto = this.paidHolidayDataRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setHoldDay(0.0);
            dto.setHoldHour(0);
            dto.setGivingDay(0.0);
            dto.setGivingHour(0);
            dto.setCancelDay(0.0);
            dto.setCancelHour(0);
            dto.setUseDay(0.0);
            dto.setUseHour(0);
            dto.setDenominatorDayHour(this.paidHolidayDto.getTimeAcquisitionLimitTimes());
            dto.setTemporaryFlag(1);
            dto.setActivateDate(grantDate);
            dto.setAcquisitionDate(grantDate);
            dto.setLimitDate(this.getExpirationDate(personalId, grantDate, grantTimes));
            dto.setHoldDay((double)this.getGrantDays(personalId, grantTimes, accomplish));
            dto.setHoldHour(0);
            return dto;
        }
        if (paidHolidayType == 1) {
            return null;
        }
        if (paidHolidayType == 2) {
            return null;
        }
        return null;
    }

    public int getGrantTimes(String personalId, Date targetDate) throws MospException {
        this.setPaidHolidaySettings(personalId, targetDate);
        if (this.paidHolidayDto == null) {
            return 0;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            Date grantDateOfFirstFiscalYear = this.getGrantDateOfFirstFiscalYear(personalId);
            if (grantDateOfFirstFiscalYear != null && targetDate.before(grantDateOfFirstFiscalYear)) {
                return 0;
            }
            int count = 0;
            Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
            if (entranceDate == null) {
                return 0;
            }
            int grantYear = DateUtility.getYear((Date)entranceDate);
            int grantMonth = this.paidHolidayDto.getPointDateMonth();
            int grantDay = this.paidHolidayDto.getPointDateDay();
            Date grantDate = DateUtility.getDate((int)grantYear, (int)grantMonth, (int)grantDay);
            while (!grantDate.after(entranceDate)) {
                grantDate = DateUtility.getDate((int)(++grantYear), (int)grantMonth, (int)grantDay);
            }
            if (grantDateOfFirstFiscalYear != null) {
                while (!grantDate.after(grantDateOfFirstFiscalYear)) {
                    grantDate = DateUtility.getDate((int)(++grantYear), (int)grantMonth, (int)grantDay);
                }
                if (!targetDate.before(grantDateOfFirstFiscalYear) && targetDate.before(grantDate)) {
                    count = 1;
                    return 1;
                }
            }
            if (targetDate.before(grantDate)) {
                return 0;
            }
            count = 2;
            Date grantDateOfNextFiscalYear = DateUtility.getDate((int)(DateUtility.getYear((Date)grantDate) + 1), (int)grantMonth, (int)grantDay);
            while (!targetDate.before(grantDateOfNextFiscalYear)) {
                grantDate = grantDateOfNextFiscalYear;
                grantDateOfNextFiscalYear = DateUtility.getDate((int)(DateUtility.getYear((Date)grantDate) + 1), (int)grantMonth, (int)grantDay);
                ++count;
            }
            return count;
        }
        if (paidHolidayType == 1) {
            return 0;
        }
        if (paidHolidayType == 2) {
            return 0;
        }
        if (paidHolidayType == 4) {
            Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
            if (entranceDate == null) {
                return 0;
            }
            int count = 0;
            int addMonth = 6;
            while (!targetDate.before(DateUtility.addMonth((Date)entranceDate, (int)addMonth))) {
                ++count;
                addMonth += 12;
            }
            return count;
        }
        return 0;
    }

    public Date getGrantDate(String personalId, Date targetDate, int grantTimes) throws MospException {
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return null;
        }
        return this.getGrantDate(personalId, grantTimes);
    }

    public Date getGrantDate(String personalId, int grantTimes) throws MospException {
        return this.getGrantDate(personalId, grantTimes, this.entranceRefer.getEntranceDate(personalId));
    }

    public Date getGrantDate(String personalId, Date targetDate, int grantTimes, Date entranceDate) throws MospException {
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return null;
        }
        return this.getGrantDate(personalId, grantTimes, entranceDate);
    }

    protected Date getGrantDate(String personalId, int grantTimes, Date entranceDate) throws MospException {
        if (entranceDate == null) {
            return null;
        }
        if (this.paidHolidayDto == null) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            Date grantDateOfFirstFiscalYear = this.getGrantDateOfFirstFiscalYear(personalId);
            if (grantTimes <= 0) {
                return null;
            }
            if (grantTimes == 1) {
                return grantDateOfFirstFiscalYear;
            }
            int grantMonth = this.paidHolidayDto.getPointDateMonth();
            int grantDay = this.paidHolidayDto.getPointDateDay();
            Date grantDate = DateUtility.getDate((int)DateUtility.getYear((Date)entranceDate), (int)grantMonth, (int)grantDay);
            while (!grantDate.after(entranceDate)) {
                grantDate = DateUtility.getDate((int)(DateUtility.getYear((Date)grantDate) + 1), (int)grantMonth, (int)grantDay);
            }
            if (grantDateOfFirstFiscalYear != null) {
                while (!grantDate.after(grantDateOfFirstFiscalYear)) {
                    grantDate = DateUtility.getDate((int)(DateUtility.getYear((Date)grantDate) + 1), (int)grantMonth, (int)grantDay);
                }
            }
            if (grantTimes == 2) {
                return grantDate;
            }
            return DateUtility.getDate((int)(DateUtility.getYear((Date)grantDate) + grantTimes - 2), (int)grantMonth, (int)grantDay);
        }
        if (paidHolidayType == 1) {
            return null;
        }
        if (paidHolidayType == 2) {
            return null;
        }
        if (paidHolidayType == 4) {
            if (grantTimes <= 0) {
                return null;
            }
            int addMonth = (grantTimes - 1) * 12 + 6;
            return DateUtility.addMonth((Date)entranceDate, (int)addMonth);
        }
        return null;
    }

    protected Date getGrantDateOfFirstFiscalYear(String personalId) throws MospException {
        Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (entranceDate == null) {
            return null;
        }
        if (this.paidHolidayDto == null) {
            return null;
        }
        PaidHolidayFirstYearDtoInterface dto = this.paidHolidayFirstYearRefer.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
        if (dto == null) {
            return null;
        }
        if (dto.getGivingAmount() <= 0) {
            return null;
        }
        return this.addDay(DateUtility.addMonth((Date)MonthUtility.getTargetYearMonth((Date)entranceDate, (MospParams)this.mospParams), (int)dto.getGivingMonth()), this.paidHolidayDto.getPointDateDay() - 1);
    }

    public Date getExpirationDate(String personalId, Date grantDate, int grantTimes) throws MospException {
        if (this.paidHolidayDto == null) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            if (grantTimes <= 0) {
                return null;
            }
            if (grantTimes == 1) {
                return this.getExpirationDateOfFirstFiscalYear(personalId, grantDate);
            }
            int addYear = 1;
            if (this.paidHolidayDto.getMaxCarryOverYear() == 0) {
                addYear = 2;
            }
            return this.addDay(DateUtility.addYear((Date)grantDate, (int)addYear), -1);
        }
        if (paidHolidayType == 1) {
            return null;
        }
        if (paidHolidayType == 2) {
            return null;
        }
        if (paidHolidayType == 4) {
            if (grantTimes <= 0) {
                return null;
            }
            int addYear = 1;
            if (this.paidHolidayDto.getMaxCarryOverYear() == 0) {
                addYear = 2;
            }
            return this.addDay(DateUtility.addYear((Date)grantDate, (int)addYear), -1);
        }
        return null;
    }

    protected Date getExpirationDateOfFirstFiscalYear(String personalId, Date grantDate) throws MospException {
        Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (entranceDate == null) {
            return null;
        }
        if (this.paidHolidayDto == null) {
            return null;
        }
        return this.getExpirationDateOfFirstFiscalYear(this.paidHolidayFirstYearRefer.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate)), grantDate);
    }

    protected Date getExpirationDateOfFirstFiscalYear(PaidHolidayFirstYearDtoInterface dto, Date grantDate) throws MospException {
        if (dto == null) {
            return null;
        }
        return this.addDay(DateUtility.addMonth((Date)grantDate, (int)dto.getGivingLimit()), -1);
    }

    protected int getGrantDays(String personalId, int grantTimes, boolean accomplish) throws MospException {
        if (this.paidHolidayDto == null) {
            return 0;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            if (!accomplish) {
                return 0;
            }
            if (grantTimes <= 0) {
                return 0;
            }
            if (grantTimes == 1) {
                return this.getGrantDaysOfFirstFiscalYear(personalId, accomplish);
            }
            PaidHolidayPointDateDtoInterface paidHolidayPointDateDto = this.paidHolidayPointDateRefer.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), grantTimes);
            if (paidHolidayPointDateDto == null) {
                return this.paidHolidayDto.getGeneralPointAmount();
            }
            return paidHolidayPointDateDto.getPointDateAmount();
        }
        if (paidHolidayType == 1) {
            return 0;
        }
        if (paidHolidayType == 2) {
            return 0;
        }
        if (paidHolidayType == 4) {
            return this.getGrantDaysForProportionally(personalId, grantTimes, accomplish);
        }
        return 0;
    }

    protected int getGrantDaysForProportionally(String personalId, int grantTimes, boolean accomplish) throws MospException {
        if (!accomplish) {
            return 0;
        }
        Date grantDate = this.getGrantDate(personalId, grantTimes);
        if (grantDate == null) {
            return 0;
        }
        return this.getGrantDaysForProportionally(personalId, grantDate, grantTimes);
    }

    public int getGrantDaysForProportionally(String personalId, Date grantDate, int grantTimes) throws MospException {
        HumanHistoryDtoInterface prescribedAnnualWorkingDaysDto;
        HumanHistoryDtoInterface prescribedWeeklyWorkingDaysDto;
        Double prescribedWeeklyWorkingHours = null;
        Integer prescribedWeeklyWorkingDays = null;
        Integer prescribedAnnualWorkingDays = null;
        HumanHistoryDtoInterface prescribedWeeklyWorkingHoursDto = this.humanHistoryRefer.findForInfo(personalId, PRESCRIBED_WEEKLY_WORKING_HOURS, grantDate);
        if (prescribedWeeklyWorkingHoursDto != null && !prescribedWeeklyWorkingHoursDto.getHumanItemValue().isEmpty()) {
            prescribedWeeklyWorkingHours = Double.valueOf(prescribedWeeklyWorkingHoursDto.getHumanItemValue());
        }
        if ((prescribedWeeklyWorkingDaysDto = this.humanHistoryRefer.findForInfo(personalId, PRESCRIBED_WEEKLY_WORKING_DAYS, grantDate)) != null && !prescribedWeeklyWorkingDaysDto.getHumanItemValue().isEmpty()) {
            prescribedWeeklyWorkingDays = Integer.valueOf(prescribedWeeklyWorkingDaysDto.getHumanItemValue());
        }
        if ((prescribedAnnualWorkingDaysDto = this.humanHistoryRefer.findForInfo(personalId, PRESCRIBED_ANNUAL_WORKING_DAYS, grantDate)) != null && !prescribedAnnualWorkingDaysDto.getHumanItemValue().isEmpty()) {
            prescribedAnnualWorkingDays = Integer.valueOf(prescribedAnnualWorkingDaysDto.getHumanItemValue());
        }
        return this.getGrantDaysForProportionally(grantTimes, prescribedWeeklyWorkingHours, prescribedWeeklyWorkingDays, prescribedAnnualWorkingDays);
    }

    protected int getGrantDaysForProportionally(int grantTimes, Double prescribedWeeklyWorkingHours, Integer prescribedWeeklyWorkingDays, Integer prescribedAnnualWorkingDays) throws MospException {
        if (prescribedWeeklyWorkingHours == null || prescribedWeeklyWorkingHours.intValue() >= 30) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 5);
        }
        if (prescribedWeeklyWorkingDays != null) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, prescribedWeeklyWorkingDays.intValue());
        }
        int pAWD = 217;
        if (prescribedAnnualWorkingDays != null) {
            pAWD = prescribedAnnualWorkingDays;
        }
        return this.getGrantDaysForPrescribedAnnualWorkingDays(grantTimes, pAWD);
    }

    protected int getGrantDaysForPrescribedWeeklyWorkingDays(int grantTimes, int prescribedWeeklyWorkingDays) throws MospException {
        int days = prescribedWeeklyWorkingDays;
        if (prescribedWeeklyWorkingDays >= 5) {
            days = 5;
        } else if (prescribedWeeklyWorkingDays <= 0) {
            return 0;
        }
        int continuousServiceTermsCountingFromTheEmploymentDay = 12 * (grantTimes - 1) + 6;
        if (grantTimes >= 7) {
            continuousServiceTermsCountingFromTheEmploymentDay = 78;
        } else if (grantTimes <= 0) {
            return 0;
        }
        PaidHolidayProportionallyDtoInterface dto = this.paidHolidayProportionallyRefer.findForInfo(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), days, continuousServiceTermsCountingFromTheEmploymentDay);
        if (dto == null) {
            return 0;
        }
        if (dto.getInactivateFlag() == 0) {
            return dto.getDays();
        }
        return 0;
    }

    protected int getGrantDaysForPrescribedAnnualWorkingDays(int grantTimes, int prescribedAnnualWorkingDays) throws MospException {
        if (prescribedAnnualWorkingDays >= 217) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 5);
        }
        if (prescribedAnnualWorkingDays >= 169) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 4);
        }
        if (prescribedAnnualWorkingDays >= 121) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 3);
        }
        if (prescribedAnnualWorkingDays >= 73) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 2);
        }
        if (prescribedAnnualWorkingDays >= 48) {
            return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 1);
        }
        return this.getGrantDaysForPrescribedWeeklyWorkingDays(grantTimes, 0);
    }

    protected int getGrantDaysOfFirstFiscalYear(String personalId, boolean accomplish) throws MospException {
        if (!accomplish) {
            return 0;
        }
        Date entranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (entranceDate == null) {
            return 0;
        }
        if (this.paidHolidayDto == null) {
            return 0;
        }
        PaidHolidayFirstYearDtoInterface dto = this.paidHolidayFirstYearRefer.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)entranceDate));
        if (dto == null) {
            return 0;
        }
        return dto.getGivingAmount();
    }
}

