/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdPaidHolidayDataDto;
import jp.mosp.time.input.vo.HolidayRequestVo;
import jp.mosp.time.utils.TimeMessageUtility;

public class PaidHolidayDataRegistBean
extends PlatformBean
implements PaidHolidayDataRegistBeanInterface {
    PaidHolidayDataDaoInterface dao;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionReference;
    protected HolidayRequestReferenceBeanInterface holidayRequestReference;

    public PaidHolidayDataRegistBean() {
    }

    public PaidHolidayDataRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (PaidHolidayDataDaoInterface)this.createDao(PaidHolidayDataDaoInterface.class);
        this.paidHolidayTransactionReference = (PaidHolidayTransactionReferenceBeanInterface)this.createBean(PaidHolidayTransactionReferenceBeanInterface.class);
        this.holidayRequestReference = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
    }

    public PaidHolidayDataDtoInterface getInitDto() {
        return new TmdPaidHolidayDataDto();
    }

    public void insert(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHolidayDataDto != null) {
            this.validate(paidHolidayDataDto);
            this.checkUpdate(paidHolidayDataDto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, paidHolidayDataDto.getTmdPaidHolidayId());
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
        dto.setTmdPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
    }

    public void delete(String personalId, Date activateDate) throws MospException {
        List list = this.dao.findForList(personalId, activateDate);
        for (PaidHolidayDataDtoInterface dto : list) {
            this.checkDelete((PaidHolidayDataDtoInterface)this.dao.findForKey(dto.getTmdPaidHolidayId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
        }
    }

    protected void checkInsert(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate()));
    }

    protected void checkUpdate(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmdPaidHolidayId(), true))) {
            return;
        }
    }

    protected void checkDelete(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
    }

    public void checkModify(PaidHolidayDataDtoInterface dto) throws MospException {
        int hour;
        Date endDate = dto.getLimitDate();
        List list = this.dao.findForHistory(dto.getPersonalId(), dto.getAcquisitionDate());
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayDataDtoInterface paidHolidayDataDto = (PaidHolidayDataDtoInterface)list.get(i);
            if (!paidHolidayDataDto.getActivateDate().equals(dto.getActivateDate())) continue;
            if (list.size() <= i + 1) break;
            endDate = this.addDay(((PaidHolidayDataDtoInterface)list.get(i + 1)).getActivateDate(), -1);
            break;
        }
        if (dto.getActivateDate().after(endDate)) {
            endDate = dto.getActivateDate();
        }
        double givingDay = 0.0;
        int givingHour = 0;
        double cancelDay = 0.0;
        int cancelHour = 0;
        List paidHolidayTransactionList = this.paidHolidayTransactionReference.findForList(dto.getPersonalId(), dto.getAcquisitionDate(), dto.getActivateDate(), endDate);
        for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionList) {
            givingDay += paidHolidayTransactionDto.getGivingDay();
            givingHour += paidHolidayTransactionDto.getGivingHour();
            cancelDay += paidHolidayTransactionDto.getCancelDay();
            cancelHour += paidHolidayTransactionDto.getCancelHour();
        }
        Map map = this.holidayRequestReference.getRequestDayHour(dto.getPersonalId(), dto.getAcquisitionDate(), 1, Integer.toString(1), dto.getActivateDate(), endDate);
        double useDay = (Double)map.get("requestDay");
        int useHour = (Integer)map.get("requestHour");
        double day = dto.getHoldDay() + givingDay - cancelDay - useDay;
        if (dto.getDenominatorDayHour() > 0) {
            for (hour = dto.getHoldHour() + givingHour - cancelHour - useHour; day >= 1.0 && hour < 0; day -= 1.0, hour += dto.getDenominatorDayHour()) {
            }
        }
        if (day >= 0.0 && hour >= 0) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0316", new String[]{this.mospParams.getName(HolidayRequestVo.class.getName()), this.mospParams.getName("Insert")});
    }

    protected void validate(PaidHolidayDataDtoInterface dto) {
        String employeeCode = MospUtility.getCodeName((String)"employee_code", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_paid_holiday", false));
        String activateDate = MospUtility.getCodeName((String)"activate_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_paid_holiday", false));
        String acquisitionDate = MospUtility.getCodeName((String)"acquisition_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_paid_holiday", false));
        String limitDate = MospUtility.getCodeName((String)"limit_date", (String[][])this.mospParams.getProperties().getCodeArray("import_tmd_paid_holiday", false));
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getPersonalId(), (String[])new String[]{employeeCode});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getActivateDate()), (String[])new String[]{activateDate});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getAcquisitionDate()), (String[])new String[]{acquisitionDate});
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)this.getStringDate(dto.getAcquisitionDate()), (String[])new String[]{limitDate});
    }

    public void checkDeleteConfirm(PaidHolidayDataDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getAcquisitionDate();
        boolean isDelete = this.isDleteConfirm(dto);
        List list = this.holidayRequestReference.getUsePaidHolidayDataList(personalId, acquisitionDate);
        for (HolidayRequestDtoInterface holidayDto : list) {
            if (isDelete) continue;
            TimeMessageUtility.addErrorNoDeleteForHolidayRequest((MospParams)this.mospParams, (Date)acquisitionDate, (Date)holidayDto.getRequestStartDate());
        }
        List transacList = this.paidHolidayTransactionReference.findForAcquisitionList(personalId, acquisitionDate);
        for (PaidHolidayTransactionDtoInterface transacDto : transacList) {
            if (isDelete) continue;
            TimeMessageUtility.addErrorNoDeleteForPaidHolidayTransaction((MospParams)this.mospParams, (Date)acquisitionDate, (Date)transacDto.getActivateDate());
        }
    }

    protected boolean isDleteConfirm(PaidHolidayDataDtoInterface dto) throws MospException {
        List list = this.dao.findForHistory(dto.getPersonalId(), dto.getAcquisitionDate());
        return list.size() != 1 && dto.getActivateDate().compareTo(dto.getAcquisitionDate()) != 0;
    }
}

