/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.PaidHolidayGrantRegistBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayGrantDaoInterface;
import jp.mosp.time.dto.settings.PaidHolidayGrantDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtPaidHolidayGrantDto;

public class PaidHolidayGrantRegistBean
extends TimeBean
implements PaidHolidayGrantRegistBeanInterface {
    protected PaidHolidayGrantDaoInterface dao;

    public PaidHolidayGrantRegistBean() {
    }

    public PaidHolidayGrantRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (PaidHolidayGrantDaoInterface)this.createDao(PaidHolidayGrantDaoInterface.class);
    }

    public PaidHolidayGrantDtoInterface getInitDto() {
        return new TmtPaidHolidayGrantDto();
    }

    public void regist(PaidHolidayGrantDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getGrantDate()) == null) {
            this.insert(dto);
            return;
        }
        this.update(dto);
    }

    public void delete(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayGrantId());
    }

    protected void insert(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmtPaidHolidayGrantId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayGrantId());
        dto.setTmtPaidHolidayGrantId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getGrantDate()));
    }

    protected void checkUpdate(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayGrantId());
    }

    protected void checkDelete(PaidHolidayGrantDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtPaidHolidayGrantId());
    }

    protected void validate(PaidHolidayGrantDtoInterface dto) {
    }
}

