/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayFirstYearReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayPointDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayDataDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayEntranceDateDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayPointDateDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayTransactionDaoInterface;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayEntranceDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayFirstYearDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayPointDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayInfoReferenceBean
extends TimeApplicationBean
implements PaidHolidayInfoReferenceBeanInterface {
    private PaidHolidayDataDaoInterface paidHolidayDataDao;
    private PaidHolidayTransactionDaoInterface paidHolidayTransactionDao;
    private HolidayRequestDaoInterface holidayRequestDao;
    private HolidayRequestReferenceBeanInterface holidayRequest;
    protected PaidHolidayPointDateReferenceBeanInterface paidHolidayPointDateReference;
    private PaidHolidayPointDateDaoInterface paidHolidayPointDao;
    private PaidHolidayEntranceDateDaoInterface paidHolidayEntranceDateDao;
    private TotalTimeDataDaoInterface totalTimeDataDao;
    protected PaidHolidayFirstYearReferenceBeanInterface paidHolidayFirstYearReference;
    protected EntranceReferenceBeanInterface entranceRefer;
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataReference;
    protected PaidHolidayDataGrantBeanInterface paidHolidayDataGrant;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected TimeMasterBeanInterface timeMaster;
    protected Date entranceDate;

    public PaidHolidayInfoReferenceBean() {
    }

    public PaidHolidayInfoReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.paidHolidayDataDao = (PaidHolidayDataDaoInterface)this.createDao(PaidHolidayDataDaoInterface.class);
        this.paidHolidayTransactionDao = (PaidHolidayTransactionDaoInterface)this.createDao(PaidHolidayTransactionDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.paidHolidayPointDao = (PaidHolidayPointDateDaoInterface)this.createDao(PaidHolidayPointDateDaoInterface.class);
        this.paidHolidayEntranceDateDao = (PaidHolidayEntranceDateDaoInterface)this.createDao(PaidHolidayEntranceDateDaoInterface.class);
        this.totalTimeDataDao = (TotalTimeDataDaoInterface)this.createDao(TotalTimeDataDaoInterface.class);
        this.paidHolidayPointDateReference = (PaidHolidayPointDateReferenceBeanInterface)this.createBean(PaidHolidayPointDateReferenceBeanInterface.class);
        this.paidHolidayFirstYearReference = (PaidHolidayFirstYearReferenceBeanInterface)this.createBean(PaidHolidayFirstYearReferenceBeanInterface.class);
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
        this.paidHolidayDataReference = (PaidHolidayDataReferenceBeanInterface)this.createBean(PaidHolidayDataReferenceBeanInterface.class);
        this.paidHolidayDataGrant = (PaidHolidayDataGrantBeanInterface)this.createBean(PaidHolidayDataGrantBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
    }

    public Map<String, Object> getPaidHolidayInfo(String personalId, Date targetDate) throws MospException {
        return this.getPaidHolidayInfo(personalId, targetDate, true);
    }

    public Map<String, Object> getPaidHolidayInfo(String personalId, Date targetDate, boolean containNotApproved) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActivateDate", targetDate);
        map.put("CurrentYearDay", 0.0);
        map.put("CurrentTime", 0);
        map.put("FormerYearDay", 0.0);
        map.put("FormerTime", 0);
        map.put("GivingDay", 0.0);
        map.put("GivingTime", 0);
        map.put("CancelDay", 0.0);
        map.put("CancelTime", 0);
        map.put("UseDay", 0.0);
        map.put("UseTime", 0);
        double currentDay = 0.0;
        int currentTime = 0;
        double formerDay = 0.0;
        int formerTime = 0;
        double currentHoldDay = 0.0;
        int currentHoldTime = 0;
        double formerHoldDay = 0.0;
        int formerHoldTime = 0;
        double currentGivingDay = 0.0;
        int currentGivingTime = 0;
        double formerGivingDay = 0.0;
        int formerGivingTime = 0;
        double currentCancelDay = 0.0;
        int currentCancelTime = 0;
        double formerCancelDay = 0.0;
        int formerCancelTime = 0;
        double currentUseDay = 0.0;
        int currentUseTime = 0;
        double formerUseDay = 0.0;
        int formerUseTime = 0;
        Date currentAcquisitionDate = null;
        int generalWorkHour = 0;
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return map;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0 || paidHolidayType == 3) {
            currentAcquisitionDate = DateUtility.getDate((int)DateUtility.getYear((Date)targetDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
            if (targetDate.before(currentAcquisitionDate)) {
                currentAcquisitionDate = DateUtility.addYear((Date)currentAcquisitionDate, (int)-1);
            }
        } else if (paidHolidayType == 4) {
            currentAcquisitionDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate));
        }
        if (currentAcquisitionDate == null) {
            return map;
        }
        generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        List paidHolidayDataDtoList = this.paidHolidayDataDao.findForInfoList(personalId, targetDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataDtoList) {
            Map approvedMap;
            Map requestMap;
            List paidHolidayTransactionDtoList;
            map.put("ActivateDate", paidHolidayDataDto.getActivateDate());
            Date acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
            if (!acquisitionDate.before(currentAcquisitionDate)) {
                currentHoldDay += paidHolidayDataDto.getHoldDay();
                currentHoldTime += paidHolidayDataDto.getHoldHour();
                paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataDto.getActivateDate(), targetDate);
                for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                    currentGivingDay += paidHolidayTransactionDto.getGivingDay();
                    currentGivingTime += paidHolidayTransactionDto.getGivingHour();
                    currentCancelDay += paidHolidayTransactionDto.getCancelDay();
                    currentCancelTime += paidHolidayTransactionDto.getCancelHour();
                }
                if (containNotApproved) {
                    requestMap = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), targetDate);
                    currentUseDay += ((Double)requestMap.get("requestDay")).doubleValue();
                    currentUseTime += ((Integer)requestMap.get("requestHour")).intValue();
                } else {
                    approvedMap = this.holidayRequest.getApprovedDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), targetDate);
                    currentUseDay += ((Double)approvedMap.get("approvedDay")).doubleValue();
                    currentUseTime += ((Integer)approvedMap.get("approvedHour")).intValue();
                }
                currentDay = currentHoldDay + currentGivingDay - currentCancelDay - currentUseDay;
                if (generalWorkHour <= 0) continue;
                for (currentTime = currentHoldTime + currentGivingTime - currentCancelTime - currentUseTime; currentTime < 0 && currentDay >= 1.0; currentDay -= 1.0, currentTime += generalWorkHour) {
                }
                continue;
            }
            if (!acquisitionDate.before(currentAcquisitionDate)) continue;
            formerHoldDay += paidHolidayDataDto.getHoldDay();
            formerHoldTime += paidHolidayDataDto.getHoldHour();
            paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataDto.getActivateDate(), targetDate);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                formerGivingDay += paidHolidayTransactionDto.getGivingDay();
                formerGivingTime += paidHolidayTransactionDto.getGivingHour();
                formerCancelDay += paidHolidayTransactionDto.getCancelDay();
                formerCancelTime += paidHolidayTransactionDto.getCancelHour();
            }
            if (containNotApproved) {
                requestMap = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), targetDate);
                formerUseDay += ((Double)requestMap.get("requestDay")).doubleValue();
                formerUseTime += ((Integer)requestMap.get("requestHour")).intValue();
            } else {
                approvedMap = this.holidayRequest.getApprovedDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), targetDate);
                formerUseDay += ((Double)approvedMap.get("approvedDay")).doubleValue();
                formerUseTime += ((Integer)approvedMap.get("approvedHour")).intValue();
            }
            formerDay = formerHoldDay + formerGivingDay - formerCancelDay - formerUseDay;
            if (generalWorkHour <= 0) continue;
            for (formerTime = formerHoldTime + formerGivingTime - formerCancelTime - formerUseTime; formerTime < 0 && formerDay >= 1.0; formerDay -= 1.0, formerTime += generalWorkHour) {
            }
        }
        map.put("CurrentYearDay", currentDay);
        map.put("CurrentTime", currentTime);
        map.put("FormerYearDay", formerDay);
        map.put("FormerTime", formerTime);
        map.put("GivingDay", currentGivingDay + formerGivingDay);
        map.put("GivingTime", currentGivingTime + formerGivingTime);
        map.put("CancelDay", currentCancelDay + formerCancelDay);
        map.put("CancelTime", currentCancelTime + formerCancelTime);
        map.put("UseDay", currentUseDay + formerUseDay);
        map.put("UseTime", currentUseTime + formerUseTime);
        return map;
    }

    public Map<String, Object> getPaidHolidayReferenceInfo(String personalId, Date firstDate, Date lastDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActivateDate", lastDate);
        map.put("CurrentYearDay", 0.0);
        map.put("CurrentTime", 0);
        map.put("FormerYearDay", 0.0);
        map.put("FormerTime", 0);
        map.put("GivingDay", 0.0);
        map.put("GivingTime", 0);
        map.put("CancelDay", 0.0);
        map.put("CancelTime", 0);
        map.put("UseDay", 0.0);
        map.put("UseTime", 0);
        double currentDay = 0.0;
        int currentTime = 0;
        double formerDay = 0.0;
        int formerTime = 0;
        double currentGivingDay = 0.0;
        int currentGivingTime = 0;
        double formerGivingDay = 0.0;
        int formerGivingTime = 0;
        double currentCancelDay = 0.0;
        int currentCancelTime = 0;
        double formerCancelDay = 0.0;
        int formerCancelTime = 0;
        double currentUseDay = 0.0;
        int currentUseTime = 0;
        double formerUseDay = 0.0;
        int formerUseTime = 0;
        Date currentAcquisitionDate = null;
        int generalWorkHour = 0;
        if (!this.hasPaidHolidaySettings(personalId, lastDate)) {
            return map;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0 || paidHolidayType == 3) {
            currentAcquisitionDate = DateUtility.getDate((int)DateUtility.getYear((Date)lastDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
            if (lastDate.before(currentAcquisitionDate)) {
                currentAcquisitionDate = DateUtility.addYear((Date)currentAcquisitionDate, (int)-1);
            }
        } else if (paidHolidayType == 4) {
            currentAcquisitionDate = this.paidHolidayDataGrant.getGrantDate(personalId, lastDate, this.paidHolidayDataGrant.getGrantTimes(personalId, lastDate));
        }
        if (currentAcquisitionDate == null) {
            return map;
        }
        generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        List paidHolidayDataDtoList = this.paidHolidayDataDao.findForInfoList(personalId, lastDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataDtoList) {
            Map targetTermApprovedMap;
            Map approvedMap;
            List paidHolidayTransactionDtoList;
            Date paidHolidayDataActivateDate = paidHolidayDataDto.getActivateDate();
            map.put("ActivateDate", paidHolidayDataActivateDate);
            Date acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
            if (!acquisitionDate.before(currentAcquisitionDate)) {
                currentDay += paidHolidayDataDto.getHoldDay();
                currentTime += paidHolidayDataDto.getHoldHour();
                paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataActivateDate, lastDate);
                for (PaidHolidayTransactionDtoInterface transactionDto : paidHolidayTransactionDtoList) {
                    if (DateUtility.isTermContain((Date)transactionDto.getActivateDate(), (Date)firstDate, (Date)lastDate)) {
                        currentGivingDay += transactionDto.getGivingDay();
                        currentGivingTime += transactionDto.getGivingHour();
                        currentCancelDay += transactionDto.getCancelDay();
                        currentCancelTime += transactionDto.getCancelHour();
                    }
                    currentDay += transactionDto.getGivingDay();
                    currentTime += transactionDto.getGivingHour();
                    currentDay -= transactionDto.getCancelDay();
                    currentTime -= transactionDto.getCancelHour();
                }
                approvedMap = this.holidayRequest.getApprovedPaidHolidayReqeust(personalId, acquisitionDate, paidHolidayDataActivateDate, lastDate);
                currentDay -= ((Double)approvedMap.get("approvedDay")).doubleValue();
                currentTime -= ((Integer)approvedMap.get("approvedHour")).intValue();
                targetTermApprovedMap = this.holidayRequest.getApprovedPaidHolidayReqeust(personalId, acquisitionDate, firstDate, lastDate);
                currentUseDay += ((Double)targetTermApprovedMap.get("approvedDay")).doubleValue();
                currentUseTime += ((Integer)targetTermApprovedMap.get("approvedHour")).intValue();
                continue;
            }
            if (!acquisitionDate.before(currentAcquisitionDate)) continue;
            formerDay += paidHolidayDataDto.getHoldDay();
            formerTime += paidHolidayDataDto.getHoldHour();
            paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataActivateDate, lastDate);
            for (PaidHolidayTransactionDtoInterface transactionDto : paidHolidayTransactionDtoList) {
                if (DateUtility.isTermContain((Date)transactionDto.getActivateDate(), (Date)firstDate, (Date)lastDate)) {
                    formerGivingDay += transactionDto.getGivingDay();
                    formerGivingTime += transactionDto.getGivingHour();
                    formerCancelDay += transactionDto.getCancelDay();
                    formerCancelTime += transactionDto.getCancelHour();
                }
                formerDay += transactionDto.getGivingDay();
                formerTime += transactionDto.getGivingHour();
                formerDay -= transactionDto.getCancelDay();
                formerTime -= transactionDto.getCancelHour();
            }
            approvedMap = this.holidayRequest.getApprovedPaidHolidayReqeust(personalId, acquisitionDate, paidHolidayDataActivateDate, lastDate);
            formerDay -= ((Double)approvedMap.get("approvedDay")).doubleValue();
            formerTime -= ((Integer)approvedMap.get("approvedHour")).intValue();
            targetTermApprovedMap = this.holidayRequest.getApprovedPaidHolidayReqeust(personalId, acquisitionDate, firstDate, lastDate);
            formerUseDay += ((Double)targetTermApprovedMap.get("approvedDay")).doubleValue();
            formerUseTime += ((Integer)targetTermApprovedMap.get("approvedHour")).intValue();
        }
        if (generalWorkHour > 0) {
            while (currentTime < 0 && currentDay >= 1.0) {
                currentDay -= 1.0;
                currentTime += generalWorkHour;
            }
        }
        if (generalWorkHour > 0) {
            while (formerTime < 0 && formerDay >= 1.0) {
                formerDay -= 1.0;
                formerTime += generalWorkHour;
            }
        }
        map.put("CurrentYearDay", currentDay);
        map.put("CurrentTime", currentTime);
        map.put("FormerYearDay", formerDay);
        map.put("FormerTime", formerTime);
        map.put("GivingDay", currentGivingDay + formerGivingDay);
        map.put("GivingTime", currentGivingTime + formerGivingTime);
        map.put("CancelDay", currentCancelDay + formerCancelDay);
        map.put("CancelTime", currentCancelTime + formerCancelTime);
        map.put("UseDay", currentUseDay + formerUseDay);
        map.put("UseTime", currentUseTime + formerUseTime);
        return map;
    }

    public List<PaidHolidayDataDtoInterface> getPaidHolidayPossibleRequestForRequestList(String personalId, Date targetDate) throws MospException {
        ArrayList<PaidHolidayDataDtoInterface> list = new ArrayList<PaidHolidayDataDtoInterface>();
        List paidHolidayDataDtoList = this.paidHolidayDataDao.findForInfoList(personalId, targetDate);
        int generalWorkHour = 0;
        if (this.hasPaidHolidaySettings(personalId, targetDate)) {
            generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        }
        for (PaidHolidayDataDtoInterface dto : paidHolidayDataDtoList) {
            int currentTime;
            double currentGivingDate = dto.getGivingDay();
            int currentGivingTime = dto.getGivingHour();
            double currentCancelDate = dto.getCancelDay();
            int currentCancelTime = dto.getCancelHour();
            List paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, dto.getAcquisitionDate(), dto.getActivateDate(), targetDate);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                currentGivingDate += paidHolidayTransactionDto.getGivingDay();
                currentGivingTime += paidHolidayTransactionDto.getGivingHour();
                currentCancelDate += paidHolidayTransactionDto.getCancelDay();
                currentCancelTime += paidHolidayTransactionDto.getCancelHour();
            }
            double currentUseDate = dto.getUseDay();
            int currentUseTime = dto.getUseHour();
            List holidayRequestList = this.holidayRequestDao.findForRequestList(personalId, dto.getAcquisitionDate(), 1, Integer.toString(1), dto.getActivateDate(), dto.getLimitDate());
            for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
                if (this.workflowIntegrate.isFirstReverted(holidayRequestDto.getWorkflow())) continue;
                currentUseDate += holidayRequestDto.getUseDay();
                currentUseTime += holidayRequestDto.getUseHour();
            }
            double currentDate = dto.getHoldDay() + currentGivingDate - currentCancelDate - currentUseDate;
            if (generalWorkHour > 0) {
                for (currentTime = dto.getHoldHour() + currentGivingTime - currentCancelTime - currentUseTime; currentTime < 0 && currentDate >= 1.0; currentDate -= 1.0, currentTime += generalWorkHour) {
                }
            }
            dto.setHoldDay(currentDate);
            dto.setHoldHour(currentTime);
            dto.setGivingDay(currentGivingDate);
            dto.setGivingHour(currentGivingTime);
            dto.setCancelDay(currentCancelDate);
            dto.setCancelHour(currentCancelTime);
            dto.setUseDay(currentUseDate);
            dto.setUseHour(currentUseTime);
            list.add(dto);
        }
        return list;
    }

    public List<Map<String, Object>> getPaidHolidayDataListForView(String personalId, Date targetDate) throws MospException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return Collections.emptyList();
        }
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate);
        Date firstGrantDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, 1);
        Date previousGrantDate = null;
        if (grantTimes >= 2) {
            previousGrantDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, grantTimes - 1);
        }
        Date currentGrantDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, grantTimes);
        int generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        for (PaidHolidayDataDtoInterface dto : this.paidHolidayDataReference.getPaidHolidayDataInfoList(personalId, targetDate)) {
            int remainHour;
            String fiscalYear = "";
            if (dto.getAcquisitionDate().equals(firstGrantDate)) {
                fiscalYear = this.mospParams.getName("FirstYear");
            }
            if (dto.getAcquisitionDate().equals(previousGrantDate)) {
                fiscalYear = this.mospParams.getName("PreviousYear", new String[]{"Times"});
            }
            if (dto.getAcquisitionDate().equals(currentGrantDate)) {
                fiscalYear = this.mospParams.getName("ThisYear", new String[]{"Times"});
            }
            double grantDay = dto.getHoldDay() + dto.getGivingDay() - dto.getCancelDay();
            int grantHour = dto.getHoldHour() + dto.getGivingHour() - dto.getCancelHour();
            List paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, dto.getAcquisitionDate(), dto.getActivateDate(), targetDate);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                grantDay += paidHolidayTransactionDto.getGivingDay();
                grantHour += paidHolidayTransactionDto.getGivingHour();
                grantDay -= paidHolidayTransactionDto.getCancelDay();
                grantHour -= paidHolidayTransactionDto.getCancelHour();
            }
            if (generalWorkHour > 0) {
                while (grantHour < 0 && grantDay >= 1.0) {
                    grantDay -= 1.0;
                    grantHour += generalWorkHour;
                }
            }
            Map map = this.holidayRequest.getRequestDayHour(personalId, dto.getAcquisitionDate(), 1, Integer.toString(1), dto.getActivateDate(), dto.getLimitDate());
            double requestDay = (Double)map.get("requestDay");
            int requestHour = (Integer)map.get("requestHour");
            double remainDay = grantDay - requestDay;
            if (generalWorkHour > 0) {
                for (remainHour = grantHour - requestHour; remainHour < 0 && remainDay >= 1.0; remainDay -= 1.0, remainHour += generalWorkHour) {
                }
            }
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("PaidLeaveFiscalYear", fiscalYear);
            map2.put("PaidLeaveGrantDate", dto.getAcquisitionDate());
            map2.put("PaidLeaveExpirationDate", dto.getLimitDate());
            map2.put("PaidLeaveGrantDays", grantDay);
            map2.put("PaidLeaveGrantHours", grantHour);
            map2.put("PaidLeaveRemainDays", remainDay);
            map2.put("PaidLeaveRemainHours", remainHour);
            list.add(map2);
        }
        for (PaidHolidayDataDtoInterface dto : this.paidHolidayDataReference.findForNextInfoList(personalId, targetDate)) {
            int remainHour;
            Map requestMap = this.holidayRequest.getRequestDayHour(personalId, dto.getAcquisitionDate(), 1, Integer.toString(1), dto.getActivateDate(), dto.getLimitDate());
            double requestDay = (Double)requestMap.get("requestDay");
            int rquestHour = (Integer)requestMap.get("requestHour");
            double grantDay = dto.getHoldDay() + dto.getGivingDay() - dto.getCancelDay();
            int grantHour = dto.getHoldHour() + dto.getGivingHour() - dto.getCancelHour();
            double remainDay = grantDay - requestDay;
            if (generalWorkHour > 0) {
                for (remainHour = grantHour - rquestHour; remainHour < 0 && remainDay >= 1.0; remainDay -= 1.0, remainHour += generalWorkHour) {
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("PaidLeaveFiscalYear", "");
            map.put("PaidLeaveGrantDate", dto.getAcquisitionDate());
            map.put("PaidLeaveExpirationDate", dto.getLimitDate());
            map.put("PaidLeaveGrantDays", grantDay);
            map.put("PaidLeaveGrantHours", grantHour);
            map.put("PaidLeaveRemainDays", remainDay);
            map.put("PaidLeaveRemainHours", remainHour);
            list.add(map);
        }
        double totalGrantDays = 0.0;
        int totalGrantHours = 0;
        double totalRemainDays = 0.0;
        int totalRemainHours = 0;
        for (Map map : list) {
            Object remainHours;
            Object remainDays;
            Object grantHours;
            Date grantDate = (Date)map.get("PaidLeaveGrantDate");
            if (grantDate.compareTo(targetDate) > 0) continue;
            Object grantDays = map.get("PaidLeaveGrantDays");
            if (grantDays != null) {
                totalGrantDays += ((Double)grantDays).doubleValue();
            }
            if ((grantHours = map.get("PaidLeaveGrantHours")) != null) {
                totalGrantHours += ((Integer)grantHours).intValue();
            }
            if ((remainDays = map.get("PaidLeaveRemainDays")) != null) {
                totalRemainDays += ((Double)remainDays).doubleValue();
            }
            if ((remainHours = map.get("PaidLeaveRemainHours")) == null) continue;
            totalRemainHours += ((Integer)remainHours).intValue();
        }
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("PaidLeaveFiscalYear", this.mospParams.getName("PresentTime", new String[]{"Of", "Remainder", "Days", "SumTotal"}));
        totalMap.put("PaidLeaveGrantDate", null);
        totalMap.put("PaidLeaveExpirationDate", null);
        totalMap.put("PaidLeaveGrantDays", totalGrantDays);
        totalMap.put("PaidLeaveGrantHours", totalGrantHours);
        totalMap.put("PaidLeaveRemainDays", totalRemainDays);
        totalMap.put("PaidLeaveRemainHours", totalRemainHours);
        list.add(totalMap);
        return list;
    }

    public Map<String, Object> getPaidHolidayPossibleRequest(String personalId, Date targetDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrentActivateDate", null);
        map.put("CurrentGivingDate", null);
        map.put("CurrentGrantDay", 0.0);
        map.put("CurrentGrantHour", 0);
        map.put("CurrentYearDay", 0.0);
        map.put("CurrentTime", 0);
        map.put("CurrentLimitDate", null);
        map.put("FormerActivateDate", null);
        map.put("FormerGivingDate", null);
        map.put("FormerGrantDay", 0.0);
        map.put("FormerGrantHour", 0);
        map.put("FormerYearDay", 0.0);
        map.put("FormerTime", 0);
        map.put("formerLimitDate", null);
        map.put("GivingDay", 0.0);
        map.put("GivingTime", 0);
        map.put("CancelDay", 0.0);
        map.put("CancelTime", 0);
        Date currentActivateDate = null;
        Date currentGivingDate = null;
        double currentGrantDay = 0.0;
        int currentGrantHour = 0;
        double currentDay = 0.0;
        int currentTime = 0;
        Date currentLimitDate = null;
        Date formerActivateDate = null;
        Date formerGivingDate = null;
        double formerGrantDay = 0.0;
        int formerGrantHour = 0;
        double formerDay = 0.0;
        int formerTime = 0;
        Date formerLimitDate = null;
        double currentHoldDay = 0.0;
        int currentHoldTime = 0;
        double formerHoldDay = 0.0;
        int formerHoldTime = 0;
        double currentGivingDay = 0.0;
        int currentGivingTime = 0;
        double formerGivingDay = 0.0;
        int formerGivingTime = 0;
        double currentCancelDay = 0.0;
        int currentCancelTime = 0;
        double formerCancelDay = 0.0;
        int formerCancelTime = 0;
        double currentUseDay = 0.0;
        int currentUseTime = 0;
        double formerUseDay = 0.0;
        int formerUseTime = 0;
        Date currentAcquisitionDate = null;
        int generalWorkHour = 0;
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return map;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0 || paidHolidayType == 3) {
            currentAcquisitionDate = DateUtility.getDate((int)DateUtility.getYear((Date)targetDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
            if (targetDate.before(currentAcquisitionDate)) {
                currentAcquisitionDate = DateUtility.addYear((Date)currentAcquisitionDate, (int)-1);
            }
        } else if (paidHolidayType == 4) {
            currentAcquisitionDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate));
        }
        if (currentAcquisitionDate == null) {
            return map;
        }
        generalWorkHour = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        List paidHolidayDataDtoList = this.paidHolidayDataDao.findForInfoList(personalId, targetDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataDtoList) {
            Map requestMap;
            List paidHolidayTransactionDtoList;
            Date acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
            if (!acquisitionDate.before(currentAcquisitionDate)) {
                currentHoldDay += paidHolidayDataDto.getHoldDay();
                currentHoldTime += paidHolidayDataDto.getHoldHour();
                currentGivingDay += paidHolidayDataDto.getGivingDay();
                currentGivingTime += paidHolidayDataDto.getGivingHour();
                currentCancelDay += paidHolidayDataDto.getCancelDay();
                currentCancelTime += paidHolidayDataDto.getCancelHour();
                currentUseDay += paidHolidayDataDto.getUseDay();
                currentUseTime += paidHolidayDataDto.getUseHour();
                if (currentGivingDate == null || currentLimitDate == null) {
                    currentActivateDate = paidHolidayDataDto.getActivateDate();
                    currentLimitDate = paidHolidayDataDto.getLimitDate();
                    currentGivingDate = paidHolidayDataDto.getAcquisitionDate();
                }
                if (currentGivingDate.after(paidHolidayDataDto.getAcquisitionDate()) || currentLimitDate.after(paidHolidayDataDto.getLimitDate())) {
                    currentActivateDate = paidHolidayDataDto.getActivateDate();
                    currentLimitDate = paidHolidayDataDto.getLimitDate();
                    currentGivingDate = paidHolidayDataDto.getAcquisitionDate();
                }
                paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataDto.getActivateDate(), targetDate);
                for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                    currentGivingDay += paidHolidayTransactionDto.getGivingDay();
                    currentGivingTime += paidHolidayTransactionDto.getGivingHour();
                    currentCancelDay += paidHolidayTransactionDto.getCancelDay();
                    currentCancelTime += paidHolidayTransactionDto.getCancelHour();
                }
                currentGrantDay = currentHoldDay + currentGivingDay - currentCancelDay;
                if (generalWorkHour > 0) {
                    for (currentGrantHour = currentHoldTime + currentGivingTime - currentCancelTime; currentGrantHour < 0 && currentGrantDay >= 1.0; currentGrantDay -= 1.0, currentGrantHour += generalWorkHour) {
                    }
                }
                requestMap = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), paidHolidayDataDto.getLimitDate());
                currentDay = currentHoldDay + currentGivingDay - currentCancelDay - (currentUseDay += ((Double)requestMap.get("requestDay")).doubleValue());
                if (generalWorkHour > 0) {
                    for (currentTime = currentHoldTime + currentGivingTime - currentCancelTime - (currentUseTime += ((Integer)requestMap.get("requestHour")).intValue()); currentTime < 0 && currentDay >= 1.0; currentDay -= 1.0, currentTime += generalWorkHour) {
                    }
                }
                map.put("CurrentAcquisitionDate", acquisitionDate);
                continue;
            }
            if (!acquisitionDate.before(currentAcquisitionDate)) continue;
            formerHoldDay += paidHolidayDataDto.getHoldDay();
            formerHoldTime += paidHolidayDataDto.getHoldHour();
            formerGivingDay += paidHolidayDataDto.getGivingDay();
            formerGivingTime += paidHolidayDataDto.getGivingHour();
            formerCancelDay += paidHolidayDataDto.getCancelDay();
            formerCancelTime += paidHolidayDataDto.getCancelHour();
            formerUseDay += paidHolidayDataDto.getUseDay();
            formerUseTime += paidHolidayDataDto.getUseHour();
            if (formerGivingDate == null || formerLimitDate == null) {
                formerActivateDate = paidHolidayDataDto.getActivateDate();
                formerLimitDate = paidHolidayDataDto.getLimitDate();
                formerGivingDate = paidHolidayDataDto.getAcquisitionDate();
            }
            if (formerGivingDate.after(paidHolidayDataDto.getAcquisitionDate()) || formerLimitDate.after(paidHolidayDataDto.getLimitDate())) {
                formerActivateDate = paidHolidayDataDto.getActivateDate();
                formerLimitDate = paidHolidayDataDto.getLimitDate();
                formerGivingDate = paidHolidayDataDto.getAcquisitionDate();
            }
            paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataDto.getActivateDate(), targetDate);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                formerGivingDay += paidHolidayTransactionDto.getGivingDay();
                formerGivingTime += paidHolidayTransactionDto.getGivingHour();
                formerCancelDay += paidHolidayTransactionDto.getCancelDay();
                formerCancelTime += paidHolidayTransactionDto.getCancelHour();
            }
            formerGrantDay = formerHoldDay + formerGivingDay - formerCancelDay;
            if (generalWorkHour > 0) {
                for (formerGrantHour = formerHoldTime + formerGivingTime - formerCancelTime; formerGrantHour < 0 && formerGrantDay >= 1.0; formerGrantDay -= 1.0, formerGrantHour += generalWorkHour) {
                }
            }
            requestMap = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), paidHolidayDataDto.getLimitDate());
            formerDay = formerHoldDay + formerGivingDay - formerCancelDay - (formerUseDay += ((Double)requestMap.get("requestDay")).doubleValue());
            if (generalWorkHour > 0) {
                for (formerTime = formerHoldTime + formerGivingTime - formerCancelTime - (formerUseTime += ((Integer)requestMap.get("requestHour")).intValue()); formerTime < 0 && formerDay >= 1.0; formerDay -= 1.0, formerTime += generalWorkHour) {
                }
            }
            map.put("FormerAcquisitionDate", acquisitionDate);
        }
        map.put("CurrentActivateDate", currentActivateDate);
        map.put("CurrentGivingDate", currentGivingDate);
        map.put("CurrentGrantDay", currentGrantDay);
        map.put("CurrentGrantHour", currentGrantHour);
        map.put("CurrentYearDay", currentDay);
        map.put("CurrentTime", currentTime);
        if (map.get("CurrentAcquisitionDate") == null) {
            if (currentDay == 0.0) {
                map.put("CurrentYearDay", null);
            }
            if (currentTime == 0) {
                map.put("CurrentTime", null);
            }
        }
        map.put("CurrentLimitDate", currentLimitDate);
        map.put("FormerActivateDate", formerActivateDate);
        map.put("FormerGivingDate", formerGivingDate);
        map.put("FormerGrantDay", formerGrantDay);
        map.put("FormerGrantHour", formerGrantHour);
        map.put("FormerYearDay", formerDay);
        map.put("FormerTime", formerTime);
        if (map.get("FormerAcquisitionDate") == null) {
            if (formerDay == 0.0) {
                map.put("FormerYearDay", null);
            }
            if (formerTime == 0) {
                map.put("FormerTime", null);
            }
        }
        map.put("formerLimitDate", formerLimitDate);
        map.put("GivingDay", currentGivingDay + formerGivingDay);
        map.put("GivingTime", currentGivingTime + formerGivingTime);
        map.put("CancelDay", currentCancelDay + formerCancelDay);
        map.put("CancelTime", currentCancelTime + formerCancelTime);
        return map;
    }

    public Map<String, Object> getSubordinateFiscalPaidHolidayInfo(HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currentGiveDay", 0.0);
        map.put("currentGiveTime", 0);
        map.put("formerRestDay", 0.0);
        map.put("formerRestTime", 0);
        map.put("termUseHolidayRequestDay", 0.0);
        map.put("termUseHolidayRequestTime", 0);
        map.put("generalWorkHour", 0);
        double currentGiveDay = 0.0;
        int currentGiveTime = 0;
        double formerRestDay = 0.0;
        int formerRestTime = 0;
        double termUseHolidayRequestDay = 0.0;
        int termUseHolidayRequestTime = 0;
        double currentHoldDay = 0.0;
        int currentHoldTime = 0;
        double formerHoldDay = 0.0;
        int formerHoldTime = 0;
        double currentGivingDay = 0.0;
        int currentGivingTime = 0;
        double formerGivingDay = 0.0;
        int formerGivingTime = 0;
        double currentCancelDay = 0.0;
        int currentCancelTime = 0;
        double formerCancelDay = 0.0;
        int formerCancelTime = 0;
        double formerUseDay = 0.0;
        int formerUseTime = 0;
        int generalWorkHour = 0;
        String personalId = humanDto.getPersonalId();
        PaidHolidayDtoInterface paidHolidayDto = this.timeMaster.getPaidHoliday(humanDto, targetDate);
        if (paidHolidayDto == null) {
            return map;
        }
        generalWorkHour = paidHolidayDto.getTimeAcquisitionLimitTimes();
        Date fiscalFirstDate = MonthUtility.getFiscalYearFirstDate((int)displayYear, (MospParams)this.mospParams);
        Date fiscalLastDate = MonthUtility.getFiscalYearLastDate((int)displayYear, (MospParams)this.mospParams);
        Date lastDate = DateUtility.addDay((Date)fiscalFirstDate, (int)-1);
        List paidHolidayDataDtoList = this.paidHolidayDataDao.findForInfoAllList(personalId, lastDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataDtoList) {
            boolean isCurrent;
            Date acquisitionDate = paidHolidayDataDto.getAcquisitionDate();
            if (acquisitionDate.compareTo(targetDate) > 0) continue;
            double restDays = paidHolidayDataDto.getHoldDay();
            int restHours = paidHolidayDataDto.getHoldHour();
            boolean bl = isCurrent = acquisitionDate.compareTo(lastDate) > 0;
            if (isCurrent) {
                currentHoldDay += paidHolidayDataDto.getHoldDay();
                currentHoldTime += paidHolidayDataDto.getHoldHour();
            } else {
                formerHoldDay += paidHolidayDataDto.getHoldDay();
                formerHoldTime += paidHolidayDataDto.getHoldHour();
            }
            List requestList = this.holidayRequest.getUsePaidHolidayDataList(personalId, acquisitionDate);
            List paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, paidHolidayDataDto.getActivateDate(), targetDate);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                if (isCurrent) {
                    currentGivingDay += paidHolidayTransactionDto.getGivingDay();
                    currentGivingTime += paidHolidayTransactionDto.getGivingHour();
                    currentCancelDay += paidHolidayTransactionDto.getCancelDay();
                    currentCancelTime += paidHolidayTransactionDto.getCancelHour();
                } else {
                    formerGivingDay += paidHolidayTransactionDto.getGivingDay();
                    formerGivingTime += paidHolidayTransactionDto.getGivingHour();
                    formerCancelDay += paidHolidayTransactionDto.getCancelDay();
                    formerCancelTime += paidHolidayTransactionDto.getCancelHour();
                }
                restDays += paidHolidayTransactionDto.getGivingDay();
                restHours += paidHolidayTransactionDto.getGivingHour();
                restDays -= paidHolidayTransactionDto.getCancelDay();
                restHours -= paidHolidayTransactionDto.getCancelHour();
            }
            for (HolidayRequestDtoInterface requestDto : requestList) {
                Date requestDate;
                if (!TimeUtility.isPaidHolidayRequest((HolidayRequestDtoInterface)requestDto) || (requestDate = requestDto.getRequestStartDate()).compareTo(fiscalLastDate) > 0) continue;
                if (requestDate.compareTo(lastDate) > 0) {
                    termUseHolidayRequestDay += requestDto.getUseDay();
                    termUseHolidayRequestTime += requestDto.getUseHour();
                } else {
                    formerUseDay += requestDto.getUseDay();
                    formerUseTime += requestDto.getUseHour();
                }
                restDays -= requestDto.getUseDay();
                restHours -= requestDto.getUseHour();
            }
            if (targetDate.compareTo(paidHolidayDataDto.getLimitDate()) <= 0) continue;
            termUseHolidayRequestDay += restDays;
            termUseHolidayRequestTime += restHours;
        }
        currentGiveDay = currentHoldDay + currentGivingDay - currentCancelDay;
        currentGiveTime = currentHoldTime + currentGivingTime - currentCancelTime;
        formerRestDay = formerHoldDay + formerGivingDay - formerCancelDay - formerUseDay;
        formerRestTime = formerHoldTime + formerGivingTime - formerCancelTime - formerUseTime;
        map.put("currentGiveDay", currentGiveDay);
        map.put("currentGiveTime", currentGiveTime);
        map.put("formerRestDay", formerRestDay);
        map.put("formerRestTime", formerRestTime);
        map.put("termUseHolidayRequestDay", termUseHolidayRequestDay);
        map.put("termUseHolidayRequestTime", termUseHolidayRequestTime);
        map.put("generalWorkHour", generalWorkHour);
        return map;
    }

    protected PaidHolidayFirstYearDtoInterface getPaidHolidayFirstYearDto(String personalId, Date targetDate) throws MospException {
        this.entranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (this.entranceDate == null) {
            String errorMes = this.mospParams.getName("Joined");
            this.mospParams.addErrorMessage("PFW0203", new String[]{errorMes});
            return null;
        }
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return null;
        }
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.paidHolidayFirstYearReference.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)this.entranceDate));
        return paidHolidayFirstYearDto;
    }

    public Map<String, Object> getNextGivingInfo(String personalId) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextPlanGivingDate", null);
        map.put("NextPlantYearDay", 0.0);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", null);
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.getPaidHolidayFirstYearDto(personalId, this.getSystemDate());
        if (this.entranceDate == null) {
            return null;
        }
        if (this.paidHolidayDto == null) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            return this.getStandardDay(map, paidHolidayFirstYearDto, personalId, this.entranceDate);
        }
        if (paidHolidayType == 1) {
            return this.getEntranceMonth(map, paidHolidayFirstYearDto, personalId, this.entranceDate);
        }
        if (paidHolidayType == 2) {
            return this.getEntranceDay(map, paidHolidayFirstYearDto, personalId);
        }
        if (paidHolidayType == 4) {
            return this.getProportionallyDay(map, personalId, this.getSystemDate());
        }
        return map;
    }

    public Map<String, Object> getNextGivingInfo(String personalId, Date targetDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextPlanGivingDate", null);
        map.put("NextPlantYearDay", 0.0);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", null);
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return map;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            this.getStandardDayNextGivingInfo(map, personalId, targetDate);
        }
        return map;
    }

    protected Date getFirstYearGivingDate(String personalId, Date targetDate) throws MospException {
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.getPaidHolidayFirstYearDto(personalId, targetDate);
        return this.getFirstYearGivingDate(paidHolidayFirstYearDto, targetDate);
    }

    protected Date getFirstYearGivingDate(PaidHolidayFirstYearDtoInterface dto, Date date) throws MospException {
        if (dto == null) {
            return null;
        }
        if (dto.getGivingAmount() <= 0) {
            return null;
        }
        return this.addDay(DateUtility.addMonth((Date)MonthUtility.getTargetYearMonth((Date)this.entranceDate, (MospParams)this.mospParams), (int)dto.getGivingMonth()), this.paidHolidayDto.getPointDateDay() - 1);
    }

    protected Date getGrantDateOfPreviousFiscalYear(String personalId, Date cutoffDate) throws MospException {
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            Date firstYearGivingDate = this.getFirstYearGivingDate(personalId, cutoffDate);
            if (firstYearGivingDate != null && cutoffDate.before(firstYearGivingDate)) {
                return null;
            }
            int pointMonth = this.paidHolidayDto.getPointDateMonth();
            int pointDay = this.paidHolidayDto.getPointDateDay();
            Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)this.entranceDate), (int)pointMonth, (int)pointDay);
            while (!this.entranceDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            }
            while (firstYearGivingDate != null && !firstYearGivingDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            }
            int count = 2;
            ArrayList<Date> list = new ArrayList<Date>();
            list.add(pointDate);
            while (!cutoffDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
                ++count;
                list.add(pointDate);
            }
            if (count == 2) {
                return firstYearGivingDate;
            }
            return (Date)list.get(count - 3);
        }
        return null;
    }

    protected boolean isGrantDateOfFirstFiscalYear(String personalId, Date cutoffDate, Date acquisitionDate) throws MospException {
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            Date firstYearGivingDate = this.getFirstYearGivingDate(personalId, cutoffDate);
            return firstYearGivingDate != null && !acquisitionDate.after(firstYearGivingDate);
        }
        return false;
    }

    protected Map<String, Object> getStandardDay(Map<String, Object> map, PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto, String personalId, Date entranceDate) throws MospException {
        Date firstYearGivingDate = this.getFirstYearGivingDate(personalId, this.getSystemDate());
        if (firstYearGivingDate != null && this.getSystemDate().before(firstYearGivingDate)) {
            map.put("NextPlanGivingDate", firstYearGivingDate);
            map.put("NextPlantYearDay", paidHolidayFirstYearDto.getGivingAmount());
            map.put("NextPlanTime", 0);
            map.put("NextPlanLimitDate", this.addDay(DateUtility.addMonth((Date)firstYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1));
            return map;
        }
        Date nextYearGivingDate = null;
        double nextYearDay = -1.0;
        Date nextYearLimitDate = null;
        int pointMonth = this.paidHolidayDto.getPointDateMonth();
        int pointDay = this.paidHolidayDto.getPointDateDay();
        Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)entranceDate), (int)pointMonth, (int)pointDay);
        if (!entranceDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        if (firstYearGivingDate != null && !firstYearGivingDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        int count = 2;
        while (!pointDate.after(this.getSystemDate())) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            ++count;
        }
        nextYearGivingDate = pointDate;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)2), -1);
        } else if (maxCarryOverYear == 1) {
            nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)1), -1);
        }
        PaidHolidayPointDateDtoInterface paidHolidayPointDateDto = this.paidHolidayPointDao.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), count);
        nextYearDay = paidHolidayPointDateDto == null ? (double)this.paidHolidayDto.getGeneralPointAmount() : (double)paidHolidayPointDateDto.getPointDateAmount();
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected Map<String, Object> getEntranceMonth(Map<String, Object> map, PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto, String personalId, Date entranceDate) throws MospException {
        int amount;
        int entranceYear = DateUtility.getYear((Date)entranceDate);
        int entranceMonth = DateUtility.getMonth((Date)entranceDate);
        Date nextYearGivingDate = null;
        double nextYearDay = -1.0;
        Date nextYearLimitDate = null;
        if (!this.hasCutoffSettings(personalId, this.getSystemDate())) {
            return null;
        }
        Date pointDate = this.addDay(MonthUtility.getYearMonthTermLastDate((int)entranceYear, (int)entranceMonth, (MospParams)this.mospParams), 1);
        if (this.cutoffDto.getCutoffDate() != 0) {
            pointDate = this.addDay(DateUtility.getDate((int)entranceYear, (int)entranceMonth, (int)this.cutoffDto.getCutoffDate()), 1);
        }
        Date firstYearGivingDate = null;
        if (paidHolidayFirstYearDto != null && (amount = paidHolidayFirstYearDto.getGivingAmount()) > 0) {
            firstYearGivingDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayFirstYearDto.getGivingMonth());
            if (this.getSystemDate().before(firstYearGivingDate)) {
                nextYearGivingDate = firstYearGivingDate;
                nextYearLimitDate = this.addDay(DateUtility.addMonth((Date)nextYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1);
                nextYearDay = amount;
            }
        }
        Date givingDate = null;
        Date maxDate = pointDate;
        int amount2 = 0;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        List list = this.paidHolidayEntranceDateDao.findForList(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate());
        for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
            Date workDate = DateUtility.addMonth((Date)pointDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
            if (firstYearGivingDate != null && !firstYearGivingDate.before(workDate)) continue;
            if (maxDate.before(workDate)) {
                maxDate = workDate;
            }
            if (!workDate.after(this.getSystemDate()) || givingDate != null && !givingDate.after(workDate)) continue;
            givingDate = workDate;
            amount2 = paidHolidayEntranceDateDto.getJoiningDateAmount();
        }
        if (givingDate == null) {
            int generalJoiningMonth = this.paidHolidayDto.getGeneralJoiningMonth();
            if (generalJoiningMonth == 0) {
                return null;
            }
            if (nextYearDay == -1.0) {
                nextYearDay = this.paidHolidayDto.getGeneralJoiningAmount();
            }
            while (!maxDate.after(this.getSystemDate())) {
                maxDate = DateUtility.addMonth((Date)maxDate, (int)generalJoiningMonth);
            }
            if (nextYearGivingDate == null) {
                nextYearGivingDate = maxDate;
            }
            if (nextYearLimitDate == null) {
                if (maxCarryOverYear == 0) {
                    nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)2), -1);
                } else if (maxCarryOverYear == 1) {
                    nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)1), -1);
                }
            }
        }
        if (nextYearDay == -1.0) {
            nextYearDay = amount2;
        }
        if (nextYearGivingDate == null) {
            nextYearGivingDate = givingDate;
        }
        if (nextYearLimitDate == null) {
            if (maxCarryOverYear == 0) {
                nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)2), -1);
            } else if (maxCarryOverYear == 1) {
                nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)1), -1);
            }
        }
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected Map<String, Object> getEntranceDay(Map<String, Object> map, PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto, String personalId) throws MospException {
        int amount;
        Date nextYearGivingDate = null;
        double nextYearDay = -1.0;
        Date nextYearLimitDate = null;
        Date firstYearGivingDate = null;
        if (paidHolidayFirstYearDto != null && (amount = paidHolidayFirstYearDto.getGivingAmount()) > 0) {
            firstYearGivingDate = DateUtility.addMonth((Date)this.entranceDate, (int)paidHolidayFirstYearDto.getGivingMonth());
            if (this.getSystemDate().before(firstYearGivingDate)) {
                nextYearGivingDate = firstYearGivingDate;
                nextYearLimitDate = this.addDay(DateUtility.addMonth((Date)nextYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1);
                nextYearDay = amount;
            }
        }
        Date givingDate = null;
        int amount2 = 0;
        Date maxDate = this.entranceDate;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        List list = this.paidHolidayEntranceDateDao.findForList(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate());
        for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
            Date workDate = DateUtility.addMonth((Date)this.entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
            if (firstYearGivingDate != null && !firstYearGivingDate.before(workDate)) continue;
            if (maxDate.before(workDate)) {
                maxDate = workDate;
            }
            if (!workDate.after(this.getSystemDate()) || givingDate != null && !givingDate.after(workDate)) continue;
            givingDate = workDate;
            amount2 = paidHolidayEntranceDateDto.getJoiningDateAmount();
        }
        if (givingDate == null) {
            int generalJoiningMonth = this.paidHolidayDto.getGeneralJoiningMonth();
            if (generalJoiningMonth == 0) {
                return null;
            }
            if (nextYearDay == -1.0) {
                nextYearDay = this.paidHolidayDto.getGeneralJoiningAmount();
            }
            while (!maxDate.after(this.getSystemDate())) {
                maxDate = DateUtility.addMonth((Date)maxDate, (int)generalJoiningMonth);
            }
            if (nextYearGivingDate == null) {
                nextYearGivingDate = maxDate;
            }
            if (nextYearLimitDate == null) {
                if (maxCarryOverYear == 0) {
                    nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)2), (int)-1);
                } else if (maxCarryOverYear == 1) {
                    nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)1), (int)-1);
                }
            }
        }
        if (nextYearDay == -1.0) {
            nextYearDay = amount2;
        }
        if (nextYearGivingDate == null) {
            nextYearGivingDate = givingDate;
        }
        if (nextYearLimitDate == null) {
            if (maxCarryOverYear == 0) {
                nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)2), (int)-1);
            } else if (maxCarryOverYear == 1) {
                nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)1), (int)-1);
            }
        }
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected Map<String, Object> getProportionallyDay(Map<String, Object> map, String personalId, Date targetDate) throws MospException {
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate);
        Date nextYearGivingDate = this.paidHolidayDataGrant.getGrantDate(personalId, grantTimes + 1);
        double nextYearDay = this.paidHolidayDataGrant.getGrantDaysForProportionally(personalId, nextYearGivingDate, grantTimes + 1);
        Date nextYearLimitDate = this.paidHolidayDataGrant.getExpirationDate(personalId, nextYearGivingDate, grantTimes + 1);
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected void getStandardDayNextGivingInfo(Map<String, Object> map, String personalId, Date targetDate) throws MospException {
        Date userEntranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (userEntranceDate == null) {
            return;
        }
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.paidHolidayFirstYearReference.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)userEntranceDate));
        this.entranceDate = userEntranceDate;
        Date firstYearGivingDate = this.getFirstYearGivingDate(paidHolidayFirstYearDto, userEntranceDate);
        if (firstYearGivingDate != null && targetDate.before(firstYearGivingDate)) {
            map.put("NextPlanGivingDate", firstYearGivingDate);
            map.put("NextPlantYearDay", paidHolidayFirstYearDto.getGivingAmount());
            map.put("NextPlanTime", 0);
            map.put("NextPlanLimitDate", this.addDay(DateUtility.addMonth((Date)firstYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1));
            return;
        }
        int pointYear = DateUtility.getYear((Date)userEntranceDate);
        int pointMonth = this.paidHolidayDto.getPointDateMonth();
        int pointDay = this.paidHolidayDto.getPointDateDay();
        Date pointDate = DateUtility.getDate((int)pointYear, (int)pointMonth, (int)pointDay);
        while (!userEntranceDate.before(pointDate)) {
            pointDate = DateUtility.getDate((int)(++pointYear), (int)pointMonth, (int)pointDay);
        }
        while (firstYearGivingDate != null && !firstYearGivingDate.before(pointDate)) {
            pointDate = DateUtility.getDate((int)(++pointYear), (int)pointMonth, (int)pointDay);
        }
        int count = 2;
        while (!pointDate.after(targetDate)) {
            pointDate = DateUtility.getDate((int)(++pointYear), (int)pointMonth, (int)pointDay);
            ++count;
        }
        Date nextYearGivingDate = pointDate;
        int addLimitYear = 0;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            addLimitYear = 2;
        } else if (maxCarryOverYear == 1) {
            addLimitYear = 1;
        } else {
            return;
        }
        Date nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)addLimitYear), -1);
        double nextYearDay = this.paidHolidayDto.getGeneralPointAmount();
        PaidHolidayPointDateDtoInterface paidHolidayPointDateDto = this.paidHolidayPointDateReference.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), count);
        if (paidHolidayPointDateDto != null) {
            nextYearDay = paidHolidayPointDateDto.getPointDateAmount();
        }
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
    }

    public Date getNextManualGivingDate(String personalId) throws MospException {
        List list = this.paidHolidayTransactionDao.findForNextGiving(personalId, this.getSystemDate());
        if (list.isEmpty()) {
            return null;
        }
        return ((PaidHolidayTransactionDtoInterface)list.get(0)).getActivateDate();
    }

    public String getNextManualGivingDaysAndHours(String personalId) throws MospException {
        Date activateDate = this.getNextManualGivingDate(personalId);
        if (activateDate == null) {
            return null;
        }
        List list = this.paidHolidayTransactionDao.findForList(personalId, activateDate);
        double givingDays = 0.0;
        int givingHours = 0;
        for (PaidHolidayTransactionDtoInterface dto : list) {
            givingDays += dto.getGivingDay();
            givingDays -= dto.getCancelDay();
            givingHours += dto.getGivingHour();
            givingHours -= dto.getCancelHour();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getStringDays(givingDays));
        sb.append(this.mospParams.getName("Day"));
        if (givingHours != 0) {
            sb.append(givingHours);
            sb.append(this.mospParams.getName("Time"));
        }
        return sb.toString();
    }

    public Integer getNumberOfYearsFromEntranceForPaidHolidayGrant(String personalId, Date cutoffDate) throws MospException {
        if (!this.hasPaidHolidaySettings(personalId, cutoffDate)) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            Date firstYearGivingDate = this.getFirstYearGivingDate(personalId, cutoffDate);
            if (firstYearGivingDate != null) {
                Date temporaryDate = DateUtility.addMonth((Date)firstYearGivingDate, (int)(-this.paidHolidayDto.getScheduleGiving()));
                if (DateUtility.addMonth((Date)cutoffDate, (int)1).before(temporaryDate)) {
                    return null;
                }
                if (cutoffDate.before(temporaryDate)) {
                    return 1;
                }
            }
            int pointMonth = this.paidHolidayDto.getPointDateMonth();
            int pointDay = this.paidHolidayDto.getPointDateDay();
            Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)this.entranceDate), (int)pointMonth, (int)pointDay);
            while (!this.entranceDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            }
            while (firstYearGivingDate != null && !firstYearGivingDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            }
            int count = 2;
            while (!cutoffDate.before(pointDate)) {
                pointDate = DateUtility.addYear((Date)pointDate, (int)1);
                ++count;
            }
            Date temporaryDate = DateUtility.addMonth((Date)pointDate, (int)(-this.paidHolidayDto.getScheduleGiving()));
            if (cutoffDate.before(temporaryDate) && !DateUtility.addMonth((Date)cutoffDate, (int)1).before(temporaryDate)) {
                return count;
            }
            return null;
        }
        return null;
    }

    public int[] getHolidayTimeUnitLimit(String personalId, Date targetDate, boolean isStatus, HolidayRequestDtoInterface holidayRequestDto) throws MospException {
        int[] limitDayTime = new int[]{0, 0, 0};
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            this.mospParams.addErrorMessage("TMW0214", new String[]{this.mospParams.getName("PaidVacation", new String[]{"Set"})});
            return limitDayTime;
        }
        Date firstDate = DateUtility.getDate((int)DateUtility.getYear((Date)targetDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
        if (firstDate.after(targetDate)) {
            firstDate = DateUtility.addYear((Date)firstDate, (int)-1);
        }
        Date lastDate = this.addDay(DateUtility.addYear((Date)firstDate, (int)1), -1);
        int limitDay = this.paidHolidayDto.getTimeAcquisitionLimitDays();
        int limitTime = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        if (this.paidHolidayDto.getTimelyPaidHolidayFlag() != 0) {
            return limitDayTime;
        }
        int time = limitDay * limitTime;
        List holidayList = this.holidayRequest.getHolidayRequestListOnWorkflow(personalId, firstDate, lastDate);
        for (HolidayRequestDtoInterface dto : holidayList) {
            if (dto.getHolidayRange() != 4 || holidayRequestDto != null && holidayRequestDto.getTmdHolidayRequestId() == dto.getTmdHolidayRequestId()) continue;
            if (isStatus && this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
                --time;
            }
            if (isStatus || this.workflowIntegrate.isWithDrawn(dto.getWorkflow()) || this.workflowIntegrate.isDraft(dto.getWorkflow())) continue;
            --time;
        }
        limitDayTime[0] = time / limitTime;
        limitDayTime[1] = time % limitTime;
        limitDayTime[2] = limitTime;
        return limitDayTime;
    }

    @Deprecated
    public double getAttendanceRatio(String personalId, Date activateDate, int calculationYear, int calculationMonth, int grant) throws MospException {
        if (!this.hasCutoffSettings(personalId, activateDate)) {
            return 0.0;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            if (!this.hasPaidHolidaySettings(personalId, activateDate)) {
                return 0.0;
            }
            int achievement = 0;
            int totalWorkDays = 0;
            if (grant == 1) {
                Date cutoffMonth = TimeUtility.getCutoffMonth((int)this.cutoffDto.getCutoffDate(), (Date)this.entranceDate);
                int year = DateUtility.getYear((Date)cutoffMonth);
                int month = DateUtility.getMonth((Date)cutoffMonth);
                while (year * 12 + month <= calculationYear * 12 + calculationMonth) {
                    TotalTimeDataDtoInterface dto = this.totalTimeDataDao.findForKey(personalId, year, month);
                    if (dto != null) {
                        achievement += dto.getTimesAchievement();
                        totalWorkDays += dto.getTimesTotalWorkDate();
                    }
                    if (++month != 13) continue;
                    ++year;
                    month = 1;
                }
                int difference = calculationYear * 12 + calculationMonth - (DateUtility.getYear((Date)cutoffMonth) * 12 + DateUtility.getMonth((Date)cutoffMonth));
                if (difference < 5) {
                    List list = TimeUtility.getDateList((Date)this.addDay(activateDate, 1), (Date)this.addDay(DateUtility.addMonth((Date)this.entranceDate, (int)6), -1));
                    for (Date targetDate : list) {
                        if (!this.hasApplicationSettings(personalId, targetDate)) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(this.applicationDto.getScheduleCode(), targetDate);
                        if (scheduleDto == null) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
                        if (scheduleDateDto == null) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        if ("legal_holiday".equals(scheduleDateDto.getWorkTypeCode()) || "prescribed_holiday".equals(scheduleDateDto.getWorkTypeCode())) continue;
                        ++achievement;
                        ++totalWorkDays;
                    }
                }
            } else if (grant >= 2) {
                Date grantDateOfPreviousFiscalYear = this.getGrantDateOfPreviousFiscalYear(personalId, activateDate);
                if (grantDateOfPreviousFiscalYear == null) {
                    grantDateOfPreviousFiscalYear = this.entranceDate;
                }
                Date cutoffMonth = TimeUtility.getCutoffMonth((int)this.cutoffDto.getCutoffDate(), (Date)grantDateOfPreviousFiscalYear);
                int year = DateUtility.getYear((Date)cutoffMonth);
                int month = DateUtility.getMonth((Date)cutoffMonth);
                while (year * 12 + month <= calculationYear * 12 + calculationMonth) {
                    TotalTimeDataDtoInterface dto = this.totalTimeDataDao.findForKey(personalId, year, month);
                    if (dto != null) {
                        achievement += dto.getTimesAchievement();
                        totalWorkDays += dto.getTimesTotalWorkDate();
                    }
                    if (++month != 13) continue;
                    ++year;
                    month = 1;
                }
                int difference = calculationYear * 12 + calculationMonth - (DateUtility.getYear((Date)cutoffMonth) * 12 + DateUtility.getMonth((Date)cutoffMonth));
                if (difference < 11) {
                    List list = TimeUtility.getDateList((Date)this.addDay(activateDate, 1), (Date)this.addDay(DateUtility.addMonth((Date)grantDateOfPreviousFiscalYear, (int)12), -1));
                    for (Date targetDate : list) {
                        if (!this.hasApplicationSettings(personalId, targetDate)) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(this.applicationDto.getScheduleCode(), targetDate);
                        if (scheduleDto == null) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.getScheduleDateInfo(scheduleDto.getScheduleCode(), targetDate);
                        if (scheduleDateDto == null) {
                            ++achievement;
                            ++totalWorkDays;
                            continue;
                        }
                        if ("legal_holiday".equals(scheduleDateDto.getWorkTypeCode()) || "prescribed_holiday".equals(scheduleDateDto.getWorkTypeCode())) continue;
                        ++achievement;
                        ++totalWorkDays;
                    }
                }
            } else {
                return 0.0;
            }
            if (totalWorkDays == 0) {
                return 0.0;
            }
            double percentage = (double)(achievement * 100) / (double)totalWorkDays;
            return percentage;
        }
        return 0.0;
    }

    protected String getStringDays(double days) {
        DecimalFormat df = new DecimalFormat("0.#");
        return df.format(days);
    }

    public Date getOldestGrantDate(String personalId, Date targetDate, double requestDay, int requestHour) throws MospException {
        return null;
    }

    public boolean canPaidHolidayRequest(String personalId, Date targetDate, double requestDay, int requestHour) throws MospException {
        return false;
    }

    public void lockTables() throws MospException {
        super.lockTables();
    }

    public void unlockTable() throws MospException {
        super.unlockTable();
    }

    public void setTimeMasterBean(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

