/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayManagementSearchBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayManagementListDtoInterface;
import jp.mosp.time.dto.settings.impl.PaidHolidayManagementListDto;

public class PaidHolidayManagementSearchBean
extends PlatformBean
implements PaidHolidayManagementSearchBeanInterface {
    private HumanSearchBeanInterface humanSearch;
    private PaidHolidayInfoReferenceBeanInterface paidHolidayInfo;
    private StockHolidayInfoReferenceBeanInterface stockHolidayInfo;
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;

    public PaidHolidayManagementSearchBean() {
    }

    public PaidHolidayManagementSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.paidHolidayInfo = (PaidHolidayInfoReferenceBeanInterface)this.createBean(PaidHolidayInfoReferenceBeanInterface.class);
        this.stockHolidayInfo = (StockHolidayInfoReferenceBeanInterface)this.createBean(StockHolidayInfoReferenceBeanInterface.class);
    }

    public List<PaidHolidayManagementListDtoInterface> getSearchList() throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        List list = this.humanSearch.search();
        ArrayList<PaidHolidayManagementListDtoInterface> paidHolidayManagementList = new ArrayList<PaidHolidayManagementListDtoInterface>();
        for (HumanDtoInterface dto : list) {
            String personalId = dto.getPersonalId();
            PaidHolidayManagementListDto paidHolidayManagementListDto = new PaidHolidayManagementListDto();
            paidHolidayManagementListDto.setPersonalId(personalId);
            paidHolidayManagementListDto.setEmployeeCode(dto.getEmployeeCode());
            paidHolidayManagementListDto.setLastName(dto.getLastName());
            paidHolidayManagementListDto.setFirstName(dto.getFirstName());
            paidHolidayManagementListDto.setSectionCode(dto.getSectionCode());
            paidHolidayManagementListDto.setFormerDate(0.0);
            paidHolidayManagementListDto.setFormerTime(0);
            paidHolidayManagementListDto.setDate(0.0);
            paidHolidayManagementListDto.setTime(0);
            Map map = this.paidHolidayInfo.getPaidHolidayInfo(personalId, this.activateDate);
            paidHolidayManagementListDto.setActivateDate((Date)map.get("ActivateDate"));
            paidHolidayManagementListDto.setFormerDate(((Double)map.get("FormerYearDay")).doubleValue());
            paidHolidayManagementListDto.setFormerTime(((Integer)map.get("FormerTime")).intValue());
            paidHolidayManagementListDto.setDate(((Double)map.get("CurrentYearDay")).doubleValue());
            paidHolidayManagementListDto.setTime(((Integer)map.get("CurrentTime")).intValue());
            double stock = 0.0;
            Double remainDay = this.stockHolidayInfo.getRemainDay(personalId, this.activateDate);
            if (remainDay != null) {
                stock = remainDay;
            }
            paidHolidayManagementListDto.setStockDate(stock);
            paidHolidayManagementList.add((PaidHolidayManagementListDtoInterface)paidHolidayManagementListDto);
        }
        return paidHolidayManagementList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }
}

