/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.dao.settings.RestDaoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdRestDto;

public class RestRegistBean
extends PlatformBean
implements RestRegistBeanInterface {
    protected AttendanceCalcBeanInterface attendanceCalc;
    protected RestDaoInterface dao;

    public RestRegistBean() {
    }

    public RestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (RestDaoInterface)this.createDao(RestDaoInterface.class);
        this.attendanceCalc = (AttendanceCalcBeanInterface)this.createBean(AttendanceCalcBeanInterface.class);
    }

    public RestDtoInterface getInitDto() {
        return new TmdRestDto();
    }

    public void regist(RestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getRest()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void insert(RestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdRestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(RestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
        dto.setTmdRestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(String personalId, Date workDate, int timesWork) throws MospException {
        List list = this.dao.findForList(personalId, workDate, timesWork);
        for (RestDtoInterface dto : list) {
            this.checkDelete((RestDtoInterface)this.dao.findForKey(dto.getTmdRestId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
        }
    }

    public void delete(String personalId, Date workDate, int timesWork, int rest) throws MospException {
        RestDtoInterface dto = this.dao.findForKey(personalId, workDate, timesWork, rest);
        this.checkDelete((RestDtoInterface)this.dao.findForKey(dto.getTmdRestId(), true));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void checkInsert(RestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getRest(), dto.getRestStart(), dto.getRestEnd()));
    }

    protected void checkUpdate(RestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void checkDelete(RestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void validate(RestDtoInterface dto) {
    }

    public int getCalcRestTime(Date restStartTime, Date restEndTime, TimeSettingDtoInterface timeSettingDto) {
        if (restStartTime == null || restEndTime == null || timeSettingDto == null) {
            return 0;
        }
        Date roundRestStartTime = this.attendanceCalc.getRoundMinute(restStartTime, timeSettingDto.getRoundDailyRestStart(), timeSettingDto.getRoundDailyRestStartUnit());
        Date roundRestEndTime = this.attendanceCalc.getRoundMinute(restEndTime, timeSettingDto.getRoundDailyRestEnd(), timeSettingDto.getRoundDailyRestEndUnit());
        return this.attendanceCalc.getRoundMinute(this.attendanceCalc.getDefferenceMinutes(roundRestStartTime, roundRestEndTime), timeSettingDto.getRoundDailyRestTime(), timeSettingDto.getRoundDailyRestTimeUnit());
    }
}

