/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.ScheduleDateRegistBeanInterface;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmScheduleDateDto;

public class ScheduleDateRegistBean
extends PlatformBean
implements ScheduleDateRegistBeanInterface {
    ScheduleDateDaoInterface dao;

    public ScheduleDateRegistBean() {
    }

    public ScheduleDateRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ScheduleDateDaoInterface)this.createDao(ScheduleDateDaoInterface.class);
    }

    public ScheduleDateDtoInterface getInitDto() {
        return new TmmScheduleDateDto();
    }

    public void insert(List<ScheduleDateDtoInterface> list) throws MospException {
        for (ScheduleDateDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmScheduleDateId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void add(List<ScheduleDateDtoInterface> list) throws MospException {
        for (ScheduleDateDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkAdd(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmScheduleDateId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(List<ScheduleDateDtoInterface> list) throws MospException {
        for (ScheduleDateDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            ScheduleDateDtoInterface oldDto = this.dao.findForKey(dto.getScheduleCode(), dto.getScheduleDate());
            if (oldDto != null) {
                boolean workType = oldDto.getWorkTypeCode().equals(dto.getWorkTypeCode());
                boolean remark = oldDto.getRemark().equals(dto.getRemark());
                if (workType && remark) continue;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleDateId());
            dto.setTmmScheduleDateId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) {
    }

    public void delete(String scheduleCode, Date activateDate) throws MospException {
        List list = this.dao.findForList(scheduleCode, activateDate);
        for (ScheduleDateDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleDateId());
        }
    }

    protected void checkInsert(ScheduleDateDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getScheduleCode(), dto.getScheduleDate()));
    }

    protected void checkAdd(ScheduleDateDtoInterface dto) throws MospException {
        this.checkDuplicateScheduleAdd((BaseDtoInterface)this.dao.findForKey(dto.getScheduleCode(), dto.getScheduleDate()));
    }

    protected void checkUpdate(ScheduleDateDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmScheduleDateId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmScheduleDateId(), true))) {
            return;
        }
    }

    protected void checkDelete(ScheduleDateDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmScheduleDateId());
    }

    protected void checkDuplicateScheduleAdd(BaseDtoInterface dto) {
        if (dto != null) {
            this.mospParams.addErrorMessage("TMW0228", new String[0]);
        }
    }

    protected void validate(ScheduleDateDtoInterface dto) {
        String scheduleCodeName = this.mospParams.getName("Calendar", new String[]{"Code"});
        this.checkRequired((Object)dto.getScheduleCode(), scheduleCodeName, null);
    }

    public void allReflectionRegist(List<ScheduleDateDtoInterface> list) throws MospException {
        for (ScheduleDateDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            ScheduleDateDtoInterface oldDto = this.dao.findForKey(dto.getScheduleCode(), dto.getScheduleDate());
            if (oldDto == null) {
                this.checkInsert(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
            } else {
                this.checkUpdate(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                boolean workType = oldDto.getWorkTypeCode().equals(dto.getWorkTypeCode());
                boolean remark = oldDto.getRemark().equals(dto.getRemark());
                if (workType && remark) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleDateId());
            }
            dto.setTmmScheduleDateId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }
}

