/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.ScheduleRegistBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dao.settings.ScheduleDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmScheduleDto;

public class ScheduleRegistBean
extends PlatformBean
implements ScheduleRegistBeanInterface {
    protected static final int LEN_CALENDER_CODE = 10;
    protected static final int LEN_CALENDER_NAME = 15;
    protected static final int LEN_CALENDER_ABBR = 6;
    ScheduleDaoInterface dao;

    public ScheduleRegistBean() {
    }

    public ScheduleRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ScheduleDaoInterface)this.createDao(ScheduleDaoInterface.class);
    }

    public ScheduleDtoInterface getInitDto() {
        return new TmmScheduleDto();
    }

    public void insert(ScheduleDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmScheduleId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(ScheduleDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmScheduleId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(ScheduleDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleId());
        dto.setTmmScheduleId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            ScheduleDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmScheduleId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleId());
            dto.setTmmScheduleId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(ScheduleDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmScheduleId());
    }

    protected void checkInsert(ScheduleDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getScheduleCode()));
    }

    protected void checkAdd(ScheduleDtoInterface dto) throws MospException {
        this.checkDuplicateScheduleAdd((BaseDtoInterface)this.dao.findForKey(dto.getScheduleCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getScheduleCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getScheduleCode(), appList);
    }

    protected void checkUpdate(ScheduleDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmScheduleId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmScheduleId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getScheduleCode());
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getScheduleCode(), appList);
    }

    protected void checkDelete(ScheduleDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmScheduleId());
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmScheduleId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getScheduleCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getScheduleCode(), appList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            ScheduleDtoInterface dto = (ScheduleDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getScheduleCode());
        }
        return list;
    }

    protected void validate(ScheduleDtoInterface dto) {
        String scheduleCodeName = this.mospParams.getName("Calendar", new String[]{"Code"});
        this.checkRequired((Object)dto.getScheduleCode(), scheduleCodeName, null);
        this.checkLength(dto.getScheduleCode(), 10, scheduleCodeName, null);
        String calenderName = this.mospParams.getName("Calendar", new String[]{"Name"});
        this.checkRequired((Object)dto.getScheduleName(), calenderName, null);
        this.checkLength(dto.getScheduleName(), 15, calenderName, null);
        String calendarAbbr = this.mospParams.getName("Calendar", new String[]{"Abbreviation"});
        this.checkRequired((Object)dto.getScheduleAbbr(), calendarAbbr, null);
        this.checkByteLength(dto.getScheduleAbbr(), 6, calendarAbbr, null);
    }

    protected void checkCodeIsUsed(String code, List<ApplicationDtoInterface> list) {
        String codeAdded = "";
        for (ApplicationDtoInterface dto : list) {
            if (!code.equals(dto.getScheduleCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getApplicationCode())) continue;
            this.addCodeIsUsedMessage(code, dto);
            codeAdded = dto.getApplicationCode();
        }
    }

    protected void addCodeIsUsedMessage(String code, ApplicationDtoInterface dto) {
        String columnName = this.mospParams.getProperties().getName("Calendar");
        String[] aryRep = new String[]{code, dto.getApplicationCode(), columnName};
        this.mospParams.addErrorMessage("TMW0226", aryRep);
    }

    protected List<ApplicationDtoInterface> getApplicationListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ApplicationDaoInterface appDao = (ApplicationDaoInterface)this.createDao(ApplicationDaoInterface.class);
        List appList = appDao.findForActivateDate(dto.getActivateDate());
        appList.addAll(appDao.findForCheckTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return appList;
    }

    protected void checkDuplicateScheduleAdd(BaseDtoInterface dto) {
        if (dto != null) {
            this.mospParams.addErrorMessage("TMW0228", new String[0]);
        }
    }
}

