/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.ScheduleTotalReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;

public class ScheduleTotalReferenceBean
extends PlatformBean
implements ScheduleTotalReferenceBeanInterface {
    WorkTypeItemReferenceBeanInterface workTypeItemReference;

    public ScheduleTotalReferenceBean() {
    }

    public ScheduleTotalReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.workTypeItemReference = (WorkTypeItemReferenceBeanInterface)this.createBean(WorkTypeItemReferenceBeanInterface.class);
    }

    public Map<String, Integer> getScheduleTotalInfo(List<ScheduleDateDtoInterface> list) throws MospException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int totalWork = 0;
        int totalRest = 0;
        int timesWork = 0;
        int timesSpecialLeave = 0;
        int timesLegalHoliday = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getWorkTypeCode().equals("prescribed_holiday")) {
                ++timesSpecialLeave;
                continue;
            }
            if (list.get(i).getWorkTypeCode().equals("legal_holiday")) {
                ++timesLegalHoliday;
                continue;
            }
            if (list.get(i).getWorkTypeCode().equals("")) continue;
            Date workTimeDate = this.workTypeItemReference.getWorkTypeItemInfo(list.get(i).getWorkTypeCode(), list.get(i).getScheduleDate(), "WorkTime").getWorkTypeItemValue();
            totalWork = totalWork + DateUtility.getHour((Date)workTimeDate) * 60 + DateUtility.getMinute((Date)workTimeDate);
            Date restTimeDate = this.workTypeItemReference.getWorkTypeItemInfo(list.get(i).getWorkTypeCode(), list.get(i).getScheduleDate(), "RestTime").getWorkTypeItemValue();
            totalRest = totalRest + DateUtility.getHour((Date)restTimeDate) * 60 + DateUtility.getMinute((Date)restTimeDate);
            ++timesWork;
        }
        map.put("TotalWorkTime", totalWork);
        map.put("TotalRestTime", totalRest);
        map.put("TotalTimesWork", timesWork);
        map.put("TotalTimesSpecificHoliday", timesSpecialLeave);
        map.put("TotalTimesLegalHoliday", timesLegalHoliday);
        return map;
    }
}

