/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.StockHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;

public class StockHolidayDataGrantBean
extends TimeApplicationBean
implements StockHolidayDataGrantBeanInterface {
    protected StockHolidayReferenceBeanInterface stockHolidayRefer;
    protected StockHolidayDataReferenceBeanInterface stockHolidayDataRefer;
    protected StockHolidayDataRegistBeanInterface stockHolidayDataRegist;
    protected StockHolidayTransactionReferenceBeanInterface stockHolidayTransactionRefer;
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataRefer;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionRefer;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;

    public StockHolidayDataGrantBean() {
    }

    public StockHolidayDataGrantBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.stockHolidayRefer = (StockHolidayReferenceBeanInterface)this.createBean(StockHolidayReferenceBeanInterface.class);
        this.stockHolidayDataRefer = (StockHolidayDataReferenceBeanInterface)this.createBean(StockHolidayDataReferenceBeanInterface.class);
        this.stockHolidayDataRegist = (StockHolidayDataRegistBeanInterface)this.createBean(StockHolidayDataRegistBeanInterface.class);
        this.stockHolidayTransactionRefer = (StockHolidayTransactionReferenceBeanInterface)this.createBean(StockHolidayTransactionReferenceBeanInterface.class);
        this.paidHolidayDataRefer = (PaidHolidayDataReferenceBeanInterface)this.createBean(PaidHolidayDataReferenceBeanInterface.class);
        this.paidHolidayTransactionRefer = (PaidHolidayTransactionReferenceBeanInterface)this.createBean(PaidHolidayTransactionReferenceBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
    }

    public void grant(String personalId, Date targetDate) throws MospException {
        this.grant(personalId, targetDate, true);
    }

    public void grant(String personalId, Date targetDate, boolean isUpdate) throws MospException {
        this.grant(this.create(personalId, targetDate, isUpdate));
    }

    protected void grant(StockHolidayDataDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        StockHolidayDataDtoInterface stockHolidayDataDto = this.stockHolidayDataRefer.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (stockHolidayDataDto != null) {
            this.stockHolidayDataRegist.delete(stockHolidayDataDto);
        }
        this.stockHolidayDataRegist.insert(dto);
    }

    protected StockHolidayDataDtoInterface create(String personalId, Date targetDate, boolean isUpdate) throws MospException {
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return null;
        }
        StockHolidayDtoInterface stockHolidayDto = this.stockHolidayRefer.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate());
        if (stockHolidayDto == null) {
            return null;
        }
        Date paidHolidayExpirationDate = this.getPaidHolidayExpirationDate(personalId, targetDate);
        if (paidHolidayExpirationDate == null) {
            return null;
        }
        Date grantDate = this.getGrantDate(paidHolidayExpirationDate);
        if (!isUpdate && this.stockHolidayDataRefer.findForKey(personalId, grantDate, grantDate) != null) {
            return null;
        }
        StockHolidayDataDtoInterface dto = this.stockHolidayDataRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setAcquisitionDate(grantDate);
        dto.setActivateDate(grantDate);
        dto.setLimitDate(this.getExpirationDate(stockHolidayDto, grantDate));
        dto.setHoldDay(this.getGrantDays(stockHolidayDto, personalId, paidHolidayExpirationDate));
        dto.setGivingDay(0.0);
        dto.setCancelDay(0.0);
        dto.setUseDay(0.0);
        return dto;
    }

    protected Date getGrantDate(Date paidHolidayExpirationDate) {
        return this.addDay(paidHolidayExpirationDate, 1);
    }

    protected Date getExpirationDate(StockHolidayDtoInterface dto, Date grantDate) {
        return this.addDay(DateUtility.addMonth((Date)grantDate, (int)dto.getStockLimitDate()), -1);
    }

    protected double getGrantDays(StockHolidayDtoInterface dto, String personalId, Date paidHolidayExpirationDate) throws MospException {
        double remainderDays = this.getRemainderDay(personalId, paidHolidayExpirationDate);
        double paidHolidayRemainderDays = this.getPaidHolidayRemainderDay(personalId, paidHolidayExpirationDate);
        double grantDays = paidHolidayRemainderDays;
        if (grantDays > (double)dto.getStockYearAmount()) {
            grantDays = dto.getStockYearAmount();
        }
        if (remainderDays >= (double)dto.getStockTotalAmount()) {
            return 0.0;
        }
        if (remainderDays + grantDays > (double)dto.getStockTotalAmount()) {
            return (double)dto.getStockTotalAmount() - remainderDays;
        }
        return grantDays;
    }

    protected double getRemainderDay(String personalId, Date targetDate) throws MospException {
        double totalDay = 0.0;
        List stockHolidayDataList = this.stockHolidayDataRefer.findForInfoList(personalId, targetDate);
        for (StockHolidayDataDtoInterface stockHolidayDataDto : stockHolidayDataList) {
            double givingDay = 0.0;
            double cancelDay = 0.0;
            List stockHolidayTransactionList = this.stockHolidayTransactionRefer.findForList(stockHolidayDataDto.getPersonalId(), stockHolidayDataDto.getAcquisitionDate(), stockHolidayDataDto.getActivateDate(), targetDate);
            for (StockHolidayTransactionDtoInterface stockHolidayTransactionDto : stockHolidayTransactionList) {
                givingDay += stockHolidayTransactionDto.getGivingDay();
                cancelDay += stockHolidayTransactionDto.getCancelDay();
            }
            Map map = this.holidayRequestRefer.getApprovedDayHour(stockHolidayDataDto.getPersonalId(), stockHolidayDataDto.getAcquisitionDate(), 1, Integer.toString(2), stockHolidayDataDto.getActivateDate(), targetDate);
            double useDay = (Double)map.get("approvedDay");
            double day = stockHolidayDataDto.getHoldDay() + givingDay - cancelDay - useDay;
            totalDay += day;
        }
        return totalDay;
    }

    protected Date getPaidHolidayExpirationDate(String personalId, Date targetDate) throws MospException {
        PaidHolidayDataDtoInterface dto = this.paidHolidayDataRefer.findForExpirationDateInfo(personalId, targetDate);
        if (dto == null) {
            return null;
        }
        return dto.getLimitDate();
    }

    protected double getPaidHolidayRemainderDay(String personalId, Date expirationDate) throws MospException {
        double totalDay = 0.0;
        List paidHolidayDataList = this.paidHolidayDataRefer.findForExpirationDateList(personalId, expirationDate);
        for (PaidHolidayDataDtoInterface paidHolidayDataDto : paidHolidayDataList) {
            double givingDay = 0.0;
            int givingHour = 0;
            double cancelDay = 0.0;
            int cancelHour = 0;
            List paidHolidayTransactionList = this.paidHolidayTransactionRefer.findForList(paidHolidayDataDto.getPersonalId(), paidHolidayDataDto.getAcquisitionDate(), paidHolidayDataDto.getActivateDate(), paidHolidayDataDto.getLimitDate());
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionList) {
                givingDay += paidHolidayTransactionDto.getGivingDay();
                givingHour += paidHolidayTransactionDto.getGivingHour();
                cancelDay += paidHolidayTransactionDto.getCancelDay();
                cancelHour += paidHolidayTransactionDto.getCancelHour();
            }
            Map map = this.holidayRequestRefer.getRequestDayHour(paidHolidayDataDto.getPersonalId(), paidHolidayDataDto.getAcquisitionDate(), 1, Integer.toString(1), paidHolidayDataDto.getActivateDate(), paidHolidayDataDto.getLimitDate());
            double useDay = (Double)map.get("requestDay");
            int useHour = (Integer)map.get("requestHour");
            double day = paidHolidayDataDto.getHoldDay() + givingDay - cancelDay - useDay;
            ApplicationDtoInterface applicationDto = this.applicationRefer.findForPerson(paidHolidayDataDto.getPersonalId(), paidHolidayDataDto.getLimitDate());
            this.applicationRefer.chkExistApplication(applicationDto, paidHolidayDataDto.getLimitDate());
            if (this.mospParams.hasErrorMessage()) {
                return 0.0;
            }
            PaidHolidayDtoInterface dto = this.paidHolidayRefer.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), paidHolidayDataDto.getLimitDate());
            this.paidHolidayRefer.chkExistPaidHoliday(dto, paidHolidayDataDto.getLimitDate());
            if (this.mospParams.hasErrorMessage()) {
                return 0.0;
            }
            if (dto.getTimeAcquisitionLimitTimes() <= 0) {
                totalDay += day;
                continue;
            }
            for (int hour = paidHolidayDataDto.getHoldHour() + givingHour - cancelHour - useHour; day >= 1.0 && hour < 0; day -= 1.0, hour += dto.getTimeAcquisitionLimitTimes()) {
            }
            totalDay += day;
        }
        return totalDay;
    }
}

