/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.StockHolidayRegistBeanInterface;
import jp.mosp.time.dao.settings.StockHolidayDaoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmStockHolidayDto;

public class StockHolidayRegistBean
extends PlatformBean
implements StockHolidayRegistBeanInterface {
    StockHolidayDaoInterface dao;

    public StockHolidayRegistBean() {
    }

    public StockHolidayRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (StockHolidayDaoInterface)this.createDao(StockHolidayDaoInterface.class);
    }

    public StockHolidayDtoInterface getInitDto() {
        return new TmmStockHolidayDto();
    }

    public void insert(StockHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(StockHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(StockHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmStockHolidayId());
        dto.setTmmStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            StockHolidayDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmStockHolidayId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmStockHolidayId());
            dto.setTmmStockHolidayId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(StockHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmStockHolidayId());
    }

    protected void checkInsert(StockHolidayDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPaidHolidayCode()));
    }

    protected void checkAdd(StockHolidayDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPaidHolidayCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPaidHolidayCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    protected void checkUpdate(StockHolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmStockHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmStockHolidayId(), true))) {
            return;
        }
    }

    protected void checkDelete(StockHolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmStockHolidayId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPaidHolidayCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            StockHolidayDtoInterface dto = (StockHolidayDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getPaidHolidayCode());
        }
        return list;
    }

    protected void validate(StockHolidayDtoInterface dto) {
    }
}

