/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayExportBeanInterface;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class SubHolidayExportBean
extends PlatformBean
implements SubHolidayExportBeanInterface {
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected SubHolidayReferenceBeanInterface subHolidayReference;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected TimeSettingReferenceBeanInterface timeSettingReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected HumanSearchBeanInterface humanSearch;
    protected SectionReferenceBeanInterface sectionReference;
    protected List<HumanDtoInterface> humanList;
    private int ckbNeedLowerSection = 0;

    public SubHolidayExportBean() {
    }

    public SubHolidayExportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDao(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDao(ExportFieldDaoInterface.class);
        this.subHolidayReference = (SubHolidayReferenceBeanInterface)this.createBean(SubHolidayReferenceBeanInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.sectionReference = (SectionReferenceBeanInterface)this.createBean(SectionReferenceBeanInterface.class);
    }

    public void export(String exportCode, int startYear, int startMonth, int endYear, int endMonth, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, int ckbNeedLowerSection, String positionCode) throws MospException {
        Date endDate;
        this.ckbNeedLowerSection = ckbNeedLowerSection;
        ExportDtoInterface dto = this.exportDao.findForKey(exportCode);
        if (dto == null) {
            this.addNoExportDataMessage();
            return;
        }
        CutoffDtoInterface cutoffDto = this.cutoffUtil.getCutoff(cutoffCode, startYear, startMonth);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date startDate = TimeUtility.getCutoffFirstDate((int)cutoffDto.getCutoffDate(), (int)startYear, (int)startMonth);
        List list = this.getCsvDataList(dto, startDate, endDate = TimeUtility.getCutoffLastDate((int)cutoffDto.getCutoffDate(), (int)endYear, (int)endMonth), cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (list.isEmpty()) {
            this.addNoExportDataMessage();
            return;
        }
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)list));
        this.setFileName(dto, startDate, endDate);
    }

    protected List<String[]> getCsvDataList(ExportDtoInterface dto, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List fieldList = this.exportFieldDao.findForList(dto.getExportCode());
        this.searchHumanData(list, fieldList, startDate, endDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        this.addSubHolidayData(list, fieldList, startDate, endDate);
        if (dto.getHeader() != 0) {
            this.addHeader(list, fieldList, endDate);
        }
        return list;
    }

    protected void addHeader(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date targetDate) throws MospException {
        String[] header = new String[fieldList.size()];
        for (int i = 0; i < header.length; ++i) {
            header[i] = this.getCodeName(fieldList.get(i).getFieldName(), "export_tmd_sub_holiday");
        }
        csvDataList.add(0, header);
    }

    protected void searchHumanData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(endDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("");
        if (this.ckbNeedLowerSection == 1) {
            this.humanSearch.setNeedLowerSection(true);
        } else {
            this.humanSearch.setNeedLowerSection(false);
        }
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        List allHumanList = this.humanSearch.search();
        if (cutoffCode.isEmpty()) {
            this.humanList = allHumanList;
            return;
        }
        this.humanList = new ArrayList();
        for (HumanDtoInterface humanDto : allHumanList) {
            TimeSettingDtoInterface timeSettingDto;
            ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(humanDto.getPersonalId(), endDate);
            if (applicationDto == null || (timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), endDate)) == null || !cutoffCode.equals(timeSettingDto.getCutoffCode())) continue;
            this.humanList.add(humanDto);
        }
    }

    protected void addSubHolidayData(List<String[]> csvDataList, List<ExportFieldDtoInterface> fieldList, Date startDate, Date endDate) throws MospException {
        Integer employeeCodeIndex = null;
        Integer fullNameIndex = null;
        Integer sectionNameIndex = null;
        Integer sectionDisplayIndex = null;
        Integer workDateIndex = null;
        Integer subHolidayTypeIndex = null;
        Integer requestDate1Index = null;
        Integer requestDate2Index = null;
        for (ExportFieldDtoInterface dto : fieldList) {
            int index = dto.getFieldOrder() - 1;
            if ("employee_code".equals(dto.getFieldName())) {
                employeeCodeIndex = index;
                continue;
            }
            if ("full_name".equals(dto.getFieldName())) {
                fullNameIndex = index;
                continue;
            }
            if ("section_name".equals(dto.getFieldName())) {
                sectionNameIndex = index;
                continue;
            }
            if ("section_display".equals(dto.getFieldName())) {
                sectionDisplayIndex = index;
                continue;
            }
            if ("work_date".equals(dto.getFieldName())) {
                workDateIndex = index;
                continue;
            }
            if ("sub_holiday_type".equals(dto.getFieldName())) {
                subHolidayTypeIndex = index;
                continue;
            }
            if ("request_date1".equals(dto.getFieldName())) {
                requestDate1Index = index;
                continue;
            }
            if (!"request_date2".equals(dto.getFieldName())) continue;
            requestDate2Index = index;
        }
        for (HumanDtoInterface humanDto : this.humanList) {
            List list = this.subHolidayReference.getSubHolidayList(humanDto.getPersonalId(), startDate, endDate);
            for (SubHolidayDtoInterface subHolidayDto : list) {
                Date[] requestDateArray = this.getRequestDateArray(subHolidayDto.getPersonalId(), subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType());
                String[] csvData = new String[fieldList.size()];
                if (employeeCodeIndex != null) {
                    csvData[employeeCodeIndex.intValue()] = humanDto.getEmployeeCode();
                }
                if (fullNameIndex != null) {
                    csvData[fullNameIndex.intValue()] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
                }
                if (sectionNameIndex != null) {
                    csvData[sectionNameIndex.intValue()] = this.sectionReference.getSectionName(humanDto.getSectionCode(), subHolidayDto.getWorkDate());
                }
                if (sectionDisplayIndex != null) {
                    csvData[sectionDisplayIndex.intValue()] = this.sectionReference.getSectionDisplay(humanDto.getSectionCode(), subHolidayDto.getWorkDate());
                }
                if (workDateIndex != null) {
                    csvData[workDateIndex.intValue()] = this.getStringDate(subHolidayDto.getWorkDate());
                }
                if (subHolidayTypeIndex != null) {
                    StringBuffer sb = new StringBuffer();
                    int subHolidayType = subHolidayDto.getSubHolidayType();
                    if (subHolidayType == 2) {
                        sb.append(this.mospParams.getName("Legal"));
                    } else if (subHolidayType == 1) {
                        sb.append(this.mospParams.getName("Prescribed"));
                    } else {
                        if (subHolidayType != 3) continue;
                        sb.append(this.mospParams.getName("Midnight"));
                    }
                    sb.append(this.mospParams.getName("FrontParentheses"));
                    double subHolidayDays = subHolidayDto.getSubHolidayDays();
                    if (Double.compare(subHolidayDays, 1.0) == 0) {
                        sb.append(this.mospParams.getName("AllTime"));
                    } else {
                        if (Double.compare(subHolidayDays, 0.5) != 0) continue;
                        sb.append(this.mospParams.getName("HalfTime"));
                    }
                    sb.append(this.mospParams.getName("BackParentheses"));
                    csvData[subHolidayTypeIndex.intValue()] = sb.toString();
                }
                if (requestDate1Index != null) {
                    csvData[requestDate1Index.intValue()] = this.getStringDate(requestDateArray[0]);
                }
                if (requestDate2Index != null) {
                    csvData[requestDate2Index.intValue()] = this.getStringDate(requestDateArray[1]);
                }
                csvDataList.add(csvData);
            }
        }
    }

    protected void setFileName(ExportDtoInterface dto, Date startDate, Date endDate) {
        String hyphen = this.mospParams.getName("Hyphen");
        String exportCode = "";
        String fileExtension = "";
        if (dto != null) {
            if (dto.getExportCode() != null) {
                exportCode = dto.getExportCode();
            }
            if ("1".equals(dto.getType())) {
                fileExtension = ".csv";
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(exportCode);
        sb.append(hyphen);
        sb.append(DateUtility.getStringYear((Date)startDate));
        sb.append(DateUtility.getStringMonth((Date)startDate));
        sb.append(DateUtility.getStringDay((Date)startDate));
        sb.append(hyphen);
        sb.append(DateUtility.getStringYear((Date)endDate));
        sb.append(DateUtility.getStringMonth((Date)endDate));
        sb.append(DateUtility.getStringDay((Date)endDate));
        sb.append(fileExtension);
        this.mospParams.setFileName(sb.toString());
    }

    protected Date[] getRequestDateArray(String personalId, Date workDate, int timesWork, int subHolidayType) throws MospException {
        Date[] requestDateArray = new Date[2];
        List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, workDate, timesWork, subHolidayType);
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
            if (!this.workflowIntegrate.isCompleted(subHolidayRequestDto.getWorkflow())) continue;
            int holidayRange = subHolidayRequestDto.getHolidayRange();
            if (holidayRange == 1) {
                requestDateArray[0] = subHolidayRequestDto.getRequestDate();
                requestDateArray[1] = subHolidayRequestDto.getRequestDate();
                return requestDateArray;
            }
            if (holidayRange != 2 && holidayRange != 3) continue;
            if (requestDateArray[0] == null) {
                requestDateArray[0] = subHolidayRequestDto.getRequestDate();
                continue;
            }
            requestDateArray[1] = subHolidayRequestDto.getRequestDate();
        }
        return requestDateArray;
    }

    protected void addNoExportDataMessage() {
        String rep = this.mospParams.getName("Export", new String[]{"Information"});
        this.mospParams.addErrorMessage("PFW0201", new String[]{rep});
    }
}

