/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;

public class SubHolidayReferenceBean
extends TimeBean
implements SubHolidayReferenceBeanInterface {
    protected SubHolidayDaoInterface dao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected AttendanceDaoInterface attendanceDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected TimeSettingReferenceBeanInterface timeSettingReference;

    public SubHolidayReferenceBean() {
    }

    public SubHolidayReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (SubHolidayDaoInterface)this.createDao(SubHolidayDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
    }

    public String[][] getSelectArray(String personalId, Date targetDate, String holidayRange, SubHolidayRequestDtoInterface dto) throws MospException {
        String frontWithCornerParentheses = this.mospParams.getName("FrontWithCornerParentheses");
        String backWithCornerParentheses = this.mospParams.getName("BackWithCornerParentheses");
        double subHolidayDays = 0.0;
        if ("1".equals(holidayRange)) {
            subHolidayDays = 1.0;
        } else if ("2".equals(holidayRange) || "3".equals(holidayRange)) {
            subHolidayDays = 0.5;
        } else {
            return this.getNoObjectDataPulldown();
        }
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, targetDate);
        this.applicationReference.chkExistApplication(applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return this.getNoObjectDataPulldown();
        }
        TimeSettingDtoInterface timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), targetDate);
        this.timeSettingReference.chkExistTimeSetting(timeSettingDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return this.getNoObjectDataPulldown();
        }
        TreeMap<String, SubHolidayDtoInterface> map = new TreeMap<String, SubHolidayDtoInterface>();
        List subHolidayList = this.dao.getSubHolidayList(personalId, DateUtility.addDay((Date)DateUtility.addMonth((Date)targetDate, (int)(-timeSettingDto.getSubHolidayLimitMonth())), (int)(-timeSettingDto.getSubHolidayLimitDate())), targetDate, subHolidayDays);
        for (SubHolidayDtoInterface subHolidayDto : subHolidayList) {
            TimeSettingDtoInterface tempTimeSettingDto;
            WorkflowDtoInterface workflowDto;
            AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(subHolidayDto.getPersonalId(), subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork());
            if (attendanceDto == null || (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())) == null || !this.workflowIntegrate.isCompleted(workflowDto)) continue;
            ApplicationDtoInterface subHolidayApplicationDto = this.applicationReference.findForPerson(personalId, subHolidayDto.getWorkDate());
            TimeSettingDtoInterface subHolidayTimeSettingDto = timeSettingDto;
            if (subHolidayApplicationDto != null && (tempTimeSettingDto = this.timeSettingReference.getTimeSettingInfo(subHolidayApplicationDto.getWorkSettingCode(), subHolidayDto.getWorkDate())) != null) {
                subHolidayTimeSettingDto = tempTimeSettingDto;
            }
            Date limitDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)subHolidayDto.getWorkDate(), (int)subHolidayTimeSettingDto.getSubHolidayLimitMonth()), (int)subHolidayTimeSettingDto.getSubHolidayLimitDate());
            StringBuffer sb = new StringBuffer();
            sb.append(DateUtility.getStringYear((Date)limitDate));
            sb.append(DateUtility.getStringMonth((Date)limitDate));
            sb.append(DateUtility.getStringDay((Date)limitDate));
            sb.append(DateUtility.getStringYear((Date)subHolidayDto.getWorkDate()));
            sb.append(DateUtility.getStringMonth((Date)subHolidayDto.getWorkDate()));
            sb.append(DateUtility.getStringDay((Date)subHolidayDto.getWorkDate()));
            sb.append(subHolidayDto.getSubHolidayType());
            map.put(sb.toString(), subHolidayDto);
        }
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        ArrayList<String> holidayRangeList = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            SubHolidayDtoInterface subHolidayDto = (SubHolidayDtoInterface)entry.getValue();
            double count = 0.0;
            List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType());
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
                WorkflowDtoInterface subHolidayRequestWorkflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (subHolidayRequestWorkflowDto == null || this.workflowIntegrate.isDraft(subHolidayRequestWorkflowDto) || this.workflowIntegrate.isWithDrawn(subHolidayRequestWorkflowDto) || dto != null && subHolidayRequestDto.getTmdSubHolidayRequestId() == dto.getTmdSubHolidayRequestId()) continue;
                int subHolidayRange = subHolidayRequestDto.getHolidayRange();
                if (subHolidayRange == 1) {
                    count += 1.0;
                    continue;
                }
                if (subHolidayRange != 2 && subHolidayRange != 3) continue;
                count += 0.5;
            }
            double notUseDay = subHolidayDto.getSubHolidayDays() - count;
            if (notUseDay < subHolidayDays) continue;
            list.add(subHolidayDto);
            if (notUseDay >= 1.0) {
                holidayRangeList.add(frontWithCornerParentheses + this.mospParams.getName("AllTime") + backWithCornerParentheses);
                continue;
            }
            if (notUseDay >= 0.5) {
                holidayRangeList.add(frontWithCornerParentheses + this.mospParams.getName("HalfTime") + backWithCornerParentheses);
                continue;
            }
            return this.getNoObjectDataPulldown();
        }
        if (list.size() != holidayRangeList.size()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), false);
        int i = 0;
        for (SubHolidayDtoInterface subHolidayDto : list) {
            array[i][0] = DateUtility.getStringDate((Date)subHolidayDto.getWorkDate()) + "," + subHolidayDto.getSubHolidayType();
            StringBuffer sb = new StringBuffer();
            sb.append(frontWithCornerParentheses);
            int subHolidayType = subHolidayDto.getSubHolidayType();
            if (subHolidayType == 1) {
                sb.append(this.mospParams.getName("Prescribed"));
            } else if (subHolidayType == 2) {
                sb.append(this.mospParams.getName("Legal"));
            } else {
                if (subHolidayType != 3) continue;
                sb.append(this.mospParams.getName("Midnight"));
            }
            sb.append(backWithCornerParentheses);
            sb.append(this.getStringDate(subHolidayDto.getWorkDate()));
            sb.append((String)holidayRangeList.get(i));
            array[i][1] = sb.toString();
            ++i;
        }
        return array;
    }

    public List<SubHolidayDtoInterface> getSubHolidayList(String personalId, Date startDate, Date endDate) throws MospException {
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface dto : this.dao.getSubHolidayList(personalId, startDate, endDate, 0.5)) {
            AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork());
            if (attendanceDto == null || !this.workflowIntegrate.isCompleted(attendanceDto.getWorkflow())) continue;
            list.add(dto);
        }
        return list;
    }

    public double getPossibleRequestDays(String personalId, Date targetDate) throws MospException {
        double days = 0.0;
        List list = this.getSubHolidayList(personalId, targetDate);
        for (SubHolidayDtoInterface dto : list) {
            double requestDays = 0.0;
            List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, dto.getWorkDate(), dto.getTimesWork(), dto.getSubHolidayType());
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (workflowDto == null || this.workflowIntegrate.isDraft(workflowDto) || this.workflowIntegrate.isWithDrawn(workflowDto)) continue;
                int subHolidayRange = subHolidayRequestDto.getHolidayRange();
                if (subHolidayRange == 1) {
                    requestDays += 1.0;
                    continue;
                }
                if (subHolidayRange != 2 && subHolidayRange != 3) continue;
                requestDays += 0.5;
            }
            double remainDays = dto.getSubHolidayDays() - requestDays;
            if (remainDays < 0.5) continue;
            days += remainDays;
        }
        return days;
    }

    public List<SubHolidayDtoInterface> getSubHolidayList(String personalId, Date targetDate) throws MospException {
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, targetDate);
        if (applicationDto == null) {
            return list;
        }
        TimeSettingDtoInterface timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), targetDate);
        if (timeSettingDto == null) {
            return list;
        }
        List subHolidayList = this.dao.getSubHolidayList(personalId, DateUtility.addDay((Date)DateUtility.addMonth((Date)targetDate, (int)(-timeSettingDto.getSubHolidayLimitMonth())), (int)(-timeSettingDto.getSubHolidayLimitDate())), targetDate, 0.5);
        for (SubHolidayDtoInterface subHolidayDto : subHolidayList) {
            WorkflowDtoInterface workflowDto;
            AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(subHolidayDto.getPersonalId(), subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork());
            if (attendanceDto == null || (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())) == null || !this.workflowIntegrate.isCompleted(workflowDto)) continue;
            list.add(subHolidayDto);
        }
        return list;
    }

    public Float[] getBirthSubHolidayTimes(String personalId, Date startDate, Date endDate) throws MospException {
        Float[] days = new Float[]{null, null, null};
        double prescribed = 0.0;
        double legal = 0.0;
        double midnight = 0.0;
        List list = this.dao.findSubHolidayList(personalId, startDate, endDate);
        for (SubHolidayDtoInterface dto : list) {
            WorkflowDtoInterface workflowDto;
            AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(personalId, dto.getWorkDate(), 1);
            if (attendanceDto == null || (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())) == null || !this.workflowIntegrate.isCompleted(workflowDto)) continue;
            if (dto.getSubHolidayType() == 1) {
                prescribed += dto.getSubHolidayDays();
                continue;
            }
            if (dto.getSubHolidayType() == 2) {
                legal += dto.getSubHolidayDays();
                continue;
            }
            if (dto.getSubHolidayType() != 3) continue;
            midnight += dto.getSubHolidayDays();
        }
        days[0] = Float.valueOf((float)prescribed);
        days[1] = Float.valueOf((float)legal);
        days[2] = Float.valueOf((float)midnight);
        return days;
    }
}

