/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.impl.HumanSearchBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.SubordinateFiscalSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.SubordinateFiscalListDto;

public class SubordinateFiscalSearchBean
extends HumanSearchBean
implements SubordinateFiscalSearchBeanInterface {
    protected TotalTimeCalcBeanInterface totalTimeCalc;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected PlatformMasterBeanInterface platformMaster;
    protected TotalTimeReferenceBeanInterface totalTimeRefer;
    protected PaidHolidayInfoReferenceBeanInterface paidHolidayInfo;
    protected StockHolidayInfoReferenceBeanInterface stockHolidayInfo;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;
    protected HolidayDataDaoInterface holidayDataDao;
    protected AttendanceReferenceBeanInterface attendanceRefer;
    protected TimeMasterBeanInterface timeMaster;
    protected int displayYear;
    protected int targetYear;
    protected int targetMonth;
    protected String humanType;
    protected String TYPE_APPLICANTS_APPROVE = "1";
    protected String TYPE_SUBORDINATE = "2";

    public SubordinateFiscalSearchBean() {
    }

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeCalc = (TotalTimeCalcBeanInterface)this.createBean(TotalTimeCalcBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBean(PlatformMasterBeanInterface.class);
        this.paidHolidayInfo = (PaidHolidayInfoReferenceBeanInterface)this.createBean(PaidHolidayInfoReferenceBeanInterface.class);
        this.stockHolidayInfo = (StockHolidayInfoReferenceBeanInterface)this.createBean(StockHolidayInfoReferenceBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBean(HolidayRequestReferenceBeanInterface.class);
        this.holidayDataDao = (HolidayDataDaoInterface)this.createDao(HolidayDataDaoInterface.class);
        this.totalTimeRefer = (TotalTimeReferenceBeanInterface)this.createBean(TotalTimeReferenceBeanInterface.class);
        this.attendanceRefer = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
        this.paidHolidayInfo.setTimeMasterBean(this.timeMaster);
    }

    public SubordinateFiscalSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public List<SubordinateFiscalListDtoInterface> getSubordinateFiscalList() throws MospException {
        List humanList;
        List<HumanDtoInterface> resultList = new ArrayList();
        this.setEmployeeCodeType("forward");
        this.setSubordinateParams();
        if (this.humanType.isEmpty()) {
            resultList = this.search();
            this.setOperationType(null);
            humanList = this.search();
            List approvalList = this.getApprovaleForApplicantList(humanList);
            Set resultSet = PlatformUtility.getPersonalIdSet(resultList);
            for (HumanDtoInterface humanDto : approvalList) {
                if (resultSet.contains(humanDto.getPersonalId())) continue;
                resultList.add(humanDto);
            }
        }
        if (this.humanType.equals(this.TYPE_APPLICANTS_APPROVE)) {
            this.setOperationType(null);
            humanList = this.search();
            resultList = this.getApprovaleForApplicantList(humanList);
        }
        if (this.humanType.equals(this.TYPE_SUBORDINATE)) {
            resultList = this.search();
        }
        return this.subordinateFiscalList(resultList);
    }

    public List<SubordinateFiscalListDtoInterface> subordinateFiscalList(List<HumanDtoInterface> humanList) throws MospException {
        ArrayList<SubordinateFiscalListDtoInterface> subordinateFiscalList = new ArrayList<SubordinateFiscalListDtoInterface>();
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)this.displayYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)this.displayYear, (MospParams)this.mospParams);
        Date searchEndDate = this.getEndTargetDate(firstDate, lastDate);
        ArrayList errorMessageList = new ArrayList(this.mospParams.getErrorMessageList());
        for (HumanDtoInterface humanDto : humanList) {
            Date applicationTargetDate;
            ApplicationDtoInterface applicationDto = this.timeMaster.getApplication(humanDto, applicationTargetDate = MonthUtility.getYearMonthTermLastDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams));
            if (applicationDto == null) continue;
            String personalId = humanDto.getPersonalId();
            SubordinateFiscalListDto dto = new SubordinateFiscalListDto();
            List attendanceList = this.attendanceRefer.getAttendanceList(humanDto.getPersonalId(), firstDate, lastDate);
            Map totalMap = this.totalTimeRefer.findFiscalMap(personalId, firstDate, lastDate);
            if (!attendanceList.isEmpty() || totalMap != null && !totalMap.isEmpty()) {
                this.setOverTime((SubordinateFiscalListDtoInterface)dto, totalMap, personalId, firstDate);
            } else {
                dto.setOverTime(Integer.valueOf(0));
            }
            this.setPaidHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, this.displayYear, searchEndDate);
            this.setStockHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, this.displayYear, searchEndDate);
            this.setHoliday((SubordinateFiscalListDtoInterface)dto, personalId, firstDate, lastDate);
            this.setHuman((SubordinateFiscalListDtoInterface)dto, humanDto);
            subordinateFiscalList.add((SubordinateFiscalListDtoInterface)dto);
        }
        this.mospParams.getErrorMessageList().clear();
        this.mospParams.getErrorMessageList().addAll(errorMessageList);
        return subordinateFiscalList;
    }

    protected void setOverTime(SubordinateFiscalListDtoInterface dto, Map<Integer, TotalTimeDataDtoInterface> totalMap, String personalId, Date firstDate) throws MospException {
        Integer overTime = 0;
        for (int i = 0; i < 12; ++i) {
            Date targetDate = DateUtility.addMonth((Date)firstDate, (int)i);
            int year = DateUtility.getYear((Date)targetDate);
            int month = DateUtility.getMonth((Date)targetDate);
            TotalTimeDataDtoInterface totalTimeDto = totalMap.get(month);
            if (totalTimeDto == null) {
                totalTimeDto = this.totalTimeCalc.calc(personalId, year, month, false);
            }
            overTime = overTime + totalTimeDto.getOvertime();
        }
        dto.setOverTime(overTime);
    }

    protected void setPaidHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        double paidHolidayDays = 0.0;
        int paidHolidayTime = 0;
        double paidHolidayRestDays = 0.0;
        int paidHolidayRestTime = 0;
        Map map = this.paidHolidayInfo.getSubordinateFiscalPaidHolidayInfo(humanDto, displayYear, targetDate);
        int generalWorkHour = (Integer)map.get("generalWorkHour");
        paidHolidayDays = (Double)map.get("currentGiveDay") + (Double)map.get("formerRestDay");
        if (generalWorkHour > 0) {
            for (paidHolidayTime = (Integer)map.get("currentGiveTime") + (Integer)map.get("formerRestTime"); paidHolidayTime < 0 && paidHolidayDays >= 1.0; paidHolidayDays -= 1.0, paidHolidayTime += generalWorkHour) {
            }
        }
        double termUseHolidayRequestDay = (Double)map.get("termUseHolidayRequestDay");
        int termUseHolidayRequestTime = (Integer)map.get("termUseHolidayRequestTime");
        paidHolidayRestDays = paidHolidayDays - termUseHolidayRequestDay;
        if (generalWorkHour > 0) {
            for (paidHolidayRestTime = paidHolidayTime - termUseHolidayRequestTime; paidHolidayRestTime < 0 && paidHolidayRestDays >= 1.0; paidHolidayRestDays -= 1.0, paidHolidayRestTime += generalWorkHour) {
            }
        }
        dto.setPaidHolidayDays(Double.valueOf(paidHolidayDays));
        dto.setPaidHolidayTime(Integer.valueOf(paidHolidayTime));
        dto.setPaidHolidayRestDays(Double.valueOf(paidHolidayRestDays));
        dto.setPaidHolidayRestTime(Integer.valueOf(paidHolidayRestTime));
    }

    protected void setStockHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, int displayYear, Date targetDate) throws MospException {
        double stockHolidayDays = 0.0;
        double stockHolidayRestDays = 0.0;
        Map map = this.stockHolidayInfo.getSubordinateFiscalStockHolidayInfo(humanDto, displayYear, targetDate);
        stockHolidayDays = (Double)map.get("currentGiveDay") + (Double)map.get("formerRestDay");
        double termUseHolidayRequestDay = (Double)map.get("termUseHolidayRequestDay");
        stockHolidayRestDays = stockHolidayDays - termUseHolidayRequestDay;
        dto.setStockHolidayDays(Double.valueOf(stockHolidayDays));
        dto.setStockHolidayRestDays(Double.valueOf(stockHolidayRestDays));
    }

    protected void setHoliday(SubordinateFiscalListDtoInterface dto, String personalId, Date firstDate, Date lastDate) throws MospException {
        Double holidayDays = 0.0;
        Double holidayRestDays = 0.0;
        String seasonCode = this.mospParams.getApplicationProperty("SeasonHolidayCode");
        List list = this.holidayDataDao.findPersonTerm(personalId, firstDate, lastDate, 2);
        for (HolidayDataDtoInterface dataDto : list) {
            if (!dataDto.getHolidayCode().equals(seasonCode)) continue;
            holidayDays = holidayDays + dataDto.getGivingDay();
            holidayDays = holidayDays - dataDto.getCancelDay();
        }
        List requestList = this.holidayRequestRefer.getHolidayRequestListOnWorkflow(personalId, firstDate, lastDate);
        for (HolidayRequestDtoInterface requestDto : requestList) {
            if (requestDto.getHolidayType1() != 2 || !requestDto.getHolidayType2().equals(seasonCode)) continue;
            holidayRestDays = holidayRestDays + requestDto.getUseDay();
        }
        dto.setSeasonHolidayDays(holidayDays);
        dto.setSeasonHolidayRestDays(Double.valueOf(holidayDays - holidayRestDays));
    }

    public void setHuman(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto) {
        if (humanDto == null) {
            return;
        }
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setSectionCode(humanDto.getSectionCode());
    }

    protected List<HumanDtoInterface> getApprovaleForApplicantList(List<HumanDtoInterface> humanList) throws MospException {
        if (this.mospParams.getUserRole().isSuper()) {
            return humanList;
        }
        ArrayList<HumanDtoInterface> list = new ArrayList<HumanDtoInterface>();
        Set routeSet = this.workflowIntegrate.getApproverRouteSet(this.mospParams.getUser().getPersonalId(), this.targetDate);
        for (HumanDtoInterface humanDto : humanList) {
            if (!this.isApprovable(humanDto, routeSet)) continue;
            list.add(humanDto);
        }
        return list;
    }

    protected boolean isApprovable(HumanDtoInterface humanDto, Set<String> routeSet) throws MospException {
        int workflowType = 1;
        RouteApplicationDtoInterface dto = this.platformMaster.getRouteApplication(humanDto, this.targetDate, workflowType);
        if (dto == null) {
            return false;
        }
        return routeSet.contains(dto.getRouteCode());
    }

    protected void setSubordinateParams() {
        this.setStateType("presence");
        this.setNeedLowerSection(true);
        this.setNeedConcurrent(true);
        this.setOperationType("1");
    }

    protected Date getEndTargetDate(Date startDate, Date endDate) {
        if (DateUtility.isTermContain((Date)this.getSystemDate(), (Date)startDate, (Date)endDate)) {
            return this.getSystemDate();
        }
        if (this.getSystemDate().compareTo(startDate) < 0) {
            return startDate;
        }
        if (this.getSystemDate().compareTo(endDate) > 0) {
            return endDate;
        }
        return this.getSystemDate();
    }

    public void setDisplayYear(int displayYear) {
        this.displayYear = displayYear;
    }

    public void setTargetYear(int targetYear) {
        this.targetYear = targetYear;
    }

    public void setTargetMonth(int targetMonth) {
        this.targetMonth = targetMonth;
    }

    public void setHumanType(String humanType) {
        this.humanType = humanType;
    }
}

