/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.impl.HumanSearchBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.utils.PlatformNamingUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.LimitStandardReferenceBeanInterface;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeTransactionReferenceBeanInterface;
import jp.mosp.time.bean.impl.TotalTimeEntityReferenceBean;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.dto.settings.impl.SubordinateListDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestDetectEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class SubordinateSearchBean
extends HumanSearchBean
implements SubordinateSearchBeanInterface {
    public static final String LIMIT_STANDARD_TERM_MONTH1 = "month1";
    protected TotalTimeDataDaoInterface totalTimeDataDao;
    protected TotalTimeCorrectionReferenceBeanInterface totalTimeCorrection;
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeTransaction;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected TotalTimeTransactionReferenceBeanInterface totalTimeTransactionRefer;
    protected TotalTimeEntityReferenceBean totalTimeEntityRefer;
    protected LimitStandardReferenceBeanInterface limitStandardReference;
    protected PlatformMasterBeanInterface platformMaster;
    protected TimeMasterBeanInterface timeMaster;
    protected int targetYear;
    protected int targetMonth;
    protected String approval;
    protected String approvalBeforeDay;
    protected String calc;
    protected String humanType;
    protected String TYPE_APPLICANTS_APPROVE = "1";
    protected String TYPE_SUBORDINATE = "2";

    public SubordinateSearchBean() {
    }

    public SubordinateSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeDataDao = (TotalTimeDataDaoInterface)this.createDao(TotalTimeDataDaoInterface.class);
        this.totalTimeCorrection = (TotalTimeCorrectionReferenceBeanInterface)this.createBean(TotalTimeCorrectionReferenceBeanInterface.class);
        this.totalTimeEmployeeTransaction = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBean(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.totalTimeTransactionRefer = (TotalTimeTransactionReferenceBeanInterface)this.createBean(TotalTimeTransactionReferenceBeanInterface.class);
        this.totalTimeEntityRefer = (TotalTimeEntityReferenceBean)this.createBean(TotalTimeEntityReferenceBean.class);
        this.limitStandardReference = (LimitStandardReferenceBeanInterface)this.createBean(LimitStandardReferenceBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBean(PlatformMasterBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBean(TimeMasterBeanInterface.class);
        this.totalTimeEntityRefer.setPlatformMasterBean(this.platformMaster);
        this.totalTimeEntityRefer.setTimeMasterBean(this.timeMaster);
    }

    public List<SubordinateListDtoInterface> getSubordinateList() throws MospException {
        List humanList;
        List<HumanDtoInterface> resultList = new ArrayList();
        this.setEmployeeCodeType("forward");
        this.setSubordinateParams();
        if (this.humanType.isEmpty()) {
            resultList = this.search();
            this.setOperationType(null);
            humanList = this.search();
            List approvalList = this.getApprovaleForApplicantList(humanList);
            Set resultSet = PlatformUtility.getPersonalIdSet(resultList);
            for (HumanDtoInterface humanDto : approvalList) {
                if (resultSet.contains(humanDto.getPersonalId())) continue;
                resultList.add(humanDto);
            }
        }
        if (this.humanType.equals(this.TYPE_APPLICANTS_APPROVE)) {
            this.setOperationType(null);
            humanList = this.search();
            resultList = this.getApprovaleForApplicantList(humanList);
        }
        if (this.humanType.equals(this.TYPE_SUBORDINATE)) {
            resultList = this.search();
        }
        return this.getSubordinateList(resultList);
    }

    protected List<HumanDtoInterface> getApprovaleForApplicantList(List<HumanDtoInterface> humanList) throws MospException {
        if (this.mospParams.getUserRole().isSuper()) {
            return humanList;
        }
        ArrayList<HumanDtoInterface> list = new ArrayList<HumanDtoInterface>();
        Set routeSet = this.workflowIntegrate.getApproverRouteSet(this.mospParams.getUser().getPersonalId(), this.targetDate);
        for (HumanDtoInterface humanDto : humanList) {
            if (!this.isApprovable(humanDto, routeSet)) continue;
            list.add(humanDto);
        }
        return list;
    }

    protected boolean isApprovable(HumanDtoInterface humanDto, Set<String> routeSet) throws MospException {
        int workflowType = 1;
        RouteApplicationDtoInterface dto = this.platformMaster.getRouteApplication(humanDto, this.targetDate, workflowType);
        if (dto == null) {
            return false;
        }
        return routeSet.contains(dto.getRouteCode());
    }

    public Set<String> getSubordinateIdSet() throws MospException {
        this.setSubordinateParams();
        this.setEmployeeCodeType("forward");
        return this.getPersonalIdSet();
    }

    protected void setSubordinateParams() {
        this.setStateType("presence");
        this.setNeedLowerSection(true);
        this.setNeedConcurrent(true);
        this.setOperationType("1");
    }

    protected List<SubordinateListDtoInterface> getSubordinateList(List<HumanDtoInterface> humanList) throws MospException {
        ArrayList<SubordinateListDtoInterface> subordinateList = new ArrayList<SubordinateListDtoInterface>();
        boolean searchBeforeDay = this.approvalBeforeDay.equals("1");
        for (HumanDtoInterface humanDto : humanList) {
            String personalId;
            TotalTimeDataDtoInterface totalTimeDto;
            SubordinateListDtoInterface dto = this.getSubordinateListDto(humanDto, this.targetYear, this.targetMonth, totalTimeDto = this.totalTimeDataDao.findForKey(personalId = humanDto.getPersonalId(), this.targetYear, this.targetMonth), searchBeforeDay);
            if (!this.isApprovalConditionMatch(dto) || !this.isCalcConditionMatch(dto)) continue;
            subordinateList.add(dto);
        }
        return subordinateList;
    }

    protected String getApprovalStateName(boolean isApprovableExist, boolean isAppliableExist) {
        if (isAppliableExist && this.isAppliableExistShow()) {
            return this.mospParams.getName("Ram", new String[]{"Register"});
        }
        if (isApprovableExist) {
            return PlatformNamingUtility.exsistAbbr((MospParams)this.mospParams);
        }
        return PlatformNamingUtility.notExsistAbbr((MospParams)this.mospParams);
    }

    protected String getApprovalStateClass(boolean isApprovableExist, boolean isAppliableExist) {
        if (isAppliableExist && this.isAppliableExistShow()) {
            return "RedLabel";
        }
        if (isApprovableExist) {
            return "RedLabel";
        }
        return "BlueLabel";
    }

    protected boolean isAppliableExistShow() {
        return this.mospParams.getApplicationPropertyBool("ShowAppliableExist");
    }

    protected String getCutoffStateClass(int cutoffState) {
        switch (cutoffState) {
            case 0: {
                return "RedLabel";
            }
            case 1: {
                return "BlueLabel";
            }
            case 2: {
                return "BlackLabel";
            }
        }
        return "";
    }

    protected boolean isApprovalConditionMatch(SubordinateListDtoInterface dto) {
        if (dto == null) {
            return false;
        }
        if (this.approval == null || this.approval.isEmpty()) {
            return true;
        }
        int condition = this.getInteger(this.approval);
        if (condition == 0) {
            return !dto.isApprovableExist();
        }
        if (condition == 1) {
            return dto.isApprovableExist();
        }
        if (condition == 2) {
            return dto.isAppliableExist();
        }
        if (condition == 3) {
            return dto.isApprovableExist() || dto.isAppliableExist();
        }
        return false;
    }

    protected boolean isCalcConditionMatch(SubordinateListDtoInterface dto) {
        if (dto == null) {
            return false;
        }
        if (this.calc == null || this.calc.isEmpty()) {
            return true;
        }
        return this.calc.equals(String.valueOf(dto.getCutoffState()));
    }

    public void setTargetYear(int targetYear) {
        this.targetYear = targetYear;
    }

    public void setTargetMonth(int targetMonth) {
        this.targetMonth = targetMonth;
    }

    public void setApproval(String approval) {
        this.approval = approval;
    }

    public void setApprovalBeforeDay(String approvalBeforeDay) {
        this.approvalBeforeDay = approvalBeforeDay;
    }

    public void setCalc(String calc) {
        this.calc = calc;
    }

    public void setHumanType(String humanType) {
        this.humanType = humanType;
    }

    public SubordinateListDtoInterface getSubordinateListDto(HumanDtoInterface humanDto, int year, int month, TotalTimeDataDtoInterface totalTimeDataDto, boolean searchBeforeDay) throws MospException {
        if (humanDto == null) {
            return null;
        }
        ApplicationEntity applicationEntity = this.timeMaster.getApplicationEntity(humanDto, year, month);
        if (!applicationEntity.isValid()) {
            return null;
        }
        int cutoffDate = applicationEntity.getCutoffDate();
        Date cutoffLastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)year, (int)month);
        if (!this.isEntered(humanDto.getPersonalId(), cutoffLastDate) || this.timeMaster.getApplication(this.getHumanInfo(humanDto.getPersonalId(), cutoffLastDate), cutoffLastDate) == null) {
            return null;
        }
        String workSettingCode = applicationEntity.getWorkSettingCode();
        SubordinateListDto dto = new SubordinateListDto();
        dto.setTargetYear(year);
        dto.setTargetMonth(month);
        this.setHuman((SubordinateListDtoInterface)dto, humanDto);
        this.setTotalTimeData((SubordinateListDtoInterface)dto, totalTimeDataDto);
        this.setApprovalState((SubordinateListDtoInterface)dto, cutoffDate, searchBeforeDay);
        this.setCutoffState((SubordinateListDtoInterface)dto);
        this.setCorrection((SubordinateListDtoInterface)dto);
        this.setLimitStandard((SubordinateListDtoInterface)dto, workSettingCode);
        return dto;
    }

    public void setHuman(SubordinateListDtoInterface dto, HumanDtoInterface humanDto) {
        if (humanDto == null) {
            return;
        }
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setSectionCode(humanDto.getSectionCode());
    }

    protected void setApprovalState(SubordinateListDtoInterface dto, int cutoffDate, boolean searchBeforeDay) throws MospException {
        String personalId = dto.getPersonalId();
        int targetYear = dto.getTargetYear();
        int targetMonth = dto.getTargetMonth();
        RequestDetectEntityInterface entity = this.totalTimeEntityRefer.getRequestDetectEntity(personalId, targetYear, targetMonth, cutoffDate);
        if (searchBeforeDay) {
            entity.setBeforeDay(this.getSystemDate());
        }
        boolean isApprovableExist = entity.isApprovableExist(true);
        boolean isAppliableExist = entity.isAppliableExist(true);
        dto.setApprovableExist(isApprovableExist);
        dto.setAppliableExist(isAppliableExist);
        dto.setApproval(this.getApprovalStateName(isApprovableExist, isAppliableExist));
        dto.setApprovalStateClass(this.getApprovalStateClass(isApprovableExist, isAppliableExist));
    }

    protected void setCutoffState(SubordinateListDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        int targetYear = dto.getTargetYear();
        int targetMonth = dto.getTargetMonth();
        int cutoffState = this.getCutoffState(personalId, targetYear, targetMonth);
        dto.setCutoffState(cutoffState);
        dto.setCalc(this.getCodeName(cutoffState, "CutoffState"));
        dto.setCutoffStateClass(this.getCutoffStateClass(cutoffState));
    }

    protected void setCorrection(SubordinateListDtoInterface dto) throws MospException {
        int targetMonth;
        int targetYear;
        String personalId = dto.getPersonalId();
        TotalTimeCorrectionDtoInterface totalTimeCorrectionDto = this.totalTimeCorrection.getLatestTotalTimeCorrectionInfo(personalId, targetYear = dto.getTargetYear(), targetMonth = dto.getTargetMonth());
        if (totalTimeCorrectionDto == null) {
            dto.setCorrection("");
            return;
        }
        if (totalTimeCorrectionDto.getCorrectionPersonalId().equals(dto.getPersonalId())) {
            dto.setCorrection(this.mospParams.getName("CorrectionHistory"));
            return;
        }
        dto.setCorrection(this.mospParams.getName("Other"));
    }

    public void setTotalTimeData(SubordinateListDtoInterface dto, TotalTimeDataDtoInterface totalTimeDataDto) {
        if (totalTimeDataDto == null) {
            return;
        }
        dto.setWorkDate(Double.valueOf(totalTimeDataDto.getTimesWorkDate()));
        dto.setWorkTime(Integer.valueOf(totalTimeDataDto.getWorkTime()));
        dto.setRestTime(Integer.valueOf(totalTimeDataDto.getRestTime()));
        dto.setPrivateTime(Integer.valueOf(totalTimeDataDto.getPrivateTime()));
        dto.setLateTime(Integer.valueOf(totalTimeDataDto.getLateTime()));
        dto.setLeaveEarlyTime(Integer.valueOf(totalTimeDataDto.getLeaveEarlyTime()));
        dto.setLateLeaveEarlyTime(Integer.valueOf(totalTimeDataDto.getLateTime() + totalTimeDataDto.getLeaveEarlyTime()));
        dto.setOverTimeIn(Integer.valueOf(totalTimeDataDto.getOvertimeIn()));
        dto.setOverTimeOut(Integer.valueOf(totalTimeDataDto.getOvertimeOut()));
        dto.setWorkOnHolidayTime(Integer.valueOf(totalTimeDataDto.getWorkOnHoliday()));
        dto.setLateNightTime(Integer.valueOf(totalTimeDataDto.getLateNight()));
        dto.setPaidHoliday(Double.valueOf(totalTimeDataDto.getTimesPaidHoliday()));
        dto.setPaidHolidayHour(totalTimeDataDto.getPaidHolidayHour());
        dto.setTotalSpecialHoliday(totalTimeDataDto.getTotalSpecialHoliday());
        dto.setTotalOtherHoliday(totalTimeDataDto.getTotalOtherHoliday());
        dto.setTimesCompensation(totalTimeDataDto.getTimesCompensation());
        dto.setAllHoliday(Double.valueOf(totalTimeDataDto.getTotalSpecialHoliday() + totalTimeDataDto.getTotalOtherHoliday() + totalTimeDataDto.getTimesCompensation()));
        dto.setAbsence(Double.valueOf(totalTimeDataDto.getTotalAbsence()));
        dto.setTimesWork(totalTimeDataDto.getTimesWork());
        dto.setTimesLate(totalTimeDataDto.getTimesLate());
        dto.setTimesLeaveEarly(totalTimeDataDto.getTimesLeaveEarly());
        dto.setTimesOvertime(totalTimeDataDto.getTimesOvertime());
        dto.setTimesWorkingHoliday(totalTimeDataDto.getTimesWorkingHoliday());
        dto.setTimesLegalHoliday(totalTimeDataDto.getTimesLegalHoliday());
        dto.setTimesSpecificHoliday(totalTimeDataDto.getTimesSpecificHoliday());
        dto.setTimesHolidaySubstitute(totalTimeDataDto.getTimesHolidaySubstitute());
    }

    public void setLimitStandard(SubordinateListDtoInterface dto, HumanDtoInterface humanDto) throws MospException {
        ApplicationEntity applicationEntity = this.timeMaster.getApplicationEntity(humanDto, dto.getTargetYear(), dto.getTargetMonth());
        if (!applicationEntity.isValid()) {
            return;
        }
        this.setLimitStandard(dto, applicationEntity.getWorkSettingCode());
    }

    protected void setLimitStandard(SubordinateListDtoInterface dto, String workSettingCode) throws MospException {
    }

    protected int getCutoffState(String personalId, int targetYear, int targetMonth) throws MospException {
        TotalTimeEmployeeDtoInterface totalTimeEmployeeDto = this.totalTimeEmployeeTransaction.findForKey(personalId, targetYear, targetMonth);
        if (totalTimeEmployeeDto == null) {
            return 0;
        }
        String cutoffCode = totalTimeEmployeeDto.getCutoffCode();
        int cutoffState = this.totalTimeTransactionRefer.getStoredCutoffState(targetYear, targetMonth, cutoffCode);
        if (cutoffState == 2) {
            return 2;
        }
        return totalTimeEmployeeDto.getCutoffState();
    }
}

