/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.ScheduleDaoInterface;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubstituteDto;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.utils.TimeNamingUtility;

public class SubstituteRegistBean
extends PlatformBean
implements SubstituteRegistBeanInterface {
    protected SubstituteDaoInterface dao;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayRefer;
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected DifferenceRequestDaoInterface differenceRequestDao;
    protected AttendanceDaoInterface attendanceDao;
    protected WorkflowDaoInterface workflowDao;
    protected ScheduleDaoInterface scheduleDao;
    protected ScheduleDateDaoInterface scheduleDateDao;
    protected ApplicationReferenceBeanInterface application;
    protected TimeSettingReferenceBeanInterface timeSettingReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected WorkTypeReferenceBeanInterface workTypeRefer;
    protected WorkTypeItemReferenceBeanInterface workTypeItemRefer;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReference;

    public SubstituteRegistBean() {
    }

    public SubstituteRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDao(HolidayRequestDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDao(SubHolidayRequestDaoInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDao(OvertimeRequestDaoInterface.class);
        this.differenceRequestDao = (DifferenceRequestDaoInterface)this.createDao(DifferenceRequestDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDao(AttendanceDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.scheduleDao = (ScheduleDaoInterface)this.createDao(ScheduleDaoInterface.class);
        this.scheduleDateDao = (ScheduleDateDaoInterface)this.createDao(ScheduleDateDaoInterface.class);
        this.application = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.timeSettingReference = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.workTypeItemRefer = (WorkTypeItemReferenceBeanInterface)this.createBean(WorkTypeItemReferenceBeanInterface.class);
        this.workOnHolidayRefer = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.workTypeChangeReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
    }

    public SubstituteDtoInterface getInitDto() {
        return new TmdSubstituteDto();
    }

    public void insert(SubstituteDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdSubstituteId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(long workflow) throws MospException {
        List list = this.dao.findForWorkflow(workflow);
        for (SubstituteDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdSubstituteId());
        }
    }

    protected void checkInsert(SubstituteDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getSubstituteDate(), dto.getSubstituteRange(), dto.getWorkDate(), dto.getTimesWork()));
    }

    protected void checkDelete(SubstituteDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdSubstituteId());
    }

    public void validate(SubstituteDtoInterface dto) throws MospException {
        this.substituteReference.chkBasicInfo(dto.getPersonalId(), dto.getSubstituteDate());
    }

    public void checkValidate(SubstituteDtoInterface dto) {
        this.checkRequired((Object)dto.getSubstituteDate(), this.mospParams.getName("Transfer", new String[]{"Day"}), null);
    }

    public void checkRegist(SubstituteDtoInterface dto) throws MospException {
        this.checkSuspension(dto);
        this.checkRetirement(dto);
        this.checkTargetTransferDate(dto);
        this.checkHolidayDate(dto);
        this.checkTransferDateRange(dto);
        this.checkRequest(dto);
        this.checkAttendance(dto);
        this.checkTighten(dto);
        this.checkOverTime(dto);
        this.checkWorkTypeChange(dto);
        this.checkHalfRequest(dto);
    }

    public void checkImport(SubstituteDtoInterface dto) throws MospException {
        this.checkValidate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetirement(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspension(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTighten(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkOnDaysOff(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTransferDateRange(dto);
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getSubstituteDate());
        this.checkWorkType(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDuplicate(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(requestUtil);
    }

    protected void checkWorkType(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        Date targetDate;
        String personalId = dto.getPersonalId();
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate = dto.getSubstituteDate(), requestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if (this.isLegalDayOff(workTypeCode) || this.isPrescribedDayOff(workTypeCode)) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("WorkingHoliday"));
        }
    }

    protected void checkDuplicate(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        int holidayRange;
        boolean substituteRangeAm = false;
        boolean substituteRangePm = false;
        boolean holidayRangeAm = false;
        boolean holidayRangePm = false;
        boolean holidayRangeTime = false;
        boolean subHolidayRangeAm = false;
        boolean subHolidayRangePm = false;
        List substituteList = this.dao.findForList(dto.getPersonalId(), dto.getSubstituteDate());
        for (SubstituteDtoInterface substituteDto : substituteList) {
            long workflow = substituteDto.getWorkflow();
            if (this.workflowIntegrate.isWithDrawn(workflow) || dto.getWorkflow() == workflow || !this.isLegalDayOff(substituteDto.getSubstituteType()) && !this.isPrescribedDayOff(substituteDto.getSubstituteType())) continue;
            int range = substituteDto.getSubstituteRange();
            if (range == 1) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
            if (range == 2) {
                substituteRangeAm = true;
                continue;
            }
            if (range != 3) continue;
            substituteRangePm = true;
        }
        if (substituteRangeAm && substituteRangePm) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        int substituteRange = dto.getSubstituteRange();
        if (substituteRange == 1) {
            if (substituteRangeAm || substituteRangePm) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
        } else if (substituteRange == 2) {
            if (subHolidayRangeAm) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
        } else if (substituteRange == 3 && substituteRangePm) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if ((holidayRange = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(false))) == 1 || holidayRange == 5) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Vacation"));
            return;
        }
        if (holidayRange == 2) {
            holidayRangeAm = true;
        } else if (holidayRange == 3) {
            holidayRangePm = true;
        } else if (holidayRange == 4) {
            holidayRangeTime = true;
        }
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 1 || subHolidayRange == 5) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayRangeAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayRangePm = true;
        }
        if ((substituteRangeAm || holidayRangeAm || subHolidayRangeAm) && (substituteRangePm || holidayRangePm || subHolidayRangePm)) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if (substituteRange == 1) {
            if (holidayRangeAm || holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (substituteRange == 2) {
            if (holidayRangeAm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (substituteRange == 3) {
            if (holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Vacation"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        }
        if (substituteRange == 1) {
            if (subHolidayRangeAm || subHolidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (substituteRange == 2) {
            if (subHolidayRangeAm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (substituteRange == 3 && subHolidayRangePm) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        int range = dto.getSubstituteRange();
        if (substituteRange == 2) {
            if (substituteRangePm || holidayRangePm || subHolidayRangePm) {
                range = 1;
            }
        } else if (substituteRange == 3 && (substituteRangeAm || holidayRangeAm || subHolidayRangeAm)) {
            range = 1;
        }
        this.checkOvertimeWorkRequest(dto, requestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChangeRequest(requestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDifferenceRequest(requestUtil, range);
    }

    public void checkTargetTransferDate(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        if (dto == null) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        int substituteRange = dto.getSubstituteRange();
        boolean substituteFlag = false;
        List substituteList = this.dao.findForList(personalId, substituteDate);
        for (SubstituteDtoInterface substituteDto : substituteList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow() || (workflowDto = this.workflowDao.findForKey(substituteDto.getWorkflow())) == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            substituteFlag = true;
            if (!"legal_holiday".equals(substituteDto.getSubstituteType()) && !"prescribed_holiday".equals(substituteDto.getSubstituteType()) || substituteDto.getSubstituteRange() != 1 && substituteRange != substituteDto.getSubstituteRange()) break;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
        if (!substituteFlag) {
            ApplicationDtoInterface applicationDto = this.application.findForPerson(personalId, substituteDate);
            if (applicationDto == null) {
                this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Set", new String[]{"Apply"}), null});
                return;
            }
            ScheduleDtoInterface scheduleDto = this.scheduleDao.findForInfo(applicationDto.getScheduleCode(), substituteDate);
            if (scheduleDto == null) {
                this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Calendar"), null});
                return;
            }
            ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateDao.findForKey(scheduleDto.getScheduleCode(), substituteDate);
            if (scheduleDateDto == null) {
                this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Calendar", new String[]{"Data"}), null});
                return;
            }
            if (scheduleDateDto.getWorkTypeCode() == null || scheduleDateDto.getWorkTypeCode().isEmpty() || this.isLegalDayOff(scheduleDateDto.getWorkTypeCode()) || this.isPrescribedDayOff(scheduleDateDto.getWorkTypeCode())) {
                String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0242", aryRep);
                return;
            }
        }
        for (SubstituteDtoInterface substituteDto : substituteList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow() || (workflowDto = this.workflowDao.findForKey(substituteDto.getWorkflow())) == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            int range = substituteDto.getSubstituteRange();
            if (substituteRange == 1 || range == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (range != 2 && range != 3 || range != substituteRange) continue;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
        List holidayRequestList = this.holidayRequestDao.findForList(personalId, substituteDate);
        for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
            WorkflowDtoInterface workflowDto2 = this.workflowDao.findForKey(holidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2)) continue;
            int holidayRange = holidayRequestDto.getHolidayRange();
            if (substituteRange == 1 || holidayRange == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (holidayRange == 2 || holidayRange == 3) {
                if (holidayRange != substituteRange) continue;
                String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0242", aryRep);
                return;
            }
            if (holidayRange != 4) continue;
            this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
            return;
        }
        List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, substituteDate);
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
            WorkflowDtoInterface workflowDto3 = this.workflowDao.findForKey(subHolidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto3) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto3)) continue;
            int holidayRange = subHolidayRequestDto.getHolidayRange();
            if (substituteRange == 1 || holidayRange == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (holidayRange != 2 && holidayRange != 3 || holidayRange != substituteRange) continue;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
    }

    protected void checkOvertimeWorkRequest(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1) {
            return;
        }
        if (requestUtil.getOverTimeList(false).isEmpty()) {
            return;
        }
        this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("OvertimeWork"));
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1) {
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = requestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(workTypeChangeRequestDto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1 && range != 2) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(false);
        if (differenceRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(differenceRequestDto.getRequestDate(), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}));
    }

    public void checkTransferDateRange(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        Date workDate = dto.getWorkDate();
        ApplicationDtoInterface applicationDto = this.application.findForPerson(dto.getPersonalId(), workDate);
        this.application.chkExistApplication(applicationDto, workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = this.timeSettingReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), workDate);
        this.timeSettingReference.chkExistTimeSetting(timeSettingDto, workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date beforeDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)workDate, (int)(-timeSettingDto.getTransferAheadLimitMonth())), (int)(-timeSettingDto.getTransferAheadLimitDate()));
        Date afterDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)workDate, (int)timeSettingDto.getTransferLaterLimitMonth()), (int)timeSettingDto.getTransferLaterLimitDate());
        Date substituteDate = dto.getSubstituteDate();
        if (!substituteDate.after(beforeDate) || !substituteDate.before(afterDate)) {
            this.mospParams.addErrorMessage("TMW0248", new String[]{this.getStringDate(dto.getSubstituteDate()), null});
        }
    }

    protected void checkRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        this.checkWorkOnHolidayRequest(requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(requestUtil);
    }

    public void checkRequest(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        Date substituteDate;
        if (dto == null) {
            return;
        }
        String personalId = dto.getPersonalId();
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(personalId, substituteDate = dto.getSubstituteDate());
        if (workOnHolidayRequestDto != null && (workflowDto = this.workflowDao.findForKey(workOnHolidayRequestDto.getWorkflow())) != null && workflowDto.getWorkflowStage() != 0 && !WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0277", aryRep);
        }
        if (dto.getSubstituteRange() == 1) {
            DifferenceRequestDtoInterface differenceRequestDto;
            RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
            requestUtil.setRequests(personalId, dto.getSubstituteDate());
            List list = this.overtimeRequestDao.findForList(personalId, substituteDate);
            for (OvertimeRequestDtoInterface requestDto : list) {
                WorkflowDtoInterface workflowDto2 = this.workflowDao.findForKey(requestDto.getWorkflow());
                if (workflowDto2 == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2)) continue;
                String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0277", aryRep);
                return;
            }
            if (requestUtil.getWorkTypeChangeDto(false) != null) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
            }
            if ((differenceRequestDto = this.differenceRequestDao.findForKeyOnWorkflow(personalId, substituteDate)) == null) {
                return;
            }
            WorkflowDtoInterface workflowDto3 = this.workflowDao.findForKey(differenceRequestDto.getWorkflow());
            if (!WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto3) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto3)) {
                String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0277", aryRep);
            }
        }
    }

    protected void checkWorkOnHolidayRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        this.addSubstituteDateErrorMessage(workOnHolidayRequestDto.getRequestDate());
    }

    protected void checkAttendance(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = requestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            attendanceDto = requestUtil.getFirstRevertedAttendance();
        }
        if (attendanceDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(attendanceDto.getWorkDate(), this.mospParams.getName("WorkManage"));
    }

    public void checkAttendance(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getSubstituteDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow());
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.mospParams.getName("WorkManage"), this.getNameSubstituteDay()};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void checkHalfRequest(SubstituteDtoInterface dto) throws MospException {
        if (!this.workOnHolidayRefer.useHalfSubstitute()) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date workDate = dto.getWorkDate();
        Date substituteDate = dto.getSubstituteDate();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        List beforeList = requestUtil.getSubstituteList(true);
        if (!beforeList.isEmpty() && dto.getHolidayRange() == 2 || !beforeList.isEmpty() && dto.getHolidayRange() == 3) {
            RequestUtilBeanInterface requestUtil2 = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
            Date targetDate = substituteDate;
            if (beforeList.size() == 2) {
                for (SubstituteDtoInterface beforeDto : beforeList) {
                    if (beforeDto.getHolidayRange() != dto.getHolidayRange()) continue;
                    targetDate = beforeDto.getWorkDate();
                    requestUtil2.setRequests(personalId, targetDate);
                }
            } else {
                requestUtil2.setRequests(personalId, targetDate);
            }
            RequestEntity entity1 = requestUtil.getRequestEntity(personalId, workDate);
            RequestEntity entity2 = requestUtil2.getRequestEntity(personalId, targetDate);
            String workTypeCode1 = entity1.getWorkType(false);
            String workTypeCode2 = entity2.getWorkType(false);
            WorkTypeChangeRequestDtoInterface workTypeChangeDto1 = requestUtil.getWorkTypeChangeDto(false);
            WorkTypeChangeRequestDtoInterface workTypeChangeDto2 = requestUtil2.getWorkTypeChangeDto(false);
            WorkflowDtoInterface workflowDto1 = null;
            WorkflowDtoInterface workflowDto2 = null;
            if (workTypeChangeDto1 != null) {
                workflowDto1 = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto1.getWorkflow());
            }
            if (workTypeChangeDto2 != null) {
                workflowDto2 = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto2.getWorkflow());
            }
            String requestName = this.mospParams.getName("Work", new String[]{"Form", "Change", "Application"});
            if (workflowDto1 != null && WorkflowUtility.isNotApproved((WorkflowDtoInterface)workflowDto1)) {
                this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(workDate), requestName});
            }
            if (workflowDto2 != null && WorkflowUtility.isNotApproved((WorkflowDtoInterface)workflowDto2)) {
                this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(substituteDate), requestName});
            }
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            if (!workTypeCode1.equals("prescribed_holiday") && !workTypeCode1.equals(workTypeCode2)) {
                this.mospParams.addErrorMessage("TMW0335", new String[]{this.getStringDate(substituteDate)});
                return;
            }
        }
        this.checkWorkTypeInfo(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    private void checkWorkTypeInfo(SubstituteDtoInterface dto) throws MospException {
        WorkTypeDtoInterface workTypeDto;
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getSubstituteDate();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        RequestEntity entity = requestUtil.getRequestEntity(personalId, targetDate);
        String workTypeCode = entity.getWorkType(false);
        if ((dto.getSubstituteRange() == 2 || dto.getSubstituteRange() == 3) && (workTypeDto = this.workTypeRefer.findForInfo(workTypeCode, targetDate)) != null) {
            WorkTypeItemDtoInterface frontStart = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "FrontStart");
            WorkTypeItemDtoInterface frontEnd = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "FrontEnd");
            WorkTypeItemDtoInterface backStart = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "BackStart");
            WorkTypeItemDtoInterface backEnd = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "BackEnd");
            String[] rep = new String[]{this.mospParams.getName("Code", new String[]{"SingleColon"}) + workTypeCode, this.mospParams.getName("AmRest", new String[]{"Or", "PmRest"}), this.mospParams.getName("HalfDay", new String[]{"Transfer"})};
            if (frontStart == null || frontEnd == null || backStart == null || backEnd == null) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
            if (DateUtility.getDefaultTime().compareTo(frontStart.getWorkTypeItemValue()) == 0 && DateUtility.getDefaultTime().compareTo(frontEnd.getWorkTypeItemValue()) == 0) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
            if (DateUtility.getDefaultTime().compareTo(backStart.getWorkTypeItemValue()) == 0 && DateUtility.getDefaultTime().compareTo(backEnd.getWorkTypeItemValue()) == 0) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
        }
    }

    protected void checkWorkOnDaysOff(SubstituteDtoInterface dto) {
        this.checkHolidayDate(dto);
    }

    public void checkHolidayDate(SubstituteDtoInterface dto) {
        if (dto == null) {
            return;
        }
        if (!"legal_holiday".equals(dto.getSubstituteType()) && !"prescribed_holiday".equals(dto.getSubstituteType())) {
            String[] aryRep = new String[]{this.mospParams.getName("GoingWork", new String[]{"Day"}), this.mospParams.getName("Holiday"), this.getNameGoingWorkDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
        }
        if (dto.getSubstituteRange() == 1) {
            return;
        }
        if ("legal_holiday".equals(dto.getSubstituteType())) {
            this.mospParams.addErrorMessage("TMW0245", new String[]{TimeNamingUtility.legalHoliday((MospParams)this.mospParams), this.mospParams.getName("HalfDay", new String[]{"Transfer"}), this.getNameSubstituteDay()});
        }
    }

    protected void checkEntered(SubstituteDtoInterface dto) throws MospException {
        if (this.isEntered(dto.getPersonalId(), dto.getSubstituteDate())) {
            return;
        }
        this.addNotEntranceErrorMessage();
    }

    public void checkSuspension(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getSubstituteDate())) {
            this.addEmployeeSuspendedMessage();
        }
    }

    public void checkRetirement(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getSubstituteDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    public void checkOverTime(SubstituteDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        float holidayTimes = 0.0f;
        if ((holidayTimes = this.checkHolidayRange(dto, holidayTimes, personalId, substituteDate)) == 0.5f) {
            ArrayList<OvertimeRequestDtoInterface> overTimeList = new ArrayList<OvertimeRequestDtoInterface>();
            List overTimeRequestList = this.overtimeRequestDao.findForList(personalId, substituteDate);
            for (OvertimeRequestDtoInterface overTimeDto : overTimeRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(overTimeDto.getWorkflow());
                if (workflowDto == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
                overTimeList.add(overTimeDto);
            }
            if (!overTimeList.isEmpty()) {
                this.addOthersRequestErrorMessage(substituteDate, this.mospParams.getName("OvertimeWork"));
            }
        }
    }

    public float checkHolidayRange(SubstituteDtoInterface dto, float holidayTimes, String personalId, Date substituteDate) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, substituteDate);
        int holidayRange = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(false));
        if (holidayRange == 2 || holidayRange == 3) {
            return holidayTimes += 0.5f;
        }
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 2 || subHolidayRange == 3) {
            return holidayTimes += 0.5f;
        }
        List substituteDtoList = requestUtil.getSubstituteList(false);
        ArrayList<SubstituteDtoInterface> substituteList = new ArrayList<SubstituteDtoInterface>();
        for (SubstituteDtoInterface substituteDto : substituteDtoList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow()) continue;
            substituteList.add(substituteDto);
        }
        int substituteRange = requestUtil.checkHolidayRangeSubstitute(substituteList);
        if (substituteRange == 2 || substituteRange == 3) {
            return holidayTimes += 0.5f;
        }
        return holidayRange;
    }

    public void checkWorkTypeChange(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        WorkTypeChangeRequestDtoInterface workTypeChangeDto;
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        float holidayTimes = 0.0f;
        if ((holidayTimes = this.checkHolidayRange(dto, holidayTimes, personalId, substituteDate)) == 0.5f && (workTypeChangeDto = this.workTypeChangeReference.findForKeyOnWorkflow(personalId, substituteDate)) != null && (workflowDto = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow())) != null && !WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            this.addOthersRequestErrorMessage(substituteDate, this.mospParams.getName("Work", new String[]{"Form", "Change"}));
        }
    }

    protected void checkTighten(SubstituteDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getSubstituteDate(), this.getNameSubstituteDay());
    }

    protected boolean isLegalDayOff(String workTypeCode) {
        return "legal_holiday".equals(workTypeCode);
    }

    protected boolean isPrescribedDayOff(String workTypeCode) {
        return "prescribed_holiday".equals(workTypeCode);
    }

    protected void addSubstituteDateErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0242", new String[]{DateUtility.getStringDate((Date)date), this.getNameGoingWorkDay(), this.getNameSubstituteDay()});
    }

    protected void addOthersRequestErrorMessage(Date date, String requestTitle) {
        this.mospParams.addErrorMessage("TMW0309", new String[]{this.getStringDate(date), requestTitle});
    }

    protected String getNameGoingWorkDay() {
        return this.mospParams.getName("GoingWork", new String[]{"Day"});
    }

    protected String getNameSubstituteDay() {
        return this.mospParams.getName("Transfer", new String[]{"Day"});
    }
}

