/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceListRegistBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.DifferenceRequestRegistBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.OvertimeRequestRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestRegistBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class TimeApprovalBean
extends TimeBean
implements TimeApprovalBeanInterface {
    protected ApprovalInfoReferenceBeanInterface approvalInfo;
    protected WorkflowReferenceBeanInterface workflowRefer;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected AttendanceListRegistBeanInterface attendanceListRegist;
    private AttendanceRegistBeanInterface attendanceRegist;
    private DifferenceRequestRegistBeanInterface differenceRequestRegist;
    private WorkTypeChangeRequestRegistBeanInterface workTypeChangeRequestRegist;
    private SubHolidayRequestRegistBeanInterface subHolidayRequestRegist;
    private WorkOnHolidayRequestRegistBeanInterface workOnHolidayRequestRegist;
    private HolidayRequestRegistBeanInterface holidayRequestRegist;
    private OvertimeRequestRegistBeanInterface overtimeRequestRegist;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected SubstituteReferenceBeanInterface substituteReference;

    public TimeApprovalBean() {
    }

    public TimeApprovalBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.approvalInfo = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.workflowRefer = (WorkflowReferenceBeanInterface)this.createBean(WorkflowReferenceBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.attendanceListRegist = (AttendanceListRegistBeanInterface)this.createBean(AttendanceListRegistBeanInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBean(AttendanceRegistBeanInterface.class);
        this.differenceRequestRegist = (DifferenceRequestRegistBeanInterface)this.createBean(DifferenceRequestRegistBeanInterface.class);
        this.workTypeChangeRequestRegist = (WorkTypeChangeRequestRegistBeanInterface)this.createBean(WorkTypeChangeRequestRegistBeanInterface.class);
        this.subHolidayRequestRegist = (SubHolidayRequestRegistBeanInterface)this.createBean(SubHolidayRequestRegistBeanInterface.class);
        this.overtimeRequestRegist = (OvertimeRequestRegistBeanInterface)this.createBean(OvertimeRequestRegistBeanInterface.class);
        this.holidayRequestRegist = (HolidayRequestRegistBeanInterface)this.createBean(HolidayRequestRegistBeanInterface.class);
        this.workOnHolidayRequestRegist = (WorkOnHolidayRequestRegistBeanInterface)this.createBean(WorkOnHolidayRequestRegistBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
    }

    public void approve(long workflow, String workflowComment) throws MospException {
        BaseDtoInterface requestDto = this.approvalInfo.getRequestDtoForWorkflow(workflow, true);
        WorkflowDtoInterface dto = this.workflowRefer.getLatestWorkflowInfo(workflow);
        this.checkApproval(requestDto);
        this.checkExclusive((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist.approve(dto, 1, workflowComment);
        if ("9".equals(dto.getWorkflowStatus())) {
            this.reDraftAttendance(dto.getPersonalId(), dto.getWorkflowDate(), requestDto);
        }
        this.registAttendanceTransaction(dto.getPersonalId(), dto.getWorkflowDate(), requestDto);
    }

    public void revert(long workflow, String workflowComment) throws MospException {
        WorkflowDtoInterface dto = this.workflowRefer.getLatestWorkflowInfo(workflow);
        this.checkExclusive((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist.revert(dto, 1, workflowComment);
    }

    public void cancelRevert(long workflow, String workflowComment) throws MospException {
        BaseDtoInterface requestDto = this.approvalInfo.getRequestDtoForWorkflow(workflow, true);
        WorkflowDtoInterface dto = this.workflowRefer.getLatestWorkflowInfo(workflow);
        this.checkApproval(requestDto);
        this.checkExclusive((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist.cancelRevert(dto, workflowComment);
        if ("9".equals(dto.getWorkflowStatus())) {
            this.reDraft(dto.getPersonalId(), dto.getWorkflowDate(), false, false, false);
        }
    }

    public void approve(long[] aryWorkflow, String workflowComment) throws MospException {
        for (long workflow : aryWorkflow) {
            this.approve(workflow, workflowComment);
        }
    }

    public void cancel(long workflow, String workflowComment) throws MospException {
        BaseDtoInterface requestDto = this.approvalInfo.getRequestDtoForWorkflow(workflow, true);
        this.checkCancel(requestDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface dto = this.workflowRefer.getLatestWorkflowInfo(workflow);
        this.workflowRegist.cancel(dto, 1, workflowComment);
        if ("4".equals(dto.getFunctionCode())) {
            this.attendanceRegist.delete(dto.getPersonalId(), dto.getWorkflowDate());
        } else if ("2".equals(dto.getFunctionCode()) || "3".equals(dto.getFunctionCode()) || "5".equals(dto.getFunctionCode()) || "6".equals(dto.getFunctionCode())) {
            this.reDraft(dto.getPersonalId(), dto.getWorkflowDate(), false, false, false);
        } else if ("7".equals(dto.getFunctionCode())) {
            this.reDraft(dto.getPersonalId(), dto.getWorkflowDate(), false, false, true);
        }
        this.registAttendanceTransaction(dto.getPersonalId(), dto.getWorkflowDate(), requestDto);
    }

    public void cancelApprove(long workflow, String workflowComment) throws MospException {
        BaseDtoInterface requestDto = this.approvalInfo.getRequestDtoForWorkflow(workflow, true);
        this.checkCancelApproval(requestDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface dto = this.workflowRefer.getLatestWorkflowInfo(workflow);
        if (dto.getWorkflowStatus().equals("7")) {
            if ("1".equals(dto.getFunctionCode())) {
                this.attendanceRegist.delete(dto.getPersonalId(), dto.getWorkflowDate());
            } else {
                this.workflowRegist.cancelWithdrawnApprove(dto, workflowComment);
            }
        } else {
            this.workflowRegist.cancelApprove(dto, workflowComment);
        }
        if ("4".equals(dto.getFunctionCode())) {
            this.attendanceRegist.delete(dto.getPersonalId(), dto.getWorkflowDate());
        } else if ("2".equals(dto.getFunctionCode()) || "3".equals(dto.getFunctionCode()) || "5".equals(dto.getFunctionCode()) || "6".equals(dto.getFunctionCode())) {
            this.reDraft(dto.getPersonalId(), dto.getWorkflowDate(), false, false, false);
        } else if ("7".equals(dto.getFunctionCode())) {
            this.reDraft(dto.getPersonalId(), dto.getWorkflowDate(), false, false, true);
        }
        this.registAttendanceTransaction(dto.getPersonalId(), dto.getWorkflowDate(), requestDto);
    }

    public void cancelApprove(long[] aryWorkflow, String workflowComment) throws MospException {
        for (long workflow : aryWorkflow) {
            this.cancelApprove(workflow, workflowComment);
        }
    }

    public void checkCancelAppli(BaseDtoInterface dto) throws MospException {
        if (dto instanceof AttendanceDtoInterface) {
            this.attendanceRegist.checkCancelAppli((AttendanceDtoInterface)dto);
        }
        if (dto instanceof OvertimeRequestDtoInterface) {
            this.overtimeRequestRegist.checkCancelAppli((OvertimeRequestDtoInterface)dto);
        }
        if (dto instanceof HolidayRequestDtoInterface) {
            this.holidayRequestRegist.checkCancelAppli((HolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkOnHolidayRequestDtoInterface) {
            this.workOnHolidayRequestRegist.checkCancelAppli((WorkOnHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof SubHolidayRequestDtoInterface) {
            this.subHolidayRequestRegist.checkCancelAppli((SubHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkTypeChangeRequestDtoInterface) {
            this.workTypeChangeRequestRegist.checkCancelAppli((WorkTypeChangeRequestDtoInterface)dto);
        }
        if (dto instanceof DifferenceRequestDtoInterface) {
            this.differenceRequestRegist.checkCancelAppli((DifferenceRequestDtoInterface)dto);
        }
    }

    public void checkApproval(BaseDtoInterface dto) throws MospException {
        if (dto instanceof AttendanceDtoInterface) {
            this.attendanceRegist.checkApproval((AttendanceDtoInterface)dto);
        }
        if (dto instanceof OvertimeRequestDtoInterface) {
            this.overtimeRequestRegist.checkApproval((OvertimeRequestDtoInterface)dto);
        }
        if (dto instanceof HolidayRequestDtoInterface) {
            this.holidayRequestRegist.checkApproval((HolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkOnHolidayRequestDtoInterface) {
            this.workOnHolidayRequestRegist.checkApproval((WorkOnHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof SubHolidayRequestDtoInterface) {
            this.subHolidayRequestRegist.checkApproval((SubHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkTypeChangeRequestDtoInterface) {
            this.workTypeChangeRequestRegist.checkApproval((WorkTypeChangeRequestDtoInterface)dto);
        }
        if (dto instanceof DifferenceRequestDtoInterface) {
            this.differenceRequestRegist.checkApproval((DifferenceRequestDtoInterface)dto);
        }
    }

    public void checkCancel(BaseDtoInterface dto) throws MospException {
        if (dto instanceof AttendanceDtoInterface) {
            this.attendanceRegist.checkCancel((AttendanceDtoInterface)dto);
        }
        if (dto instanceof OvertimeRequestDtoInterface) {
            this.overtimeRequestRegist.checkCancel((OvertimeRequestDtoInterface)dto);
        }
        if (dto instanceof HolidayRequestDtoInterface) {
            this.holidayRequestRegist.checkCancel((HolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkOnHolidayRequestDtoInterface) {
            this.workOnHolidayRequestRegist.checkCancel((WorkOnHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof SubHolidayRequestDtoInterface) {
            this.subHolidayRequestRegist.checkCancel((SubHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkTypeChangeRequestDtoInterface) {
            this.workTypeChangeRequestRegist.checkCancel((WorkTypeChangeRequestDtoInterface)dto);
        }
        if (dto instanceof DifferenceRequestDtoInterface) {
            this.differenceRequestRegist.checkCancel((DifferenceRequestDtoInterface)dto);
        }
    }

    protected void checkCancelApproval(BaseDtoInterface dto) throws MospException {
        if (dto instanceof AttendanceDtoInterface) {
            this.attendanceRegist.checkCancelApproval((AttendanceDtoInterface)dto);
        }
        if (dto instanceof OvertimeRequestDtoInterface) {
            this.overtimeRequestRegist.checkCancelApproval((OvertimeRequestDtoInterface)dto);
        }
        if (dto instanceof HolidayRequestDtoInterface) {
            this.holidayRequestRegist.checkCancelApproval((HolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkOnHolidayRequestDtoInterface) {
            this.workOnHolidayRequestRegist.checkCancelApproval((WorkOnHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof SubHolidayRequestDtoInterface) {
            this.subHolidayRequestRegist.checkCancelApproval((SubHolidayRequestDtoInterface)dto);
        }
        if (dto instanceof WorkTypeChangeRequestDtoInterface) {
            this.workTypeChangeRequestRegist.checkCancelApproval((WorkTypeChangeRequestDtoInterface)dto);
        }
        if (dto instanceof DifferenceRequestDtoInterface) {
            this.differenceRequestRegist.checkCancelApproval((DifferenceRequestDtoInterface)dto);
        }
    }

    public void registAttendanceTransaction(String personalId, Date workDate, BaseDtoInterface requestDto) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto;
        int substitute;
        if (requestDto instanceof HolidayRequestDtoInterface) {
            HolidayRequestDtoInterface holidayRequestDto = (HolidayRequestDtoInterface)requestDto;
            List list = TimeUtility.getDateList((Date)holidayRequestDto.getRequestStartDate(), (Date)holidayRequestDto.getRequestEndDate());
            for (Date date : list) {
                this.attendanceTransactionRegist.regist(personalId, date);
            }
            return;
        }
        if (requestDto instanceof WorkOnHolidayRequestDtoInterface && ((substitute = (workOnHolidayRequestDto = (WorkOnHolidayRequestDtoInterface)requestDto).getSubstitute()) == 1 || substitute == 3 || substitute == 4)) {
            for (SubstituteDtoInterface substituteDto : this.substituteReference.getSubstituteList(workOnHolidayRequestDto.getWorkflow())) {
                this.attendanceTransactionRegist.regist(substituteDto.getPersonalId(), substituteDto.getSubstituteDate());
            }
        }
        this.attendanceTransactionRegist.regist(personalId, workDate);
    }

    protected void reDraftAttendance(String personalId, Date workDate, BaseDtoInterface requestDto) throws MospException {
        SubHolidayRequestDtoInterface subHolidayRequestDto;
        int holidayRange;
        boolean deleteRest = false;
        boolean useWorkTypeChangeRequest = false;
        if (requestDto instanceof HolidayRequestDtoInterface) {
            HolidayRequestDtoInterface holidayRequestDto = (HolidayRequestDtoInterface)requestDto;
            int holidayRange2 = holidayRequestDto.getHolidayRange();
            if (holidayRange2 == 2 || holidayRange2 == 3) {
                deleteRest = true;
            }
        } else if (requestDto instanceof SubHolidayRequestDtoInterface && ((holidayRange = (subHolidayRequestDto = (SubHolidayRequestDtoInterface)requestDto).getHolidayRange()) == 2 || holidayRange == 3)) {
            deleteRest = true;
        }
        if (requestDto instanceof WorkTypeChangeRequestDtoInterface) {
            useWorkTypeChangeRequest = true;
        }
        this.reDraft(personalId, workDate, deleteRest, useWorkTypeChangeRequest, false);
    }

    public void reDraft(String personalId, Date workDate, boolean deleteRest, boolean useWorkTypeChangeRequest, boolean useSchedule) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        AttendanceDtoInterface dto = requestUtil.getDraftAttendance();
        if (dto == null) {
            return;
        }
        String actualStartTime = "";
        if (dto.getActualStartTime() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(DateUtility.getStringHour((Date)dto.getActualStartTime(), (Date)dto.getWorkDate()));
            sb.append(DateUtility.getStringMinute((Date)dto.getActualStartTime()));
            actualStartTime = sb.toString();
        }
        String actualEndTime = "";
        if (dto.getActualEndTime() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(DateUtility.getStringHour((Date)dto.getActualEndTime(), (Date)dto.getWorkDate()));
            sb.append(DateUtility.getStringMinute((Date)dto.getActualEndTime()));
            actualEndTime = sb.toString();
        }
        this.attendanceListRegist.draft(dto.getPersonalId(), new String[]{this.getStringDate(dto.getWorkDate())}, new String[]{actualStartTime}, new String[]{actualEndTime}, deleteRest, useWorkTypeChangeRequest, useSchedule);
    }
}

