/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayDaoInterface;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.WorkTypeEntity;
import jp.mosp.time.utils.TimeUtility;

public class TimeMasterBean
extends PlatformBean
implements TimeMasterBeanInterface {
    protected HumanDaoInterface humanDao;
    protected ApplicationDaoInterface applicationDao;
    protected TimeSettingDaoInterface timeSettingDao;
    protected PaidHolidayDaoInterface paidHolidayDao;
    protected CutoffDaoInterface cutoffDao;
    protected ScheduleDateDaoInterface scheduleDateDao;
    protected HolidayDaoInterface holidayDao;
    protected WorkTypeReferenceBeanInterface workTypeRefer;
    protected Date applicationFromDate;
    protected Date applicationToDate;
    protected Set<Date> applicationDateSet;
    protected Map<Date, Set<ApplicationDtoInterface>> applicationPersonMap;
    protected Map<Date, Set<ApplicationDtoInterface>> applicationMasterMap;
    protected Map<Date, Set<TimeSettingDtoInterface>> timeSettingMap;
    protected Map<Date, Set<PaidHolidayDtoInterface>> paidHolidayMap;
    protected Map<Date, Set<CutoffDtoInterface>> cutoffMap;
    protected Map<String, Map<Date, ScheduleDateDtoInterface>> scheduleMap;
    protected Map<String, List<WorkTypeEntity>> workTypeMap;
    protected Map<Date, Set<HolidayDtoInterface>> holidayMap;

    public TimeMasterBean() {
    }

    public TimeMasterBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        this.applicationDao = (ApplicationDaoInterface)this.createDao(ApplicationDaoInterface.class);
        this.timeSettingDao = (TimeSettingDaoInterface)this.createDao(TimeSettingDaoInterface.class);
        this.paidHolidayDao = (PaidHolidayDaoInterface)this.createDao(PaidHolidayDaoInterface.class);
        this.cutoffDao = (CutoffDaoInterface)this.createDao(CutoffDaoInterface.class);
        this.scheduleDateDao = (ScheduleDateDaoInterface)this.createDao(ScheduleDateDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDao(HolidayDaoInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.applicationDateSet = new HashSet();
        this.applicationPersonMap = new HashMap();
        this.applicationMasterMap = new HashMap();
        this.timeSettingMap = new HashMap();
        this.paidHolidayMap = new HashMap();
        this.cutoffMap = new HashMap();
        this.scheduleMap = new HashMap();
        this.workTypeMap = new HashMap();
        this.holidayMap = new HashMap();
    }

    public ApplicationDtoInterface getApplication(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        Set personSet = this.getApplicationPersonSet(targetDate);
        Set masterSet = this.getApplicationMasterSet(targetDate);
        return (ApplicationDtoInterface)PlatformUtility.getApplicationMaster((HumanDtoInterface)humanDto, (Set)personSet, (Set)masterSet);
    }

    public PaidHolidayDtoInterface getPaidHoliday(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        ApplicationDtoInterface application = this.getApplication(humanDto, targetDate);
        if (application == null) {
            return null;
        }
        return this.getPaidHoliday(application.getPaidHolidayCode(), targetDate);
    }

    public Map<Date, ApplicationDtoInterface> getApplicationMap(String personalId, Date firstDate, Date lastDate) throws MospException {
        HashMap<Date, ApplicationDtoInterface> map = new HashMap<Date, ApplicationDtoInterface>();
        List humanList = this.humanDao.findForHistory(personalId);
        Set activateDateSet = this.getApplicationDateSet(firstDate, lastDate);
        for (HumanDtoInterface humanDto : humanList) {
            activateDateSet.add(humanDto.getActivateDate());
        }
        activateDateSet.add(firstDate);
        ApplicationDtoInterface applicationDto = null;
        for (Date targetDate : TimeUtility.getDateList((Date)firstDate, (Date)lastDate)) {
            HumanDtoInterface humanDto;
            if (activateDateSet.contains(targetDate) && (humanDto = (HumanDtoInterface)PlatformUtility.getLatestDto((List)humanList, (Date)targetDate)) != null) {
                applicationDto = this.getApplication(humanDto, targetDate);
            }
            map.put(targetDate, applicationDto);
        }
        return map;
    }

    public ApplicationEntity getApplicationEntity(HumanDtoInterface humanDto, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getApplicationEntity(humanDto, targetDate);
    }

    public ApplicationEntity getApplicationEntity(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        ApplicationDtoInterface applicationDto = this.getApplication(humanDto, targetDate);
        ApplicationEntity applicationEntity = new ApplicationEntity(applicationDto);
        if (applicationDto == null) {
            return applicationEntity;
        }
        String workSettingCode = applicationEntity.getWorkSettingCode();
        applicationEntity.setTimeSettingDto(this.getTimeSetting(workSettingCode, targetDate));
        String cutoffCode = applicationEntity.getCutoffCode();
        applicationEntity.setCutoffDto(this.getCutoff(cutoffCode, targetDate));
        return applicationEntity;
    }

    public Map<Date, TimeSettingDtoInterface> getTimeSettingMap(Map<Date, ApplicationDtoInterface> applicationMap) throws MospException {
        HashMap<Date, TimeSettingDtoInterface> map = new HashMap<Date, TimeSettingDtoInterface>();
        for (Map.Entry<Date, ApplicationDtoInterface> entry : applicationMap.entrySet()) {
            Date targetDate = entry.getKey();
            ApplicationDtoInterface applicationDto = entry.getValue();
            if (applicationDto == null) {
                map.put(targetDate, null);
                continue;
            }
            map.put(targetDate, this.getTimeSetting(applicationDto.getWorkSettingCode(), targetDate));
        }
        return map;
    }

    public CutoffDtoInterface getCutoff(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getCutoff(cutoffCode, targetDate);
    }

    public CutoffDtoInterface getCutoff(String cutoffCode, Date targetDate) throws MospException {
        if (cutoffCode == null) {
            return null;
        }
        HashSet<CutoffDtoInterface> set = (HashSet<CutoffDtoInterface>)this.cutoffMap.get(targetDate);
        if (set == null) {
            set = new HashSet<CutoffDtoInterface>();
            this.cutoffMap.put(targetDate, set);
        }
        for (CutoffDtoInterface dto : set) {
            if (!dto.getCutoffCode().equals(cutoffCode)) continue;
            return dto;
        }
        CutoffDtoInterface dto = this.cutoffDao.findForInfo(cutoffCode, targetDate);
        if (dto == null) {
            return null;
        }
        set.add(dto);
        return dto;
    }

    public ScheduleDateDtoInterface getScheduleDate(String scheduleCode, Date targetDate) throws MospException {
        ScheduleDateDtoInterface dto;
        HashMap<Date, ScheduleDateDtoInterface> map = (HashMap<Date, ScheduleDateDtoInterface>)this.scheduleMap.get(scheduleCode);
        if (map == null) {
            map = new HashMap<Date, ScheduleDateDtoInterface>();
            this.scheduleMap.put(scheduleCode, map);
        }
        if ((dto = (ScheduleDateDtoInterface)map.get(targetDate)) != null) {
            return dto;
        }
        dto = this.scheduleDateDao.findForKey(scheduleCode, targetDate);
        map.put(targetDate, dto);
        return dto;
    }

    public void addScheduleDateMap(String scheduleCode, Date firstDate, Date lastDate) throws MospException {
        HashMap<Date, ScheduleDateDtoInterface> map = (HashMap<Date, ScheduleDateDtoInterface>)this.scheduleMap.get(scheduleCode);
        if (map != null && !map.isEmpty()) {
            return;
        }
        map = new HashMap<Date, ScheduleDateDtoInterface>();
        this.scheduleMap.put(scheduleCode, map);
        List list = this.scheduleDateDao.findForList(scheduleCode, firstDate, lastDate);
        for (ScheduleDateDtoInterface dto : list) {
            map.put(dto.getScheduleDate(), dto);
        }
    }

    public Set<HolidayDtoInterface> getHolidaySet(Date targetDate) throws MospException {
        Set set = (Set)this.holidayMap.get(targetDate);
        if (set == null) {
            set = this.holidayDao.findForActivateDate(targetDate);
            this.holidayMap.put(targetDate, set);
        }
        return set;
    }

    protected Set<ApplicationDtoInterface> getApplicationPersonSet(Date targetDate) throws MospException {
        if (this.applicationPersonMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        return (Set)this.applicationPersonMap.get(targetDate);
    }

    protected Set<ApplicationDtoInterface> getApplicationMasterSet(Date targetDate) throws MospException {
        if (this.applicationMasterMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        return (Set)this.applicationMasterMap.get(targetDate);
    }

    protected void addApplicationSet(Date targetDate) throws MospException {
        HashSet<ApplicationDtoInterface> personSet = new HashSet<ApplicationDtoInterface>();
        HashSet<ApplicationDtoInterface> masterSet = new HashSet<ApplicationDtoInterface>();
        this.applicationPersonMap.put(targetDate, personSet);
        this.applicationMasterMap.put(targetDate, masterSet);
        int person = Integer.parseInt("1");
        int master = Integer.parseInt("0");
        List list = this.applicationDao.findForActivateDate(targetDate);
        for (ApplicationDtoInterface dto : list) {
            if (dto.getApplicationType() == person) {
                personSet.add(dto);
            }
            if (dto.getApplicationType() != master) continue;
            masterSet.add(dto);
        }
    }

    protected Set<Date> getApplicationDateSet(Date firstDate, Date lastDate) throws MospException {
        boolean isOutOfTerm = false;
        if (this.applicationFromDate == null || firstDate.before(this.applicationFromDate)) {
            isOutOfTerm = true;
            this.applicationFromDate = firstDate;
        }
        if (this.applicationToDate == null || lastDate.after(this.applicationToDate)) {
            isOutOfTerm = true;
            this.applicationToDate = lastDate;
        }
        if (isOutOfTerm) {
            this.applicationDateSet = new HashSet();
            List list = this.applicationDao.findForTerm(this.applicationFromDate, this.applicationToDate);
            for (ApplicationDtoInterface dto : list) {
                this.applicationDateSet.add(dto.getActivateDate());
            }
        }
        return this.applicationDateSet;
    }

    public TimeSettingDtoInterface getTimeSetting(String workSettingCode, Date targetDate) throws MospException {
        HashSet<TimeSettingDtoInterface> set = (HashSet<TimeSettingDtoInterface>)this.timeSettingMap.get(targetDate);
        if (set == null) {
            set = new HashSet<TimeSettingDtoInterface>();
            this.timeSettingMap.put(targetDate, set);
        }
        for (TimeSettingDtoInterface dto : set) {
            if (!dto.getWorkSettingCode().equals(workSettingCode)) continue;
            return dto;
        }
        TimeSettingDtoInterface dto = this.timeSettingDao.findForInfo(workSettingCode, targetDate);
        set.add(dto);
        return dto;
    }

    public PaidHolidayDtoInterface getPaidHoliday(String paidHolidayCode, Date targetDate) throws MospException {
        HashSet<PaidHolidayDtoInterface> set = (HashSet<PaidHolidayDtoInterface>)this.paidHolidayMap.get(targetDate);
        if (set == null) {
            set = new HashSet<PaidHolidayDtoInterface>();
            this.paidHolidayMap.put(targetDate, set);
        }
        for (PaidHolidayDtoInterface dto : set) {
            if (!dto.getPaidHolidayCode().equals(paidHolidayCode)) continue;
            return dto;
        }
        PaidHolidayDtoInterface dto = this.paidHolidayDao.findForInfo(paidHolidayCode, targetDate);
        set.add(dto);
        return dto;
    }

    public List<WorkTypeEntity> getWorkTypeEntityHistory(String workTypeCode) throws MospException {
        List history = (List)this.workTypeMap.get(workTypeCode);
        if (history != null) {
            return history;
        }
        history = this.workTypeRefer.getWorkTypeEntityHistory(workTypeCode);
        this.workTypeMap.put(workTypeCode, history);
        return history;
    }
}

