/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalAbsenceRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalAbsenceDaoInterface;
import jp.mosp.time.dto.settings.TotalAbsenceDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalAbsenceDto;

public class TotalAbsenceRegistBean
extends PlatformBean
implements TotalAbsenceRegistBeanInterface {
    TotalAbsenceDaoInterface dao;

    public TotalAbsenceRegistBean() {
    }

    public TotalAbsenceRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TotalAbsenceDaoInterface)this.createDao(TotalAbsenceDaoInterface.class);
    }

    public TotalAbsenceDtoInterface getInitDto() {
        return new TmdTotalAbsenceDto();
    }

    public void insert(TotalAbsenceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdTotalAbsenceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(TotalAbsenceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalAbsenceId());
        dto.setTmdTotalAbsenceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(TotalAbsenceDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getAbsenceCode()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void delete(String personalId, int calculationYear, int calculationMonth) throws MospException {
        List list = this.dao.findForList(personalId, calculationYear, calculationMonth);
        for (TotalAbsenceDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalAbsenceId());
        }
    }

    public void delete(List<String> personalIdList, int calculationYear, int calculationMonth) throws MospException {
        for (String personalId : personalIdList) {
            List list = this.dao.findForList(personalId, calculationYear, calculationMonth);
            for (TotalAbsenceDtoInterface dto : list) {
                this.validate(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.checkDelete(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalAbsenceId());
            }
        }
    }

    protected void checkInsert(TotalAbsenceDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getAbsenceCode()));
    }

    protected void checkUpdate(TotalAbsenceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalAbsenceId());
    }

    protected void checkDelete(TotalAbsenceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalAbsenceId());
    }

    protected void validate(TotalAbsenceDtoInterface dto) {
    }
}

