/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalTimeRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalTimeDataDto;

public class TotalTimeRegistBean
extends PlatformBean
implements TotalTimeRegistBeanInterface {
    TotalTimeDataDaoInterface dao;

    public TotalTimeRegistBean() {
    }

    public TotalTimeRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (TotalTimeDataDaoInterface)this.createDao(TotalTimeDataDaoInterface.class);
    }

    public TotalTimeDataDtoInterface getInitDto() {
        return new TmdTotalTimeDataDto();
    }

    public void insert(TotalTimeDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdTotalTimeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(TotalTimeDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalTimeId());
        dto.setTmdTotalTimeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(TotalTimeDataDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void delete(TotalTimeDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalTimeId());
    }

    public void delete(List<String> personalIdList, int calculationYear, int calculationMonth) throws MospException {
        for (String personalId : personalIdList) {
            TotalTimeDataDtoInterface dto = this.dao.findForKey(personalId, calculationYear, calculationMonth);
            if (dto == null) continue;
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalTimeId());
        }
    }

    protected void checkInsert(TotalTimeDataDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth()));
    }

    protected void checkUpdate(TotalTimeDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalTimeId());
    }

    protected void checkDelete(TotalTimeDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalTimeId());
    }

    protected void validate(TotalTimeDataDtoInterface dto) {
    }
}

