/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.bean.TotalTimeSearchBeanInterface;
import jp.mosp.time.bean.impl.SubordinateSearchBean;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

public class TotalTimeSearchBean
extends SubordinateSearchBean
implements TotalTimeSearchBeanInterface {
    private TotalTimeDataDaoInterface totalTimeDataDao;
    private CutoffUtilBeanInterface cutoffUtil;
    private SubordinateSearchBeanInterface subordinateSearch;
    protected String cutoffCode;

    public TotalTimeSearchBean() {
    }

    public TotalTimeSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeDataDao = (TotalTimeDataDaoInterface)this.createDao(TotalTimeDataDaoInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.subordinateSearch = (SubordinateSearchBeanInterface)this.createBean(SubordinateSearchBeanInterface.class);
    }

    public List<SubordinateListDtoInterface> getSearchList() throws MospException {
        ArrayList<SubordinateListDtoInterface> list = new ArrayList<SubordinateListDtoInterface>();
        Set personalIdSet = this.cutoffUtil.getCutoffPersonalIdSet(this.cutoffCode, this.targetYear, this.targetMonth);
        this.setTargetDate(this.cutoffUtil.getCutoffTermTargetDate(this.cutoffCode, this.targetYear, this.targetMonth));
        this.setStartDate(this.cutoffUtil.getCutoffFirstDate(this.cutoffCode, this.targetYear, this.targetMonth));
        this.setEndDate(this.cutoffUtil.getCutoffLastDate(this.cutoffCode, this.targetYear, this.targetMonth));
        this.setEmployeeCodeType("forward");
        this.setStateType("presence");
        boolean searchBeforeDay = this.approvalBeforeDay.equals("1");
        List humanList = this.search();
        for (HumanDtoInterface human : humanList) {
            TotalTimeDataDtoInterface totalTimeDto;
            SubordinateListDtoInterface dto;
            String personalId = human.getPersonalId();
            if (!personalIdSet.contains(personalId) || !this.isApprovalConditionMatch(dto = this.subordinateSearch.getSubordinateListDto(human, this.targetYear, this.targetMonth, totalTimeDto = this.totalTimeDataDao.findForKey(personalId, this.targetYear, this.targetMonth), searchBeforeDay)) || !this.isCalcConditionMatch(dto)) continue;
            list.add(dto);
        }
        return list;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }
}

