/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.bean.workflow.impl.WorkflowReferenceBean;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdWorkOnHolidayRequestDto;
import jp.mosp.time.utils.TimeNamingUtility;

public class WorkOnHolidayRequestRegistBean
extends TimeBean
implements WorkOnHolidayRequestRegistBeanInterface {
    protected WorkOnHolidayRequestDaoInterface dao;
    WorkOnHolidayRequestReferenceBeanInterface workOnHolidayReference;
    private WorkflowDaoInterface workflowDao;
    private WorkflowReferenceBeanInterface workflowReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    private SubstituteDaoInterface substituteDao;
    private SubstituteReferenceBeanInterface substituteReference;
    private SubstituteRegistBeanInterface substituteRegist;
    protected AttendanceRegistBeanInterface attendanceRegist;
    private AttendanceReferenceBeanInterface attendanceReference;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    private CutoffUtilBeanInterface cutoffUtil;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected SubHolidayRequestReferenceBeanInterface subholidayRequestReference;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeRequestReference;
    protected OvertimeRequestReferenceBeanInterface overtimeRequestReference;
    protected DifferenceRequestReferenceBeanInterface differenceReference;

    public WorkOnHolidayRequestRegistBean() {
    }

    public WorkOnHolidayRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkOnHolidayRequestDaoInterface)this.createDao(WorkOnHolidayRequestDaoInterface.class);
        this.workOnHolidayReference = (WorkOnHolidayRequestReferenceBeanInterface)this.createBean(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
        this.workflowReference = (WorkflowReferenceBean)this.createBean(WorkflowReferenceBean.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDao(SubstituteDaoInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBean(SubstituteReferenceBeanInterface.class);
        this.substituteRegist = (SubstituteRegistBeanInterface)this.createBean(SubstituteRegistBeanInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBean(AttendanceRegistBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBean(AttendanceReferenceBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBean(ApprovalInfoReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBean(ScheduleReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBean(ScheduleDateReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBean(AttendanceTransactionRegistBeanInterface.class);
        this.subholidayRequestReference = (SubHolidayRequestReferenceBeanInterface)this.createBean(SubHolidayRequestReferenceBeanInterface.class);
        this.workTypeChangeRequestReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBean(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.overtimeRequestReference = (OvertimeRequestReferenceBeanInterface)this.createBean(OvertimeRequestReferenceBeanInterface.class);
        this.differenceReference = (DifferenceRequestReferenceBeanInterface)this.createBean(DifferenceRequestReferenceBeanInterface.class);
    }

    public WorkOnHolidayRequestDtoInterface getInitDto() {
        return new TmdWorkOnHolidayRequestDto();
    }

    public void insert(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdWorkOnHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public List<WorkflowDtoInterface> update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        ArrayList<WorkflowDtoInterface> workflowList = new ArrayList<WorkflowDtoInterface>();
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            List substituteList = this.substituteDao.findForWorkflow(dto.getWorkflow());
            int size = substituteList.size();
            if (size == 1) {
                SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)substituteList.get(0);
                this.substituteRegist.checkRegist(substituteDto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.attendanceRegist.delete(substituteDto.getPersonalId(), substituteDto.getSubstituteDate());
            }
            WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (!substituteList.isEmpty()) {
                this.attendanceTransactionRegist.regist((SubstituteDtoInterface)substituteList.get(0));
            }
            if (workflowDto == null) continue;
            workflowList.add(workflowDto);
        }
        return workflowList;
    }

    public void regist(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdWorkOnHolidayRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void add(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
        dto.setTmdWorkOnHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
    }

    protected void checkInsert(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate()));
    }

    protected void checkAdd(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    protected void checkUpdate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    @Deprecated
    protected void checkDelete(WorkOnHolidayRequestDtoInterface dto) throws MospException {
    }

    protected void checkInactivate(String code, Date activateDate) {
    }

    public void validate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.workOnHolidayReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
    }

    public void checkValidate(WorkOnHolidayRequestDtoInterface dto) {
        this.checkRequired((Object)dto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Day"}), null);
    }

    public void checkSetRequestDate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTightenForSetRequestDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkOnHolidayOverlap(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayRequest(dto);
    }

    public void checkDraft(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkSetRequestDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkLegalHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeCode(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
    }

    public void checkAppli(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequired(dto);
        this.checkHalfSubstitute(dto);
        this.checkAttendanceDraft(dto);
    }

    protected void checkHalfSubstitute(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (!this.workOnHolidayReference.useHalfSubstitute()) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date workDate = dto.getRequestDate();
        int substitute = dto.getSubstitute();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        List beforeList = requestUtil.getSubstituteList(true);
        if (beforeList.isEmpty()) {
            return;
        }
        boolean isHalfSubstitute = false;
        int beforeHolidayRange = ((SubstituteDtoInterface)beforeList.get(0)).getHolidayRange();
        boolean bl = isHalfSubstitute = beforeHolidayRange == 2 || beforeHolidayRange == 3;
        if (isHalfSubstitute && substitute != 3 && substitute != 4) {
            this.mospParams.addErrorMessage("TMW0334", new String[]{this.getStringDate(workDate)});
            return;
        }
        this.halfHolidayRangeCheck(dto, beforeList);
    }

    protected void checkAttendanceDraft(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        Date workDate;
        String personalId = dto.getPersonalId();
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(personalId, workDate = dto.getRequestDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto.getWorkflowStatus().equals("0") || workflowDto.getWorkflowStatus().equals("3")) {
            this.attendanceRegist.delete(personalId, workDate);
        }
    }

    protected void halfHolidayRangeCheck(WorkOnHolidayRequestDtoInterface dto, List<SubstituteDtoInterface> beforeList) {
        int range = dto.getSubstitute();
        if (range == 3) {
            range = 2;
        } else if (range == 4) {
            range = 3;
        } else {
            return;
        }
        int substituteRange = beforeList.get(0).getSubstituteRange();
        if (substituteRange == 1) {
            return;
        }
        if (beforeList.size() == 1 && range != substituteRange) {
            String[] rep = new String[]{this.getStringDate(dto.getRequestDate()), this.mospParams.getName("Transfer", new String[]{"Holiday", "Range"}), this.mospParams.getName("Application")};
            this.mospParams.addErrorMessage("TMW0333", rep);
            return;
        }
    }

    public void checkCancelAppli(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        this.checkCancel(dto);
    }

    public void checkWithdrawn(WorkOnHolidayRequestDtoInterface dto) {
    }

    public void checkApproval(WorkOnHolidayRequestDtoInterface dto) {
    }

    public void checkCancelApproval(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        String personalId = dto.getPersonalId();
        Date workDate = dto.getRequestDate();
        if (dto.getSubstitute() == 2) {
            this.checkSubHolidayRequest(dto, personalId, workDate);
            return;
        }
        this.checkWorkDate(personalId, workDate);
        SubstituteDtoInterface substituteDto = this.substituteReference.getSubstituteDto(personalId, workDate);
        Date substituteDate = substituteDto.getSubstituteDate();
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(personalId, substituteDate, 1);
        if (attendanceDto != null && (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())) != null && !WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) && !WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            this.mospParams.addErrorMessage("TMW0316", new String[]{this.getNameSubstituteDay() + this.mospParams.getName("Of", new String[]{"WorkManage", "Application"}), this.mospParams.getName("Release")});
            return;
        }
        substituteDto = this.substituteReference.getSubstituteDto(personalId, substituteDate);
        if (substituteDto != null) {
            workflowDto = this.workflowReference.getLatestWorkflowInfo(substituteDto.getWorkflow());
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
                return;
            }
            this.mospParams.addErrorMessage("TMW0283", new String[0]);
            this.mospParams.addErrorMessage("TMW0284", new String[0]);
        } else {
            WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.workOnHolidayReference.findForSubstitute(personalId, substituteDate, 1);
            if (workOnHolidayDto == null) {
                return;
            }
            WorkflowDtoInterface workflowDto2 = this.workflowReference.getLatestWorkflowInfo(workOnHolidayDto.getWorkflow());
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto2)) {
                return;
            }
            this.mospParams.addErrorMessage("TMW0283", new String[0]);
            this.mospParams.addErrorMessage("TMW0284", new String[0]);
        }
    }

    protected void checkWorkDate(String personalId, Date workDate) throws MospException {
        List subHolidayList;
        if (this.approvalInfoReference.isExistAttendanceTargetDate(personalId, workDate)) {
            this.addOthersRequestErrorMessage(workDate, this.mospParams.getName("WorkManage"));
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        List list = requestUtil.getHolidayList(false);
        if (!list.isEmpty()) {
            this.addOthersRequestErrorMessage(workDate, this.mospParams.getName("Vacation"));
        }
        if (!(subHolidayList = requestUtil.getSubHolidayList(false)).isEmpty()) {
            this.addOthersRequestErrorMessage(workDate, this.mospParams.getName("CompensatoryHoliday"));
        }
        this.checkWorkTypeChangeRequest(personalId, workDate);
        this.checkOverTimeRequest(personalId, workDate);
        this.checkDifferenceRequest(personalId, workDate);
    }

    public void checkWorkOnHolidayOverlap(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkOnHolidayRequestDtoInterface requestDto = this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate());
        if (requestDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (dto.getWorkflow() == workflowDto.getWorkflow()) {
            return;
        }
        this.addWorkOnHolidayTargetDateWorkOnHolidayRequestErrorMessage(dto.getRequestDate());
    }

    public void checkHolidayDate(WorkOnHolidayRequestDtoInterface dto) {
        if (dto.getWorkOnHolidayType() == null || dto.getWorkOnHolidayType().isEmpty()) {
            this.addWorkTypeNotExistErrorMessage(dto.getRequestDate());
            return;
        }
        if (!"legal_holiday".equals(dto.getWorkOnHolidayType()) && !"prescribed_holiday".equals(dto.getWorkOnHolidayType())) {
            this.addWorkOnHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
        }
    }

    public void checkAttendance(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        AttendanceDtoInterface requestDto = this.attendanceReference.findForKey(dto.getPersonalId(), dto.getRequestDate(), 1);
        if (requestDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(requestDto.getWorkflow());
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        this.addApplicatedAttendanceErrorMessage(dto.getRequestDate());
    }

    protected void checkLegalHolidayDate(WorkOnHolidayRequestDtoInterface dto) {
        int substitute = dto.getSubstitute();
        if (substitute != 3 && substitute != 4) {
            return;
        }
        if ("legal_holiday".equals(dto.getWorkOnHolidayType())) {
            this.mospParams.addErrorMessage("TMW0245", new String[]{TimeNamingUtility.legalHoliday((MospParams)this.mospParams), this.mospParams.getName("HalfDay", new String[]{"Transfer"}), this.getNameGoingWorkDay()});
        }
    }

    protected void checkHolidayRequest(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkHolidayRequest(dto, requestUtil);
    }

    protected void checkHolidayRequest(WorkOnHolidayRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        List list = requestUtil.getHolidayList(false);
        int substitute = dto.getSubstitute();
        if (substitute == 1 || substitute == 3 || substitute == 4) {
            if (list.isEmpty()) {
                return;
            }
            this.addDuplicateConsecutiveHolidaysErrorMessage();
            return;
        }
        for (HolidayRequestDtoInterface holidayRequestDto : list) {
            if (!holidayRequestDto.getRequestStartDate().equals(dto.getRequestDate()) && !holidayRequestDto.getRequestEndDate().equals(dto.getRequestDate())) continue;
            this.addApplicatedRequestErrorMessage(dto.getRequestDate());
            return;
        }
    }

    protected void checkWorkTypeCode(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (dto.getSubstitute() != 5) {
            return;
        }
        WorkTypeDtoInterface workTypeDto = this.workTypeReference.findForInfo(dto.getWorkTypeCode(), dto.getRequestDate());
        if (workTypeDto == null || workTypeDto.getInactivateFlag() == 1) {
            this.addWorkTypeNotExistErrorMessage(dto.getRequestDate());
        }
    }

    public void checkRequired(WorkOnHolidayRequestDtoInterface dto) {
        if (dto.getRequestReason().isEmpty()) {
            this.addWorkOnHolidayRequestReasonErrorMessage();
        }
    }

    protected void checkEntered(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            this.addNotEntranceErrorMessage();
        }
    }

    protected void checkRetired(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspended(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeSuspendedMessage();
        }
    }

    protected void checkTightenForSetRequestDate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameGoingWorkDay());
    }

    public void checkTemporaryClosingFinal(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameGoingWorkDay());
        if (dto.getSubstitute() == 2) {
            return;
        }
        List substituteList = this.substituteReference.getSubstituteList(dto.getWorkflow());
        for (SubstituteDtoInterface substituteDto : substituteList) {
            this.cutoffUtil.checkTighten(substituteDto.getPersonalId(), substituteDto.getSubstituteDate(), this.getNameSubstituteDay());
        }
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        return this.getScheduledWorkTypeCode(personalId, targetDate, requestUtil);
    }

    protected String getScheduledWorkTypeCode(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        List list = requestUtil.getSubstituteList(true);
        for (SubstituteDtoInterface substituteDto : list) {
            if (substituteDto.getSubstituteRange() != 1) continue;
            return substituteDto.getSubstituteType();
        }
        ApplicationDtoInterface applicationDto = this.applicationReference.findForPerson(personalId, targetDate);
        this.applicationReference.chkExistApplication(applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        ScheduleDtoInterface scheduleDto = this.scheduleReference.getScheduleInfo(applicationDto.getScheduleCode(), targetDate);
        this.scheduleReference.chkExistSchedule(scheduleDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        ScheduleDateDtoInterface scheduleDateDto = this.scheduleDateReference.findForKey(scheduleDto.getScheduleCode(), targetDate);
        this.scheduleDateReference.chkExistScheduleDate(scheduleDateDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        return scheduleDateDto.getWorkTypeCode();
    }

    protected void checkSubHolidayRequest(WorkOnHolidayRequestDtoInterface dto, String personalId, Date workDate) throws MospException {
        List subholidayRequestList = this.subholidayRequestReference.findForWorkDate(personalId, workDate);
        if (!subholidayRequestList.isEmpty()) {
            for (SubHolidayRequestDtoInterface subholidayRequestDto : subholidayRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(subholidayRequestDto.getWorkflow());
                if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) continue;
                this.mospParams.addErrorMessage("TMW0316", new String[]{DateUtility.getStringDate((Date)subholidayRequestDto.getRequestDate()) + this.mospParams.getName("Of", new String[]{"CompensatoryHoliday", "Application"}), this.mospParams.getName("Release")});
            }
        }
        if (this.approvalInfoReference.isExistAttendanceTargetDate(personalId, workDate)) {
            this.mospParams.addErrorMessage("TMW0337", new String[]{DateUtility.getStringDate((Date)workDate)});
        }
    }

    protected void checkWorkTypeChangeRequest(String personalId, Date workDate) throws MospException {
        WorkflowDtoInterface workflowDto;
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.workTypeChangeRequestReference.findForKeyOnWorkflow(personalId, workDate);
        if (!(workTypeChangeDto == null || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)(workflowDto = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow()))) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto))) {
            this.mospParams.addErrorMessage("TMW0316", new String[]{this.getNameSubstituteDay() + this.mospParams.getName("Of", new String[]{"Work", "Form", "Change", "Application"}), this.mospParams.getName("Release")});
        }
    }

    protected void checkOverTimeRequest(String personalId, Date workDate) throws MospException {
        List overtimeRequestList = this.overtimeRequestReference.getOvertimeRequestList(personalId, workDate, workDate);
        if (!overtimeRequestList.isEmpty()) {
            for (OvertimeRequestDtoInterface overtimeRequestDto : overtimeRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(overtimeRequestDto.getWorkflow());
                if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) continue;
                this.mospParams.addErrorMessage("TMW0316", new String[]{this.getNameSubstituteDay() + this.mospParams.getName("Of", new String[]{"OvertimeWork", "Application"}), this.mospParams.getName("Release")});
            }
        }
    }

    protected void checkDifferenceRequest(String personalId, Date workDate) throws MospException {
        DifferenceRequestDtoInterface differenceDto = this.differenceReference.findForKeyOnWorkflow(personalId, workDate);
        if (differenceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(differenceDto.getWorkflow());
        if (workflowDto != null && WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0316", new String[]{this.getNameGoingWorkDay() + this.mospParams.getName("Of", new String[]{"TimeDifference", "GoingWork", "Application"}), this.mospParams.getName("Release")});
    }

    protected void addDuplicateConsecutiveHolidaysErrorMessage() {
        String substitutionHolidayWorkRequest = this.mospParams.getName("Transfer", new String[]{"GoingWork", "Application"});
        this.mospParams.addErrorMessage("TMW0288", new String[]{substitutionHolidayWorkRequest, substitutionHolidayWorkRequest, this.mospParams.getName("Administrator")});
    }

    protected void addApplicatedRequestErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0277", new String[]{this.getStringDate(date), this.getNameGoingWorkDay()});
    }

    protected String getNameGoingWorkDay() {
        return this.mospParams.getName("GoingWork", new String[]{"Day"});
    }

    protected String getNameSubstituteDay() {
        return this.mospParams.getName("Transfer", new String[]{"Day"});
    }

    protected void addApplicatedAttendanceErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0240", new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("GoingWork", new String[]{"Day"})});
    }
}

