/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdWorkTypeChangeRequestDto;

public class WorkTypeChangeRequestRegistBean
extends TimeBean
implements WorkTypeChangeRequestRegistBeanInterface {
    protected WorkTypeChangeRequestDaoInterface dao;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected TimeApprovalBeanInterface timeApproval;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;

    public WorkTypeChangeRequestRegistBean() {
    }

    public WorkTypeChangeRequestRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeChangeRequestDaoInterface)this.createDao(WorkTypeChangeRequestDaoInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBean(WorkTypeReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBean(WorkflowCommentRegistBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBean(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBean(ScheduleUtilBeanInterface.class);
    }

    public WorkTypeChangeRequestDtoInterface getInitDto() {
        return new TmdWorkTypeChangeRequestDto();
    }

    public void regist(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdWorkTypeChangeRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    protected void insert(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdWorkTypeChangeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkTypeChangeRequestId());
        dto.setTmdWorkTypeChangeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkTypeChangeRequestDtoInterface dto = (WorkTypeChangeRequestDtoInterface)baseDto;
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (workflowDto == null) continue;
            this.draftAttendance(dto);
        }
    }

    public void delete(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkTypeChangeRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkTypeChangeRequestDtoInterface dto = (WorkTypeChangeRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), this.mospParams.getProperties().getMessage("PFI0001", new String[]{this.mospParams.getName("TakeDown")}));
        }
    }

    protected void checkInsert(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate()));
    }

    protected void checkUpdate(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdWorkTypeChangeRequestId());
    }

    public void validate(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.initial(dto.getPersonalId(), dto.getRequestDate(), "7");
        String scheduledWorkTypeCode = this.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate());
        if (scheduledWorkTypeCode.equals(dto.getWorkTypeCode())) {
            this.addDuplicateWorkType();
        }
    }

    public void checkSetActivationDate(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTighten(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkDuplicate(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSchedule(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(dto, requestUtil);
    }

    public void checkDraft(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkSetActivationDate(dto);
    }

    public void checkAppli(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        this.checkRequired(dto);
    }

    public void checkCancelAppli(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkTighten(dto);
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        if (this.checkAttendanceNoMsg(requestUtil)) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkManage"));
        }
        List holidayList = requestUtil.getHolidayList(false);
        for (HolidayRequestDtoInterface holidayRequestDto : holidayList) {
            if (holidayRequestDto.getHolidayRange() != 4) continue;
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
            break;
        }
    }

    public void checkWithdrawn(WorkTypeChangeRequestDtoInterface dto) {
    }

    public void checkDelete(WorkTypeChangeRequestDtoInterface dto) {
    }

    public void checkApproval(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkAppli(dto);
    }

    public void checkCancelApproval(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    protected void checkRequired(WorkTypeChangeRequestDtoInterface dto) {
        if (!this.checkRequiredNoMsg(dto)) {
            this.addReasonErrorMessage();
        }
    }

    protected boolean checkRequiredNoMsg(WorkTypeChangeRequestDtoInterface dto) {
        return !dto.getRequestReason().isEmpty();
    }

    protected void checkDuplicate(WorkTypeChangeRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.checkDuplicateNoMsg(dto, requestUtil)) {
            this.addDuplicateErrorMessage(dto.getRequestDate());
        }
    }

    protected boolean checkDuplicateNoMsg(WorkTypeChangeRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        WorkTypeChangeRequestDtoInterface requestDto = requestUtil.getWorkTypeChangeDto(false);
        if (requestDto == null) {
            return false;
        }
        if (this.workflowIntegrate.isWithDrawn(requestDto.getWorkflow())) {
            return false;
        }
        return dto.getWorkflow() != requestDto.getWorkflow();
    }

    protected void checkAttendance(RequestUtilBeanInterface requestUtil) throws MospException {
        if (this.checkAttendanceNoMsg(requestUtil)) {
            this.addApplicatedAttendanceErrorMessage(requestUtil.getApplicatedAttendance().getWorkDate());
        }
    }

    protected boolean checkAttendanceNoMsg(RequestUtilBeanInterface requestUtil) throws MospException {
        return requestUtil.getApplicatedAttendance() != null;
    }

    protected void checkRequest(WorkTypeChangeRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        this.checkHolidayRequest(dto, requestUtil);
    }

    protected void checkHolidayRequest(WorkTypeChangeRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        List subHolidayList;
        List holidayList = requestUtil.getHolidayList(false);
        if (!holidayList.isEmpty()) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("Vacation"));
        }
        if (!(subHolidayList = requestUtil.getSubHolidayList(false)).isEmpty()) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("CompensatoryHoliday"));
        }
    }

    public void checkSchedule(String personalId, Date targetDate) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        this.checkSchedule(personalId, targetDate, requestUtil);
    }

    protected void checkSchedule(WorkTypeChangeRequestDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        this.checkSchedule(dto.getPersonalId(), dto.getRequestDate(), requestUtil);
    }

    protected void checkSchedule(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, requestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty() || "legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addDayOffErrorMessage(targetDate);
        } else if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addApplicatedRequestErrorMessage(targetDate);
        }
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        return this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, true);
    }

    public String getScheduledWorkTypeName(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        return this.getScheduledWorkTypeName(dto.getPersonalId(), dto.getRequestDate());
    }

    public String getScheduledWorkTypeName(String personalId, Date targetDate) throws MospException {
        String workTypeCode = this.getScheduledWorkTypeCode(personalId, targetDate);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            return "";
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode) || "work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            return this.workTypeReference.getParticularWorkTypeName(workTypeCode);
        }
        return this.workTypeReference.getWorkTypeAbbrAndTime(workTypeCode, targetDate);
    }

    protected void checkEntered(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            this.addNotEntranceErrorMessage();
        }
    }

    protected void checkRetired(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspended(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            this.addEmployeeSuspendedMessage();
        }
    }

    protected void checkTighten(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.mospParams.getName("GoingWork", new String[]{"Day"}));
    }

    public void draftAttendance(WorkTypeChangeRequestDtoInterface dto) throws MospException {
        if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
            return;
        }
        this.timeApproval = (TimeApprovalBeanInterface)this.createBean(TimeApprovalBeanInterface.class);
        this.timeApproval.reDraft(dto.getPersonalId(), dto.getRequestDate(), false, true, false);
    }

    protected void addReasonErrorMessage() {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Reason")});
    }

    protected void addDuplicateWorkType() {
        String errorMes1 = this.mospParams.getName("Work", new String[]{"Form"});
        String errorMes2 = this.mospParams.getName("Change", new String[]{"Later", "Work", "Form"});
        this.mospParams.addErrorMessage("TMW0243", new String[]{errorMes1, errorMes2});
    }

    protected void addDuplicateErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0240", new String[]{DateUtility.getStringDate((Date)date), this.mospParams.getName("Work", new String[]{"Form", "Change"}), this.mospParams.getName("GoingWork", new String[]{"Day"})});
    }

    protected void addApplicatedAttendanceErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0240", new String[]{this.getStringDate(date), this.mospParams.getName("WorkManage"), this.mospParams.getName("GoingWork", new String[]{"Day"})});
    }

    protected void addApplicatedRequestErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0277", new String[]{this.getStringDate(date), this.mospParams.getName("GoingWork", new String[]{"Day"})});
    }

    protected void addDayOffErrorMessage(Date date) {
        String workDay = this.mospParams.getName("GoingWork", new String[]{"Day"});
        this.mospParams.addErrorMessage("TMW0242", new String[]{this.getStringDate(date), workDay, workDay});
    }

    protected void addRequestPeriodErrorMessage() {
        this.mospParams.addErrorMessage("TMW0241", new String[]{this.mospParams.getName("Work", new String[]{"Form", "Change", "Application"}), this.mospParams.getName("No1", new String[]{"Months"}), this.mospParams.getName("GoingWork", new String[]{"Day"})});
    }
}

