/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeItemDto;

public class WorkTypeItemRegistBean
extends PlatformBean
implements WorkTypeItemRegistBeanInterface {
    WorkTypeItemDaoInterface dao;
    WorkTypeDaoInterface workTypeDao;
    protected String[] codesWorkTypeItem = new String[]{"WorkStart", "WorkEnd", "WorkTime", "RestTime", "RestStart1", "RestEnd1", "RestStart2", "RestEnd2", "RestStart3", "RestEnd3", "RestStart4", "RestEnd4", "FrontStart", "FrontEnd", "BackStart", "BackEnd", "OverBefore", "OverPer", "OverRest", "HalfRest", "HalfRestStart", "HalfRestEnd", "DirectStart", "DirectEnd", "ExcludeNightRest", "Short1Start", "Short1End", "Short2Start", "Short2End", "AutoBefOverWork"};

    public WorkTypeItemRegistBean() {
    }

    public WorkTypeItemRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkTypeItemDaoInterface)this.createDao(WorkTypeItemDaoInterface.class);
        this.workTypeDao = (WorkTypeDaoInterface)this.createDao(WorkTypeDaoInterface.class);
    }

    public WorkTypeItemDtoInterface getInitDto() {
        return new TmmWorkTypeItemDto();
    }

    public void insert(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (dto.getTmmWorkTypeItemId() == 0L) {
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            for (String workTypeItemCode : this.codesWorkTypeItem) {
                WorkTypeItemDtoInterface dto = this.dao.findForKey(code, activateDate, workTypeItemCode);
                if (dto == null) {
                    dto = this.dao.findForInfo(code, activateDate, workTypeItemCode);
                    if (dto == null) continue;
                    dto.setActivateDate(activateDate);
                    dto.setInactivateFlag(inactivateFlag);
                    this.validate(dto);
                    this.checkAdd(dto);
                    if (this.mospParams.hasErrorMessage()) continue;
                    dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                    this.dao.insert((BaseDtoInterface)dto);
                    continue;
                }
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkUpdate(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
                dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
            }
        }
    }

    public void delete(String workTypeCode, Date activateDate) throws MospException {
        for (String workTypeItemCode : this.codesWorkTypeItem) {
            WorkTypeItemDtoInterface dto = this.dao.findForKey(workTypeCode, activateDate, workTypeItemCode);
            if (dto == null) continue;
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        }
    }

    protected void checkInsert(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode()));
    }

    protected void checkAdd(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), dto.getWorkTypeItemCode()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    protected void checkUpdate(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmWorkTypeItemId(), true))) {
            return;
        }
    }

    protected void checkDelete(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)this.workTypeDao.findForKey(id, false);
            list.add(dto.getWorkTypeCode());
        }
        return list;
    }

    protected void validate(WorkTypeItemDtoInterface dto) {
    }

    public String[] getCodesWorkTypeItem() {
        return CapsuleUtility.getStringArrayClone((String[])this.codesWorkTypeItem);
    }
}

